// Generated by CoffeeScript 1.10.0
(function() {
  var bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  jQuery(function($) {
    var AlbumView, AuthenticateView, CheckAccessTokenView, CheckUserView, CopyKeysView, CopyOAuthBlock, FacebookEditor, FacebookSettings;
    FacebookSettings = (function(superClass) {
      extend(FacebookSettings, superClass);

      function FacebookSettings() {
        this.validate = bind(this.validate, this);
        return FacebookSettings.__super__.constructor.apply(this, arguments);
      }

      FacebookSettings.prototype.validate = function() {
        if (!this.get('app_id')) {
          return 'Please enter app ID';
        }
        if (!this.get('app_secret')) {
          return 'Please enter app secret';
        }
        return null;
      };

      return FacebookSettings;

    })(Backbone.Model);
    CopyKeysView = (function(superClass) {
      extend(CopyKeysView, superClass);

      function CopyKeysView() {
        return CopyKeysView.__super__.constructor.apply(this, arguments);
      }

      CopyKeysView.prototype.el = $('#facebook-copy-keys-block');

      CopyKeysView.prototype.initialize = function(params) {
        CopyKeysView.__super__.initialize.call(this, params);
        this.binding = rivets.bind(this.el, {
          model: this.model
        });
        this.binding.publish();
        return this.$el.find('#facebook-id').on('keyup', (function(_this) {
          return function() {
            return _this.binding.publish();
          };
        })(this));
      };

      return CopyKeysView;

    })(Backbone.View);
    AuthenticateView = (function(superClass) {
      extend(AuthenticateView, superClass);

      function AuthenticateView() {
        this.authenticate = bind(this.authenticate, this);
        this.getAuthUrl2 = bind(this.getAuthUrl2, this);
        this.getAuthUrl = bind(this.getAuthUrl, this);
        this.onModelChanged = bind(this.onModelChanged, this);
        this.initialize = bind(this.initialize, this);
        return AuthenticateView.__super__.constructor.apply(this, arguments);
      }

      AuthenticateView.prototype.el = $('#facebook-authenticate-block');

      AuthenticateView.prototype.events = {
        'click #facebook-authenticate': 'authenticate'
      };

      AuthenticateView.prototype.initialize = function(params) {
        AuthenticateView.__super__.initialize.call(this, params);
        this.redirect_url = this.$el.attr('data-redirect-url');
        this.$el.removeAttr('data-redirect-url');
        rivets.bind(this.el, {
          model: this.model
        }).publish();
        this.listenTo(this.model, 'change', this.onModelChanged);
        return this.onModelChanged();
      };

      AuthenticateView.prototype.onModelChanged = function() {
        if (this.model.get('app_id') && this.model.get('app_id') !== '' && this.model.get('app_secret') && this.model.get('app_secret') !== '') {
          return this.$el.find('.auth-url').text(this.getAuthUrl2());
        } else {
          return this.$el.find('.auth-url').text('Please enter APP ID and APP SECRET');
        }
      };

      AuthenticateView.prototype.getAuthUrl = function() {
        return "https://www.facebook.com/dialog/oauth?client_id=" + (this.model.get('app_id')) + "&redirect_uri=" + (encodeURIComponent(this.redirect_url)) + "&state=" + (this.model.get('app_id')) + "|" + (this.model.get('app_secret')) + "&scope=user_photos,manage_pages";
      };

      AuthenticateView.prototype.getAuthUrl2 = function() {
        return "https://www.facebook.com/dialog/oauth?client_id=" + (this.model.get('app_id')) + "&redirect_uri=" + (encodeURIComponent(this.$el.attr('friend-redirect-url'))) + "&state=" + (this.model.get('app_id')) + "|" + (this.model.get('app_secret')) + "&scope=user_photos,manage_pages";
      };

      AuthenticateView.prototype.authenticate = function(event) {
        event.preventDefault();
        return window.open(this.getAuthUrl());
      };

      return AuthenticateView;

    })(Backbone.View);
    CopyOAuthBlock = (function(superClass) {
      extend(CopyOAuthBlock, superClass);

      function CopyOAuthBlock() {
        this.initialize = bind(this.initialize, this);
        return CopyOAuthBlock.__super__.constructor.apply(this, arguments);
      }

      CopyOAuthBlock.prototype.el = $('#faceboook-oauth-block');

      CopyOAuthBlock.prototype.initialize = function() {
        CopyOAuthBlock.__super__.initialize.apply(this, arguments);
        return this.listenTo(this.model, 'change:app_id', (function(_this) {
          return function() {
            return $('#facebook-oauth-block .button-hero').attr('href', "https://developers.facebook.com/apps/" + (_this.model.get('app_id')) + "/advanced?ref=nav");
          };
        })(this));
      };

      return CopyOAuthBlock;

    })(Backbone.View);
    CheckAccessTokenView = (function(superClass) {
      extend(CheckAccessTokenView, superClass);

      function CheckAccessTokenView() {
        this.checkToken = bind(this.checkToken, this);
        this.initialize = bind(this.initialize, this);
        return CheckAccessTokenView.__super__.constructor.apply(this, arguments);
      }

      CheckAccessTokenView.prototype.el = $('#facebook-check-access-token-block');

      CheckAccessTokenView.prototype.events = {
        'click #facebook-check-access-token': 'checkToken'
      };

      CheckAccessTokenView.prototype.initialize = function() {
        CheckAccessTokenView.__super__.initialize.apply(this, arguments);
        return this.spinner = this.$('.spinner');
      };

      CheckAccessTokenView.prototype.checkToken = function() {
        if (!this.model.isValid()) {
          alert(this.model.validate);
          return;
        }
        this.spinner.css('display', 'inline-block');
        $.post('admin-ajax.php?action=asg-facebook-check-access-token', this.model.toJSON(), (function(_this) {
          return function(response) {
            _this.spinner.css('display', 'none');
            return alert(response);
          };
        })(this));
        return false;
      };

      return CheckAccessTokenView;

    })(Backbone.View);
    CheckUserView = (function(superClass) {
      extend(CheckUserView, superClass);

      function CheckUserView() {
        this.checkUser = bind(this.checkUser, this);
        this.initialize = bind(this.initialize, this);
        return CheckUserView.__super__.constructor.apply(this, arguments);
      }

      CheckUserView.prototype.el = $('#facebook-check-user-block');

      CheckUserView.prototype.events = {
        'click #facebook-check-user': 'checkUser'
      };

      CheckUserView.prototype.initialize = function() {
        CheckUserView.__super__.initialize.apply(this, arguments);
        rivets.bind(this.el, {
          model: this.model
        }).publish();
        return this.spinner = this.$('.spinner');
      };

      CheckUserView.prototype.checkUser = function() {
        if (!this.model.isValid()) {
          alert(this.model.validate);
          return;
        }
        this.spinner.css('display', 'inline-block');
        $.post('admin-ajax.php?action=asg-facebook-ping-user', this.model.toJSON(), (function(_this) {
          return function(response) {
            _this.spinner.css('display', 'none');
            return alert(response);
          };
        })(this));
        return false;
      };

      return CheckUserView;

    })(Backbone.View);
    AlbumView = (function(superClass) {
      extend(AlbumView, superClass);

      function AlbumView() {
        this.preview = bind(this.preview, this);
        this.updateSelectorButtons = bind(this.updateSelectorButtons, this);
        this.selectAlbum = bind(this.selectAlbum, this);
        this.initialize = bind(this.initialize, this);
        return AlbumView.__super__.constructor.apply(this, arguments);
      }

      AlbumView.prototype.el = $('#facebook-select-album-block');

      AlbumView.prototype.events = {
        'click #facebook-preview': 'preview',
        'click #facebook-select-album': 'selectAlbum',
        'change #facebook-select-source-type': 'updateSelectorButtons'
      };

      AlbumView.prototype.initialize = function() {
        AlbumView.__super__.initialize.apply(this, arguments);
        rivets.bind(this.el, {
          model: this.model
        }).publish();
        this.$select_album = $('#facebook-select-album');
        this.$facebook_source_type = $('#facebook-select-source-type');
        this.$facebook_source = $('#facebook-source');
        this.$facebook_source_name = $('#facebook-source-name');
        this.$facebook_source_name_input = $('#facebook-source-name-input');
        this.$facebook_source_name_label = $('#facebook-current-source-label');
        this.album_selector = new window.asg.ExternalGallerySelector;
        return this.updateSelectorButtons(true);
      };

      AlbumView.prototype.selectAlbum = function() {
        this.album_selector.select({
          ajax_action: 'asg-facebook-get-albums',
          value: this.model.get('source'),
          ajax_data: this.model.toJSON(),
          title: 'Select Album'
        }).done((function(_this) {
          return function(val) {
            _this.model.set('source', val.id);
            return _this.model.set('source_name', val.get('title'));
          };
        })(this));
        return false;
      };

      AlbumView.prototype.updateSelectorButtons = function(init) {
        this.model.set('source_type', this.$facebook_source_type.val());
        this.$select_album.hide();
        if (this.model.get('source_type') === 'album') {
          this.$select_album.show() && this.$facebook_source_name.show();
        }
        if (this.model.get('source_type') === 'album') {
          this.$facebook_source_name_label.show();
          this.$facebook_source_name.show();
          if (!init) {
            this.$facebook_source_name.text('Please select').show();
            return this.$facebook_source_name_input.val('');
          }
        } else {
          this.$facebook_source_name.hide();
          this.$facebook_source_name_label.hide();
          return this.$facebook_source_name_input.val('');
        }
      };

      AlbumView.prototype.preview = function() {
        return Preview.show();
      };

      return AlbumView;

    })(Backbone.View);
    FacebookEditor = (function(superClass) {
      extend(FacebookEditor, superClass);

      function FacebookEditor() {
        FacebookEditor.__super__.constructor.apply(this, arguments);
        this.model = new FacebookSettings;
        this.model.set('id', $('#post_ID').val());
        new CopyKeysView({
          model: this.model
        });
        new AuthenticateView({
          model: this.model
        });
        new CheckAccessTokenView({
          model: this.model
        });
        new CheckUserView({
          model: this.model
        });
        new asgSettingsView({
          model: this.model,
          el: $('#facebook-settings-block')
        });
        new AlbumView({
          model: this.model
        });
        new CopyOAuthBlock({
          model: this.model
        });
      }

      return FacebookEditor;

    })(window.asgSourceEditor);
    return window.asgRegisteredSourceEditors.facebook = FacebookEditor;
  });

}).call(this);
