// Generated by CoffeeScript 1.8.0
(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  jQuery(function($) {
    var CheckKeysView, CheckUserView, CopyKeysView, FlickrEditor, FlickrSettings, PhotosetView;
    FlickrSettings = (function(_super) {
      __extends(FlickrSettings, _super);

      function FlickrSettings() {
        return FlickrSettings.__super__.constructor.apply(this, arguments);
      }

      return FlickrSettings;

    })(Backbone.Model);
    CopyKeysView = (function(_super) {
      __extends(CopyKeysView, _super);

      function CopyKeysView() {
        this.initialize = __bind(this.initialize, this);
        return CopyKeysView.__super__.constructor.apply(this, arguments);
      }

      CopyKeysView.prototype.el = $('#flickr-copy-keys-block');

      CopyKeysView.prototype.initialize = function(params) {
        CopyKeysView.__super__.initialize.call(this, params);
        return rivets.bind(this.el, {
          model: this.model
        }).publish();
      };

      return CopyKeysView;

    })(Backbone.View);
    CheckKeysView = (function(_super) {
      __extends(CheckKeysView, _super);

      function CheckKeysView() {
        this.checkKeys = __bind(this.checkKeys, this);
        this.initialize = __bind(this.initialize, this);
        return CheckKeysView.__super__.constructor.apply(this, arguments);
      }

      CheckKeysView.prototype.el = $("#flickr-check-keys-block");

      CheckKeysView.prototype.events = {
        'click #flickr-check-keys': 'checkKeys'
      };

      CheckKeysView.prototype.initialize = function() {
        CheckKeysView.__super__.initialize.apply(this, arguments);
        return this.spinner = this.$('.spinner');
      };

      CheckKeysView.prototype.checkKeys = function() {
        this.spinner.css('display', 'inline-block');
        $.post('admin-ajax.php?action=asg-flickr-ping', this.model.toJSON(), (function(_this) {
          return function(response) {
            _this.spinner.css('display', 'none');
            return alert(response);
          };
        })(this));
        return false;
      };

      return CheckKeysView;

    })(Backbone.View);
    CheckUserView = (function(_super) {
      __extends(CheckUserView, _super);

      function CheckUserView() {
        this.checkUser = __bind(this.checkUser, this);
        this.initialize = __bind(this.initialize, this);
        return CheckUserView.__super__.constructor.apply(this, arguments);
      }

      CheckUserView.prototype.el = $('#flickr-check-user-block');

      CheckUserView.prototype.events = {
        'click #flickr-check-user': 'checkUser'
      };

      CheckUserView.prototype.initialize = function() {
        CheckUserView.__super__.initialize.apply(this, arguments);
        this.spinner = this.$('.spinner');
        return rivets.bind(this.el, {
          model: this.model
        }).publish();
      };

      CheckUserView.prototype.checkUser = function() {
        this.spinner.css('display', 'inline-block');
        $.post('admin-ajax.php?action=asg-flickr-ping-user', this.model.toJSON(), (function(_this) {
          return function(response) {
            _this.spinner.css('display', 'none');
            return alert(response);
          };
        })(this));
        return false;
      };

      return CheckUserView;

    })(Backbone.View);
    PhotosetView = (function(_super) {
      __extends(PhotosetView, _super);

      function PhotosetView() {
        this.preview = __bind(this.preview, this);
        this.updateSelectorButtons = __bind(this.updateSelectorButtons, this);
        this.selectGroup = __bind(this.selectGroup, this);
        this.selectPhotoset = __bind(this.selectPhotoset, this);
        this.initialize = __bind(this.initialize, this);
        return PhotosetView.__super__.constructor.apply(this, arguments);
      }

      PhotosetView.prototype.el = $('#flickr-select-gallery');

      PhotosetView.prototype.events = {
        'click #flickr-preview': 'preview',
        'click #flickr-select-photoset': 'selectPhotoset',
        'click #flickr-select-group': 'selectGroup'
      };

      PhotosetView.prototype.initialize = function() {
        PhotosetView.__super__.initialize.apply(this, arguments);
        rivets.bind(this.el, {
          model: this.model
        });
        this.$select_group = $('#flickr-select-group');
        this.$select_photoset = $('#flickr-select-photoset');
        this.$flickr_source_type = $('#flickr-source-type');
        this.$flickr_source = $('#flickr-source');
        this.$flickr_source_name = $('#flickr-source-name');
        this.$flickr_source_name_input = $('#flickr-source-name-input');
        this.$flickr_source_name_label = $('#flickr-current-source-label');
        this.photoset_selector = new window.asg.ExternalGallerySelector;
        this.group_selector = new window.asg.ExternalGallerySelector;
        this.$flickr_source_type.change(this.updateSelectorButtons);
        return this.updateSelectorButtons(true);
      };

      PhotosetView.prototype.selectPhotoset = function(event) {
        event.preventDefault();
        this.photoset_selector.select({
          ajax_action: 'asg-flickr-get-photosets',
          value: this.$flickr_source.val(),
          ajax_data: this.model.attributes,
          title: 'Select photoset'
        }).done((function(_this) {
          return function(val) {
            _this.$flickr_source.val(val.id);
            _this.$flickr_source_name.text(val.get('title'));
            return _this.$flickr_source_name_input.val(val.get('title'));
          };
        })(this));
        return false;
      };

      PhotosetView.prototype.selectGroup = function(event) {
        event.preventDefault();
        this.group_selector.select({
          ajax_action: 'asg-flickr-get-groups',
          value: this.$flickr_source.val(),
          ajax_data: this.model.attributes,
          title: 'Select group'
        }).done((function(_this) {
          return function(val) {
            _this.$flickr_source.val(val.id);
            _this.$flickr_source_name.text(val.get('title'));
            return _this.$flickr_source_name_input.val(val.get('title'));
          };
        })(this));
        return false;
      };

      PhotosetView.prototype.updateSelectorButtons = function(init) {
        this.$select_photoset.hide();
        this.$select_group.hide();
        if (this.$flickr_source_type.val() === 'photoset') {
          this.$select_photoset.show() && this.$flickr_source_name.show();
        }
        if (this.$flickr_source_type.val() === 'group') {
          this.$select_group.show() && this.$flickr_source_name.show();
        }
        this.$flickr_source_name.text('');
        if (this.$flickr_source_type.val() === 'photoset' || this.$flickr_source_type.val() === 'group') {
          this.$flickr_source_name_label.show();
          if (!init) {
            this.$flickr_source_name.text('Please select').show();
            this.$flickr_source_name_input.val('');
          } else {
            this.$flickr_source_name.text(this.$flickr_source_name_input.val());
          }
          if (this.$flickr_source_type.val() === 'group') {
            return this.$flickr_source.show();
          }
        } else {
          this.$flickr_source.hide();
          this.$flickr_source_name.hide();
          this.$flickr_source_name_label.hide();
          return this.$flickr_source_name_input.val('');
        }
      };

      PhotosetView.prototype.preview = function() {
        return Preview.show();
      };

      return PhotosetView;

    })(Backbone.View);
    FlickrEditor = (function(_super) {
      __extends(FlickrEditor, _super);

      function FlickrEditor(view) {
        var model;
        FlickrEditor.__super__.constructor.call(this, view);
        model = new FlickrSettings;
        model.set('id', $('#post_ID').val());
        new CopyKeysView({
          model: model
        });
        new CheckKeysView({
          model: model
        });
        new CheckUserView({
          model: model
        });
        new PhotosetView({
          model: model
        });
        new asgSettingsView({
          model: model,
          el: $('#flickr-settings-block')
        });
      }

      return FlickrEditor;

    })(window.asgSourceEditor);
    return window.asgRegisteredSourceEditors.flickr = FlickrEditor;
  });

}).call(this);
