// Generated by CoffeeScript 1.10.0
(function() {
  var bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  jQuery(function() {
    var $, AuthorizeView, CheckAuthView, CheckDataView, CopyKeysView, InstagramEditor, InstagramModel;
    $ = jQuery;
    InstagramModel = (function(superClass) {
      extend(InstagramModel, superClass);

      function InstagramModel() {
        this.validate = bind(this.validate, this);
        return InstagramModel.__super__.constructor.apply(this, arguments);
      }

      InstagramModel.prototype.validate = function() {
        if (!this.get('client_id')) {
          return 'Please enter Instagram client ID';
        }
        if (!this.get('client_secret')) {
          return 'Please enter Instagram client secret';
        }
        if (this.get('feed_type') === 'other-user' && !this.get('other_user_login')) {
          return 'Please enter other user\'s login';
        }
      };

      return InstagramModel;

    })(Backbone.Model);
    CopyKeysView = (function(superClass) {
      extend(CopyKeysView, superClass);

      function CopyKeysView() {
        this.initialize = bind(this.initialize, this);
        return CopyKeysView.__super__.constructor.apply(this, arguments);
      }

      CopyKeysView.prototype.el = $('#instagram-copy-keys-block');

      CopyKeysView.prototype.initialize = function(params) {
        CopyKeysView.__super__.initialize.call(this, params);
        return rivets.bind(this.el, {
          model: this.model
        }).publish();
      };

      return CopyKeysView;

    })(Backbone.View);
    AuthorizeView = (function(superClass) {
      extend(AuthorizeView, superClass);

      function AuthorizeView() {
        this.authorize = bind(this.authorize, this);
        this.initialize = bind(this.initialize, this);
        return AuthorizeView.__super__.constructor.apply(this, arguments);
      }

      AuthorizeView.prototype.el = $('#instagram-authorize-block');

      AuthorizeView.prototype.events = {
        'click #instagram-authorize': 'authorize'
      };

      AuthorizeView.prototype.initialize = function(params) {
        AuthorizeView.__super__.initialize.call(this, params);
        this.redirect_uri = $('#instagram-redirect-uri').text();
        return rivets.bind(this.el, {
          model: this.model
        }).publish();
      };

      AuthorizeView.prototype.authorize = function(event) {
        var error, href;
        event.preventDefault();
        if (error = this.model.validate()) {
          alert(error);
          return;
        }
        href = "https://api.instagram.com/oauth/authorize/?client_id=" + (this.model.get('client_id')) + "&response_type=code&redirect_uri=" + (encodeURIComponent(this.redirect_uri)) + "&scope=public_content";
        href = "admin.php?action=asg_instagram_save_client_data&" + $.param(this.model.toJSON()) + "&redirect=" + encodeURIComponent(href);
        return window.open(href);
      };

      return AuthorizeView;

    })(Backbone.View);
    CheckAuthView = (function(superClass) {
      extend(CheckAuthView, superClass);

      function CheckAuthView() {
        this.checkAuth = bind(this.checkAuth, this);
        this.initialize = bind(this.initialize, this);
        return CheckAuthView.__super__.constructor.apply(this, arguments);
      }

      CheckAuthView.prototype.el = $('#instagram-check-auth-block');

      CheckAuthView.prototype.events = {
        'click #instagram-check-auth': 'checkAuth'
      };

      CheckAuthView.prototype.initialize = function() {
        this.$auth_spinner = this.$('.spinner');
        return this.$auth_result = this.$('#instagram-auth-result');
      };

      CheckAuthView.prototype.checkAuth = function(event) {
        var data, error, id;
        if (event) {
          event.preventDefault();
        }
        if (error = this.model.validate()) {
          alert(error);
          return;
        }
        this.$auth_spinner.css('display', 'inline-block');
        data = this.model.toJSON();
        id = jQuery('#post_ID').val();
        return $.post('admin-ajax.php', {
          action: 'asg_instagram_ping',
          data: data,
          id: id
        }, (function(_this) {
          return function(response) {
            _this.$auth_spinner.css('display', 'none');
            if (response === 'OK') {
              return _this.$auth_result.text('Valid').addClass('asg-valid').removeClass('asg-invalid');
            } else {
              return _this.$auth_result.text('Invalid').addClass('asg-invalid').removeClass('asg-valid');
            }
          };
        })(this));
      };

      return CheckAuthView;

    })(Backbone.View);
    CheckDataView = (function(superClass) {
      extend(CheckDataView, superClass);

      function CheckDataView() {
        this.checkData = bind(this.checkData, this);
        this.initialize = bind(this.initialize, this);
        return CheckDataView.__super__.constructor.apply(this, arguments);
      }

      CheckDataView.prototype.el = $('#instagram-check-data-block');

      CheckDataView.prototype.events = {
        'click #instagram-check-data': 'checkData'
      };

      CheckDataView.prototype.initialize = function() {
        CheckDataView.__super__.initialize.apply(this, arguments);
        this.$data_spinner = this.$('.spinner');
        this.$other_user_wrapper = this.$('#instagram-other-user-wrapper');
        this.$hashtag_wrapper = this.$('#instagram-hashtag-wrapper');
        this.listenTo(this.model, 'change:feed_type', (function(_this) {
          return function() {
            if (_this.model.get('feed_type') === 'other-user') {
              _this.$other_user_wrapper.show();
            } else {
              _this.$other_user_wrapper.hide();
            }
            if (_this.model.get('feed_type') === 'hashtag') {
              return _this.$hashtag_wrapper.show();
            } else {
              return _this.$hashtag_wrapper.hide();
            }
          };
        })(this));
        return rivets.bind(this.el, {
          model: this.model
        }).publish();
      };

      CheckDataView.prototype.checkData = function(event) {
        var error;
        event.preventDefault();
        if (error = this.model.validate()) {
          alert(error);
          return;
        }
        this.$data_spinner.css('display', 'inline-block');
        return $.post('admin-ajax.php', {
          action: 'asg_instagram_data_check',
          data: this.model.toJSON()
        }, (function(_this) {
          return function(response) {
            _this.$data_spinner.css('display', 'none');
            return alert(response);
          };
        })(this));
      };

      return CheckDataView;

    })(Backbone.View);
    InstagramEditor = (function(superClass) {
      extend(InstagramEditor, superClass);

      function InstagramEditor(view) {
        this.link_mode_changed = bind(this.link_mode_changed, this);
        this.other_user_changed = bind(this.other_user_changed, this);
        InstagramEditor.__super__.constructor.call(this, view);
        this.model = new InstagramModel;
        new CopyKeysView({
          model: this.model
        });
        new AuthorizeView({
          model: this.model
        });
        this.check_auth = new CheckAuthView({
          model: this.model
        });
        new CheckDataView({
          model: this.model
        });
        new asgSettingsView({
          model: this.model,
          el: $('#instagram-settings-block')
        });
        if (this.model.isValid()) {
          this.check_auth.checkAuth();
        }
      }

      InstagramEditor.prototype.other_user_changed = function() {};

      InstagramEditor.prototype.link_mode_changed = function() {};

      return InstagramEditor;

    })(window.asgSourceEditor);
    return window.asgRegisteredSourceEditors.instagram = InstagramEditor;
  });

}).call(this);
