// Generated by CoffeeScript 1.6.3
(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  jQuery(function() {
    var $, ManualEditor;
    $ = jQuery;
    ManualEditor = (function(_super) {
      var $images, $template, $view, ImageEditor, renameInputs;

      __extends(ManualEditor, _super);

      $images = null;

      $view = null;

      $template = null;

      function ManualEditor(view) {
        var _this = this;
        ManualEditor.__super__.constructor.call(this, view);
        $images = $('#manual-images');
        $view = $(view);
        $template = $('#manual-source-image-template');
        $images.find('li').each(function(index, li) {
          return new ImageEditor($(li));
        });
        $('#add-new-image').removeAttr('disabled').click(function() {
          var html, title;
          html = $($template.html());
          title = "Image " + ($images.find('li').size() + 1);
          html.find('input.title').val(title);
          html.find('h3 .heading').text(title);
          $images.append(html);
          new ImageEditor(html);
          renameInputs();
          return false;
        });
        $('ul#manual-images').sortable({
          update: renameInputs
        });
        renameInputs();
      }

      renameInputs = function() {
        return $images.find('>li').each(function(index, cell) {
          return $(cell).find('*:input').each(function(inputIndex, input) {
            var name;
            name = $(input).attr('name');
            if (name) {
              return $(input).attr('name', name.replace(/\[images\]\[\d*\]/, "[images][" + index + "]"));
            }
          });
        });
      };

      ImageEditor = (function() {
        function ImageEditor(view) {
          this.remove = __bind(this.remove, this);
          this.toggle = __bind(this.toggle, this);
          var _this = this;
          this.$view = $(view);
          this.$content = this.$view.find('>.content');
          this.$remove = this.$view.find('a.cell-delete');
          this.$cancel = this.$view.find('a.cell-cancel');
          this.$title = this.$view.find('input.title');
          this.$description = this.$view.find('textarea.description');
          this.$lightboxTitle = this.$view.find('input.asg-lightbox-title');
          this.$lightboxDescription = this.$view.find('textarea.asg-lightbox-description');
          this.$view.find('label.huge :checkbox').each(function(index, el) {
            if (!$(el).is(':checked')) {
              return $(el).parent().parent().find('.column-1, .columns-2').hide();
            }
          }).click(function() {
            return $(this).parent().parent().find('.column-1, .columns-2').toggle();
          });
          this.mainImageSelector = new asg.ImageSelector({
            el: this.$view.find('.asg-manual-main-image')
          });
          this.mainImageSelector.on('changed:selection', function(event) {
            if (!(_this.$title.val() && _this.$title.val() !== '')) {
              _this.$title.val(event.attributes.title);
            }
            if (!(_this.$description.val() && _this.$description.val() !== '')) {
              return _this.$description.val(event.attributes.caption);
            }
          });
          this.lightboxImageSelector = new asg.ImageSelector({
            el: this.$view.find('.asg-manual-lightbox-image')
          });
          this.lightboxImageSelector.on('changed:selection', function(event) {
            if (!(_this.$lightboxTitle.val() && _this.$lightboxTitle.val() !== '')) {
              _this.$lightboxTitle.val(event.attributes.title);
            }
            if (!(_this.$lightboxDescription.val() && _this.$lightboxDescription.val() !== '')) {
              return _this.$lightboxDescription.val(event.attributes.caption);
            }
          });
          this.$view.find('h3').on('click', this.toggle);
          this.$cancel.click(this.toggle);
          this.$remove.click(this.remove);
          this.$title.keyup(function(event) {
            var i, text;
            text = $(event.target).val();
            if (text) {
              return _this.$view.find('h3 .heading').text(text);
            } else {
              i = -1;
              $('#manual-images > li').each(function(index, element) {
                if (element === $(event.target).closest('li')[0]) {
                  return i = index + 1;
                }
              });
              return _this.$view.find('h3 .heading').html("Image " + i);
            }
          });
        }

        ImageEditor.prototype.toggle = function(callback) {
          this.$view.toggleClass('expanded');
          this.$content.toggle(callback);
          return false;
        };

        ImageEditor.prototype.remove = function() {
          this.$view.remove();
          renameInputs();
          return false;
        };

        return ImageEditor;

      })();

      return ManualEditor;

    }).call(this, window.asgSourceEditor);
    return window.asgRegisteredSourceEditors.manual = ManualEditor;
  });

}).call(this);
