<?php
/**
 * Create / Update / Display OTW Blog Manager Widgets
 */
class OTWBM_Widget extends WP_Widget {

	private $otwBMQuery = null;
	private $otwDispatcher = null;
	private $otwCSS = null;
	// Contructor 
	function __construct(){

		parent::__construct(
			'otw_bm_widget_items', 
			'OTW Blog Manager Widget', 
			array(
				'description' => esc_html__('With the help of this widget you can add your created Widget Lists to the sidebars', 'otw_bm')
			)
		);

		$this->otwBMQuery = new OTWBMQuery();
		$this->otwDispatcher = new OTWDispatcher();
		$this->otwCSS = new OTWCss();
	}

	/** 
	 * Widget Form Creation
	 * Form used to input the List ID.
	 * Once a List is created using the plugin there is going to be and ID supplied
	 * User will need to insert that ID within this FORM
	 */
	function form ( $instance ) {

		( !empty( $instance['id'] ) )? $currentWidgetID = $instance['id'] : $currentWidgetID = null;
		( !empty( $instance['title'] ) )? $currentWidgetTitle = $instance['title'] : $currentWidgetTitle = null;

		$field_id = $this->get_field_id( 'id' );
		$field_idName = $this->get_field_name( 'id' );
		$field_title = $this->get_field_id( 'title' );
		$field_titleName = $this->get_field_name( 'title' );

		$lists = $this->otwBMQuery->getLists();
		
		$htmlForm  = '<p>';
		$htmlForm .= '<label for="'.esc_attr( $field_title ).'">'. esc_html__('Title:', 'otw_bm') .'</label><br>';
		$htmlForm .= '<input type="text" id="'.esc_attr( $field_title ).'" name="'.esc_attr( $field_titleName ).'" value="'.esc_attr( $currentWidgetTitle ).'" class="widefat"><br><br>';

		$htmlForm .= '<label for="'.esc_attr( $field_id ).'">'. esc_html__('OTW Blog List Widget:', 'otw_bm') .'</label><br>';
		$htmlForm .= '<select id="'.esc_attr( $field_id ).'" name="'.esc_attr( $field_idName ).'">';
		$htmlForm .= '<option value="0"> ---'.esc_html__('Select Widget', 'otw_bm').'--- </option>';

		if( is_array( $lists['otw-bm-list'] ) && count( $lists['otw-bm-list'] ) ){
			foreach( $lists['otw-bm-list'] as $optionData ): 
				
				if( isset( $optionData['id'] ) ) {
					
					$selected = '';
					if( $optionData['id'] == $currentWidgetID ) {
						$selected = 'selected="selected" ';
					}
					$htmlForm .= "<option value=\"".$optionData['id']."\" ".$selected.">".$optionData['list_name']."</option>";
				}
			endforeach;
		}

		$htmlForm .= '</select>';
		$htmlForm .= '</p>';
 		
 		echo $htmlForm;

	}

	// Update widget
	function update ( $new_instance, $old_instance ) {
		return $new_instance;
	}

	// Display Widget
	function widget ( $args, $instance ) {
	
		global $otw_bm_factory_object, $otw_bm_plugin_id;
		
		if( !$otw_bm_factory_object->is_plugin_active( $otw_bm_plugin_id ) ){
		
			return;
		}

		$widgetID = $instance['id'];

		if( !empty( $widgetID ) ) {

			// Get Current Items in the DB
			$otw_bm_options = $this->otwBMQuery->getItemById( $widgetID );

			if ( !empty( $otw_bm_options ) ) {
			
				$currentPage = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
				
				if( !preg_match( "/^\d+$/", get_query_var( 'paged' ) ) && preg_match( "/^\d+$/", get_query_var( 'page' ) ) ){
					$currentPage = ( get_query_var( 'page' ) )?get_query_var( 'page' ):1;
				}

				$otw_posts_result = $this->otwBMQuery->getPosts( $otw_bm_options, $currentPage );

				$templateResult = $this->otwDispatcher->generateTemplate( $otw_bm_options, $otw_posts_result );

				$widgetOutput = $templateResult;

				if( !empty( $instance['title'] ) ) {
					$widgetOutput  = $args['before_title'] . $instance['title'] . $args['after_title'];
					$widgetOutput .= $templateResult;

				}

				if( !empty( $args['before_widget'] ) && !empty( $args['after_widget'] ) ) {
					$widgetOutput = $args['before_widget'] . $widgetOutput . $args['after_widget'];
				}
				
				if( !isset( $otw_bm_options['has_custom_css_file'] ) && ( $otw_bm_options['has_custom_css_file'] == 1 ) ){
					wp_register_style( 'otw-bm-custom-widget-'.$widgetID.'-css', SKIN_BM_URL .'otw-bm-list-'.$widgetID.'-custom.css' );
					wp_enqueue_style( 'otw-bm-custom-widget-'.$widgetID.'-css' );
				}

		    include( dirname( __FILE__ ) . '/../include' . DS . 'fonts.php' );
		    $googleFontsArray = json_decode($allFonts);

	      $customFonts = array(
	        'title'         => isset( $otw_bm_options['title_font'] )?$otw_bm_options['title_font']:'',
	        'meta'          => isset( $otw_bm_options['meta_font'] )? $otw_bm_options['meta_font']:'',
	        'excpert'       => isset( $otw_bm_options['excpert_font'] )?$otw_bm_options['excpert_font']:'',
	        'continue_read' => isset( $otw_bm_options['read-more_font'] )?$otw_bm_options['read-more_font']:''
	      );

	      $googleWidgetFonts = $this->otwCSS->getGoogleFonts( $customFonts, $googleFontsArray  );
	      
	      if( !empty( $googleWidgetFonts ) ) {
	        $httpFonts = (!empty($_SERVER['HTTPS'])) ? "https" : "http";
	        $url = $httpFonts.'://fonts.googleapis.com/css?family='.$googleWidgetFonts.'&variant=italic:bold';
	        wp_enqueue_style('otw-bm-widget-googlefonts',$url, null, null);
	      }

				echo $widgetOutput;
			}
			 
		}

	}

}
?>