(function(document, $) {
	'use strict';

	var prevTime = new Date().getTime();

	$(document).on({
		'onInit.eb': function(e, instance, current) {
			instance.$refs.stage.on(
				'mousewheel DOMMouseScroll wheel MozMousePixelScroll',
				function(e) {
					var current = instance.current,
						currTime = new Date().getTime();

					if (
						instance.group.length < 1 ||
						current.opts.wheel === false ||
						(current.opts.wheel === 'auto' &&
							current.type !== 'image')
					) {
						return;
					}

					e.preventDefault();
					e.stopPropagation();

					if (current.$slide.hasClass('envirabox-animated')) {
						return;
					}

					e = e.originalEvent || e;

					if (currTime - prevTime < 250) {
						return;
					}

					prevTime = currTime;

					instance[
						(-e.deltaY ||
							-e.deltaX ||
							e.wheelDelta ||
							-e.detail) < 0
							? 'next'
							: 'previous'
					]();
				},
			);
		},
	});
})(document, window.jQuery || jQuery);
