<?php
/**
 * Debug Output
 *
 * @since 1.7.0
 *
 * @package Envira_Gallery
 * @author  Envira Gallery Team <support@enviragallery.com>
 */

global $wpdb;
?>
<textarea readonly="readonly" onclick="this.focus();this.select()" id="debug-textarea" name="send-system-info-textarea" title="<?php esc_html_e( 'To copy the System Info, click below then press Ctrl + C (PC) or Cmd + C (Mac).', 'send-system-info' ); ?>">
/////////////////////////////////
// Generated by Envira Support //
/////////////////////////////////

Multisite:                <?php echo is_multisite() ? 'Yes' . "\n" : 'No' . "\n"; ?>

SITE_URL:                 <?php echo esc_html( site_url() ) . "\n"; ?>
HOME_URL:                 <?php echo esc_html( home_url() ) . "\n"; ?>

WordPress Version:        <?php echo esc_html( get_bloginfo( 'version' ) ) . "\n"; ?>
Permalink Structure:      <?php echo esc_html( get_option( 'permalink_structure' ) ) . "\n"; ?>
Active Theme:             <?php echo esc_html( $data['theme'] ) . "\n"; ?>

Registered Post Types:    <?php echo esc_html( implode( ', ', get_post_stati() ) ) . "\n\n"; ?>
<?php
if ( isset( $_GET['system_info'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
	echo '// Browser of Current Viewer //';
	echo "\r\n\r\n";
}
?>
<?php echo esc_html( $data['browser']->getBrowser() ); ?>
<?php
if ( isset( $_GET['system_info'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
	echo "\r\n";
	echo '// End Browser of Current Viewer //';
	echo "\r\n\r\n";
}
?>
PHP Version:              <?php echo PHP_VERSION . "\n"; ?>
MySQL Version:            <?php echo esc_html( $wpdb->db_version() ) . "\n"; ?>
Web Server Info:          <?php echo isset( $_SERVER['SERVER_SOFTWARE'] ) ? esc_html( sanitize_text_field( wp_unslash( $_SERVER['SERVER_SOFTWARE'] ) ) ) : '' . "\n"; ?>

WordPress Memory Limit:   <?php echo ( esc_html( envira_let_to_num( WP_MEMORY_LIMIT ) ) / ( 1024 ) ) . 'MB'; ?><?php echo "\n"; ?>
PHP Memory Limit:         <?php echo esc_html( ini_get( 'memory_limit' ) ) . "\n"; ?>
PHP Upload Max Size:      <?php echo esc_html( ini_get( 'upload_max_filesize' ) ) . "\n"; ?>
PHP Post Max Size:        <?php echo esc_html( ini_get( 'post_max_size' ) ) . "\n"; ?>
PHP Upload Max Filesize:  <?php echo esc_html( ini_get( 'upload_max_filesize' ) ) . "\n"; ?>
PHP Max File Uploads:      <?php echo esc_html( ini_get( 'max_file_uploads' ) ) . "\n"; ?>
PHP Input Nesting Level   <?php echo esc_html( ini_get( 'max_input_nesting_level' ) ) . "\n"; ?>
PHP Max Input Time:       <?php echo esc_html( ini_get( 'max_input_time' ) ) . "\n"; ?>
PHP Time Limit:           <?php echo esc_html( ini_get( 'max_execution_time' ) ) . "\n"; ?>
PHP Max Input Vars:       <?php echo esc_html( ini_get( 'max_input_vars' ) ) . "\n"; ?>
PHP Arg Separator:        <?php echo esc_html( ini_get( 'arg_separator.output' ) ) . "\n"; ?>
PHP Allow URL File Open:  <?php echo ( esc_html( ini_get( 'allow_url_fopen' ) ) ? 'Yes' : 'No' ) . PHP_EOL; ?>
GD Extension:             <?php echo ( envira_has_gd_extension() ? 'Yes' : 'No' ) . PHP_EOL; ?>
Imagick Extension:        <?php echo ( envira_has_imagick_extension() ? 'Yes' : 'No' ) . PHP_EOL; ?>

WP_DEBUG:                 <?php echo defined( 'WP_DEBUG' ) ? esc_attr( WP_DEBUG ) ? 'Enabled' . "\n" : 'Disabled' . "\n" : 'Not set' . "\n"; ?>

WP Table Prefix:
<?php
echo 'Length: ' . esc_html( strlen( $wpdb->prefix ) );
echo ' Status:';
if ( strlen( $wpdb->prefix ) > 16 ) {
	echo ' ERROR: Too Long';
} else {
	echo ' Acceptable';
} echo "\n";
?>

Show On Front:            <?php echo esc_html( get_option( 'show_on_front' ) ) . "\n"; ?>
Page On Front:
<?php
$id_option = get_option( 'page_on_front' );
echo isset( $id ) ? esc_html( get_the_title( $id ) ) . ' (#' . esc_attr( $id_option ) . ')' . "\n" : "\n";
?>
Page For Posts:
<?php
$id_option = get_option( 'page_for_posts' );
echo isset( $id ) ? esc_html( get_the_title( $id ) ) . ' (#' . esc_attr( $id_option ) . ')' . "\n" : "\n";
?>

WP Remote Post:           <?php echo esc_attr( $data['wp_remote'] ); ?>

Session:                  <?php echo isset( $_SESSION ) ? 'Enabled' : 'Disabled'; ?><?php echo "\n"; ?>
Session Name:             <?php echo esc_html( ini_get( 'session.name' ) ); ?><?php echo "\n"; ?>
Cookie Path:              <?php echo esc_html( ini_get( 'session.cookie_path' ) ); ?><?php echo "\n"; ?>
Save Path:                <?php echo esc_html( ini_get( 'session.save_path' ) ); ?><?php echo "\n"; ?>
Use Cookies:              <?php echo ini_get( 'session.use_cookies' ) ? 'On' : 'Off'; ?><?php echo "\n"; ?>
Use Only Cookies:         <?php echo ini_get( 'session.use_only_cookies' ) ? 'On' : 'Off'; ?><?php echo "\n"; ?>

DISPLAY ERRORS:           <?php echo ( ini_get( 'display_errors' ) ) ? 'On (' . esc_html( ini_get( 'display_errors' ) ) . ')' : 'N/A'; ?><?php echo "\n"; ?>
FSOCKOPEN:                <?php echo ( function_exists( 'fsockopen' ) ) ? 'Your server supports fsockopen.' : 'Your server does not support fsockopen.'; ?><?php echo "\n"; ?>
cURL:                     <?php echo ( function_exists( 'curl_init' ) ) ? 'Your server supports cURL.' : 'Your server does not support cURL.'; ?><?php echo "\n"; ?>
SOAP Client:              <?php echo ( class_exists( 'SoapClient' ) ) ? 'Your server has the SOAP Client enabled.' : 'Your server does not have the SOAP Client enabled.'; ?><?php echo "\n"; ?>
SUHOSIN:                  <?php echo ( extension_loaded( 'suhosin' ) ) ? 'Your server has SUHOSIN installed.' : 'Your server does not have SUHOSIN installed.'; ?><?php echo "\n"; ?>
MB ENCODING:              <?php echo ( function_exists( 'mb_detect_encoding' ) ) ? 'Your server has MB ENCODING enabled.' : 'Your server does not have MB ENCODING enabled.'; ?><?php echo "\n"; ?>
ZIP ARCHIVE:              <?php echo ( class_exists( 'ZipArchive' ) ) ? 'Your server has ZipArchive installed (PHP).' : 'Your server does not have ZipArchive installed (PHP).'; ?><?php echo "\n"; ?>

CACHING:

WP_CACHE                  <?php echo ( ! defined( 'WP_CACHE' ) || ! WP_CACHE ) ? 'No' : 'Yes'; ?><?php echo "\n"; ?>
Ext Object Cache          <?php echo ( wp_using_ext_object_cache() ) ? 'Yes' : 'No'; ?><?php echo "\n"; ?>

HOST:

<?php if ( version_compare( phpversion(), '5.3', '>' ) ) { ?>
Hostname:                 <?php echo esc_html( gethostname() ); ?><?php echo "\n"; ?>
<?php } ?>
<?php

$the_host   = false;
$is_local   = false;
$find_host  = gethostname();
$find_local = strpos( $find_host, 'local' );
if ( ! empty( $find_local ) ) {
	$is_local = true;
} elseif ( strpos( $find_host, 'sgvps.net' ) ) {
				$the_host = 'Siteground';
} elseif ( strpos( $find_host, 'pagelyhosting.com' ) ) {
	$the_host = 'Pagely';
} elseif ( strpos( $find_host, 'fw' ) ) {
	$the_host = 'Flywheel';
} elseif ( strpos( $find_host, 'secureserver.net' ) ) {
	$the_host = 'GoDaddy/Media Temple';
} else {
	$the_host = 'We cannot determine your web host. Please mention it in your Envira support ticket.';
}
?>
Host:                     <?php echo ( esc_html( $is_local ) ) ? 'This is a local environment' : esc_html( $the_host ); ?><?php echo "\n"; ?>

ACTIVE PLUGINS:

<?php
$wp_plugins     = get_plugins();
$active_plugins = get_option( 'active_plugins', [] );

foreach ( $wp_plugins as $plugin_path => $plugin ) {
	// If the plugin isn't active, don't show it.
	if ( ! in_array( $plugin_path, $active_plugins, true ) ) {
		continue;
	}

	echo esc_html( $plugin['Name'] . ': ' . $plugin['Version'] . "\n" );
}

?>

ENVIRA SETTINGS:

ENVIRA_DEBUG                                 <?php echo ( ! defined( 'ENVIRA_DEBUG' ) || ! ENVIRA_DEBUG ) ? 'No' : 'Yes'; ?><?php echo "\n"; ?>
Add New Images Before Existing Images:       <?php echo ucwords( envira_get_setting( 'media_position' ) ) ? 'Yes' : 'No'; ?><?php echo "\n"; ?>
Delete Image on Gallery Image Deletion:      <?php echo ( envira_get_setting( 'image_delete' ) ) ? 'Yes' : 'No'; ?><?php echo "\n"; ?>
Delete Images on Gallery Deletion:            <?php echo ( envira_get_setting( 'media_delete' ) ) ? 'Yes' : 'No'; ?><?php echo "\n"; ?>
Standalone:                                  <?php echo ( envira_standalone_get_the_slug( 'standalone_enabled' ) ) ? 'Yes' : 'No'; ?><?php echo "\n"; ?>
Gallery Slug:                                <?php echo ( esc_html( envira_standalone_get_the_slug( 'gallery' ) ) ); ?><?php echo "\n"; ?>
Album Slug:                                  <?php echo ( esc_html( envira_standalone_get_the_slug( 'albums' ) ) ); ?><?php echo "\n"; ?>

<?php

if ( is_multisite() ) :
	?>

NETWORK ACTIVE PLUGINS:

	<?php

	$wp_plugins     = wp_get_active_network_plugins();
	$active_plugins = get_site_option( 'active_sitewide_plugins', [] );

	foreach ( $wp_plugins as $plugin_path ) {
		$plugin_base = plugin_basename( $plugin_path );

		// If the plugin isn't active, don't show it.
		if ( ! array_key_exists( $plugin_base, $active_plugins ) ) {
			continue;
		}

		$plugin = get_plugin_data( $plugin_path );

		echo esc_html( $plugin['Name'] . ' :' . $plugin['Version'] . "\n" );
	}
endif;

if ( has_action( 'ssi_extra_info' ) ) {
	echo "\n";
	do_action( 'ssi_extra_info' );
}
?>

</textarea>
