<?php

/**
 * Add Metaboxes
 *
 * @version 1.0.0
 * @since   1.0.0
 */
add_meta_box('gs_gallery_image', esc_html__('Gallery Options', GSPWP_TEXTDOMAIN), 'gspwp_gallery_image', 'gs_layouts', 'normal');

if (!function_exists('gspwp_gallery_image')) {

    function gspwp_gallery_image($post) {
        $gallery_meta_data = get_post_custom($post->ID);
        
        $gspwp_gallery_image = '';
        if (isset($gallery_meta_data['gs_gallery_images'])) {
            $gspwp_gallery_image = $gallery_meta_data['gs_gallery_images'][0];
        }
        $button = '<button></button>';
        $selectText = esc_html__('Select Images', GSPWP_TEXTDOMAIN);
        $visible = 'hidden';
        if ($gspwp_gallery_image) {
            $selectText = esc_html__('Edit', GSPWP_TEXTDOMAIN);
            $visible = 'visible';
        }
        $gspwp_gallery_details = '';
        if (isset($gallery_meta_data['gs_gallery_details'])) {
            $gspwp_gallery_details = unserialize($gallery_meta_data['gs_gallery_details'][0]);
        }
        wp_nonce_field(plugin_basename(__FILE__), 'gspwp_gallery_image_information');
        $gspwp_options = get_post_custom($post->ID, 'gs_optoins', true);
        if (is_array($gspwp_options) && !empty($gspwp_options)) {
            $gspwp_options = unserialize($gspwp_options['gs_optoins'][0]);
        } else {
            $gspwp_options = array();
        }
        $default_value = gspwp_default_values();
        
        $gspwp_options = array_merge($default_value, $gspwp_options);
        ?>
        <div class="gspwp_gallery_option_wrap">

            <div class="gspwp_gallery_option_input">
                <div class="gspwp_gallery_cover">
                    <?php   
                        if ($gspwp_gallery_image) {
                            $gallery_images = explode(',', $gspwp_gallery_image);
                            foreach ($gallery_images as $value) {
                                $post_data = get_post($value);                              
                            
                                $title = isset($gspwp_gallery_details[$value]['title']) ? $gspwp_gallery_details[$value]['title'] : $post_data->post_title;
                                $desc = isset($gspwp_gallery_details[$value]['desc']) ? $gspwp_gallery_details[$value]['desc'] : $post_data->post_content;
                                ?>
                                <div class="gspwp_gallery_single_cover">
                                    <div class="gspwp_gallery_image_cover">
                                        <img src="<?php echo esc_url(wp_get_attachment_url($value)); ?>" id="<?php echo 'gs_gallery_' . esc_attr($value); ?>" >
                                    </div>
                                    <div class="gspwp_gallery_content_cover">
                                        <p>
                                            <label for="gspwp_gallery_title_<?php echo esc_attr($value); ?>"><?php esc_html_e('Title', GSPWP_TEXTDOMAIN); ?></label>
                                            <input id="gspwp_gallery_title_<?php echo esc_attr($value); ?>" name="gs_gallery_details[<?php echo esc_attr($value); ?>][title]" type="text" value="<?php echo esc_attr($title); ?>">
                                        </p>
                                        <p>
                                            <label for="gspwp_gallery_desc_<?php echo esc_attr($value); ?>"><?php esc_html_e('Description', GSPWP_TEXTDOMAIN); ?></label>
                                            <textarea id="gspwp_gallery_desc_<?php echo esc_attr($value); ?>" name="gs_gallery_details[<?php echo esc_attr($value); ?>][desc]"><?php echo __( $desc , GSPWP_TEXTDOMAIN); ?></textarea>
                                        </p>
                                    </div>
                                </div>
                                <?php
                            }
                        }
                    ?>
                </div>
                <input type="hidden" name="gs_gallery_post_id" id="gspwp_gallery_post_id" value="<?php echo esc_attr($post->ID); ?>" />
                <input type="hidden" name="gs_gallery_images" id="gspwp_gallery_images" value="<?php echo esc_attr($gspwp_gallery_image); ?>" />
                <button class="button" id="gspwp_gallery_image_select"><?php esc_html_e( $selectText , GSPWP_TEXTDOMAIN); ?></button>
                <button class="button <?php echo esc_attr($visible); ?>" id="gspwp_gallery_image_removeall"><?php esc_html_e('Remove All', GSPWP_TEXTDOMAIN); ?></button>
            </div>

        </div>
        <?php
    }

}

/**
 * Add Metaboxes For Layout Options
 *
 * @version 1.0.0
 * @since   1.0.0
 */
add_meta_box('gs_layout_options', esc_html__('Layout Options', GSPWP_TEXTDOMAIN), 'gspwp_layout_options', 'gs_layouts', 'normal', 'high');

if (!function_exists('gspwp_layout_options')) {

    function gspwp_layout_options($post) {
        wp_nonce_field(plugin_basename(__FILE__), 'gspwp_layout_options_nonce');
        $gspwp_options = get_post_custom($post->ID, 'gs_optoins', true);

        if (is_array($gspwp_options) && !empty($gspwp_options)) {
            $gspwp_options = unserialize($gspwp_options['gs_optoins'][0]);
        } else {
            $gspwp_options = array();
        }
        $default_value = gspwp_default_values();
        $gspwp_options = array_merge($default_value, $gspwp_options);
        
        ?>
        <div class="gspwp_panel_wrap">
            <ul class="gspwp-options-tabs">
                <li class="gspwp-options-tab layout-setting-data" data-id="#layout-setting-data">
                    <span> <i class="fa fa-gears"></i> <?php esc_html_e('General', GSPWP_TEXTDOMAIN) ?></span>
                </li>
                <li class="gspwp-options-tab thumbnail-setting-data" data-id="#thumbnail-setting-data">
                    <span> <i class="fa fa-image"></i> <?php esc_html_e('Thumbnail', GSPWP_TEXTDOMAIN) ?></span>
                </li>
                <li class="gspwp-options-tab slider-setting-data" data-id="#slider-setting-data">
                    <span> <i class="fa fa-map"></i> <?php esc_html_e('Slider Setting', GSPWP_TEXTDOMAIN) ?></span>
                </li>
                <li class="gspwp-options-tab title-setting-data" data-id="#title-setting-data">
                    <span> <i class="fa fa-window-maximize"></i> <?php esc_html_e('Title Setting', GSPWP_TEXTDOMAIN) ?></span>
                </li>
                <li class="gspwp-options-tab content-setting-data" data-id="#content-setting-data">
                    <span> <i class="fa fa-file-text-o"></i> <?php esc_html_e('Content Setting', GSPWP_TEXTDOMAIN) ?></span>
                </li>
                <li class="gspwp-options-tab filter-design" data-id="#filter-design">
                    <span> <i class="fa fa-delicious"></i> <?php esc_html_e('Filter Design', GSPWP_TEXTDOMAIN) ?></span>
                </li>
            </ul>

            <div id="layout-setting-data" class="panel gspwp-options-panel hidden">
                
                <div class="gspwp-options-group">
                    <div class="gspwp-form-field gspwp-buttonset-cover">
                        <label> <?php esc_html_e('Enable Dynamic Posts?', GSPWP_TEXTDOMAIN); ?> </label>
                        <fieldset class="gspwp-buttonset">
                            <?php $dynamic_post_content = isset($gspwp_options['dynamic_post_content']) ? $gspwp_options['dynamic_post_content'] : 1; ?>
                            <input id="dynamic_post_content_0" name="options[dynamic_post_content]" type="radio" value="0" <?php echo checked(0, $dynamic_post_content); ?>/>
                            <label for="dynamic_post_content_0"><?php esc_html_e('Yes', GSPWP_TEXTDOMAIN); ?></label>
                            <input id="dynamic_post_content_1" name="options[dynamic_post_content]" type="radio" value="1" <?php echo checked(1, $dynamic_post_content); ?> />
                            <label for="dynamic_post_content_1"><?php esc_html_e('No', GSPWP_TEXTDOMAIN); ?></label>
                        </fieldset>
                    </div>
                </div>

                <div class="gspwp-options-group gspwp-dynamic-post-data">
                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="custom_post_type"><?php esc_html_e('Custom Post Type', GSPWP_TEXTDOMAIN) ?></label>
                        <select id="custom_post_type" name="options[custom_post_type]"  class="chosen-select" data-placeholder="<?php esc_attr_e('Custom Post Type', GSPWP_TEXTDOMAIN) ?>">
                        <?php
                            $args = array(
                                'public'   => true,
                            );
                        
                            $output = 'objects'; // names or objects, note names is the default
                            $operator = 'and'; // 'and' or 'or'
                            
                            $post_types = get_post_types( $args, $output, $operator ); 

                            foreach ($post_types as $post_type) {
                                if( $post_type->name != 'attachment' && $post_type->name != 'page') {
                                    ?>
                                        <option value="<?php echo esc_attr($post_type->name); ?>" <?php echo ( isset($gspwp_options['custom_post_type']) && $gspwp_options['custom_post_type'] == $post_type->name ) ? 'selected="selected"' : '' ?>><?php _e($post_type->label, GSPWP_TEXTDOMAIN) ?></option>
                                    <?php
                                }
                            }
                        ?>
                        </select>
                    </div>
                </div>

                <div class="gspwp-options-group gspwp-dynamic-post-data">
                    <div class="gspwp-form-field gspwp-number-cover gspwp-number-style">
                        <label for="set_post_limit"> <?php esc_html_e('Set Post Image Limit', GSPWP_TEXTDOMAIN) ?>
                            <div class="tooltip"> <i class="fa fa-info" aria-hidden="true"></i>
                                <span class="tooltiptext"><?php esc_html_e('If you set -1 / 0 it will take all Images.',GSPWP_TEXTDOMAIN); ?></span>
                            </div>
                        </label>
                        <input type="number" class="gspwp-number" id="set_post_limit" name="options[set_post_limit]" min="-1" placeholder="<?php esc_attr_e('-1', GSPWP_TEXTDOMAIN); ?>" value="<?php echo ( isset($gspwp_options['set_post_limit']) && $gspwp_options['set_post_limit'] != '') ? esc_attr($gspwp_options['set_post_limit']) : '-1' ?>">
                    </div>
                </div>

                <div class="gspwp-options-group gspwp-dynamic-post-data">
                    <div class="gspwp-form-field gspwp-buttonset-cover">
                        <label> <?php esc_html_e('Want Categories Filter', GSPWP_TEXTDOMAIN); ?> </label>
                        <fieldset class="gspwp-buttonset">
                            <?php $want_category_filter = isset($gspwp_options['want_category_filter']) ? $gspwp_options['want_category_filter'] : 1; ?>
                            <input id="want_category_filter_0" name="options[want_category_filter]" type="radio" value="0" <?php echo checked(0, $want_category_filter); ?>/>
                            <label for="want_category_filter_0"><?php esc_html_e('Yes', GSPWP_TEXTDOMAIN); ?></label>
                            <input id="want_category_filter_1" name="options[want_category_filter]" type="radio" value="1" <?php echo checked(1, $want_category_filter); ?> />
                            <label for="want_category_filter_1"><?php esc_html_e('No', GSPWP_TEXTDOMAIN); ?></label>
                        </fieldset>
                    </div>
                </div>
                <!-- gspwp-category-filter  gspwp-dynamic-post-data-->
                <div class="gspwp-options-group  custom-post-type-taxonomies">
                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="custom_post_type_taxonomies"><?php esc_html_e('Select Filter Category', GSPWP_TEXTDOMAIN) ?></label>
                            <select id="custom_post_type_taxonomies" name="options[custom_post_type_taxonomies]"  class="chosen-select" data-placeholder="<?php esc_attr_e('No Category Found', GSPWP_TEXTDOMAIN) ?>">
                            <?php
                                $post_type = ( isset($gspwp_options['custom_post_type'])  ) ? $gspwp_options['custom_post_type'] : "post";
                                $taxonomies_array = get_object_taxonomies( $post_type );
                                foreach ($taxonomies_array as $taxonomy) {                                   
                                    $taxonomy_details = get_taxonomy( $taxonomy );
                                    if($taxonomy != "post_format"){ ?>                                                              
                                        <option value="<?php echo esc_attr( $taxonomy ); ?>" <?php selected( $gspwp_options['custom_post_type_taxonomies'], $taxonomy); ?> ><?php esc_html_e( $taxonomy_details->label , GSPWP_TEXTDOMAIN) ?></option>
                                        <?php
                                    }
                                } ?>
                        </select>
                    </div>
                </div>

                <div class="gspwp-options-group">
                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="layout_type"><?php esc_html_e('Layout Type', GSPWP_TEXTDOMAIN) ?></label>
                        <select id="layout_type" name="options[layout_type]"  class="chosen-select" data-placeholder="<?php esc_attr_e('Layout Type', GSPWP_TEXTDOMAIN) ?>">
                            <option value="grid" <?php echo ($gspwp_options['layout_type'] == 'grid') ? 'selected="selected"' : '' ?>><?php esc_attr_e('Grid', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="masonry" <?php echo ($gspwp_options['layout_type'] == 'masonry') ? 'selected="selected"' : '' ?> ><?php esc_attr_e('Masonry', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="slider" <?php echo ($gspwp_options['layout_type'] == 'slider') ? 'selected="selected"' : '' ?> ><?php esc_attr_e('Slider', GSPWP_TEXTDOMAIN) ?></option>
                        </select>
                    </div>
                </div>

                <div class="gspwp-options-group">
                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="column_desktop"> <?php esc_attr_e('Column for Desktop', GSPWP_TEXTDOMAIN); ?> </label>
                        <select id="column_desktop" name="options[column_desktop]">
                            <option value="1" <?php echo ($gspwp_options['column_desktop'] == '1') ? 'selected="selected"' : '' ?>><?php esc_attr_e('1 Column', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="2" <?php echo ($gspwp_options['column_desktop'] == '2') ? 'selected="selected"' : '' ?>><?php esc_attr_e('2 Columns', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="3" <?php echo ($gspwp_options['column_desktop'] == '3') ? 'selected="selected"' : '' ?>><?php esc_attr_e('3 Columns', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="4" <?php echo ($gspwp_options['column_desktop'] == '4') ? 'selected="selected"' : '' ?>><?php esc_attr_e('4 Columns', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="5" <?php echo ($gspwp_options['column_desktop'] == '5') ? 'selected="selected"' : '' ?>><?php esc_attr_e('5 Columns', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="6" <?php echo ($gspwp_options['column_desktop'] == '6') ? 'selected="selected"' : '' ?>><?php esc_attr_e('6 Columns', GSPWP_TEXTDOMAIN) ?></option>
                        </select>
                    </div>

                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="column_small_desktop"> <?php esc_attr_e('Column for Small Desktop', GSPWP_TEXTDOMAIN); ?> </label>
                        <select id="column_small_desktop" name="options[column_small_desktop]">
                            <option value="1" <?php echo ($gspwp_options['column_small_desktop'] == '1') ? 'selected="selected"' : '' ?>><?php esc_attr_e('1 Column', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="2" <?php echo ($gspwp_options['column_small_desktop'] == '2') ? 'selected="selected"' : '' ?>><?php esc_attr_e('2 Columns', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="3" <?php echo ($gspwp_options['column_small_desktop'] == '3') ? 'selected="selected"' : '' ?>><?php esc_attr_e('3 Columns', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="4" <?php echo ($gspwp_options['column_small_desktop'] == '4') ? 'selected="selected"' : '' ?>><?php esc_attr_e('4 Columns', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="5" <?php echo ($gspwp_options['column_small_desktop'] == '5') ? 'selected="selected"' : '' ?>><?php esc_attr_e('5 Columns', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="6" <?php echo ($gspwp_options['column_small_desktop'] == '6') ? 'selected="selected"' : '' ?>><?php esc_attr_e('6 Columns', GSPWP_TEXTDOMAIN) ?></option>
                        </select>
                    </div>

                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="column_tablet"> <?php esc_attr_e('Column for Tablet', GSPWP_TEXTDOMAIN); ?> </label>
                        <select id="column_tablet" name="options[column_tablet]">
                            <option value="1" <?php echo ($gspwp_options['column_tablet'] == '1') ? 'selected="selected"' : '' ?>><?php esc_attr_e('1 Column', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="2" <?php echo ($gspwp_options['column_tablet'] == '2') ? 'selected="selected"' : '' ?>><?php esc_attr_e('2 Columns', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="3" <?php echo ($gspwp_options['column_tablet'] == '3') ? 'selected="selected"' : '' ?>><?php esc_attr_e('3 Columns', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="4" <?php echo ($gspwp_options['column_tablet'] == '4') ? 'selected="selected"' : '' ?>><?php esc_attr_e('4 Columns', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="5" <?php echo ($gspwp_options['column_tablet'] == '5') ? 'selected="selected"' : '' ?>><?php esc_attr_e('5 Columns', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="6" <?php echo ($gspwp_options['column_tablet'] == '6') ? 'selected="selected"' : '' ?>><?php esc_attr_e('6 Columns', GSPWP_TEXTDOMAIN) ?></option>
                        </select>
                    </div>

                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="column_mobile"> <?php esc_attr_e('Column for Mobile', GSPWP_TEXTDOMAIN); ?> </label>
                        <select id="column_mobile" name="options[column_mobile]">
                            <option value="1" <?php echo ($gspwp_options['column_mobile'] == '1') ? 'selected="selected"' : '' ?>><?php esc_attr_e('1 Column', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="2" <?php echo ($gspwp_options['column_mobile'] == '2') ? 'selected="selected"' : '' ?>><?php esc_attr_e('2 Columns', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="3" <?php echo ($gspwp_options['column_mobile'] == '3') ? 'selected="selected"' : '' ?>><?php esc_attr_e('3 Columns', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="4" <?php echo ($gspwp_options['column_mobile'] == '4') ? 'selected="selected"' : '' ?>><?php esc_attr_e('4 Columns', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="5" <?php echo ($gspwp_options['column_mobile'] == '5') ? 'selected="selected"' : '' ?>><?php esc_attr_e('5 Columns', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="6" <?php echo ($gspwp_options['column_mobile'] == '6') ? 'selected="selected"' : '' ?>><?php esc_attr_e('6 Columns', GSPWP_TEXTDOMAIN) ?></option>
                        </select>
                    </div>
                </div>

                <div class="gspwp-options-group">
                    <div class="gspwp-form-field gspwp-number-cover">
                        <label for="padding_top"> <?php esc_attr_e('Padding', GSPWP_TEXTDOMAIN) ?> </label>
                        <input type="number" class="gspwp-four-number" id="padding_top" name="options[padding_top]" min="0" placeholder="<?php esc_attr_e('Top', GSPWP_TEXTDOMAIN); ?>" value="<?php echo ($gspwp_options['padding_top'] != '') ? esc_attr($gspwp_options['padding_top']) : '0' ?>">
                        <input type="number" class="gspwp-four-number" id="padding_right" name="options[padding_right]" min="0" placeholder="<?php esc_attr_e('Right', GSPWP_TEXTDOMAIN); ?>" value="<?php echo ($gspwp_options['padding_right'] != '') ? esc_attr($gspwp_options['padding_right']) : '0' ?>">
                        <input type="number" class="gspwp-four-number" id="padding_bottom" name="options[padding_bottom]" min="0" placeholder="<?php esc_attr_e('Bottom', GSPWP_TEXTDOMAIN); ?>" value="<?php echo ($gspwp_options['padding_bottom'] != '') ? esc_attr($gspwp_options['padding_bottom']) : '0' ?>">
                        <input type="number" class="gspwp-four-number" id="padding_left" name="options[padding_left]" min="0" placeholder="<?php esc_attr_e('Left', GSPWP_TEXTDOMAIN); ?>" value="<?php echo ($gspwp_options['padding_left'] != '') ? esc_attr($gspwp_options['padding_left']) : '0' ?>">
                    </div>
                </div>

                <div class="gspwp-options-group">
                    <div class="gspwp-form-field gspwp-testarea-cover">
                        <label for="custom_css"> <?php esc_attr_e('Custom CSS', GSPWP_TEXTDOMAIN); ?> </label>
                        <textarea id="custom_css" name="options[custom_css]" placeholder="<?php esc_attr_e('Write your Custom CSS here', GSPWP_TEXTDOMAIN); ?>"><?php echo esc_attr_e($gspwp_options['custom_css']); ?></textarea>
                    </div>
                </div>
            </div>

            <div id="thumbnail-setting-data" class="panel gspwp-options-panel hidden">
                <div class="gspwp-options-group">
                    <?php $thumb_sizes = array(); ?>
                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="image_size"> <?php esc_html_e('Select Image Size', 'gllery-showcase'); ?> </label>
                        <select id="image_size" name="options[image_size]">
                            <option value="full" <?php echo (isset($gspwp_options['image_size']) && $gspwp_options['image_size'] == 'full') ? 'selected="selected"' : ''; ?>><?php esc_html_e('Original Resolution', GSPWP_TEXTDOMAIN); ?></option>
                            <?php
                            foreach (get_intermediate_image_sizes() as $s) {
                                $thumb_sizes [$s] = array(0, 0);
                                if (in_array($s, array('thumbnail', 'medium', 'large'))) {
                                    ?> <option value="<?php echo esc_attr($s); ?>"  <?php echo (isset($gspwp_options['image_size']) && $gspwp_options['image_size'] == $s) ? 'selected="selected"' : ''; ?>> <?php echo esc_attr($s) . ' (' . esc_attr(get_option($s . '_size_w')) . 'x' . esc_attr(get_option($s . '_size_h')) . ')'; ?> </option> <?php
                                }
                            }
                            ?>
                            <option value="custom" <?php echo (isset($gspwp_options['image_size']) && $gspwp_options['image_size'] == 'custom') ? 'selected="selected"' : '' ?>><?php esc_html_e('Custom Size', GSPWP_TEXTDOMAIN); ?></option>
                        </select>
                    </div>
                </div>

                <div class="gspwp-options-group gspwp-image-custom-size">
                    <div class="gspwp-form-field gspwp-number-cover">
                        <label for="image_width"> <?php esc_html_e('Add Image Size', 'gllery-showcase'); ?> </label>
                        <input type="number" class="gspwp-two-number" id="image_width" name="options[image_width]" min="50" placeholder="<?php esc_attr_e('Width', GSPWP_TEXTDOMAIN); ?>" value="<?php echo ($gspwp_options['image_width'] != '') ? esc_attr($gspwp_options['image_width']) : '500' ?>">
                        <input type="number" class="gspwp-two-number" id="image_height" name="options[image_height]" min="50" placeholder="<?php esc_attr_e('Height', GSPWP_TEXTDOMAIN); ?>" value="<?php echo ($gspwp_options['image_height'] != '') ? esc_attr($gspwp_options['image_height']) : '500' ?>">
                    </div>
                </div>

                <div class="gspwp-options-group gspwp-image-custom-size">
                    <div class="gspwp-form-field gspwp-checkbox-cover">
                        <label for="gspwp-image-hard-crop"><?php esc_html_e('Image Hard Corp', GSPWP_TEXTDOMAIN) ?></label>
                        <input id="gspwp-image-hard-crop" name="options[image-hard-crop]" value="1" type="checkbox" <?php echo (isset($gspwp_options['image-hard-crop']) && $gspwp_options['image-hard-crop'] == 1) ? 'checked="checked"' : ''; ?>>
                    </div>
                </div>

                <div class="gspwp-options-group">
                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="layout_effect"> <?php _e('Layout Effects', GSPWP_TEXTDOMAIN); ?> </label>
                        <select id="layout_effect" name="options[layout_effect]">
                            <optgroup class="inspirational" label="<?php _e('Inspirational', GSPWP_TEXTDOMAIN); ?>">
                                <option value="apollo" <?php echo ($gspwp_options['layout_effect'] == 'apollo') ? 'selected="selected"' : '' ?>><?php _e('Apollo', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="bubba" <?php echo ($gspwp_options['layout_effect'] == 'bubba') ? 'selected="selected"' : '' ?>><?php _e('Bubba', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="chico" <?php echo ($gspwp_options['layout_effect'] == 'chico') ? 'selected="selected"' : '' ?>><?php _e('Chico', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="dexter" <?php echo ($gspwp_options['layout_effect'] == 'dexter') ? 'selected="selected"' : '' ?>><?php _e('Dexter', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="duke" <?php echo ($gspwp_options['layout_effect'] == 'duke') ? 'selected="selected"' : '' ?>><?php _e('Duke', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="jazz" <?php echo ($gspwp_options['layout_effect'] == 'jazz') ? 'selected="selected"' : '' ?>><?php _e('Jazz', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="julia" <?php echo ($gspwp_options['layout_effect'] == 'julia') ? 'selected="selected"' : '' ?>><?php _e('Julia', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="goliath" <?php echo ($gspwp_options['layout_effect'] == 'goliath') ? 'selected="selected"' : '' ?>><?php _e('Goliath', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="layla" <?php echo ($gspwp_options['layout_effect'] == 'layla') ? 'selected="selected"' : '' ?>><?php _e('Layla', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="lily" <?php echo ($gspwp_options['layout_effect'] == 'lily') ? 'selected="selected"' : '' ?>><?php _e('Lily', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="marley" <?php echo ($gspwp_options['layout_effect'] == 'marley') ? 'selected="selected"' : '' ?>><?php _e('Marley', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="milo" <?php echo ($gspwp_options['layout_effect'] == 'milo') ? 'selected="selected"' : '' ?>><?php _e('Milo', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="ming" <?php echo ($gspwp_options['layout_effect'] == 'ming') ? 'selected="selected"' : '' ?>><?php _e('Ming', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="moses" <?php echo ($gspwp_options['layout_effect'] == 'moses') ? 'selected="selected"' : '' ?>><?php _e('Moses', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="oscar" <?php echo ($gspwp_options['layout_effect'] == 'oscar') ? 'selected="selected"' : '' ?>><?php _e('Oscar', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="ruby" <?php echo ($gspwp_options['layout_effect'] == 'ruby') ? 'selected="selected"' : '' ?>><?php _e('Ruby', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="romeo" <?php echo ($gspwp_options['layout_effect'] == 'romeo') ? 'selected="selected"' : '' ?>><?php _e('Romeo', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="roxy" <?php echo ($gspwp_options['layout_effect'] == 'roxy') ? 'selected="selected"' : '' ?>><?php _e('Roxy', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="sadie" <?php echo ($gspwp_options['layout_effect'] == 'sadie') ? 'selected="selected"' : '' ?>><?php _e('Sadie', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="sarah" <?php echo ($gspwp_options['layout_effect'] == 'sarah') ? 'selected="selected"' : '' ?>><?php _e('Sarah', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="selena" <?php echo ($gspwp_options['layout_effect'] == 'selena') ? 'selected="selected"' : '' ?>><?php _e('Selena', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="steve" <?php echo ($gspwp_options['layout_effect'] == 'steve') ? 'selected="selected"' : '' ?>><?php _e('Steve', GSPWP_TEXTDOMAIN) ?></option>
                                <option value="zoe" <?php echo ($gspwp_options['layout_effect'] == 'zoe') ? 'selected="selected"' : '' ?>><?php _e('Zoe', GSPWP_TEXTDOMAIN) ?></option>
                            </optgroup>
                        </select>
                        <input type="text" id="layout_effect_group" class="hidden" value="<?php echo ( $gspwp_options['layout_effect_group'] != '') ? esc_attr($gspwp_options['layout_effect_group']) : '' ?>" name="options[layout_effect_group]" />
                    </div>
                </div>

                <div class="gspwp-options-group">
                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="layout_animation"> <?php _e('Animation', GSPWP_TEXTDOMAIN); ?> </label>
                        <select id="layout_animation" name="options[layout_animation]">
                            <option value="" <?php echo ($gspwp_options['layout_animation'] == '') ? 'selected="selected"' : '' ?>><?php _e('None', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="bounce" <?php echo ($gspwp_options['layout_animation'] == 'bounce') ? 'selected="selected"' : '' ?>><?php _e('Bounce', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="bounceIn" <?php echo ($gspwp_options['layout_animation'] == 'bounceIn') ? 'selected="selected"' : '' ?>><?php _e('Bounce In', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="bounceInDown" <?php echo ($gspwp_options['layout_animation'] == 'bounceInDown') ? 'selected="selected"' : '' ?>><?php _e('Bounce In Down', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="bounceInLeft" <?php echo ($gspwp_options['layout_animation'] == 'bounceInLeft') ? 'selected="selected"' : '' ?>><?php _e('Bounce In Left', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="bounceInRight" <?php echo ($gspwp_options['layout_animation'] == 'bounceInRight') ? 'selected="selected"' : '' ?>><?php _e('Bounce In Right', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="bounceInUp" <?php echo ($gspwp_options['layout_animation'] == 'bounceInUp') ? 'selected="selected"' : '' ?>><?php _e('Bounce In Up', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="jackInTheBox" <?php echo ($gspwp_options['layout_animation'] == 'jackInTheBox') ? 'selected="selected"' : '' ?>><?php _e('Jack In The Box', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="jello" <?php echo ($gspwp_options['layout_animation'] == 'jello') ? 'selected="selected"' : '' ?>><?php _e('Jello', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="flash" <?php echo ($gspwp_options['layout_animation'] == 'flash') ? 'selected="selected"' : '' ?>><?php _e('Flash', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="fadeIn" <?php echo ($gspwp_options['layout_animation'] == 'fadeIn') ? 'selected="selected"' : '' ?>><?php _e('Fade In', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="fadeInDown" <?php echo ($gspwp_options['layout_animation'] == 'fadeInDown') ? 'selected="selected"' : '' ?>><?php _e('Fade In Down', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="fadeInDownBig" <?php echo ($gspwp_options['layout_animation'] == 'fadeInDownBig') ? 'selected="selected"' : '' ?>><?php _e('Fade In Down Big', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="fadeInLeft" <?php echo ($gspwp_options['layout_animation'] == 'fadeInLeft') ? 'selected="selected"' : '' ?>><?php _e('Fade In Left', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="fadeInLeftBig" <?php echo ($gspwp_options['layout_animation'] == 'fadeInLeftBig') ? 'selected="selected"' : '' ?>><?php _e('Fade In Left Big', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="fadeInRight" <?php echo ($gspwp_options['layout_animation'] == 'fadeInRight') ? 'selected="selected"' : '' ?>><?php _e('Fade In Right', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="fadeInRightBig" <?php echo ($gspwp_options['layout_animation'] == 'fadeInRightBig') ? 'selected="selected"' : '' ?>><?php _e('Fade In Right Big', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="fadeInUp" <?php echo ($gspwp_options['layout_animation'] == 'fadeInUp') ? 'selected="selected"' : '' ?>><?php _e('Fade In Up', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="fadeInUpBig" <?php echo ($gspwp_options['layout_animation'] == 'fadeInUpBig') ? 'selected="selected"' : '' ?>><?php _e('Fade In Up Big', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="flipInX" <?php echo ($gspwp_options['layout_animation'] == 'flipInX') ? 'selected="selected"' : '' ?>><?php _e('Flip In X', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="flipInY" <?php echo ($gspwp_options['layout_animation'] == 'flipInY') ? 'selected="selected"' : '' ?>><?php _e('Flip In Y', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="lightSpeedIn" <?php echo ($gspwp_options['layout_animation'] == 'lightSpeedIn') ? 'selected="selected"' : '' ?>><?php _e('Light Speed In', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="pulse" <?php echo ($gspwp_options['layout_animation'] == 'pulse') ? 'selected="selected"' : '' ?>><?php _e('Pulse', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="rollIn" <?php echo ($gspwp_options['layout_animation'] == 'rollIn') ? 'selected="selected"' : '' ?>><?php _e('Roll In', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="rotateIn" <?php echo ($gspwp_options['layout_animation'] == 'rotateIn') ? 'selected="selected"' : '' ?>><?php _e('Rotate In', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="rotateInDownLeft" <?php echo ($gspwp_options['layout_animation'] == 'rotateInDownLeft') ? 'selected="selected"' : '' ?>><?php _e('Rotate In Down Left', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="rotateInDownRight" <?php echo ($gspwp_options['layout_animation'] == 'rotateInDownRight') ? 'selected="selected"' : '' ?>><?php _e('Rotate In Down Right', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="rotateInUpLeft" <?php echo ($gspwp_options['layout_animation'] == 'rotateInUpLeft') ? 'selected="selected"' : '' ?>><?php _e('Rotate In Up Left', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="rotateInUpRight" <?php echo ($gspwp_options['layout_animation'] == 'rotateInUpRight') ? 'selected="selected"' : '' ?>><?php _e('Rotate In Up Right', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="rubberBand" <?php echo ($gspwp_options['layout_animation'] == 'rubberBand') ? 'selected="selected"' : '' ?>><?php _e('Rubber Band', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="shake" <?php echo ($gspwp_options['layout_animation'] == 'shake') ? 'selected="selected"' : '' ?>><?php _e('Shake', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="headShake" <?php echo ($gspwp_options['layout_animation'] == 'headShake') ? 'selected="selected"' : '' ?>><?php _e('Head Shake', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="slideInDown" <?php echo ($gspwp_options['layout_animation'] == 'slideInDown') ? 'selected="selected"' : '' ?>><?php _e('Slide In Down', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="slideInLeft" <?php echo ($gspwp_options['layout_animation'] == 'slideInLeft') ? 'selected="selected"' : '' ?>><?php _e('Slide In Left', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="slideInRight" <?php echo ($gspwp_options['layout_animation'] == 'slideInRight') ? 'selected="selected"' : '' ?>><?php _e('Slide In Right', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="slideInUp" <?php echo ($gspwp_options['layout_animation'] == 'slideInUp') ? 'selected="selected"' : '' ?>><?php _e('Slide In Up', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="swing" <?php echo ($gspwp_options['layout_animation'] == 'swing') ? 'selected="selected"' : '' ?>><?php _e('Swing', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="tada" <?php echo ($gspwp_options['layout_animation'] == 'tada') ? 'selected="selected"' : '' ?>><?php _e('Tada', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="wobble" <?php echo ($gspwp_options['layout_animation'] == 'wobble') ? 'selected="selected"' : '' ?>><?php _e('Wobble', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="zoomIn" <?php echo ($gspwp_options['layout_animation'] == 'zoomIn') ? 'selected="selected"' : '' ?>><?php _e('Zoom In', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="zoomInDown" <?php echo ($gspwp_options['layout_animation'] == 'zoomInDown') ? 'selected="selected"' : '' ?>><?php _e('Zoom In Down', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="zoomInLeft" <?php echo ($gspwp_options['layout_animation'] == 'zoomInLeft') ? 'selected="selected"' : '' ?>><?php _e('Zoom In Left', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="zoomInRight" <?php echo ($gspwp_options['layout_animation'] == 'zoomInRight') ? 'selected="selected"' : '' ?>><?php _e('Zoom In Right', GSPWP_TEXTDOMAIN) ?></option>
                            <option value="zoomInUp" <?php echo ($gspwp_options['layout_animation'] == 'zoomInUp') ? 'selected="selected"' : '' ?>><?php _e('Zoom In Up', GSPWP_TEXTDOMAIN) ?></option>
                        </select>
                    </div>
                </div>

                <div class="gspwp-options-group gspwp-layout-bg-color-div">
                    <div class="gspwp-form-field gspwp-color-cover">
                        <label for="gspwp-layout-bg-color"><?php _e('Background Color', GSPWP_TEXTDOMAIN) ?></label>
                        <input id="gspwp-layout-bg-color" name="options[gs-layout-bg-color]" class="gspwp-color-picker" data-alpha="true" placeholder="<?php esc_attr_e('Color', GSPWP_TEXTDOMAIN); ?>" value="<?php echo esc_attr($gspwp_options['gs-layout-bg-color']); ?>" type="text" />
                    </div>
                </div>
                <div class="gspwp-options-group gspwp-layout-border-color-div">
                    <div class="gspwp-form-field gspwp-color-cover">
                        <label for="gspwp-layout-border-color"><?php _e('Border Color', GSPWP_TEXTDOMAIN) ?></label>
                        <input id="gspwp-layout-border-color" name="options[gs-layout-border-color]" class="gspwp-color-picker" data-alpha="true" placeholder="<?php esc_attr_e('Color', GSPWP_TEXTDOMAIN); ?>" value="<?php echo esc_attr($gspwp_options['gs-layout-border-color']); ?>" type="text" />
                    </div>
                </div>

            </div>

            <div id="slider-setting-data" class="panel gspwp-options-panel hidden">
                <ul class="gspwp-slider-menu">
                    <li class="gspwp-option-tab gspwp-slider-menu-item active" data-id="gspwp-slider-arrow"><?php _e('Arrow', GSPWP_TEXTDOMAIN) ?></li>
                    <li class="gspwp-option-tab gspwp-slider-menu-item" data-id="gspwp-slider-navigation"><?php _e('Navigation', GSPWP_TEXTDOMAIN) ?></li>
                </ul>

                <div id="gspwp-slider-arrow" class="gspwp-slider-arrow gspwp-slider-options">
                    <div class="gspwp-options-group">
                        <div class="gspwp-form-field gspwp-buttonset-cover">
                            <label><?php _e('Display Arrow', GSPWP_TEXTDOMAIN) ?></label>
                            <fieldset class="gspwp-buttonset">
                                <?php $display_arrow = $gspwp_options['display_arrow']; ?>
                                <input id="display_arrow_0" name="options[display_arrow]" type="radio" value="0" <?php echo checked(0, $display_arrow); ?> />
                                <label for="display_arrow_0"><?php _e('Yes', GSPWP_TEXTDOMAIN); ?></label>
                                <input id="display_arrow_1" name="options[display_arrow]" type="radio" value="1" <?php echo checked(1, $display_arrow); ?>/>
                                <label for="display_arrow_1"><?php _e('No', GSPWP_TEXTDOMAIN); ?></label>
                            </fieldset>
                        </div>
                    </div>
                    <div class="gspwp-options-group gspwp-arrow-options">
                        <div class="gspwp-form-field gspwp-button-cover">
                            <label><?php _e('Arrows Style', GSPWP_TEXTDOMAIN) ?></label>
                            <a class="gspwp-btn gspwp-arrow-style" href="javascript:void(0);"><?php _e('Chose Arrow Style', GSPWP_TEXTDOMAIN); ?></a>
                            <?php $gspwp_arrow_style = $gspwp_options['gs_arrow_style']; ?>
                            <input type="text" hidden="hidden" class="hidden" id="gspwp-arrow-style" name="options[gs_arrow_style]" value="<?php echo esc_attr($gspwp_arrow_style); ?>" />
                            <div class="gspwp-arrow-cover">
                                <div class="gspwp-arrow gspwp-left-arrow gspwp-arrow-<?php echo esc_attr($gspwp_arrow_style); ?>"></div>
                                <div class="gspwp-arrow gspwp-right-arrow gspwp-arrow-<?php echo esc_attr($gspwp_arrow_style); ?>"></div>
                            </div>
                        </div>
                    </div>
                    <div class="gspwp-options-group gspwp-arrow-options">
                        <div class="gspwp-form-field gspwp-number-cover">
                            <label for="gspwp-arrow-size"> <?php _e('Arrow Size', 'gllery-showcase'); ?> </label>
                            <input type="number" class="gspwp-one-number" id="gspwp-arrow-size" name="options[gs_arrow_size]" placeholder="<?php esc_attr_e('Arrow Size', GSPWP_TEXTDOMAIN); ?>" value="<?php echo ($gspwp_options['gs_arrow_size'] != '') ? esc_attr($gspwp_options['gs_arrow_size']) : '40' ?>">
                        </div>
                    </div>
                    <div class="gspwp-options-group gspwp-arrow-options gspwp-padding-10">
                        <p class="gspwp-field-title"><?php _e('Left Arrow', GSPWP_TEXTDOMAIN) ?></p>
                        <div class="gspwp-form-field gspwp-buttonset-cover">
                            <label><?php _e('Horizontal Position', GSPWP_TEXTDOMAIN) ?></label>
                            <fieldset class="gspwp-buttonset">
                                <?php $left_arrow_hori_pos = $gspwp_options['left_arrow_hori_pos']; ?>
                                <input id="left_arrow_hori_pos_0" name="options[left_arrow_hori_pos]" type="radio" value="0" <?php echo checked(0, $left_arrow_hori_pos); ?> />
                                <label for="left_arrow_hori_pos_0"><?php _e('Left', GSPWP_TEXTDOMAIN); ?></label>
                                <input id="left_arrow_hori_pos_1" name="options[left_arrow_hori_pos]" type="radio" value="1" <?php echo checked(1, $left_arrow_hori_pos); ?>/>
                                <label for="left_arrow_hori_pos_1"><?php _e('Center', GSPWP_TEXTDOMAIN); ?></label>
                                <input id="left_arrow_hori_pos_2" name="options[left_arrow_hori_pos]" type="radio" value="2" <?php echo checked(2, $left_arrow_hori_pos); ?>/>
                                <label for="left_arrow_hori_pos_2"><?php _e('Right', GSPWP_TEXTDOMAIN); ?></label>
                            </fieldset>
                        </div>
                        <div class="gspwp-form-field gspwp-buttonset-cover">
                            <label><?php _e('Vertical Position', GSPWP_TEXTDOMAIN) ?></label>
                            <fieldset class="gspwp-buttonset">
                                <?php $left_arrow_vert_pos = $gspwp_options['left_arrow_vert_pos']; ?>
                                <input id="left_arrow_vert_pos_0" name="options[left_arrow_vert_pos]" type="radio" value="0" <?php echo checked(0, $left_arrow_vert_pos); ?> />
                                <label for="left_arrow_vert_pos_0"><?php _e('Top', GSPWP_TEXTDOMAIN); ?></label>
                                <input id="left_arrow_vert_pos_1" name="options[left_arrow_vert_pos]" type="radio" value="1" <?php echo checked(1, $left_arrow_vert_pos); ?>/>
                                <label for="left_arrow_vert_pos_1"><?php _e('Center', GSPWP_TEXTDOMAIN); ?></label>
                                <input id="left_arrow_vert_pos_2" name="options[left_arrow_vert_pos]" type="radio" value="2" <?php echo checked(2, $left_arrow_vert_pos); ?>/>
                                <label for="left_arrow_vert_pos_2"><?php _e('Bottom', GSPWP_TEXTDOMAIN); ?></label>
                            </fieldset>
                        </div>
                        <div class="gspwp-form-field gspwp-number-cover">
                            <label for="left_arrow_hori_off"> <?php _e('Horizontal Offset', 'gllery-showcase'); ?> </label>
                            <input type="number" class="gspwp-one-number" id="left_arrow_hori_off" name="options[left_arrow_hori_off]" placeholder="<?php esc_attr_e('Horizontal Offset', GSPWP_TEXTDOMAIN); ?>" value="<?php echo esc_attr($gspwp_options['left_arrow_hori_off']); ?>">
                        </div>
                        <div class="gspwp-form-field gspwp-number-cover">
                            <label for="left_arrow_vert_off"> <?php _e('Vertical Offset', 'gllery-showcase'); ?> </label>
                            <input type="number" class="gspwp-one-number" id="left_arrow_vert_off" name="options[left_arrow_vert_off]" placeholder="<?php esc_attr_e('Vertical Offset', GSPWP_TEXTDOMAIN); ?>" value="<?php echo esc_attr($gspwp_options['left_arrow_vert_off']); ?>">
                        </div>
                    </div>
                    <div class="gspwp-options-group gspwp-arrow-options gspwp-padding-10">
                        <p class="gspwp-field-title"><?php _e('Right Arrow', GSPWP_TEXTDOMAIN) ?></p>
                        <div class="gspwp-form-field gspwp-buttonset-cover">
                            <label><?php _e('Horizontal Position', GSPWP_TEXTDOMAIN) ?></label>
                            <fieldset class="gspwp-buttonset">
                                <?php $right_arrow_hori_pos = isset($gspwp_options['right_arrow_hori_pos']) ? $gspwp_options['right_arrow_hori_pos'] : 2; ?>
                                <input id="right_arrow_hori_pos_0" name="options[right_arrow_hori_pos]" type="radio" value="0" <?php echo checked(0, $right_arrow_hori_pos); ?> />
                                <label for="right_arrow_hori_pos_0"><?php _e('Left', GSPWP_TEXTDOMAIN); ?></label>
                                <input id="right_arrow_hori_pos_1" name="options[right_arrow_hori_pos]" type="radio" value="1" <?php echo checked(1, $right_arrow_hori_pos); ?>/>
                                <label for="right_arrow_hori_pos_1"><?php _e('Center', GSPWP_TEXTDOMAIN); ?></label>
                                <input id="right_arrow_hori_pos_2" name="options[right_arrow_hori_pos]" type="radio" value="2" <?php echo checked(2, $right_arrow_hori_pos); ?>/>
                                <label for="right_arrow_hori_pos_2"><?php _e('Right', GSPWP_TEXTDOMAIN); ?></label>
                            </fieldset>
                        </div>
                        <div class="gspwp-form-field gspwp-buttonset-cover">
                            <label><?php _e('Vertical Position', GSPWP_TEXTDOMAIN) ?></label>
                            <fieldset class="gspwp-buttonset">
                                <?php $right_arrow_vert_pos = isset($gspwp_options['right_arrow_vert_pos']) ? $gspwp_options['right_arrow_vert_pos'] : 1; ?>
                                <input id="right_arrow_vert_pos_0" name="options[right_arrow_vert_pos]" type="radio" value="0" <?php echo checked(0, $right_arrow_vert_pos); ?> />
                                <label for="right_arrow_vert_pos_0"><?php _e('Top', GSPWP_TEXTDOMAIN); ?></label>
                                <input id="right_arrow_vert_pos_1" name="options[right_arrow_vert_pos]" type="radio" value="1" <?php echo checked(1, $right_arrow_vert_pos); ?>/>
                                <label for="right_arrow_vert_pos_1"><?php _e('Center', GSPWP_TEXTDOMAIN); ?></label>
                                <input id="right_arrow_vert_pos_2" name="options[right_arrow_vert_pos]" type="radio" value="2" <?php echo checked(2, $right_arrow_vert_pos); ?>/>
                                <label for="right_arrow_vert_pos_2"><?php _e('Bottom', GSPWP_TEXTDOMAIN); ?></label>
                            </fieldset>
                        </div>
                        <div class="gspwp-form-field gspwp-number-cover">
                            <label for="right_arrow_hori_off"> <?php _e('Horizontal Offset', 'gllery-showcase'); ?> </label>
                            <input type="number" class="gspwp-one-number" id="right_arrow_hori_off" name="options[right_arrow_hori_off]" placeholder="<?php _e('Horizontal Offset', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['right_arrow_hori_off']) && $gspwp_options['right_arrow_hori_off'] != '') ? esc_attr($gspwp_options['right_arrow_hori_off']) : '-20' ?>">
                        </div>
                        <div class="gspwp-form-field gspwp-number-cover">
                            <label for="right_arrow_vert_off"> <?php _e('Vertical Offset', 'gllery-showcase'); ?> </label>
                            <input type="number" class="gspwp-one-number" id="right_arrow_vert_off" name="options[right_arrow_vert_off]" placeholder="<?php _e('Vertical Offset', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['left_arrow_vert_off']) && $gspwp_options['right_arrow_vert_off'] != '') ? esc_attr($gspwp_options['right_arrow_vert_off']) : '0' ?>">
                        </div>
                    </div>
                </div>

                <div id="gspwp-slider-navigation" class="gspwp-slider-navigation gspwp-slider-options">
                    <div class="gspwp-options-group">
                        <div class="gspwp-form-field gspwp-buttonset-cover">
                            <label><?php _e('Display Navigation', GSPWP_TEXTDOMAIN) ?></label>
                            <fieldset class="gspwp-buttonset">
                                <?php $display_navigation = isset($gspwp_options['display_navigation']) ? $gspwp_options['display_navigation'] : 1; ?>
                                <input id="display_navigation_0" name="options[display_navigation]" type="radio" value="0" <?php echo checked(0, $display_navigation); ?> />
                                <label for="display_navigation_0"><?php _e('Yes', GSPWP_TEXTDOMAIN); ?></label>
                                <input id="display_navigation_1" name="options[display_navigation]" type="radio" value="1" <?php echo checked(1, $display_navigation); ?>/>
                                <label for="display_navigation_1"><?php _e('No', GSPWP_TEXTDOMAIN); ?></label>
                            </fieldset>
                        </div>
                    </div>

                    <div class="gspwp-options-group gspwp-navigation-options">
                        <div class="gspwp-form-field gspwp-button-cover">
                            <label><?php _e('Navigation Style', GSPWP_TEXTDOMAIN) ?></label>
                            <a class="gspwp-btn gspwp-navigation-style" href="javascript:void(0);"><?php _e('Chose Navigation Style', GSPWP_TEXTDOMAIN); ?></a>
                            <?php $gspwp_navigation_style = isset($gspwp_options['gs_navigation_style']) ? $gspwp_options['gs_navigation_style'] : 'style-1'; ?>
                            <input type="text" hidden="hidden" class="hidden" id="gspwp-navigation-style" name="options[gs_navigation_style]" value="<?php echo esc_attr($gspwp_navigation_style); ?>" />
                            <div class="gspwp-navigation-cover">
                                <div class="gspwp-navigation gspwp-navigation-<?php echo esc_attr($gspwp_navigation_style); ?>">
                                    <div class="owl-pagination">
                                        <div class="owl-page active"><span></span></div>
                                        <div class="owl-page"><span></span></div>
                                        <div class="owl-page"><span></span></div>
                                        <div class="owl-page"><span></span></div>
                                        <div class="owl-page"><span></span></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="gspwp-options-group gspwp-navigation-options">
                        <div class="gspwp-form-field gspwp-number-cover">
                            <label for="gspwp-navigation-size"> <?php _e('Navigation Size', 'gllery-showcase'); ?> </label>
                            <input type="number" class="gspwp-one-number" id="gspwp-navigation-size" name="options[gs_navigation_size]" placeholder="<?php esc_attr_e('Navigation Size', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['gsp_navigation_size']) && $gspwp_options['gs_navigation_size'] != '') ? esc_attr($gspwp_options['gs_navigation_size']) : '16' ?>">
                        </div>
                    </div>
                    <div class="gspwp-options-group gspwp-navigation-options">
                        <div class="gspwp-form-field gspwp-buttonset-cover">
                            <label><?php _e('Horizontal Position', GSPWP_TEXTDOMAIN) ?></label>
                            <fieldset class="gspwp-buttonset">
                                <?php $nav_hori_pos = isset($gspwp_options['nav_hori_pos']) ? $gspwp_options['nav_hori_pos'] : 1; ?>
                                <input id="nav_hori_pos_0" name="options[nav_hori_pos]" type="radio" value="0" <?php echo checked(0, $nav_hori_pos); ?> />
                                <label for="nav_hori_pos_0"><?php _e('Left', GSPWP_TEXTDOMAIN); ?></label>
                                <input id="nav_hori_pos_1" name="options[nav_hori_pos]" type="radio" value="1" <?php echo checked(1, $nav_hori_pos); ?>/>
                                <label for="nav_hori_pos_1"><?php _e('Center', GSPWP_TEXTDOMAIN); ?></label>
                                <input id="nav_hori_pos_2" name="options[nav_hori_pos]" type="radio" value="2" <?php echo checked(2, $nav_hori_pos); ?>/>
                                <label for="nav_hori_pos_2"><?php _e('Right', GSPWP_TEXTDOMAIN); ?></label>
                            </fieldset>
                        </div>
                        <div class="gspwp-form-field gspwp-buttonset-cover">
                            <label><?php _e('Vertical Position', GSPWP_TEXTDOMAIN) ?></label>
                            <fieldset class="gspwp-buttonset">
                                <?php $nav_vert_pos = isset($gspwp_options['nav_vert_pos']) ? $gspwp_options['nav_vert_pos'] : 2; ?>
                                <input id="nav_vert_pos_0" name="options[nav_vert_pos]" type="radio" value="0" <?php echo checked(0, $nav_vert_pos); ?> />
                                <label for="nav_vert_pos_0"><?php _e('Top', GSPWP_TEXTDOMAIN); ?></label>
                                <input id="nav_vert_pos_1" name="options[nav_vert_pos]" type="radio" value="1" <?php echo checked(1, $nav_vert_pos); ?>/>
                                <label for="nav_vert_pos_1"><?php _e('Center', GSPWP_TEXTDOMAIN); ?></label>
                                <input id="nav_vert_pos_2" name="options[nav_vert_pos]" type="radio" value="2" <?php echo checked(2, $nav_vert_pos); ?>/>
                                <label for="nav_vert_pos_2"><?php _e('Bottom', GSPWP_TEXTDOMAIN); ?></label>
                            </fieldset>
                        </div>
                    </div>
                    <div class="gspwp-options-group gspwp-navigation-options">
                        <div class="gspwp-form-field gspwp-number-cover">
                            <label for="nav_hori_off"> <?php _e('Horizontal Offset', 'gllery-showcase'); ?> </label>
                            <input type="number" class="gspwp-one-number" id="nav_hori_off" name="options[nav_hori_off]" placeholder="<?php esc_attr_e('Horizontal Offset', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['nav_hori_off']) && $gspwp_options['nav_hori_off'] != '') ? esc_attr($gspwp_options['nav_hori_off']) : '0' ?>">
                        </div>
                        <div class="gspwp-form-field gspwp-number-cover">
                            <label for="nav_vert_off"> <?php _e('Vertical Offset', 'gllery-showcase'); ?> </label>
                            <input type="number" class="gspwp-one-number" id="nav_vert_off" name="options[nav_vert_off]" placeholder="<?php esc_attr_e('Vertical Offset', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['left_arrow_vert_off']) && isset( $gspwp_options['nav_vert_off'] ) && $gspwp_options['nav_vert_off'] != '') ? esc_attr($gspwp_options['nav_vert_off']) : '-20' ?>">
                        </div>
                    </div>
                </div>
            </div>

            <div id="title-setting-data" class="panel gspwp-options-panel hidden">
                <div class="gspwp-options-group">
                    <div class="gspwp-form-field gspwp-buttonset-cover">
                        <label> <?php _e('Display Title', GSPWP_TEXTDOMAIN); ?> </label>
                        <fieldset class="gspwp-buttonset">
                            <?php $display_title = isset($gspwp_options['display_title']) ? $gspwp_options['display_title'] : 0; ?>
                            <input id="display_title_0" name="options[display_title]" type="radio" value="0" <?php echo checked(0, $display_title); ?>/>
                            <label for="display_title_0"><?php _e('Yes', GSPWP_TEXTDOMAIN); ?></label>
                            <input id="display_title_1" name="options[display_title]" type="radio" value="1" <?php echo checked(1, $display_title); ?> />
                            <label for="display_title_1"><?php _e('No', GSPWP_TEXTDOMAIN); ?></label>
                        </fieldset>
                    </div>
                </div>

                <div class="gspwp-options-group gspwp-title-options">
                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="title_font"> <?php _e('Font Family', GSPWP_TEXTDOMAIN); ?> </label>
                        <select id="title_font" name="options[title_font]">
                            <option value="" <?php echo (isset($gspwp_options['title_font']) && $gspwp_options['title_font'] == '') ? 'selected="selected"' : '' ?>><?php _e('Default', GSPWP_TEXTDOMAIN) ?></option>
                        </select>
                        <input type="text" hidden="hidden" value="<?php echo isset($gspwp_options['title_font']) ? $gspwp_options['title_font'] : ''; ?>" class="title_font_selected" />
                    </div>
                </div>

                <div class="gspwp-options-group gspwp-title-options">
                    <div class="gspwp-form-field gspwp-number-cover">
                        <label for="gspwp-title-font-size"> <?php _e('Font Size', 'gllery-showcase'); ?> </label>
                        <input type="number" class="gspwp-one-number" id="gspwp-title-font-size" name="options[title-font-size]" placeholder="<?php esc_attr_e('Font Size', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['title-font-size']) && $gspwp_options['title-font-size'] != '') ? esc_attr($gspwp_options['title-font-size']) : '0' ?>">
                    </div>
                </div>

                <div class="gspwp-options-group gspwp-title-options">
                    <div class="gspwp-form-field gspwp-color-cover">
                        <label for="gspwp-title-font-color"><?php _e('Font Color', GSPWP_TEXTDOMAIN) ?></label>
                        <input id="gspwp-title-font-color" name="options[gs-title-font-color]" class="gspwp-color-picker" data-alpha="true" placeholder="<?php esc_attr_e('Color', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['gs-title-font-color'])) ? esc_attr($gspwp_options['gs-title-font-color']) : '#ffffff'; ?>" type="text" />
                    </div>
                </div>

                <div class="gspwp-options-group gspwp-title-bg-color-div gspwp-title-options">
                    <div class="gspwp-form-field gspwp-color-cover">
                        <label for="gspwp-title-bg-color"><?php _e('Background Color', GSPWP_TEXTDOMAIN) ?></label>
                        <input id="gspwp-title-bg-color" name="options[gs-title-bg-color]" class="gspwp-color-picker" data-alpha="true" placeholder="<?php esc_attr_e('Color', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['gs-title-bg-color'])) ? esc_attr($gspwp_options['gs-title-bg-color']) : '#ffffff'; ?>" type="text" />
                    </div>
                </div>

                <div class="gspwp-options-group gspwp-title-options">
                    <div class="gspwp-form-field gspwp-checkbox-cover">
                        <label for="gspwp-title-font-italic"><?php _e('Italic Style', GSPWP_TEXTDOMAIN) ?></label>
                        <input id="gspwp-title-font-italic" name="options[gs-title-font-italic]" value="1" type="checkbox" <?php echo (isset($gspwp_options['gs-title-font-italic']) && $gspwp_options['gs-title-font-italic'] == 1) ? 'checked="checked"' : ''; ?>>
                    </div>
                    <div class="gspwp-form-field gspwp-select-cover">
                        <?php $title_font_weidth = (isset($gspwp_options['gs-title-font-weight']) && $gspwp_options['gs-title-font-weight'] != '') ? $gspwp_options['gs-title-font-weight'] : 'normal'; ?>
                        <label for="gspwp-title-font-weight"><?php _e('Font Weight', GSPWP_TEXTDOMAIN) ?></label>
                        <select id="gspwp-title-font-weight" name="options[gs-title-font-weight]">
                            <option value="100" <?php echo ($title_font_weidth == '100') ? 'selected="selected"' : ''; ?> >100</option>
                            <option value="200" <?php echo ($title_font_weidth == '200') ? 'selected="selected"' : ''; ?> >200</option>
                            <option value="300" <?php echo ($title_font_weidth == '300') ? 'selected="selected"' : ''; ?> >300</option>
                            <option value="400" <?php echo ($title_font_weidth == '400') ? 'selected="selected"' : ''; ?> >400</option>
                            <option value="500" <?php echo ($title_font_weidth == '500') ? 'selected="selected"' : ''; ?> >500</option>
                            <option value="600" <?php echo ($title_font_weidth == '600') ? 'selected="selected"' : ''; ?> >600</option>
                            <option value="700" <?php echo ($title_font_weidth == '800') ? 'selected="selected"' : ''; ?> >700</option>
                            <option value="800" <?php echo ($title_font_weidth == '800') ? 'selected="selected"' : ''; ?> >800</option>
                            <option value="900" <?php echo ($title_font_weidth == '900') ? 'selected="selected"' : ''; ?> >900</option>
                            <option value="bold" <?php echo ($title_font_weidth == 'bold') ? 'selected="selected"' : ''; ?> ><?php _e('Bold', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="normal" <?php echo ($title_font_weidth == 'normal') ? 'selected="selected"' : ''; ?> ><?php _e('Normal', GSPWP_TEXTDOMAIN); ?></option>
                        </select>
                    </div>
                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="gspwp-title-text-transform"><?php _e('Text Transform', GSPWP_TEXTDOMAIN) ?></label>
                        <select id="gspwp-title-text-transform" name="options[gs-title-text-transform]">
                            <option value="none" <?php echo ((isset($gspwp_options['gs-title-text-transform']) && $gspwp_options['gs-title-text-transform'] == 'none')) ? 'selected="selected"' : ''; ?> ><?php _e('None', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="capitalize" <?php echo ((isset($gspwp_options['gs-title-text-transform']) && $gspwp_options['gs-title-text-transform'] == 'capitalize')) ? 'selected="selected"' : ''; ?> ><?php _e('Capitalize', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="uppercase" <?php echo ((isset($gspwp_options['gs-title-text-transform']) && $gspwp_options['gs-title-text-transform'] == 'uppercase')) ? 'selected="selected"' : ''; ?> ><?php _e('Uppercase', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="lowercase" <?php echo ((isset($gspwp_options['gs-title-text-transform']) && $gspwp_options['gs-title-text-transform'] == 'lowercase')) ? 'selected="selected"' : ''; ?> ><?php _e('Lowercase', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="full-width" <?php echo ((isset($gspwp_options['gs-title-text-transform']) && $gspwp_options['gs-title-text-transform'] == 'full-width')) ? 'selected="selected"' : ''; ?> ><?php _e('Full Width', GSPWP_TEXTDOMAIN); ?></option>
                        </select>
                    </div>
                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="gspwp-title-text-decoration"><?php _e('Text Decoration', GSPWP_TEXTDOMAIN) ?></label>
                        <select id="gspwp-title-text-decoration" name="options[gs-title-text-decoration]">
                            <option value="none" <?php echo ((isset($gspwp_options['gs-title-text-decoration']) && $gspwp_options['gs-title-text-decoration'] == 'none')) ? 'selected="selected"' : ''; ?> ><?php _e('None', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="underline" <?php echo ((isset($gspwp_options['gs-title-text-decoration']) && $gspwp_options['gs-title-text-decoration'] == 'underline')) ? 'selected="selected"' : ''; ?> ><?php _e('Underline', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="overline" <?php echo ((isset($gspwp_options['gs-title-text-decoration']) && $gspwp_options['gs-title-text-decoration'] == 'overline')) ? 'selected="selected"' : ''; ?> ><?php _e('Overline', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="line-through" <?php echo ((isset($gspwp_options['gs-title-text-decoration']) && $gspwp_options['gs-title-text-decoration'] == 'line-through')) ? 'selected="selected"' : ''; ?> ><?php _e('Line Through', GSPWP_TEXTDOMAIN); ?></option>
                        </select>
                    </div>
                    <div class="gspwp-form-field gspwp-number-cover">
                        <label for="gspwp-title-line-height"><?php _e('Line Height', GSPWP_TEXTDOMAIN) ?></label>
                        <input type="number" class="gspwp-one-number" id="gspwp-title-line-height" name="options[gs-title-line-height]" min="0" step="0.1" placeholder="<?php esc_attr_e('Line Height', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['gs-title-line-height']) && $gspwp_options['gs-title-line-height'] != '') ? esc_attr($gspwp_options['gs-title-line-height']) : '1.5' ?>">
                    </div>
                    <div class="gspwp-form-field gspwp-number-cover">
                        <label for="gspwp-title-letter-spacing"><?php _e('Letter Spacing', GSPWP_TEXTDOMAIN) ?> (PX)</label>
                        <input type="number" class="gspwp-one-number" id="gspwp-title-letter-spacing" name="options[gs-title-letter-spacing]" min="0" placeholder="<?php esc_attr_e('Letter Spacing', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['gs-title-letter-spacing']) && $gspwp_options['gs-title-letter-spacing'] != '') ? esc_attr($gspwp_options['gs-title-letter-spacing']) : '0' ?>">
                    </div>
                </div>
            </div>

            <div id="content-setting-data" class="panel gspwp-options-panel hidden">
                <div class="gspwp-options-group">
                    <div class="gspwp-form-field gspwp-buttonset-cover">
                        <label> <?php _e('Display Content', GSPWP_TEXTDOMAIN); ?> </label>
                        <fieldset class="gspwp-buttonset">
                            <?php $display_content = isset($gspwp_options['display_content']) ? $gspwp_options['display_content'] : 0; ?>
                            <input id="display_content_0" name="options[display_content]" type="radio" value="0" <?php echo checked(0, $display_content); ?>/>
                            <label for="display_content_0"><?php _e('Yes', GSPWP_TEXTDOMAIN); ?></label>
                            <input id="display_content_1" name="options[display_content]" type="radio" value="1" <?php echo checked(1, $display_content); ?> />
                            <label for="display_content_1"><?php _e('No', GSPWP_TEXTDOMAIN); ?></label>
                        </fieldset>
                    </div>
                </div>

                <div class="gspwp-options-group gspwp-content-options">
                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="content_font"> <?php _e('Font Family', GSPWP_TEXTDOMAIN); ?> </label>
                        <select id="content_font" name="options[content_font]">
                            <option value="" <?php echo (isset($gspwp_options['content_font']) && $gspwp_options['content_font'] == '') ? 'selected="selected"' : '' ?>><?php _e('Default', GSPWP_TEXTDOMAIN) ?></option>
                        </select>
                        <input type="text" hidden="hidden" value="<?php echo isset($gspwp_options['content_font']) ? esc_attr($gspwp_options['content_font']) : '' ?>" class="content_font_selected" />
                    </div>
                </div>

                <div class="gspwp-options-group gspwp-content-options">
                    <div class="gspwp-form-field gspwp-number-cover">
                        <label for="gspwp-content-font-size"> <?php _e('Font Size', 'gllery-showcase'); ?> </label>
                        <input type="number" class="gspwp-one-number" id="gspwp-content-font-size" name="options[content-font-size]" placeholder="<?php esc_attr_e('Font Size', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['content-font-size']) && $gspwp_options['content-font-size'] != '') ? esc_attr($gspwp_options['content-font-size']) : '0' ?>">
                    </div>
                </div>

                <div class="gspwp-options-group gspwp-content-options">
                    <div class="gspwp-form-field gspwp-color-cover">
                        <label for="gspwp-content-font-color"><?php _e('Font Color', GSPWP_TEXTDOMAIN) ?></label>
                        <input id="gspwp-content-font-color" name="options[gs-content-font-color]" class="gspwp-color-picker" data-alpha="true" placeholder="<?php esc_attr_e('Color', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['gs-content-font-color'])) ? esc_attr($gspwp_options['gs-content-font-color']) : '#ffffff'; ?>" type="text" />
                    </div>
                </div>

                <div class="gspwp-options-group gspwp-content-bg-color-div">
                    <div class="gspwp-form-field gspwp-color-cover">
                        <label for="gspwp-content-bg-color"><?php _e('Background Color', GSPWP_TEXTDOMAIN) ?></label>
                        <input id="gspwp-content-bg-color" name="options[gs-content-bg-color]" class="gspwp-color-picker" data-alpha="true" placeholder="<?php esc_attr_e('Color', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['gs-content-bg-color'])) ? esc_attr($gspwp_options['gs-content-bg-color']) : '#ffffff'; ?>" type="text" />
                    </div>
                </div>

                <div class="gspwp-options-group gspwp-content-options">
                    <div class="gspwp-form-field gspwp-checkbox-cover">
                        <label for="gspwp-content-font-italic"><?php _e('Italic Style', GSPWP_TEXTDOMAIN) ?></label>
                        <input id="gspwp-content-font-italic" name="options[gs-content-font-italic]" value="1" type="checkbox" <?php echo (isset($gspwp_options['gs-content-font-italic']) && $gspwp_options['gs-content-font-italic'] == 1) ? 'checked="checked"' : ''; ?>>
                    </div>
                    <div class="gspwp-form-field gspwp-select-cover">
                        <?php $content_font_weidth = (isset($gspwp_options['gs-content-font-weight']) && $gspwp_options['gs-content-font-weight'] != '') ? $gspwp_options['gs-content-font-weight'] : 'normal'; ?>
                        <label for="gspwp-content-font-weight"><?php _e('Font Weight', GSPWP_TEXTDOMAIN) ?></label>
                        <select id="gspwp-content-font-weight" name="options[gs-content-font-weight]">
                            <option value="100" <?php echo ($content_font_weidth == '100') ? 'selected="selected"' : ''; ?> >100</option>
                            <option value="200" <?php echo ($content_font_weidth == '200') ? 'selected="selected"' : ''; ?> >200</option>
                            <option value="300" <?php echo ($content_font_weidth == '300') ? 'selected="selected"' : ''; ?> >300</option>
                            <option value="400" <?php echo ($content_font_weidth == '400') ? 'selected="selected"' : ''; ?> >400</option>
                            <option value="500" <?php echo ($content_font_weidth == '500') ? 'selected="selected"' : ''; ?> >500</option>
                            <option value="600" <?php echo ($content_font_weidth == '600') ? 'selected="selected"' : ''; ?> >600</option>
                            <option value="700" <?php echo ($content_font_weidth == '800') ? 'selected="selected"' : ''; ?> >700</option>
                            <option value="800" <?php echo ($content_font_weidth == '800') ? 'selected="selected"' : ''; ?> >800</option>
                            <option value="900" <?php echo ($content_font_weidth == '900') ? 'selected="selected"' : ''; ?> >900</option>
                            <option value="bold" <?php echo ($content_font_weidth == 'bold') ? 'selected="selected"' : ''; ?> ><?php _e('Bold', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="normal" <?php echo ($content_font_weidth == 'normal') ? 'selected="selected"' : ''; ?> ><?php _e('Normal', GSPWP_TEXTDOMAIN); ?></option>
                        </select>
                    </div>
                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="gspwp-content-text-transform"><?php _e('Text Transform', GSPWP_TEXTDOMAIN) ?></label>
                        <select id="gspwp-content-text-transform" name="options[gs-content-text-transform]">
                            <option value="none" <?php echo ((isset($gspwp_options['gs-content-text-transform']) && $gspwp_options['gs-content-text-transform'] == 'none')) ? 'selected="selected"' : ''; ?> ><?php _e('None', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="capitalize" <?php echo ((isset($gspwp_options['gs-content-text-transform']) && $gspwp_options['gs-content-text-transform'] == 'capitalize')) ? 'selected="selected"' : ''; ?> ><?php _e('Capitalize', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="uppercase" <?php echo ((isset($gspwp_options['gs-content-text-transform']) && $gspwp_options['gs-content-text-transform'] == 'uppercase')) ? 'selected="selected"' : ''; ?> ><?php _e('Uppercase', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="lowercase" <?php echo ((isset($gspwp_options['gs-content-text-transform']) && $gspwp_options['gs-content-text-transform'] == 'lowercase')) ? 'selected="selected"' : ''; ?> ><?php _e('Lowercase', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="full-width" <?php echo ((isset($gspwp_options['gs-content-text-transform']) && $gspwp_options['gs-content-text-transform'] == 'full-width')) ? 'selected="selected"' : ''; ?> ><?php _e('Full Width', GSPWP_TEXTDOMAIN); ?></option>
                        </select>
                    </div>
                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="gspwp-content-text-decoration"><?php _e('Text Decoration', GSPWP_TEXTDOMAIN) ?></label>
                        <select id="gspwp-content-text-decoration" name="options[gs-content-text-decoration]">
                            <option value="none" <?php echo ((isset($gspwp_options['gs-content-text-decoration']) && $gspwp_options['gs-content-text-decoration'] == 'none')) ? 'selected="selected"' : ''; ?> ><?php _e('None', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="underline" <?php echo ((isset($gspwp_options['gs-content-text-decoration']) && $gspwp_options['gs-content-text-decoration'] == 'underline')) ? 'selected="selected"' : ''; ?> ><?php _e('Underline', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="overline" <?php echo ((isset($gspwp_options['gs-content-text-decoration']) && $gspwp_options['gs-content-text-decoration'] == 'overline')) ? 'selected="selected"' : ''; ?> ><?php _e('Overline', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="line-through" <?php echo ((isset($gspwp_options['gs-content-text-decoration']) && $gspwp_options['gs-content-text-decoration'] == 'line-through')) ? 'selected="selected"' : ''; ?> ><?php _e('Line Through', GSPWP_TEXTDOMAIN); ?></option>
                        </select>
                    </div>
                    <div class="gspwp-form-field gspwp-number-cover">
                        <label for="gspwp-content-line-height"><?php _e('Line Height', GSPWP_TEXTDOMAIN) ?></label>
                        <input type="number" class="gspwp-one-number" id="gspwp-content-line-height" name="options[gs-content-line-height]" min="0" step="0.1" placeholder="<?php esc_attr_e('Line Height', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['gs-content-line-height']) && $gspwp_options['gs-content-line-height'] != '') ? esc_attr($gspwp_options['gs-content-line-height']) : '1.5' ?>">
                    </div>
                    <div class="gspwp-form-field gspwp-number-cover">
                        <label for="gspwp-content-letter-spacing"><?php _e('Letter Spacing', GSPWP_TEXTDOMAIN) ?> (PX)</label>
                        <input type="number" class="gspwp-one-number" id="gspwp-content-letter-spacing" name="options[gs-content-letter-spacing]" min="0" placeholder="<?php esc_attr_e('Letter Spacing', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['gs-content-letter-spacing']) && $gspwp_options['gs-content-letter-spacing'] != '') ? esc_attr($gspwp_options['gs-content-letter-spacing']) : '0' ?>">
                    </div>
                </div>
            </div>

            <div id="filter-design" class="panel gspwp-options-panel hidden">

                <div class="gspwp-options-group">
                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="filter_title_font"> <?php _e('Font Family', GSPWP_TEXTDOMAIN); ?> </label>
                        <select id="filter_title_font" name="options[filter_title_font]">
                            <option value="" <?php echo (isset($gspwp_options['filter_title_font']) && $gspwp_options['filter_title_font'] == '') ? 'selected="selected"' : '' ?>><?php _e('Default', GSPWP_TEXTDOMAIN) ?></option>
                        </select>
                        <input type="text" hidden="hidden" value="<?php echo isset($gspwp_options['filter_title_font']) ? esc_attr($gspwp_options['filter_title_font']) : ''; ?>" class="filter_title_font_selected" />
                    </div>
                </div>

                <div class="gspwp-options-group">
                    <div class="gspwp-form-field gspwp-number-cover">
                        <label for="gspwp-filter-title-font-size"> <?php _e('Font Size', 'gllery-showcase'); ?> </label>
                        <input type="number" class="gspwp-one-number" id="gspwp-filter-title-font-size" name="options[filter-title-font-size]" placeholder="<?php esc_attr_e('Font Size', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['filter-title-font-size']) && $gspwp_options['filter-title-font-size'] != '') ? esc_attr($gspwp_options['filter-title-font-size']) : '0' ?>">
                    </div>
                </div>

                <div class="gspwp-options-group d-flex">
                    <div class="gspwp-form-field gspwp-color-cover">
                        <label for="gspwp-filter-title-font-color"><?php _e('Font Color', GSPWP_TEXTDOMAIN) ?></label>
                        <input id="gspwp-filter-title-font-color" name="options[gs-filter-title-font-color]" class="gspwp-color-picker" data-alpha="true" placeholder="<?php esc_attr_e('Color', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['gs-filter-title-font-color'])) ? esc_attr($gspwp_options['gs-filter-title-font-color']) : '#4f4f4f'; ?>" type="text" />
                    </div>
                    <div class="gspwp-form-field gspwp-color-cover">
                        <label for="gspwp-filter-title-font-color-hover"><?php _e('Hover Font Color', GSPWP_TEXTDOMAIN) ?></label>
                        <input id="gspwp-filter-title-font-color-hover" name="options[gs-filter-title-font-color-hover]" class="gspwp-color-picker" data-alpha="true" placeholder="<?php esc_attr_e('Color', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['gs-filter-title-font-color-hover'])) ? esc_attr($gspwp_options['gs-filter-title-font-color-hover']) : '#000000'; ?>" type="text" />
                    </div>
                </div>

                <div class="gspwp-options-group d-flex">
                    <div class="gspwp-form-field gspwp-color-cover">
                        <label for="gspwp-filter-title-bg-color"><?php _e('Background Color', GSPWP_TEXTDOMAIN) ?></label>
                        <input id="gspwp-filter-title-bg-color" name="options[gs-filter-title-bg-color]" class="gspwp-color-picker" data-alpha="true" placeholder="<?php esc_attr_e('Color', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['gs-filter-title-bg-color'])) ? esc_attr($gspwp_options['gs-filter-title-bg-color']) : '#ffffff'; ?>" type="text" />
                    </div>
                    <div class="gspwp-form-field gspwp-color-cover">
                        <label for="gspwp-filter-title-bg-color-hover"><?php _e('Hover Background Color', GSPWP_TEXTDOMAIN) ?></label>
                        <input id="gspwp-filter-title-bg-color-hover" name="options[gs-filter-title-bg-color-hover]" class="gspwp-color-picker" data-alpha="true" placeholder="<?php esc_attr_e('Color', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['gs-filter-title-bg-color-hover'])) ? esc_attr($gspwp_options['gs-filter-title-bg-color-hover']) : '#ffffff'; ?>" type="text" />
                    </div>
                </div>

                <div class="gspwp-options-group ">
                    <div class="gspwp-form-field gspwp-number-cover">
                        <label for="gspwp-filter-gap"><?php _e('Filter Tab Gap', GSPWP_TEXTDOMAIN) ?></label>
                        <input type="number" class="gspwp-one-number" id="gspwp-filter-gap" name="options[gs-filter-gap]" min="0"  placeholder="<?php esc_attr_e('Line Height', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['gs-filter-gap']) && $gspwp_options['gs-filter-gap'] != '') ? esc_attr($gspwp_options['gs-filter-gap']) : '10' ?>">
                    </div>
                </div>

                <div class="gspwp-options-group">
                    <div class="gspwp-form-field gspwp-number-cover">
                        <label for="filter_padding_top"> <?php _e('Padding', GSPWP_TEXTDOMAIN) ?> </label>
                        <input type="number" class="gspwp-four-number" id="filter_padding_top" name="options[filter_padding_top]" min="0" placeholder="<?php esc_attr_e('Top', GSPWP_TEXTDOMAIN); ?>" value="<?php echo ($gspwp_options['filter_padding_top'] != '') ? esc_attr($gspwp_options['filter_padding_top']) : '0' ?>">
                        <input type="number" class="gspwp-four-number" id="filter_padding_right" name="options[filter_padding_right]" min="0" placeholder="<?php esc_attr_e('Right', GSPWP_TEXTDOMAIN); ?>" value="<?php echo ($gspwp_options['filter_padding_right'] != '') ? esc_attr($gspwp_options['filter_padding_right']) : '0' ?>">
                        <input type="number" class="gspwp-four-number" id="filter_padding_bottom" name="options[filter_padding_bottom]" min="0" placeholder="<?php esc_attr_e('Bottom', GSPWP_TEXTDOMAIN); ?>" value="<?php echo ($gspwp_options['filter_padding_bottom'] != '') ?esc_attr( $gspwp_options['filter_padding_bottom']) : '0' ?>">
                        <input type="number" class="gspwp-four-number" id="filter_padding_left" name="options[filter_padding_left]" min="0" placeholder="<?php esc_attr_e('Left', GSPWP_TEXTDOMAIN); ?>" value="<?php echo ($gspwp_options['filter_padding_left'] != '') ? esc_attr($gspwp_options['filter_padding_left']) : '0' ?>">
                    </div>
                </div>

                <div class="gspwp-options-group">
                    <div class="gspwp-form-field gspwp-checkbox-cover">
                        <label for="gspwp-filter-title-font-italic"><?php _e('Italic Style', GSPWP_TEXTDOMAIN) ?></label>
                        <input id="gspwp-filter-title-font-italic" name="options[gs-filter-title-font-italic]" value="1" type="checkbox" <?php echo (isset($gspwp_options['gs-filter-title-font-italic']) && $gspwp_options['gs-filter-title-font-italic'] == 1) ? 'checked="checked"' : ''; ?>>
                    </div>
                    <div class="gspwp-form-field gspwp-select-cover">
                        <?php $title_font_weidth = (isset($gspwp_options['gs-filter-title-font-weight']) && $gspwp_options['gs-filter-title-font-weight'] != '') ? $gspwp_options['gs-filter-title-font-weight'] : 'normal'; ?>
                        <label for="gspwp-filter-title-font-weight"><?php _e('Font Weight', GSPWP_TEXTDOMAIN) ?></label>
                        <select id="gspwp-filter-title-font-weight" name="options[gs-filter-title-font-weight]">
                            <option value="100" <?php echo ($title_font_weidth == '100') ? 'selected="selected"' : ''; ?> >100</option>
                            <option value="200" <?php echo ($title_font_weidth == '200') ? 'selected="selected"' : ''; ?> >200</option>
                            <option value="300" <?php echo ($title_font_weidth == '300') ? 'selected="selected"' : ''; ?> >300</option>
                            <option value="400" <?php echo ($title_font_weidth == '400') ? 'selected="selected"' : ''; ?> >400</option>
                            <option value="500" <?php echo ($title_font_weidth == '500') ? 'selected="selected"' : ''; ?> >500</option>
                            <option value="600" <?php echo ($title_font_weidth == '600') ? 'selected="selected"' : ''; ?> >600</option>
                            <option value="700" <?php echo ($title_font_weidth == '800') ? 'selected="selected"' : ''; ?> >700</option>
                            <option value="800" <?php echo ($title_font_weidth == '800') ? 'selected="selected"' : ''; ?> >800</option>
                            <option value="900" <?php echo ($title_font_weidth == '900') ? 'selected="selected"' : ''; ?> >900</option>
                            <option value="bold" <?php echo ($title_font_weidth == 'bold') ? 'selected="selected"' : ''; ?> ><?php _e('Bold', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="normal" <?php echo ($title_font_weidth == 'normal') ? 'selected="selected"' : ''; ?> ><?php _e('Normal', GSPWP_TEXTDOMAIN); ?></option>
                        </select>
                    </div>
                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="gspwp-filter-title-text-transform"><?php _e('Text Transform', GSPWP_TEXTDOMAIN) ?></label>
                        <select id="gspwp-filter-title-text-transform" name="options[gs-filter-title-text-transform]">
                            <option value="none" <?php echo ((isset($gspwp_options['gs-filter-title-text-transform']) && $gspwp_options['gs-filter-title-text-transform'] == 'none')) ? 'selected="selected"' : ''; ?> ><?php _e('None', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="capitalize" <?php echo ((isset($gspwp_options['gs-filter-title-text-transform']) && $gspwp_options['gs-filter-title-text-transform'] == 'capitalize')) ? 'selected="selected"' : ''; ?> ><?php _e('Capitalize', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="uppercase" <?php echo ((isset($gspwp_options['gs-filter-title-text-transform']) && $gspwp_options['gs-filter-title-text-transform'] == 'uppercase')) ? 'selected="selected"' : ''; ?> ><?php _e('Uppercase', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="lowercase" <?php echo ((isset($gspwp_options['gs-filter-title-text-transform']) && $gspwp_options['gs-filter-title-text-transform'] == 'lowercase')) ? 'selected="selected"' : ''; ?> ><?php _e('Lowercase', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="full-width" <?php echo ((isset($gspwp_options['gs-filter-title-text-transform']) && $gspwp_options['gs-filter-title-text-transform'] == 'full-width')) ? 'selected="selected"' : ''; ?> ><?php _e('Full Width', GSPWP_TEXTDOMAIN); ?></option>
                        </select>
                    </div>
                    <div class="gspwp-form-field gspwp-select-cover">
                        <label for="gspwp-filter-title-text-decoration"><?php _e('Text Decoration', GSPWP_TEXTDOMAIN) ?></label>
                        <select id="gspwp-filter-title-text-decoration" name="options[gs-filter-title-text-decoration]">
                            <option value="none" <?php echo ((isset($gspwp_options['gs-filter-title-text-decoration']) && $gspwp_options['gs-filter-title-text-decoration'] == 'none')) ? 'selected="selected"' : ''; ?> ><?php _e('None', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="underline" <?php echo ((isset($gspwp_options['gs-filter-title-text-decoration']) && $gspwp_options['gs-filter-title-text-decoration'] == 'underline')) ? 'selected="selected"' : ''; ?> ><?php _e('Underline', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="overline" <?php echo ((isset($gspwp_options['gs-filter-title-text-decoration']) && $gspwp_options['gs-filter-title-text-decoration'] == 'overline')) ? 'selected="selected"' : ''; ?> ><?php _e('Overline', GSPWP_TEXTDOMAIN); ?></option>
                            <option value="line-through" <?php echo ((isset($gspwp_options['gs-filter-title-text-decoration']) && $gspwp_options['gs-filter-title-text-decoration'] == 'line-through')) ? 'selected="selected"' : ''; ?> ><?php _e('Line Through', GSPWP_TEXTDOMAIN); ?></option>
                        </select>
                    </div>
                    <div class="gspwp-form-field gspwp-number-cover">
                        <label for="gspwp-filter-title-line-height"><?php _e('Line Height', GSPWP_TEXTDOMAIN) ?></label>
                        <input type="number" class="gspwp-one-number" id="gspwp-filter-title-line-height" name="options[gs-filter-title-line-height]" min="0" step="0.1" placeholder="<?php esc_attr_e('Line Height', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['gs-filter-title-line-height']) && $gspwp_options['gs-filter-title-line-height'] != '') ? esc_attr($gspwp_options['gs-filter-title-line-height']) : '1.5' ?>">
                    </div>
                    <div class="gspwp-form-field gspwp-number-cover">
                        <label for="gspwp-filter-title-letter-spacing"><?php _e('Letter Spacing', GSPWP_TEXTDOMAIN) ?> (PX)</label>
                        <input type="number" class="gspwp-one-number" id="gspwp-filter-title-letter-spacing" name="options[gs-filter-title-letter-spacing]" min="0" placeholder="<?php esc_attr_e('Letter Spacing', GSPWP_TEXTDOMAIN); ?>" value="<?php echo (isset($gspwp_options['gs-filter-title-letter-spacing']) && $gspwp_options['gs-filter-title-letter-spacing'] != '') ? esc_attr($gspwp_options['gs-filter-title-letter-spacing']) : '0' ?>">
                    </div>
                </div>

            </div>

        </div>

        <div id="gspwp-arrow-style-dialog" class="gspwp-arrow-style-dialog" title="<?php esc_attr_e('Select Arrows', GSPWP_TEXTDOMAIN); ?>" style="display: none;">
            <div class="gspwp-arrow-style-box">
                <?php
                for ($i = 1; $i <= 10; $i++) {
                    ?>
                    <div class="gspwp-arrow-cover" data-style="style-<?php echo esc_attr($i); ?>">
                        <div class="gspwp-arrow gspwp-left-arrow gspwp-arrow-style-<?php echo esc_attr($i); ?>"></div>
                        <div class="gspwp-arrow gspwp-right-arrow gspwp-arrow-style-<?php echo esc_attr($i); ?>"></div>
                    </div>
                    <?php
                }
                ?>
            </div>
        </div>

        <div id="gspwp-navigation-style-dialog" class="gspwp-navigation-style-dialog" title="<?php esc_attr_e('Select Navigation', GSPWP_TEXTDOMAIN); ?>" style="display: none;">
            <div class="gspwp-navigation-style-box">
                <?php
                for ($i = 1; $i <= 10; $i++) {
                    ?>
                    <div class="gspwp-navigation-cover" data-style="style-<?php echo esc_attr($i); ?>">
                        <div class="gspwp-navigation gspwp-navigation-style-<?php echo esc_attr($i); ?>">
                            <div class="owl-pagination">
                                <div class="owl-page active"><span></span></div>
                                <div class="owl-page"><span></span></div>
                                <div class="owl-page"><span></span></div>
                                <div class="owl-page"><span></span></div>
                                <div class="owl-page"><span></span></div>
                            </div>
                        </div>
                    </div>
                    <?php
                }
                ?>
            </div>

        </div>
        
        <?php
    }

}