<?php

/**
 * Remove Metaboxes submitdiv & gspwp_layouts & core
 *
 * @version 1.0.0
 * @since   1.0.0
 */
remove_meta_box('submitdiv', 'gs_layouts', 'core');

/**
 * Add Metaboxes submitdiv
 *
 * @version 1.0.0
 * @since   1.0.0
 */
add_meta_box('submitdiv', sprintf(__('Publish', GSPWP_TEXTDOMAIN)), 'gspwp_layouts_submit_meta_box', 'gs_layouts', 'side', 'high');

if (!function_exists('gspwp_layouts_submit_meta_box')) {

    function gspwp_layouts_submit_meta_box() {
        global $action, $post;
        $post_type = $post->post_type;
        $post_type_object = get_post_type_object($post_type);
        $can_publish = current_user_can($post_type_object->cap->publish_posts);
        ?>
        <div class="submitbox" id="submitpost">
            <?php
            if (in_array($post->post_status, array('publish', 'future', 'private'))) {
                ?>
                <div class="minor-publishing">
                    <div class="gallery-showcase-shortcode">
                        <input type="text" value="[gallery_showcase layout='<?php echo sanitize_text_field($post->post_name); ?>']" onclick="this.select();" readonly="readonly"/>
                    </div>
                </div>
                <?php
            }
            ?>
            <div id="major-publishing-actions">
                <?php do_action('post_submitbox_start'); ?>
                <div id="delete-action">
                    <?php
                    if (!EMPTY_TRASH_DAYS) {
                        $delete_text = esc_html__('Delete Permanently', GSPWP_TEXTDOMAIN);
                    } else {
                        $delete_text = esc_html__('Move to Trash', GSPWP_TEXTDOMAIN);
                    }
                    ?>
                    <a class="submitdelete deletion" href="<?php echo get_delete_post_link($post->ID); ?>"><?php echo esc_html__($delete_text , GSPWP_TEXTDOMAIN); ?></a>
                </div>
                <div id="publishing-action">
                    <span class="spinner"></span>
                    <?php
                    if (!in_array($post->post_status, array('publish', 'future', 'private')) || 0 == $post->ID) {
                        if ($can_publish) :
                            ?><input name="original_publish" type="hidden" id="original_publish" value="<?php esc_attr_e('Add Tab', GSPWP_TEXTDOMAIN) ?>" /><?php
                            submit_button(sprintf(esc_html__('Add', GSPWP_TEXTDOMAIN)), 'primary button-large', 'publish', false, array('accesskey' => 'p'));
                        endif;
                    } else {
                        ?>
                        <input name="original_publish" type="hidden" id="original_publish" value="<?php esc_attr_e('Update', GSPWP_TEXTDOMAIN) ?>" />
                        <input name="save" type="submit" class="button button-primary button-large" id="publish" accesskey="p" value="<?php esc_attr_e('Update', GSPWP_TEXTDOMAIN); ?>" />
                        <?php
                    }
                    ?>
                </div>
                <div class="clear"></div>
            </div>
        </div>
        <?php
    }

}