<?php
// DEFINING MODULE STRUCTURE AND FIELDS


class gg_collection_divi_module extends ET_Builder_Module {

	public $slug       = 'gg_collection';
	public $vb_support = 'on';

    
	protected $module_credits = array(
        'module_uri' => 'https://lcweb.it/global-gallery',
        'author'     => 'LCweb',
        'author_uri' => 'https://lcweb.it/',
	);

    
    public function get_advanced_fields_config() {
        return unserialize(LC_DIVI_DEF_OPTS_OVERRIDE);
	}

    
	public function init() {
		$this->name               = 'GG - '. esc_html__('Collection', 'gg_ml');
		$this->icon_path          =  $GLOBALS['gg_divi_icon_path'];
		$this->main_css_element   = '%%order_class%%';	
        
        $this->settings_modal_toggles  = array(
			'general'  => array(
				'toggles' => array(
					'main'     => esc_html__('Main Options', 'gg_ml'),
					'styling'  => esc_html__('Styling', 'gg_ml'),
				),
			),
		);
	}
 
    
	public function get_fields() {
        include_once(GG_DIR .'/settings/field_options.php');
        
        // collections array
		$collections = get_terms('gg_collections', 'hide_empty=0');
		
		$colls_arr = array(); 
		foreach($collections as $collection) {
			$colls_arr[ $collection->term_id ] = $collection->name;
		}		
		////////////////////////////////
        
        
        $fields =array(
            'cid' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Choose collection', 'gg_ml'),
				'type'            => 'select',
                'default'         => current(array_keys($colls_arr)),
				'default_on_front'=> current(array_keys($colls_arr)),
				'options'         => $colls_arr,
				//'description'     => esc_html__( 'Choose whether your linklink opens in a new window or not', 'gg_ml'),
			),
            'filter' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Allow Filters?', 'gg_ml'),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
                'description'     => esc_html__('Allows galleries filtering by category', 'gg_ml'),
			),	
            'random' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Random display?', 'gg_ml'),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
			),	
            'pag_sys' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Pagination system", 'gg_ml'),
				'type'            => 'select',
				'default'         => '',
				'default_on_front'=> '',					
				'options'         => array(
				    'unset' => __('None', 'gg_ml'),
                    'auto' 	=> __('Auto - follow global settings', 'gg_ml')
			     ) + gg_pag_sys(),
			),
            'per_page' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("How many galleries per page?", 'gg_ml'),
				'type'            => 'range',
                'default'         => 0,
				'default_on_front'=> 0,
				'range_settings'    => array(
					'min'   => 0,
					'max'   => 200,
                    'step'  => 1
				),
                'validate_unit' => true,
                'description'     => esc_html__('Use zero to disable pagination', 'gg_ml'),
			),
		);
        
        
        $GLOBALS[ $this->slug .'_divi_field_indexes'] = array_keys($fields);
        return $fields;
	}


    
    public function render($attrs, $content = null, $render_slug = null) {
        return gg_divi_modules::front_shortcode_render($this->slug, $this->props);  
	}
}

new gg_collection_divi_module;