<?php
// DEFINING MODULE STRUCTURE AND FIELDS


class gg_itg_divi_module extends ET_Builder_Module {

	public $slug       = 'gg_itg';
	public $vb_support = 'on';

    
	protected $module_credits = array(
        'module_uri' => 'https://lcweb.it/global-gallery',
        'author'     => 'LCweb',
        'author_uri' => 'https://lcweb.it/',
	);

    
    public function get_advanced_fields_config() {
        return unserialize(LC_DIVI_DEF_OPTS_OVERRIDE);
	}

    
	public function init() {
		$this->name               = 'GG - '. esc_html__('Image to Gallery', 'gg_ml');
		$this->icon_path          =  $GLOBALS['gg_divi_icon_path'];
		$this->main_css_element   = '%%order_class%%';	
        
        $this->settings_modal_toggles  = array(
			'general'  => array(
				'toggles' => array(
					'main'     => esc_html__('Main Options', 'gg_ml'),
					'styling'  => esc_html__('Styling', 'gg_ml'),
				),
			),
		);
	}
 
    
	public function get_fields() {
        $fields =array(
            'gid' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Images source', 'gg_ml'),
				'type'            => 'select',
                'default'         => current(array_keys($GLOBALS['gg_divi_galls'])),
				'default_on_front'=> current(array_keys($GLOBALS['gg_divi_galls'])),
				'options'         => $GLOBALS['gg_divi_galls'],
				//'description'     => esc_html__('Choose whether your linklink opens in a new window or not', 'gg_ml'),
			),
            'lc_width' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Box width", 'gg_ml'),
				'type'            => 'range',
                'default'         => 100,
				'default_on_front'=> 100,
				'range_settings'    => array(
					'min'   => 20,
					'max'   => 1000,
                    'step'  => 1
				),
                'validate_unit' => true,
			),
            'w_type' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Width's unit type", 'gg_ml'),
				'type'            => 'select',
				'default'         => '%',
				'default_on_front'=> '%',					
				'options'         => array(
				    'px'	=> 'px ('. esc_html__("static", 'gg_ml') .')',
                    '%'	=> '% ('. esc_html__("responsive", 'gg_ml') .')',
				),
			),
            'img_h' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Images height", 'gg_ml'),
				'type'            => 'range',
                'default'         => 75,
				'default_on_front'=> 75,
				'range_settings'    => array(
					'min'   => 20,
					'max'   => 1000,
                    'step'  => 5
				),
                'validate_unit' => true,
			),
            'h_type' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Height's unit type", 'gg_ml'),
				'type'            => 'select',
				'default'         => '%',
				'default_on_front'=> '%',					
				'options'         => array(
				    'px'	=> 'px ('. esc_html__("static", 'gg_ml') .')',
                    '%'	=> '% ('. esc_html__("responsive", 'gg_ml') .')',
				),
                'description'     => esc_html__('Using % value, height is proportional to width', 'gg_ml'),
			),
            'layout' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Layout', 'gg_ml'),
				'type'            => 'select',
                'default'         => '',
				'default_on_front'=> '',
				'options'         => array('unset' => __('(as default)', 'gg_ml')) + gg_itg_layouts(),
				//'description'     => esc_html__('Choose whether your linklink opens in a new window or not', 'gg_ml'),
			),
            'img_num' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('How many images to display?', 'gg_ml'),
				'type'            => 'select',
                'default'         => '1',
				'default_on_front'=> '1',
				'options'         => array(
                    '1'	=> '1',
                    '2'	=> '2',
                    '4'	=> '4',
                ),
				//'description'     => esc_html__('Choose whether your linklink opens in a new window or not', 'gg_ml'),
			),
            'lc_font_size' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Custom font size", 'gg_ml') .' (rem)',
				'type'            => 'text',
                'default'         => '',
				'default_on_front'=> '',
                'description'     => esc_html__('Leave empty to use default one', 'gg_ml'),
			),
            'random' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Random display?', 'gg_ml'),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
			),	
            'watermark' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Use watermark?', 'gg_ml'),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
			),	
            'ol_txt' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Custom overlay text", 'gg_ml'),
				'type'            => 'textarea',
                'default'         => '',
				'default_on_front'=> '',
                'description'     => esc_html__('Remember you can use placeholders and FontAwesome icons as explained in settings', 'gg_ml'),
			),
		);
        
        
        $GLOBALS[ $this->slug .'_divi_field_indexes'] = array_keys($fields);
        return $fields;
	}


    
    public function render($attrs, $content = null, $render_slug = null) {
        return gg_divi_modules::front_shortcode_render($this->slug, $this->props);  
	}
}

new gg_itg_divi_module;

