<?php
// Elementor shortcodes integration

function gg_on_elementor($widgets_manager) {
    $basepath = GG_DIR .'/builders_integration/elementor_elements';
    
    
    /*** store common arrays into globals ***/
		
    // galleries array
    $args = array(
        'post_type' => 'gg_galleries',
        'numberposts' => -1,
        'post_status' => 'publish',
    );
    $galleries = get_posts($args);

    $galls_arr = array(); 
    foreach($galleries as $gallery) {
        $galls_arr[ $gallery->ID ] = $gallery->post_title;
    }
    $GLOBALS['gg_emtr_galls'] = $galls_arr;
    
    
    
    
    $widgets = array(
        'gallery'       => 'gg_gallery_on_elementor',
        'itg'           => 'gg_itg_on_elementor',
        'collection'    => 'gg_collection_on_elementor',
        'slider'        => 'gg_slider_on_elementor',
        'carousel'      => 'gg_carousel_on_elementor',
    );
    
    foreach($widgets as $filename => $classname) {
        
        include_once($basepath .'/'. $filename .'.php');
        $widgets_manager->register( new $classname() );
    }
}
add_action('elementor/widgets/register', 'gg_on_elementor');





// add Global Gallery section
add_action('elementor/init', function() {
   \Elementor\Plugin::$instance->elements_manager->add_category( 
   	'global-gallery',
   	array(
   		'title' => 'Global Gallery',
   		'icon' => 'fa fa-plug',
   	),
	3
   );
});





// style needed for LCweb icons
add_action('elementor/editor/after_enqueue_styles', function() {
	wp_enqueue_style('lcweb-elementor-icon', GG_URL .'/builders_integration/elementor_elements/lcweb_icon.css');	
});
