<?php
// REGISTER BLOCK


// structure
$defaults = array(
	'gid' => array(
		'label'		=> __('Which gallery?', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array('' => __('Select a gallery', 'gg_ml')) + $GLOBALS['gg_guten_galls'],
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'img_max_w' => array(
		'label'		=> __('Images max width', 'gg_ml'),
		'type'		=> 'slider',
		'min'		=> 20,
		'max'		=> 2000,
		'default' 	=> 180,
		'panel'		=> 'main',
	),
	'height' => array(
		'label'		=> __('Images height', 'gg_ml'),
		'type'		=> 'slider',
		'min'		=> 20,
		'max'		=> 1000,
		'default' 	=> 200,
		'panel'		=> 'main',
	),
	'h_type' => array(
		'label'		=> __('Height unit type', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'px'	=> 'px (static)',
			'%'		=> '% (responsive)',
		),
		'default' 	=> 'px',
		'panel'		=> 'main',
	),
	'rows' => array(
		'label'		=> __('Rows', 'gg_ml'),
		'type'		=> 'slider',
		'min'		=> 1,
		'max'		=> 10,
		'default' 	=> 1,
		'panel'		=> 'main',
	),
	'multiscroll' => array(
		'label'		=> __('Multi-scroll?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'center' => array(
		'label'		=> __('Center display mode?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'nocrop' => array(
		'label'		=> __('Avoid images crop?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'static' => array(
		'label'		=> __('Static mode?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'random' => array(
		'label'		=> __('Random display?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'watermark' => array(
		'label'		=> __('Use watermark?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'autoplay' => array(
		'label'		=> __('Autoplay carousel?', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'auto'	=> __('as default', 'gg_ml'),
			'1'		=> __('Yes'),
			'0'		=> __('No'),
		),
		'default' 	=> 'auto',
		'panel'		=> 'main',
	),
);





$defaults = gg_fix_block_defs($defaults);

register_block_type('lcweb/g-carousel', array(
	'editor_script' 	=> 'gg_car_on_guten',
	'render_callback' 	=> 'gg_carousel_guten_handler',
	'attributes' 		=> $defaults
));


wp_localize_script('wp-blocks', 'gg_car_defaults', $defaults);
