<?php
// REGISTER BLOCK


// structure
$defaults = array(
	'gid' => array(
		'label'		=> __('Images source', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array('' => __('Select a gallery', 'gg_ml')) + $GLOBALS['gg_guten_galls'],
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'width' => array(
		'label'		=> __("Slider's width", 'gg_ml'),
		'type'		=> 'slider',
		'min'		=> 20,
		'max'		=> 1000,
		'default' 	=> 100,
		'panel'		=> 'main',
	),
	'w_type' => array(
		'label'		=> __("Width's unit type", 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'px'	=> 'px (static)',
			'%'		=> '% (responsive)',
		),
		'default' 	=> '%',
		'panel'		=> 'main',
	),
	'height' => array(
		'label'		=> __("Slider's height", 'gg_ml'),
		'type'		=> 'slider',
		'min'		=> 20,
		'max'		=> 1000,
		'default' 	=> 55,
		'panel'		=> 'main',
	),
	'h_type' => array(
		'label'		=> __("Height's unit type", 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'px'	=> 'px (static)',
			'%'		=> '% (responsive)',
		),
		'default' 	=> '%',
		'panel'		=> 'main',
	),
	'random' => array(
		'label'		=> __('Random display?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'watermark' => array(
		'label'		=> __('Use watermark?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'autoplay' => array(
		'label'		=> __('Autoplay slider?', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'auto'	=> __('as default', 'gg_ml'),
			'1'		=> __('Yes'),
			'0'		=> __('No'),
		),
		'default' 	=> 'auto',
		'panel'		=> 'main',
	),
);




$defaults = gg_fix_block_defs($defaults);

register_block_type('lcweb/g-slider', array(
	'editor_script' 	=> 'gg_slider_on_guten',
	'render_callback' 	=> 'gg_slider_guten_handler',
	'attributes' 		=> $defaults
));


wp_localize_script('wp-blocks', 'gg_slider_defaults', $defaults);
