<?php
/*	GALLERY BUILDER HUB 
	MAIN CLASS SETTING UP PARAMETERES AND RETURNING SPECIFIC OPTIONS CODE 
*/

class gg_builder_hub {
	
	public $gid; // (int) gallery ID
	public $src; // (string) images source type
	public $gall_params = array(); // (array) associative array containing gallery arguments to show images (eg. username, token)
		
	
	/* construct - setup gallery ID and eventually source type */
	public function __construct($gid, $src = false) {
		$this->gid = $gid;
		
		$this->src = (empty($src)) ? get_post_meta($gid, 'gg_type', true) : $src;
		if(empty($this->src)) {$this->src = 'wp';}   // still empty == new gallery == set to WP
	}
	
	
	
	/* LOAD PARAMETERS */
	public function load_params($params = false) {
		// whether to use passed params
		if(is_array($params)) {
			$this->gall_params['username'] 		= (isset($params['username'])) ? $params['username'] : '';	
			$this->gall_params['connect_id'] 	= (isset($params['connect_id'])) ? $params['connect_id'] : '';	
		}
		else {
			$this->gall_params['username'] 		= get_post_meta($this->gid, 'gg_username', true);
			$this->gall_params['connect_id'] 	= get_post_meta($this->gid, 'gg_connect_id', true);
		}
	}
	
	
	/* SAVE PARAMETERS */
	public function save_params() {
		if(empty($this->gall_params)) {$this->load_params();}
		
		update_post_meta($this->gid, 'gg_username'	, $this->gall_params['username']);	
		update_post_meta($this->gid, 'gg_connect_id', $this->gall_params['connect_id']);
	}
	
	
	
	/* HAS GALLERY BEEN SET UP? 
	 * boolean resource to know whether to show options or not
	 * @param (bool) $check_db = whether to check post_meta or just use $this->gall_params
	 */
	public function is_gallery_ready($check_db = false) {
		if(empty($this->src)) {return false;}
		if(empty($this->gall_params)) {$this->load_params();}
		
		if(in_array($this->src, array('g_drive', 'onedrive')) && !$this->gall_params['connect_id']) {
			return false;
		}
		if(!in_array($this->src, array('wp', 'wp_cat', 'cpt_tax', 'gg_album', 'rml', 'ngg', 'g_drive', 'onedrive')) && !$this->gall_params['username']) {
			return false;
		}
		
		return true;	
	}
	
	
	
	/* BUILDER SPECIFIC OPTIONS - RELATED TO SOURCE
	 * @param $params (array) - associative array containing data needed to connect to sources (eg. username - password)
	 * @return (string) html code to be used in builder's AJAX request or directly
	 */
	public function spec_opt($params = false) {

		// load parameters
		$this->load_params($params);

		$gid = $this->gid; 
		$code = '<div class="gg_mainbox_meta gg_form">';
		
		// if gallery isn't ready - only message
		if(!$this->is_gallery_ready()) {
			return '<em>' . __('Select gallery type and fill in data to get images', 'gg_ml') . '</em>';
		}
		
		
		// autopopulation (if allowed)
		if($this->src != 'wp') {
			$autopop = get_post_meta($gid, 'gg_autopop', true);
			$auto_author = get_post_meta($gid, 'gg_auto_author', true);
			$auto_title = get_post_meta($gid, 'gg_auto_title', true);
			$auto_descr = get_post_meta($gid, 'gg_auto_descr', true);
			$auto_link = get_post_meta($gid, 'gg_auto_link', true);
			
            $forced_author = get_post_meta($gid, 'gg_forced_author', true);
            $cache_interval = get_post_meta($gid, 'gg_cache_interval', true);
			$auto_random = get_post_meta($gid, 'gg_auto_random', true);
			
            $max_images = get_post_meta($gid, 'gg_max_images', true);	
            if(!$max_images) {
                $max_images = 20;
            }
			
			// switches
			$autopop_vis = ($autopop == 1) ?  '' : 'gg_displaynone';
			
			
			// automatic gallery population option
			$code .= '
			<h4>' . __('Auto Gallery Population', 'gg_ml') . '</h4>
			<table class="widefat gg_table gg_metabox_table">	 
			  <tr>
				<td class="gg_label_td">' . __('Auto population?', 'gg_ml') . '</td>
				<td class="gg_field_td" id="gg_autopop">
					<input type="checkbox" value="1" name="gg_autopop" class="gg_lc_switch" '. checked('1', $autopop, false) .' autocomplete="off" />
				</td>     
				<td><span class="info">' . __('Check to enable automatic gallery population', 'gg_ml') . '</span></td>
			  </tr>
			  <tr class="gg_autopop_fields '.$autopop_vis.'">
				<td class="gg_label_td">' . __('Display authors?', 'gg_ml') . '</td>
				<td class="gg_field_td">
					<input type="checkbox" value="1" name="gg_auto_author" class="gg_lc_switch" '. checked('1', $auto_author, false) .' autocomplete="off" />
				</td>     
				<td><span class="info">' . __('Check to display fetched authors', 'gg_ml') . '</span></td>
			  </tr>
			  <tr class="gg_autopop_fields '.$autopop_vis.'">
				<td class="gg_label_td">' . __('Display titles?', 'gg_ml') . '</td>
				<td class="gg_field_td">
					<input type="checkbox" value="1" name="gg_auto_title" class="gg_lc_switch" '. checked('1', $auto_title, false) .' autocomplete="off" />
				</td>     
				<td><span class="info">' . __('Check to display fetched titles', 'gg_ml') . '</span></td>
			  </tr>
			  <tr class="gg_autopop_fields '.$autopop_vis.'">
				<td class="gg_label_td">' . __('Display descriptions?', 'gg_ml') . '</td>
				<td class="gg_field_td">
					<input type="checkbox" value="1" name="gg_auto_descr" class="gg_lc_switch" '. checked('1', $auto_descr, false) .' autocomplete="off" />
				</td>     
				<td><span class="info">' . __('Check to display fetched descriptions', 'gg_ml') . '</span></td>
			  </tr>';
			  
			  
			  // WP-terms - add the auto-link ability
			  if($this->src == 'wp_cat' || $this->src == 'cpt_tax') {
			  	$code .= '
				<tr class="gg_autopop_fields '.$autopop_vis.'">
				  <td class="gg_label_td">' . __('Enable post links?', 'gg_ml') . '</td>
				  <td class="gg_field_td">
					  <input type="checkbox" value="1" name="gg_auto_link" class="gg_lc_switch" '. checked('1', $auto_link, false) .' autocomplete="off" />
				  </td>     
				  <td><span class="info">' . __('If checked, each image will lead to its linked post', 'gg_ml') . '</span></td>
				</tr>';
			  }
			  
			  
			  $code .= '
			  <tr>
			  	<td colspan="3"></td>
			  </tr>
              <tr class="gg_autopop_fields '.$autopop_vis.'">
				<td class="gg_label_td">' . __('Custom author', 'gg_ml') . '</td>
				<td class="gg_field_td">
				  <input type="text" name="gg_forced_author" value="'. esc_attr($forced_author) .'" autocomplete="off" />
				</td>     
				<td><span class="info">' . __('Optionally set a custom author, overriding fetched values', 'gg_ml') . '</span></td>
			  </tr>
			  <tr class="gg_autopop_fields '.$autopop_vis.'">
				<td class="gg_label_td">' . __('Cache interval', 'gg_ml') . '</td>
				<td class="gg_field_td">
				  <select name="gg_cache_interval" autocomplete="off">';
				  
				  foreach(gg_gall_static::cache_intervals() as $key => $val) {
					  $code .= '<option value="'. $key .'" '. selected($key, $cache_interval, false) .'>'. esc_html($val) .'</option>';
				  }
				  
				$code .= '
				  </select>
				</td>     
				<td><span class="info">' . __('Choose gallery images cache interval', 'gg_ml') . '</span></td>
			  </tr>
			  <tr class="gg_autopop_fields '.$autopop_vis.'">
				<td class="gg_label_td">' . __('Random selection?', 'gg_ml') . '</td>
				<td class="gg_field_td" id="gg_auto_random">
					<input type="checkbox" value="1" name="gg_auto_random" class="gg_lc_switch" '. checked('1', $auto_random, false) .' autocomplete="off" />
					<span class="gg_rebuild_cache">(' . __('rebuild cache', 'gg_ml') . ')</span>
				</td>     
				<td><span class="info">' . __('Check to randomly select images between available ones', 'gg_ml') . '</span></td>
			  </tr>
			  <tr class="gg_autopop_fields '.$autopop_vis.'">
				<td class="gg_label_td">' . __('Max images', 'gg_ml') . '</td>
				<td class="gg_field_td">
					<input type="number" name="gg_max_images" value="'. (int)$max_images .'" min="1" max="5000" step="1" id="gg_max_images" autocomplete="off" />
					<span class="gg_rebuild_cache">(' . __('rebuild cache', 'gg_ml') . ')</span>
				</td>     
				<td><span class="info">' . __('Maximum gallery images number', 'gg_ml') . '</span></td>
			  </tr>
			</table>';	
		} // autopop end

		
		// specific selections - depending on source
		switch($this->src) {
			case 'wp_cat' :
				$sel_cat = get_post_meta($gid, 'gg_wp_cat', true);
				
				$code .= '
				<h4>'. __('Images Source', 'gg_ml') .'</h4>
				<table class="widefat gg_table gg_metabox_table gg_bordernone">
				  <tr class="gg_imgpckr_cat_sel_wrap">
					<td class="gg_label_td">'. __('Choose category', 'gg_ml') .'</td>
					<td class="gg_field_td">
					  <select name="gg_wp_cat" id="gg_wp_cat" class="gg_lc_select" autocomplete="off">';
						  
						  foreach( get_categories() as $cat ) {
							  $code .= '<option value="'. $cat->term_id .'" '. selected($cat->term_id, $sel_cat, false) .'>'. $cat->name .'</option>'; 
						  }
			  
				  $code .= '	
					  </select>
					</td>     
					<td><span class="info">'. __('Choose posts category to use as images source', 'gg_ml') .'</span></td>
				  </tr>
				</table>';
				break;
			
			
			case 'cpt_tax' :
				$sel_tax = get_post_meta($gid, 'gg_cpt_tax', true);
				$sel_term = get_post_meta($gid, 'gg_cpt_tax_term', true);
				
				$code .= '
				<h4>'. __('Images Source', 'gg_ml') .'</h4>
				<table class="widefat gg_table gg_metabox_table gg_bordernone">
				  <tr class="gg_imgpckr_cat_sel_wrap">
					<td class="gg_label_td">'. __('Choose post type and taxonomy', 'gg_ml') .'</td>
					<td class="gg_field_td">
					  <select name="gg_cpt_tax" id="gg_cpt_tax" class="gg_lc_select" autocomplete="off">';
						  
						  $a = 0;
                          $cpt_n_tax = array(
                              'post' => array(
                                  'name' => __('Posts'), 
                                  'tax' => array('post_tag' => __('Post tags', 'gg_ml'))
                              )
                          ) + gg_gall_static::get_cpt_with_tax(); 
                
						  foreach($cpt_n_tax as $slug => $data ) {
							  $b = 0;
							  foreach($data['tax'] as $tax_slug => $tax_name) {
								  $val = $slug.'|||'.$tax_slug;
								  if($a == 0 && $b == 0) {$first_cpt_cat = $val;} // save first value for first term query
								  
								  $sel = ($sel_tax == $val) ? 'selected="selected"' : '';
								  $code .= '<option value="'.$val.'" '.$sel.'>'.$tax_name.'</option>'; 
								  
								  $b++;
							  }
							  $a++;
						  }
			  
				 $code .= '	
					  </select>
					</td>     
					<td></td>
				  </tr>
				  <tr class="gg_imgpckr_cat_sel_wrap">
					<td class="gg_label_td">'. __('Choose term', 'gg_ml') .'</td>
					<td class="gg_field_td" id="gg_ctp_tax_term_wrap">';
					
					  if(empty($sel_tax)) {$sel_tax = $first_cpt_cat;}
					  $code .= gg_gall_static::get_taxonomy_terms($sel_tax, $sel_term);
				   
				  $code .= '	
					</td>     
					<td></td>
				  </tr>
				</table>';
				break;
			
			
			case 'gg_album' :
				include_once(GG_DIR .'/classes/gg_local_images.php');
                $fm = new gg_local_images();

                // startup engine
                $fm_response = $fm->is_ready();
                if($fm_response !== true) {
                    return sprintf(
                        __('Initialization error, <a href="%s">please configure this source</a> before creating galleries', 'gg_ml'), 
                        admin_url('edit.php?post_type=gg_galleries&page=gg_album_manager')
                    );
                }
                
				$albums = $fm->list_folders();	
				$sel_album = get_post_meta($gid, 'gg_album', true);
                
                if(!is_array($albums)) {
                    return (string)$albums;
                }
				elseif(empty($albums)) {
                    return '<strong>'. __('No albums found', 'gg_ml') .'</strong>';
                }

				$code .= '
				<h4>'. __('Images Source', 'gg_ml') .'</h4>
				<table class="widefat gg_table gg_metabox_table gg_bordernone">
				  <tr class="gg_imgpckr_cat_sel_wrap">
					<td class="gg_label_td">'. __('Choose an album', 'gg_ml') .'</td>
					<td class="gg_field_td">
					  <select name="gg_album" id="gg_album" class="gg_lc_select" autocomplete="off">';
			  
						  foreach($albums as $folder) {
							  $code .= '<option value="'. esc_attr($folder) .'" '. selected($sel_album, $folder, false) .'>'. $folder .'</option>'; 
						  }
			  
				 $code .= '	
					  </select>
					</td>     
					<td><span class="info">'. __('Choose the gallery to use as image source', 'gg_ml') .'</span></td>
				  </tr>
				</table>';
				break;
				
				
			case 'flickr' :
				$subj = gg_gall_static::flickr_subj($this->gall_params['username']);
				$arr = explode('/', untrailingslashit($this->gall_params['username'] ));
                $subj_id = end($arr);
				
				switch($subj) {
					case 'set' 			: if(!$subj_id) {return '<strong>'. __('ID not found - please insert a valid set URL', 'gg_ml') .'</strong>';}
						break;
					case 'photostream' 	: if(!$subj_id) {return '<strong>'. __('Username not found - please insert a valid profile URL', 'gg_ml') .'</strong>';}
						break;
					case 'tag' 			: if(!$subj_id) {return '<strong>'. __('No tag found - please insert a valid tag URL', 'gg_ml') .'</strong>';} 	
						break;
				}
				break;	
			
		
			case 'instagram' :
				if(!filter_var($this->gall_params['username'], FILTER_VALIDATE_URL) || strpos($this->gall_params['username'], '.instagram.com/') === false)  {
					return '<strong>'. __('Invalid URL - please insert a valid profile URL', 'gg_ml') .'</strong>';
				}
				break;	
			
			
			case 'pinterest' :
				if(substr($this->gall_params['username'], 0, 22) != 'https://www.pinterest.')  {
					return '<strong>'. __('Invalid URL - please insert a valid board URL', 'gg_ml') .'</strong>';
				}
				break;
			
		
			case 'fb' :
				return '<h3 class="gg_disc_source_warn"><strong>NOTE:</strong> starting from October 2019, Facebook blocked the way Global Gallery used to access albums.<br/>
				Because of this, actually, isn\'t possible to use this source anymore.</h3>
				
				<style>
				#publishing-action, #gg_handle_user_btn, #gg_launch_conn_wizard {
					display: none !important;	
				}
				</style>';
				break;
				
	
			case 'picasa' : // google+
				
				return '<h3 class="gg_disc_source_warn"><strong>NOTE:</strong> starting from January 2019, Google prevents permanent image URLs to be retrieved from its Google Photos service.<br/>
				Because of this, actually, isn\'t possible to use this source anymore.</h3>
				
				<style>
				#publishing-action, #gg_handle_user_btn {
					display: none !important;	
				}
				</style>';
				break;	
			
			
			case 'g_drive' :
				include_once(GG_DIR .'/classes/source_helpers/gdrive_integration.php');
				$gdrive = new gg_gdrive_integration($this->gall_params['connect_id']);

				$sel_album = get_post_meta($gid, 'gg_gdrive_album', true);
				
                try {
                    $albums = $gdrive->list_albums();
                }
                catch(Google_Service_Exception $e) {
                    $mess = json_decode($e->getMessage(), true);
                    return '<strong>GDrive '. __('Connection error', 'gg_ml') .' - '. $mess['error']['message'] .'</strong>';        
                }

				if(!$albums) {
                    return '<strong>GDrive '. __('Connection error', 'gg_ml') .' - '. __('no albums found', 'gg_ml') .'</strong>';
                }
				if(!is_array($albums)) {
                    return '<strong>'. $albums .'</strong>';
                }
				
				$code .= '
				<h4>'. __('Images Source', 'gg_ml') .'</h4>
				<table class="widefat gg_table gg_metabox_table gg_bordernone">
				  <tr class="gg_imgpckr_cat_sel_wrap">
					<td class="gg_label_td">'. __('Choose an Album', 'gg_ml') .'</td>
					<td class="gg_field_td">
					  <select name="gg_gdrive_album" id="gg_gdrive_album" class="gg_lc_select" autocomplete="off">';
						  
						  foreach( $albums as $id => $name ) {
							  $code .= '<option value="'.$id.'" '. selected($id, $sel_album, false) .'>'.$name.'</option>'; 
						  }
			  
				  $code .= '	
					  </select>
					</td>     
					<td><span class="info">'. __('Choose the album to use as image source', 'gg_ml') .'</span></td>
				  </tr>
				</table>';
				break;
				
				
			case 'onedrive' :
				include_once(GG_DIR .'/classes/source_helpers/onedrive_integration.php');
				$onedrive = new gg_onedrive_integration($this->gall_params['connect_id']);
				
				$sel_album = get_post_meta($gid, 'gg_onedrive_album', true);
				$albums = $onedrive->list_albums();

				if(!$albums) {
                    return '<strong>Onedrive '. __('Connection error', 'gg_ml') .' - '. __('no albums found', 'gg_ml') .'</strong>';
                }
				if(!is_array($albums)) {
                    return '<strong>'. $albums .'</strong>';
                }
				
				$code .= '
				<h4>'. __('Images Source', 'gg_ml') .'</h4>
				<table class="widefat gg_table gg_metabox_table gg_bordernone">
				  <tr class="gg_imgpckr_cat_sel_wrap">
					<td class="gg_label_td">'. __('Choose an Album', 'gg_ml') .'</td>
					<td class="gg_field_td">
					  <select name="gg_onedrive_album" id="gg_onedrive_album" class="gg_lc_select" autocomplete="off">';
						  
						  foreach( $albums as $id => $name ) {
							  ($id == $sel_album) ? $sel = 'selected="selected"' : $sel = '';
							  $code .= '<option value="'.$id.'" '. selected($id, $sel_album, false) .'>'.$name.'</option>'; 
						  }
			  
				  $code .= '	
					  </select>
					</td>     
					<td><span class="info">'. __('Choose the album to use as image source', 'gg_ml') .'</span></td>
				  </tr>
				</table>';
				break;
			
			
			case 'twitter' :
				return '<h3 class="gg_disc_source_warn"><strong>NOTE:</strong> starting from May 2023, Twitter blocked the ability to search for tweets (unless you subscribe a 5000$/months account).<br/>
				Because of this, actually, isn\'t possible to use this source anymore.</h3>
				
				<style>
				#publishing-action, #gg_handle_user_btn, #gg_username_wrap {
					display: none !important;	
				}
				</style>';
                
                /*if(!preg_match("/\@[a-z0-9_]+/i", $this->gall_params['username']) && !preg_match("/\#[a-z0-9_]+/i", $this->gall_params['username'])) {
					return '<strong>'. __('Please use a valid username or hashtag', 'gg_ml') .'</strong>';	
				}*/
				break;	
			
			
			case 'tumblr' :
				if(!filter_var($this->gall_params['username'], FILTER_VALIDATE_URL)) {return '<strong>'. __('Invalid URL - please insert a valid blog URL', 'gg_ml') .'</strong>';}
				break;	
				
				
			case 'rml' :
				$rml_folders 	= gg_gall_static::get_rml_galleries();
				$sel_folder 	= get_post_meta($gid, 'gg_rml_folder', true);
			
				$code .= '
				<h4>'. __('Images Source', 'gg_ml') .'</h4>
				<table class="widefat gg_table gg_metabox_table gg_bordernone">
				  <tr class="gg_imgpckr_cat_sel_wrap">
					<td class="gg_label_td">'. __('Choose Folder', 'gg_ml') .'</td>
					<td class="gg_field_td">
					  <select name="gg_rml_folder" id="gg_rml_folder" class="gg_lc_select" autocomplete="off">';
						  
						  foreach($rml_folders as $f_id => $f_name) {
							  $code .= '<option value="'. $f_id .'" '. selected($sel_folder, $f_id, false) .'>'. $f_name .'</option>'; 
						  }
			  
				  $code .= '	
					  </select>
					</td>     
					<td><span class="info">'. __('Choose the folder to use as images source', 'gg_ml') .'</span></td>
				  </tr>
				</table>';
				break;			
				

			case 'ngg' :
				$ngg_galls = gg_gall_static::get_ngg_galleries();
				$sel_gall = get_post_meta($gid, 'gg_ngg_gallery', true);
			
				$code .= '
				<h4>'. __('Images Source', 'gg_ml') .'</h4>
				<table class="widefat gg_table gg_metabox_table gg_bordernone">
				  <tr class="gg_imgpckr_cat_sel_wrap">
					<td class="gg_label_td">'. __('Choose Gallery', 'gg_ml') .'</td>
					<td class="gg_field_td">
					  <select name="gg_ngg_gallery" id="gg_ngg_gallery" class="gg_lc_select" autocomplete="off">';
						  
						  foreach($ngg_galls as $gall) {
							  ($gall['gid'] == $sel_gall) ? $sel = 'selected="selected"' : $sel = '';
							  $code .= '<option value="'.$gall['gid'].'" '.$sel.'>'.$gall['title'].'</option>'; 
						  }
			  
				  $code .= '	
					  </select>
					</td>     
					<td><span class="info">'. __('Choose the nextGEN gallery to use as images source', 'gg_ml') .'</span></td>
				  </tr>
				</table>';
				break;		
				
			
			case 'rss' :
				if(!filter_var($this->gall_params['username'], FILTER_VALIDATE_URL)) {return '<strong>'. __('Invalid URL - please insert a valid feed URL', 'gg_ml') .'</strong>';}
				break;
		}
		/////////////
		
		
		if(in_array($this->src, array('wp', 'g_drive', 'onedrive', 'rml'))) {
			$btn_part = '
			<input type="button" value="'. __('Add to Gallery', 'gg_ml') .'" id="gg_add_img" class="button-secondary" />
			<h4>
				'. __('Choose images', 'gg_ml') .' ';
				
				if($this->src == 'wp') {
					$btn_part .= '<span id="gg_total_img_num"></span> <span class="gg_TB gg_upload_img add-new-h2">'. __('Manage Images', 'gg_ml') .'</span>';
				}
			
			$btn_part .= '
			  <span class="dashicons dashicons-no-alt gg_clear_img_search" title="'. esc_attr__('clear search', 'gg_ml') .'"></span>
			  <input type="text" placeholder="🔎 '. __('search images', 'gg_ml') .' .." class="gg_img_search" autocomplete="off" />
			  <input type="button" class="button-secondary gg_sel_all_btn" value="'. __('Select all', 'gg_ml') .'"/> 
			</h4>';
		}
		else {
			$btn_part = '
			<input type="button" value="'. __('Add to Gallery', 'gg_ml') .'" id="gg_add_img" class="button-secondary" />
			<h4>
			  '. __('Choose images', 'gg_ml') .' <span id="gg_total_img_num"></span>
			  <input type="button" class="button-secondary gg_sel_all_btn" value="'. __('Select all', 'gg_ml') .'"/> 
			</h4>';	
		}
		

		$img_pick_vis = (isset($autopop) && $autopop) ? 'gg_displaynone' : ''; 
		$code .= '
		  <table class="widefat gg_table gg_metabox_table gg_bordernone">
		  <tr id="gg_img_picker_area" class="'.$img_pick_vis.'">
			<td class="gg_label_td" colspan="3">
			  '. $btn_part .'
			  <div id="gg_img_picker"></div>	
			</td>
		</tr>
		</table>';	

	
		$this->save_params();
		return $code.'</div>';
	}	
	
}
