<?php
// GENERIC PLUGIN STATIC METHODS
class gg_static {
    

    // WP image ID to path
    public static function img_id_to_path($img_src) {
        if(is_numeric($img_src)) {
            if(get_option('gg_use_url_for_wp_thumbs')) {
                return self::img_id_to_url($img_src);
            }
            
            $max_img_size   = get_option('gg_fetched_img_max_size', 'max');
            $wp_img_data    = wp_get_attachment_metadata((int)$img_src);
            $upload_dirs    = wp_upload_dir();
            
            if($max_img_size == 'max') {
                if(is_array($wp_img_data) && isset($wp_img_data['file'])) { 
                    $img_src = $upload_dirs['basedir'] . '/' . $wp_img_data['file'];
                }
            }
            
            else {
                $url = self::img_id_to_url($img_src);
                if($url != $img_src) {
                    $url = str_replace($upload_dirs['baseurl'], $upload_dirs['basedir'], $url);
                }
            }
        }

        return $img_src;
    }

    

    // WP image ID to url
    public static function img_id_to_url($img_src) {
        if(is_numeric($img_src)) {
            $max_img_size   = get_option('gg_fetched_img_max_size', 'max');
            $wp_img_data    = wp_get_attachment_metadata((int)$img_src);
            
            if($max_img_size == 'max') {
                if($wp_img_data && isset($wp_img_data['file'])) {
                    $upload_dirs = wp_upload_dir();
                    $img_src = $upload_dirs['baseurl'] . '/' . $wp_img_data['file'];
                }    
            }
            else {
                $size = ($max_img_size == 'big') ? 'large' : 'medium_large';
                $result = wp_get_attachment_image_url($img_src, $size);
                
                if(!$result) {
                    $result = wp_get_attachment_image_url($img_src, 'full');        
                }
                
                if($result) {
                    $img_src = $result;
                }
            }
        }

        return $img_src;
    }

    

    // thumbnail source switch between timthumb and ewpt
    public static function thumb_src($img_id, $width = false, $height = false, $quality = 80, $alignment = 'c', $resize = 1, $canvas_col = 'FFFFFF', $fx = array()) {
        if(!$img_id) {
            return false;
        }

        if(get_option('gg_use_timthumb') || isset($_REQUEST['gg_thumb_creation_debug'])) {
            $thumb_url = GG_TT_URL .'?src='. self::img_id_to_path($img_id) .'&w='. (int)$width .'&h='. (int)$height .'&a='.$alignment.'&q='.$quality.'&zc='.$resize.'&cc='.$canvas_col;
        } else {
            $thumb_url = easy_wp_thumb($img_id, $width, $height, $quality, $alignment, $resize, $canvas_col , $fx);
        }	

        return $thumb_url;
    }
    
    
    
    // thumbnail source switch between timthumb and ewpt - use the remote URL version 
    public static function inline_thumb_src($img_id, $width = false, $height = false, $quality = 80, $alignment = 'c', $resize = 1, $canvas_col = 'FFFFFF', $fx = array()) {
        if(!$img_id) {
            return false;
        }

        if(get_option('gg_use_timthumb') || isset($_REQUEST['gg_thumb_creation_debug'])) {
            $thumb_url = GG_TT_URL.'?src='. self::img_id_to_path($img_id) .'&w='. (int)$width .'&h='. (int)$height .'&a='. $alignment .'&q='. $quality .'&zc='. $resize .'&cc='. $canvas_col;
        } 
        else {
            $thumb_url = easy_wp_thumb($img_id, $width, $height, $quality, $alignment, $resize, $canvas_col , $fx, GG_EWPT_URL);
        }	

        return $thumb_url;
    }
    
    
    
    // given the gallery type - return the image path ready to be used
    public static function img_src_on_type($raw_src, $type) {
        if(get_option('gg_use_url_for_wp_thumbs')) {
            return self::img_url_on_type($raw_src, $type);
        }
        
        
        if(in_array($type, array('wp', 'wp_cat', 'wp_gall', 'cpt_tax', 'rml'))) {
            $img_full_src = self::img_id_to_path($raw_src);	
        } 
        elseif($type == 'gg_album') {
            $img_full_src = trailingslashit(get_option('gg_albums_basepath')) . $raw_src;	
        }
        elseif($type == 'ngg') {
            $img_full_src = (strpos($raw_src, WP_CONTENT_DIR) === false) ? WP_CONTENT_DIR.'/'.$raw_src : $raw_src;	
        }
        else {
            $img_full_src = $raw_src;
        }	

        return str_replace(' ', '%20', $img_full_src);
    }



    // given the gallery type - return the image url ready to be used
    public static function img_url_on_type($raw_src, $type) {

        if(in_array($type, array('wp', 'wp_cat', 'wp_gall', 'rml'))) {
            $img_url = self::img_id_to_url($raw_src);
        } 
        elseif($type == 'gg_album') {
            $img_url = trailingslashit(get_option('gg_albums_baseurl')) . $raw_src;	
        }
        elseif($type == 'ngg') {
            if(strpos($raw_src, WP_CONTENT_DIR) !== false) {$img_url = str_replace(WP_CONTENT_DIR.'/', '', $raw_src);} // fix old error in path calculation
            else {$img_url = $raw_src;}

            if(strpos($img_url, 'wp-content/') !== false) {$img_url = str_replace('wp-content/', '', $img_url);} // fix old error in path calculation
            else {$img_url = $raw_src;}

            $img_url = (strpos($img_url, WP_CONTENT_URL) === false) ? WP_CONTENT_URL.'/'.$img_url : $img_url;
        }
        else {
            $img_url = $raw_src;
        }	

        return str_replace(' ', '%20', $img_url);
    }
    
    
    
    // Given a local image path, eventually returns IPTC data as associative array (title, descr, author, tags)
    public static function maybe_get_iptc_tags($img_path) {
        
        $path_arr  = explode('/', $img_path);
        $file_name = end($path_arr);
        
        $to_return = array(
            'title'  => self::stringToFilename($file_name), 
            'descr'  => '',
            'author' => '',	
            'tags'   => '',
        );

        try {
            include_once(GG_DIR .'/classes/iptc.php');
            $iptc = new Iptc($img_path);
            
            if(get_option('gga_img_title_src') == 'iptc' && !empty($iptc->fetch('005'))) {
                $to_return['title'] = $iptc->fetch('005');    
            }
            
            if(!empty($iptc->fetch('120'))) {
                $to_return['descr'] = $iptc->fetch('120');     
            }
            
            if(!empty($iptc->fetch('080'))) {
                $to_return['author'] = $iptc->fetch('080');     
            }
            if(empty($to_return['author']) && !empty($iptc->fetch('116'))) {
                $to_return['author'] = $iptc->fetch('116');
            }
            
            //var_dump($iptc->fetch('025'));
            
            if(is_array($iptc->fetch('025')) && count($iptc->fetch('025'))) {
                $to_return['tags'] = implode(',', $iptc->fetch('025')); 
            }
        }
        catch(Exception $e) {}
        
        return $to_return;
    }
    
    
    
    
    ///////////////////////////////////////////////////////////////////////////////////////////////////
    
    
    
    
    // watermarker
    public static function watermark_image($img_src) {
        include_once(GG_DIR . '/classes/lc_wp_watermarker.php');
        @ini_set('memory_limit', '256M');


        // cached instance? use it!
        if(isset($GLOBALS['gg_wm_instance'])) {
            $lcww = $GLOBALS['gg_wm_instance'];	
        }
        else {

            // retrieve watermark image
            $wm_img = get_option('gg_watermark_img');
            if(!filter_var($wm_img, FILTER_VALIDATE_URL)) {
                die( __("Watermark image's url is wrong", 'gg_ml') );	
            }

            // setup class
            $wp_dirs = wp_upload_dir();
            $folder_name = 'gg_watermarked'; 

            $args = array(
                'cache_folder_dir' => trailingslashit($wp_dirs['basedir']) . $folder_name,
                'cache_folder_url' => trailingslashit($wp_dirs['baseurl']) . $folder_name,

                'quality' 		=> 95,
                'proportional' 	=> get_option('gg_wm_proport', false),
                'prop_sizes'	=> get_option('gg_wm_prop_val', array(15, 15)),
                'wm_pos'		=> strtolower(get_option('gg_watermark_pos', 'mm')),
                'wm_margin'		=> get_option('gg_wm_margin', 10),
                'wm_margin_type'=> get_option('gg_wm_margin_type', '%'),
                'wm_opacity'	=> get_option('gg_watermark_opacity', 1),
            );

            $lcww = new lc_wp_watermark($wm_img, $args, get_option('gg_use_url_for_wp_thumbs'));
            $GLOBALS['gg_wm_instance'] = $lcww;	
        }

        return $lcww->mark_it($img_src);
    }
    
    
    
    
    ///////////////////////////////////////////////////////////////////////////////////////////////////
    
    
    
    
    public static function getPrefixedCss($css,$prefix) {
        # Wipe all block comments
        $css = preg_replace('!/\*.*?\*/!s', '', $css);

        $parts = explode('}', $css);
        $keyframeStarted = false;
        $mediaQueryStarted = false;

        foreach($parts as &$part) {
            $part = trim($part); # Wht not trim immediately .. ?
            if(empty($part)) {
                $keyframeStarted = false;
                continue;
            }
            else { # This else is also required
                $partDetails = explode('{', $part);

                if (strpos($part, 'keyframes') !== false) {
                    $keyframeStarted = true;
                    continue;
                }

                if($keyframeStarted) {
                    continue;
                }

                if(substr_count($part, "{")==2) {
                    $mediaQuery = $partDetails[0]."{";
                    $partDetails[0] = $partDetails[1];
                    $mediaQueryStarted = true;
                }

                $subParts = explode(',', $partDetails[0]);
                foreach($subParts as &$subPart) {
                    if(trim($subPart)==="@font-face") continue;
                    else $subPart = $prefix . ' ' . trim($subPart);
                }

                if(substr_count($part,"{")==2) {
                    $part = $mediaQuery."\n".implode(', ', $subParts)."{".$partDetails[2];
                }
                elseif(empty($part[0]) && $mediaQueryStarted) {
                    $mediaQueryStarted = false;
                    $part = implode(', ', $subParts)."{".$partDetails[2]."}\n"; //finish media query
                }
                else {
                    if(isset($partDetails[1]))
                    {   # Sometimes, without this check,
                        # there is an error-notice, we don't need that..
                        $part = implode(', ', $subParts)."{".$partDetails[1];
                    }
                }

                unset($partDetails, $mediaQuery, $subParts); # Kill those three ..
            }   unset($part); # Kill this one as well
        }

        # Finish with the whole new prefixed string/file in one line
        return(preg_replace('/\s+/',' ',implode("} ", $parts)));
    }



    // handles custom CSS written in LESS and returns a CSS string
    public static function custom_css_less_parser() {
        ob_start();
        require_once(GG_DIR.'/frontend_css.php');

        $css = ob_get_clean();
        if(!trim($css)) { 
            return '';    
        }

        // Divi fix
        if(class_exists('DiviExtension')) {
            $css .= self::getPrefixedCss($css, '#et-boc .et-l');
        }

        return $css;
    }



    // create the frontend css and js
    public static function create_frontend_css() {	
        global $wp_filesystem;

        if(empty($wp_filesystem)) {
            require_once(ABSPATH .'/wp-admin/includes/file.php');
            WP_Filesystem();
        }

        $css = self::custom_css_less_parser();
        if(trim($css)) {
            if(!$wp_filesystem->put_contents(GG_DIR.'/css/custom.css', $css)) {
                $error = true;
            }
            else {
                update_option('gg_dynamic_scripts_id', md5($css));	
            }
        }
        else {
            if(file_exists(GG_DIR.'/css/custom.css'))	{
                wp_delete_file(GG_DIR.'/css/custom.css');
            }
        }

        return (isset($error)) ? false : true;
    }
     
    
    
    
    ///////////////////////////////////////////////////////////////////////////////////////////////////
    
    
    
    
    // preloader code
    public static function preloader() {
        return '
        <div class="gg_loader">
            <div class="ggl_1"></div>
            <div class="ggl_2"></div>
            <div class="ggl_3"></div>
            <div class="ggl_4"></div>
        </div>';	
    }
    
    
    
    // given images total number - returns a randomized indexes array
    public static function random_img_indexes($img_count) {
        $arr = array();
        for($a = 0; $a < $img_count; $a++) {
            $arr[] = $a;	
        }

        shuffle($arr);
        return $arr;
    }
    
    
    
    // get the current URL
    public static function curr_url() {
        $pageURL = 'http';

        if ((isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] == "on") || (function_exists('is_ssl') && is_ssl())) {$pageURL .= "s";}
        $pageURL .= "://" . $_SERVER['HTTP_HOST'].$_SERVER["REQUEST_URI"];

        return $pageURL;
    }
	


    // get file extension from a filename
    public static function stringToExt($string) {
        // remove url parameters
        if(strpos($string, '?') !== false) {
            $arr = explode('?', $string);
            $string = $arr[0];	
        }

        $pos = strrpos($string, '.');
        $ext = strtolower(substr($string,$pos));
        return $ext;	
    }



    // get filename without extension
    public static function stringToFilename($string, $raw_name = false) {
        $pos = strrpos($string, '.');
        $name = substr($string, 0, $pos);
        
        if(!$raw_name) {
            $name = ucwords(str_replace('_', ' ', $name));
        }
        return $name;	
    }



    // know if server supports cURL followlocation command
    public static function use_followlocation() {
        return (!ini_get('open_basedir') && !ini_get('safe_mode')) ? true : false; 	
    }
    
    
    
    // bytes to human readable format
    public static function human_filesize($bytes, $decimals = 2) {
        $size = array('Bytes','KB','MB','GB','TB','PB','EB','ZB','YB');
        $factor = floor((strlen($bytes) - 1) / 3);

        $val = sprintf("%.{$decimals}f", $bytes / pow(1024, $factor));

        // remove precise values
        if($decimals) {
            if(!(int)substr($val, ($decimals * -1))) {
                $arr = explode('.', $val);
                $val = $arr[0];
            }
        }

        return $val .' '. $size[$factor];
    }
    
    
    
    // retrieve term meta value considering the old WP option storing system - automatically moves data to the new storing system
    public static function retrocomp_get_term_meta($term_id, $meta_key, $old_key, $default_val = false) {
        $val = get_term_meta($term_id, $meta_key, true);
       
        if($val === false) {
            $val = get_option($old_key, $default_val);
            delete_option($old_key);
            update_term_meta($term_id, $meta_key, $val); 
        }
        
        return $val;
    }
    
    
    
    // FontAwesome v4 class retrocompatibility
    public static function fontawesome_v4_retrocomp($class) {
        if(!empty($class) && strpos($class, ' ') === false) {
            $class = 'fas '. $class;    
        }
        
        return $class;
    }
    
    
    
    // returning "selected" string if a targeted builder layout is active in cookies (cols or rows)
    public static function builder_layout_selected($target_layout) {
        $default        = 'cols';
        $cookie_name    = 'gg_builder_layout';
        $cookie_val     = (!isset($_COOKIE[$cookie_name ])) ? $default : $_COOKIE[$cookie_name ];
        
        return ($target_layout == $cookie_val) ? 'selected' : '';
    }
    
    
    
    // link field generator
    public static function link_field($src, $val = '') {
        if($src == 'page') {
            $code = '<select name="gg_item_link[]" class="gg_link_field gg_lc_select_dd" autocomplete="off">';

            foreach(get_pages() as $pag) {
                $code .= '<option value="'.$pag->ID.'" '. selected($val, $pag->ID, false) .'>'.$pag->post_title.'</option>';
            }

            return $code . '</select>';
        }
        else if($src == 'custom') {
            return '<input type="text" name="gg_item_link[]" value="'. esc_attr($val) .'" class="gg_link_field" placeholder="'. esc_attr__('insert a valid link', 'gg_ml') .'" autocomplete="off" />';
        }
        else {
            return '<input type="hidden" name="gg_item_link[]" value="" autocomplete="off" />';
        }
    }
    
    
    
    // given a field value (eg. gallery builder sidebox) sanitizes it to be empty or a number
    public static function empty_or_number_val($val) {
        return ($val === '' || $val === false) ? '' : (int)$val;       
    }
    
    
    
    // clean emoticons from instagram texts
    public static function clean_emoticons($text) {
        $clean_text = "";

        // Match Emoticons
        $regexEmoticons = '/[\x{1F600}-\x{1F64F}]/u';
        $clean_text = preg_replace($regexEmoticons, '', $text);

        // Match Miscellaneous Symbols and Pictographs
        $regexSymbols = '/[\x{1F300}-\x{1F5FF}]/u';
        $clean_text = preg_replace($regexSymbols, '', $clean_text);

        // Match Transport And Map Symbols
        $regexTransport = '/[\x{1F680}-\x{1F6FF}]/u';
        $clean_text = preg_replace($regexTransport, '', $clean_text);

        return $clean_text;
    }
    
    
    
    // hex color to RGBA
    public static function hex2rgba($hex, $alpha) {
        // if is RGB or transparent - return it
        $pattern = '/^#[a-f0-9]{6}$/i';
        if(empty($hex) || $hex == 'transparent' || !preg_match($pattern, $hex)) {
            return $hex;
        }

        $hex = str_replace("#", "", $hex);
        if(strlen($hex) == 3) {
            $r = hexdec(substr($hex,0,1).substr($hex,0,1));
            $g = hexdec(substr($hex,1,1).substr($hex,1,1));
            $b = hexdec(substr($hex,2,1).substr($hex,2,1));
        } else {
            $r = hexdec(substr($hex,0,2));
            $g = hexdec(substr($hex,2,2));
            $b = hexdec(substr($hex,4,2));
        }
        $rgb = array($r, $g, $b);
        $rgb = 'rgb('. implode(",", $rgb) .')';

        $rgba = str_replace(array('rgb', ')'), array('rgba', ', '.$alpha.')'), $rgb);
        return $rgba;	
    }
    
    
    // print loader's CSS code 
    public static function loaders_switch() {
        $color = get_option('gg_loader_color', '#888888');

        switch(get_option('gg_loader', 'default')) {

            /* media grid loader */
            case 'default':
            default:
                ?>
                .ggl_1, .ggl_2, .ggl_3, .ggl_4 {
                    background-color: <?php echo $color ?>;
                    width: 12px;
                    height: 12px;
                    position: absolute;
                    top: 0;
                    left: 0;

                    transform-origin: 	0 50%;	
                    animation: 			gg_loader 1.7s infinite ease-in-out;
                    transform: 			rotateX(90deg);	
                }
                .ggl_2 {
                    top: 0;
                    left: 14px;
                    animation-delay: .2s;
                }
                .ggl_3 {
                    top: 14px;
                    left: 14px;
                    animation-delay: .4s;
                }
                .ggl_4 {
                    top: 14px;
                    left: 0px;
                    animation-delay: .6s;
                }
                @keyframes gg_loader {
                    20%, 80%, 100% {transform: rotateX(90deg);}
                    40%, 60% {transform: rotateX(0deg);}
                }
                <?php
                break;



            /* rotating square */
            case 'rotating_square':
                ?>
                .gg_loader {
                    background-color: <?php echo $color ?>;
                    animation: gg-rotateplane 1.2s infinite ease-in-out;
                }
                .gg_grid_wrap .gg_loader {
                    width: 32px;
                    height: 32px;	
                    margin-top: -16px;
                    margin-left: -16px;
                }
                @keyframes gg-rotateplane {
                    0%	{transform: perspective(120px) rotateX(0deg) rotateY(0deg);} 
                    50%	{transform: perspective(120px) rotateX(-180.1deg) rotateY(0deg);} 
                    100%	{transform: perspective(120px) rotateX(-180deg) rotateY(-179.9deg);}
                }
                <?php
                break;



            /* overlapping circles */
            case 'overlapping_circles':
                ?>
                .gg_loader div {
                    background-color: <?php echo $color ?>;
                }
                .gg_loader {
                    width: 32px;
                    height: 32px;	
                    margin-top: -16px;
                    margin-left: -16px;
                }
                .ggl_1, .ggl_2 {
                    width: 100%;
                    height: 100%;
                    border-radius: 50%;
                    opacity: 0.6;
                    position: absolute;
                    top: 0;
                    left: 0;
                    animation: gg-bounce 1.8s infinite ease-in-out;
                }
                .ggl_2 {
                    animation-delay: -1.0s;
                }
                @keyframes gg-bounce {
                    0%, 100% {transform: scale(0.0);} 
                    50% {transform: scale(1.0);}
                }
                <?php
                break;



            /* stretching rectangles */
            case 'stretch_rect':
                ?>
                .gg_loader div {
                    background-color: <?php echo $color ?>;
                }
                .ggl_1, .ggl_2, .ggl_3 {
                    height: 100%;
                    width: 6px;
                    display: inline-block;
                    position: absolute;
                    animation: gg-stretchdelay 1.1s infinite ease-in-out;
                }
                .ggl_2 {
                    left: 10px;
                    animation-delay: -1s;
                }
                .ggl_3 {
                    right: 0;
                    animation-delay: -.9s;
                }
                @keyframes gg-stretchdelay {
                    0%, 40%, 100% {transform: scaleY(.6);}  
                    20% {transform: scaleY(1.1);}
                }
                <?php
                break;



            /* spin and fill square */
            case 'spin_n_fill_square':
                ?>
                .gg_loader {
                    border-color: <?php echo $color ?>;
                }
                .gg_loader div {
                    background-color: <?php echo $color ?>;
                }

                .gg_loader {
                    border-size: 3px;
                    border-style: solid;
                    animation: gg_spinNfill 2.3s infinite ease;
                }
                .ggl_1 {
                    vertical-align: top;
                    width: 100%;
                    animation: gg_spinNfill-inner 2.3s infinite ease-in;
                }

                @keyframes gg_spinNfill {
                    0% {transform: rotate(0deg);}
                    25%, 50%  {transform: rotate(180deg);}
                    75%, 100% {transform: rotate(360deg);}
                }
                @keyframes gg_spinNfill-inner {
                    0%, 25%, 100% {height: 0%;}
                    50%, 75% {height: 100%;}
                }
                <?php
                break;



            /* pulsing circle */
            case 'pulsing_circle':
                ?>
                .gg_loader {
                    border-radius: 100%;  
                    background-color: <?php echo $color ?>;
                    animation: gg-scaleout 1.0s infinite ease-in-out;
                }
                .gg_grid_wrap .gg_loader {
                    width: 36px;
                    height: 36px;	
                    margin-top: -18px;
                    margin-left: -18px;
                }
                @keyframes gg-scaleout {
                    0% {transform: scale(0);} 
                    100% {
                      transform: scale(1.0);
                      opacity: 0;
                    }
                }
                <?php
                break;	



            /* spinning dots */
            case 'spinning_dots':
                ?>
                .gg_loader div {
                    background-color: <?php echo $color ?>;
                }
                .gg_loader {
                  text-align: center;
                  animation: gg-rotate 1.6s infinite linear;
                }
                .gg_grid_wrap .gg_loader {
                    width: 36px;
                    height: 36px;	
                    margin-top: -18px;
                    margin-left: -18px;
                }
                .ggl_1, .ggl_2 {
                    width: 57%;
                    height: 57%;
                    display: inline-block;
                    position: absolute;
                    top: 0;
                    border-radius: 100%;
                    animation: gg-bounce 1.6s infinite ease-in-out;
                }
                .ggl_2 {
                    top: auto;
                    bottom: 0;
                    animation-delay: -.8s;
                }
                @keyframes gg-rotate { 
                    0% { transform: rotate(0deg); -webkit-transform: rotate(0deg) }
                    100% { transform: rotate(360deg); -webkit-transform: rotate(360deg) }
                }
                @keyframes gg-bounce {
                    0%, 100% {transform: scale(0.0);} 
                    50% {transform: scale(1.0);}
                }
                <?php
                break;	



            /* appearing cubes */
            case 'appearing_cubes':
                ?>
                .gg_loader div {
                    background-color: <?php echo $color ?>;
                }
                .ggl_1, .ggl_2, .ggl_3, .ggl_4 {
                    width: 50%;
                    height: 50%;
                    float: left;
                    animation: gg-cubeGridScaleDelay 1.3s infinite ease-in-out; 
                }
                .gg_grid_wrap .gg_loader {
                    width: 36px;
                    height: 36px;	
                    margin-top: -18px;
                    margin-left: -18px;
                }
                .ggl_1, .ggl_4 {
                    animation-delay: .1s; 
                }
                .ggl_2 {
                    animation-delay: .2s; 
                }
                @keyframes gg-cubeGridScaleDelay {
                    0%, 70%, 100% {
                        transform: scale3D(1, 1, 1);
                    } 
                    35% {
                        transform: scale3D(0, 0, 1);
                    } 
                }
                <?php
                break;



            /* folding cube */
            case 'folding_cube':
                ?>
                .gg_loader div:before {
                    background-color: <?php echo $color ?>;
                }
                .gg_loader {
                    transform: rotateZ(45deg);
                }
                .ggl_1, .ggl_2, .ggl_3, .ggl_4 {
                  float: left;
                  width: 50%;
                  height: 50%;
                  position: relative;
                    transform: scale(1.1); 
                }
                .gg_loader div:before {
                  content: '';
                  position: absolute;
                  top: 0;
                  left: 0;
                  width: 100%;
                  height: 100%;

                    animation: gg-foldCubeAngle 2.3s infinite linear both;
                    transform-origin: 100% 100%;
                }
                .ggl_2 {
                    transform: scale(1.1) rotateZ(90deg);
                }
                .ggl_3 {
                    transform: scale(1.1) rotateZ(270deg);
                }
                .ggl_4 {
                    transform: scale(1.1) rotateZ(180deg);
                }
                .gg_loader .ggl_2:before {
                    animation-delay: 0.3s;
                }
                .gg_loader .ggl_3:before {
                    animation-delay: 0.9s;
                }
                .gg_loader .ggl_4:before {
                    animation-delay: 0.6s; 
                }
                @keyframes gg-foldCubeAngle {
                  0%, 10% {
                    transform: perspective(140px) rotateX(-180deg);
                    opacity: 0; 
                  } 
                  25%, 75% {
                    transform: perspective(140px) rotateX(0deg);
                    opacity: 1; 
                  } 
                  90%, 100% {
                    transform: perspective(140px) rotateY(180deg);
                    opacity: 0; 
                  }
                }
                <?php
                break;



            /* old-style circles spinner */
            case 'old_style_spinner':
                ?>
                .gg_loader div:before {
                    color: <?php echo $color ?>;
                }
                .gg_loader {            	
                    font-size: 20px;
                    border-radius: 50%;

                    animation: gg-circles-spinner 1.3s infinite linear;
                    transform: scale(0.28) translateZ(0);	
                }
                @keyframes gg-circles-spinner {
                  0%,
                  100% 	{box-shadow: 0 -3em 0 0.2em, 2em -2em 0 0em, 3em 0 0 -1em, 2em 2em 0 -1em, 0 3em 0 -1em, -2em 2em 0 -1em, -3em 0 0 -1em, -2em -2em 0 0;}
                  12.5% {box-shadow: 0 -3em 0 0, 2em -2em 0 0.2em, 3em 0 0 0, 2em 2em 0 -1em, 0 3em 0 -1em, -2em 2em 0 -1em, -3em 0 0 -1em, -2em -2em 0 -1em;}
                  25% 	{box-shadow: 0 -3em 0 -0.5em, 2em -2em 0 0, 3em 0 0 0.2em, 2em 2em 0 0, 0 3em 0 -1em, -2em 2em 0 -1em, -3em 0 0 -1em, -2em -2em 0 -1em;}
                  37.5% {box-shadow: 0 -3em 0 -1em, 2em -2em 0 -1em, 3em 0em 0 0, 2em 2em 0 0.2em, 0 3em 0 0em, -2em 2em 0 -1em, -3em 0em 0 -1em, -2em -2em 0 -1em;}
                  50% 	{box-shadow: 0 -3em 0 -1em, 2em -2em 0 -1em, 3em 0 0 -1em, 2em 2em 0 0em, 0 3em 0 0.2em, -2em 2em 0 0, -3em 0em 0 -1em, -2em -2em 0 -1em;}
                  62.5% {box-shadow: 0 -3em 0 -1em, 2em -2em 0 -1em, 3em 0 0 -1em, 2em 2em 0 -1em, 0 3em 0 0, -2em 2em 0 0.2em, -3em 0 0 0, -2em -2em 0 -1em;}
                  75% 	{box-shadow: 0em -3em 0 -1em, 2em -2em 0 -1em, 3em 0em 0 -1em, 2em 2em 0 -1em, 0 3em 0 -1em, -2em 2em 0 0, -3em 0em 0 0.2em, -2em -2em 0 0;}
                  87.5% {box-shadow: 0em -3em 0 0, 2em -2em 0 -1em, 3em 0 0 -1em, 2em 2em 0 -1em, 0 3em 0 -1em, -2em 2em 0 0, -3em 0em 0 0, -2em -2em 0 0.2em;}
                }
                <?php
                break;



            /* minimal spinner */
            case 'minimal_spinner':
                ?>
                .gg_loader .ggl_1 {
                    border-color: <?php echo self::hex2rgba($color, '.25').' '.self::hex2rgba($color, '.25').' '.$color ?>;
                }
                .gg_loader {
                    width: 34px;
                    height: 34px;
                    margin-top: -17px;
                    margin-left: -17px;	
                }
                .ggl_1,
                .ggl_1:after {
                    border-radius: 50%;
                    box-sizing: border-box !important;	
                    height: 100%;
                }
                .ggl_1 {
                    background: none !important;
                    font-size: 10px;
                    border-size: 6px;
                    border-style: solid;
                    animation: gg_minimal_spinner 1.05s infinite linear;
                }
                @keyframes gg_minimal_spinner {
                    0% {transform: rotate(0deg);}
                    100% {transform: rotate(360deg);}
                }
                <?php
                break;



            /* spotify-like spinner */
            case 'spotify_like':
                ?>
                .ggl_1 {
                    background: none !important;
                    border-radius: 50%;
                    font-size: 5px;
                    height: 28%;
                    margin-left: 36%;
                    margin-top: 36%;
                    width: 28%;
                    animation: gg_spotify .9s infinite ease;
                }

                @keyframes gg_spotify {
                  0%,
                  100% {
                    box-shadow: 0em -2.6em 0em 0em <?php echo $color ?>, 1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 2.5em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.75em 1.75em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 0em 2.5em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em 1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -2.6em 0em 0 0em <?php echo self::hex2rgba($color, '.5') ?>, -1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.7') ?>;
                  }
                  12.5% {
                    box-shadow: 0em -2.6em 0em 0em <?php echo self::hex2rgba($color, '.7') ?>, 1.8em -1.8em 0 0em <?php echo $color ?>, 2.5em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.75em 1.75em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 0em 2.5em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em 1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -2.6em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.5') ?>;
                  }
                  25% {
                    box-shadow: 0em -2.6em 0em 0em <?php echo self::hex2rgba($color, '.5') ?>, 1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.7') ?>, 2.5em 0em 0 0em <?php echo $color ?>, 1.75em 1.75em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 0em 2.5em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em 1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -2.6em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>;
                  }
                  37.5% {
                    box-shadow: 0em -2.6em 0em 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.5') ?>, 2.5em 0em 0 0em <?php echo self::hex2rgba($color, '.7') ?>, 1.75em 1.75em 0 0em <?php echo $color ?>, 0em 2.5em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em 1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -2.6em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>;
                  }
                  50% {
                    box-shadow: 0em -2.6em 0em 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 2.5em 0em 0 0em <?php echo self::hex2rgba($color, '.5') ?>, 1.75em 1.75em 0 0em <?php echo self::hex2rgba($color, '.7') ?>, 0em 2.5em 0 0em <?php echo $color ?>, -1.8em 1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -2.6em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>;
                  }
                  62.5% {
                    box-shadow: 0em -2.6em 0em 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 2.5em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.75em 1.75em 0 0em <?php echo self::hex2rgba($color, '.5') ?>, 0em 2.5em 0 0em <?php echo self::hex2rgba($color, '.7') ?>, -1.8em 1.8em 0 0em <?php echo $color ?>, -2.6em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>;
                  }
                  75% {
                    box-shadow: 0em -2.6em 0em 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 2.5em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.75em 1.75em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 0em 2.5em 0 0em <?php echo self::hex2rgba($color, '.5') ?>, -1.8em 1.8em 0 0em <?php echo self::hex2rgba($color, '.7') ?>, -2.6em 0em 0 0em <?php echo $color ?>, -1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>;
                  }
                  87.5% {
                    box-shadow: 0em -2.6em 0em 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 2.5em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.75em 1.75em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 0em 2.5em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em 1.8em 0 0em <?php echo self::hex2rgba($color, '.5') ?>, -2.6em 0em 0 0em <?php echo self::hex2rgba($color, '.7') ?>, -1.8em -1.8em 0 0em <?php echo $color ?>;
                  }
                }
                <?php
                break;



            /* minimal spinner */
            case 'vortex':
                ?>
                .ggl_1 {
                    background: none !important;
                    border-radius: 50%;
                    font-size: 3px;
                    height: 70%;
                    margin-left: 15%;
                    margin-top: 15%;
                    width: 70%;
                    animation: gg_vortex .45s infinite linear;
                }

                @keyframes gg_vortex {
                  0%,
                  100% {
                    box-shadow: 0em -2.6em 0em 0em <?php echo $color ?>, 1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 2.5em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.75em 1.75em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 0em 2.5em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em 1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -2.6em 0em 0 0em <?php echo self::hex2rgba($color, '.5') ?>, -1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.7') ?>;
                  }
                  12.5% {
                    box-shadow: 0em -2.6em 0em 0em <?php echo self::hex2rgba($color, '.7') ?>, 1.8em -1.8em 0 0em <?php echo $color ?>, 2.5em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.75em 1.75em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 0em 2.5em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em 1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -2.6em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.5') ?>;
                  }
                  25% {
                    box-shadow: 0em -2.6em 0em 0em <?php echo self::hex2rgba($color, '.5') ?>, 1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.7') ?>, 2.5em 0em 0 0em <?php echo $color ?>, 1.75em 1.75em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 0em 2.5em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em 1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -2.6em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>;
                  }
                  37.5% {
                    box-shadow: 0em -2.6em 0em 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.5') ?>, 2.5em 0em 0 0em <?php echo self::hex2rgba($color, '.7') ?>, 1.75em 1.75em 0 0em <?php echo $color ?>, 0em 2.5em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em 1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -2.6em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>;
                  }
                  50% {
                    box-shadow: 0em -2.6em 0em 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 2.5em 0em 0 0em <?php echo self::hex2rgba($color, '.5') ?>, 1.75em 1.75em 0 0em <?php echo self::hex2rgba($color, '.7') ?>, 0em 2.5em 0 0em <?php echo $color ?>, -1.8em 1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -2.6em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>;
                  }
                  62.5% {
                    box-shadow: 0em -2.6em 0em 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 2.5em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.75em 1.75em 0 0em <?php echo self::hex2rgba($color, '.5') ?>, 0em 2.5em 0 0em <?php echo self::hex2rgba($color, '.7') ?>, -1.8em 1.8em 0 0em <?php echo $color ?>, -2.6em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>;
                  }
                  75% {
                    box-shadow: 0em -2.6em 0em 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 2.5em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.75em 1.75em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 0em 2.5em 0 0em <?php echo self::hex2rgba($color, '.5') ?>, -1.8em 1.8em 0 0em <?php echo self::hex2rgba($color, '.7') ?>, -2.6em 0em 0 0em <?php echo $color ?>, -1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>;
                  }
                  87.5% {
                    box-shadow: 0em -2.6em 0em 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.8em -1.8em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 2.5em 0em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 1.75em 1.75em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, 0em 2.5em 0 0em <?php echo self::hex2rgba($color, '.2') ?>, -1.8em 1.8em 0 0em <?php echo self::hex2rgba($color, '.5') ?>, -2.6em 0em 0 0em <?php echo self::hex2rgba($color, '.7') ?>, -1.8em -1.8em 0 0em <?php echo $color ?>;
                  }
                }
                <?php
                break;



            /* bubbling dots */
            case 'bubbling_dots':
                ?>
                .gg_loader div {
                    background-color: <?php echo $color ?>;
                }
                .gg_loader {
                    transform: scale(1.4);
                }
                .ggl_1, .ggl_2, .ggl_3 {
                    border-radius: 35px;
                    bottom: -8px;
                    display: inline-block;
                    height: 6px;
                    margin: 0 2px 0 0;
                    position: relative;
                    width: 6px;

                    animation: gg_bubbling ease .65s infinite alternate;
                }
                .ggl_2 {
                    animation-delay: 0.212s;
                }
                .ggl_3 {
                    margin-right: 0;
                    animation-delay: 0.425s;
                }
                @keyframes gg_bubbling {
                    0% 		{transform: scale(1) translateY(0);}
                    35%		{opacity: 1;}
                    100% 	{transform: scale(1.3) translateY(-15px); opacity: .3;}
                }
                <?php
                break;	



            /* overlapping dots */
            case 'overlapping_dots':
                ?>
                .gg_loader div:before,
                .gg_loader div:after {
                    background-color: <?php echo $color ?>;
                }
                .ggl_1 {
                    width: 100%;
                    height: 100%;
                    border-radius: 50%;
                    position: relative;
                    vertical-align: middle;
                    animation: gg_overlap_dots1 1.73s infinite linear;
                }
                .ggl_1:before,
                .ggl_1:after {
                    content:"";
                    margin: -14px 0 0 -14px;
                    width: 100%; 
                    height: 100%;
                    border-radius: 50%;
                    position: absolute;
                    top: 50%;
                    left: 50%;
                    animation: gg_overlap_dots2 1.15s infinite ease-in-out;
                }
                .ggl_1:after { 
                    animation-direction: reverse;
                }

                @keyframes gg_overlap_dots1 {
                    0% {	 transform: rotate(0deg); }
                    100% { transform: rotate(360deg); }
                }
                @keyframes gg_overlap_dots2 {
                    0%	 { transform: scale(0.2); left:	 0%; }
                    50%	{ transform: scale(1.0); left:	50%; }
                    100% { transform: scale(0.2); left: 100%; opacity: 0.5; }
                }
                <?php
                break;



            /* fading circles */
            case 'fading_circles':
                ?>
                .gg_loader div:before,
                .gg_loader div:after {
                    background-color: <?php echo $color ?>;
                }
                .ggl_1 {
                    width: 100%;
                    height: 100%;
                    border-radius: 50%;
                    position: relative;
                    vertical-align: middle;
                }
                .ggl_1:before,
                .ggl_1:after {
                    content: "";
                    width: 100%; 
                    height: 100%;
                    border-radius: 50%;
                    position: absolute;
                    top: 0;
                    left: 0;

                    transform: scale(0);
                    animation: gg_fading_circles 1.4s infinite ease-in-out;
                }
                .ggl_1:after {
                    animation-delay: 0.7s;
                }
                @keyframes gg_fading_circles {
                    0%	 { transform: translateX(-80%) scale(0); }
                    50%	{ transform: translateX(0)		scale(1); }
                    100% { transform: translateX(80%)	scale(0); }
                }
                <?php
                break;

        }
    }
}
