<?php

/////////////////////////////////////
////// PAGINATION ///////////////////
/////////////////////////////////////

function gg_pagination() {
	if(isset($_POST['gg_type']) && $_POST['gg_type'] == 'gg_pagination') {
		include_once(GG_DIR . '/classes/gg_overlay_manager.php');
		
		/* SC structure
		'gid' 			=> '',
		'overlay' 		=> 'default',

		'filter' 	 => '',
		'search_str' => '',
		'page'		 => 0,
		*/
		
		
		// default shortcode atts
		if(!isset($_POST['gid']) || !filter_var($_POST['gid'], FILTER_VALIDATE_INT)) {
			die('Gallery ID is missing');
		}
		if(!isset($_POST['gg_pag_vars'])) {
			die('Missing gallery pag vars');
		}
		if(!isset($_POST['gg_page'])) {
			die('wrong page number');
		}
		
		$sc_atts = array();
		$sc_atts['gid'] = (int)$_POST['gid'];
		$sc_atts['overlay']	= (!isset($_POST['gg_ol'])) ? 'default' : $_POST['gg_ol'];
		
		
		//// ajax-related shortcode atts
		// is applying a filter? handle matching image indexes
		$sc_atts['filter'] = (isset($_POST['gg_filtered_imgs']) && is_array($_POST['gg_filtered_imgs'])) ? implode(',', $_POST['gg_filtered_imgs']) : '';
		
		// is searching?
		$sc_atts['search_str'] = (isset($_POST['gg_search_str'])) ? $_POST['gg_search_str'] : '';
		
		// page
		$sc_atts['page'] = (is_array($_POST['gg_page'])) ? $_POST['gg_page'] : (int)$_POST['gg_page'];
		
		
		
		// wrap up atts in a final array 
		$atts = array();
		foreach($sc_atts as $key => $val) {
			$atts[] = $key .'="'. esc_attr($val) .'"';	
		}
		
		
		$sc = '[g-gallery '. implode(' ', $atts) .']'; 
        
		echo do_shortcode($sc);
		die();
	}
}
add_action('init', 'gg_pagination');




//////////////////////////////////////////////////////////////////////////////




////////////////////////////////////////////
////// LOAD GALLERY WITHIN COLLECTION //////
////////////////////////////////////////////

function gg_load_coll_gallery() {
	if(isset($_POST['gg_type']) && $_POST['gg_type'] == 'load_coll_gallery') {
		
		if(!isset($_POST['gdata'])) {
            wp_die('data is missing');
        }
		$gdata = json_decode(base64_decode($_POST['gdata']), true);
		
		$resp = '';
		if(get_option('gg_coll_show_gall_title')) {
			$resp .= '<h3 class="gg_coll_gall_title">'. get_the_title($gdata['id']) .'</h3>';
		}
		
		$resp .= '<div class="gg_coll_gall_topmargin"></div>';
		
		$resp .= do_shortcode('[g-gallery gid="'.$gdata['id'].'" random="'.$gdata['rand'].'" filters="'.$gdata['filters'].'" search="'.$gdata['search'].'" watermark="'.$gdata['wmark'].'"]');
		
        die($resp);
	}
}
add_action('init', 'gg_load_coll_gallery');

