<?php

// add the order field
add_action('gg_gall_categories_add_form_fields','gg_cat_order_field', 10, 2 );
add_action('gg_gall_categories_edit_form_fields' , "gg_cat_order_field", 10, 2);

function gg_cat_order_field($tax_data) {
    dike_lc('lcweb', 'gg', true);
    
    $icon = '';
    $order = 0;

    // check for existing taxonomy meta for term ID
    if(is_object($tax_data)) {
        $term_id = $tax_data->term_id;
        $icon = gg_static::retrocomp_get_term_meta($term_id, 'gg_cat_icon', "gg_cat_".$term_id."_icon");
        $order = (int)gg_static::retrocomp_get_term_meta($term_id, 'gg_cat_order', "gg_cat_".$term_id."_order", 0);
    }

    // creator layout
    if(!is_object($tax_data)) :
        ?>
        <div class="form-field">
            <label><?php _e('Icon', 'gg_ml') ?></label>
            <div class="gg_gall_cat_icon_trigger">
                <i class="<?php echo esc_attr(gg_static::fontawesome_v4_retrocomp($icon)) ?> gg_displayib" title="<?php esc_attr_e('set category icon', 'gg_ml') ?>"></i>
                <input type="hidden" name="gg_cat_icon" value="<?php echo esc_attr(gg_static::fontawesome_v4_retrocomp($icon)) ?>" /> 
            </div>
            <p><?php _e('Category icon, placed before category name', 'gg_ml') ?></p>
        </div>
        <div class="form-field">
            <label><?php _e('Order', 'gg_ml') ?></label>
            <input type="number" name="gg_cat_order" value="<?php echo $order ?>" min="0" step="1" /> 
            <p><?php _e('Parameter used for custom categories sorting', 'gg_ml') ?></p>
        </div>

    <?php
    else:
    ?>

        <tr class="form-field">
            <th scope="row" valign="top"><label><?php _e('Icon', 'gg_ml') ?></label></th>
            <td>
                <div class="gg_gall_cat_icon_trigger">
                    <i class="<?php echo esc_attr(gg_static::fontawesome_v4_retrocomp($icon)) ?> gg_displayib" title="<?php esc_attr_e('set category icon', 'gg_ml') ?>"></i>
                    <input type="hidden" name="gg_cat_icon" value="<?php echo esc_attr(gg_static::fontawesome_v4_retrocomp($icon)) ?>" /> 
                </div>
                <p class="description"><?php _e('Category icon, placed before category name', 'mg_ml') ?></p>
            </td>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label><?php _e('Order', 'gg_ml') ?></label></th>
            <td>
                <input type="number" name="gg_cat_order" value="<?php echo $order ?>" min="0" step="1" />
                <p class="description"><?php _e('Parameter used for custom categories sorting', 'gg_ml') ?></p>
            </td>
        </tr>
        <?php
    endif;
}





///////////////////////////////
// save fields

function save_gg_cat_metas($term_id) {
    update_term_meta($term_id, 'gg_cat_icon', $_POST['gg_cat_icon']);    
    update_term_meta($term_id, 'gg_cat_order', (int)$_POST['gg_cat_order']);    
}

add_action('created_gg_gall_categories', 'save_gg_cat_metas', 10, 2);
add_action('edited_gg_gall_categories', 'save_gg_cat_metas', 10, 2);






/////////////////////////////
// manage taxonomy table
add_filter( 'manage_edit-gg_gall_categories_columns', 'gg_cat_extra_column_headers', 10, 1);
add_filter( 'manage_gg_gall_categories_custom_column', 'gg_cat_extra_column_row', 10, 3);


// add the table column
function gg_cat_extra_column_headers($columns) {
	$prepend_cols = array();
	$append_cols = array();
	
	$prepend_cols['icon'] = __("Icon", 'gg_ml');
    $append_cols['order'] = __("Order", 'gg_ml');
	
	if(count($prepend_cols) > 0) {
		$columns = array_slice($columns, 0, 1, true) + $prepend_cols + array_slice($columns, 1, count($columns)-1, true);
	}
    return array_merge($columns, $append_cols);
}


// fill custom column row
function gg_cat_extra_column_row($row_content, $column_name, $term_id){
	if($column_name == 'icon') {
		$icon = gg_static::retrocomp_get_term_meta($term_id, 'gg_cat_icon', "gg_cat_".$term_id."_icon");
        return '<i class="'. gg_static::fontawesome_v4_retrocomp($icon) .'"></i>';	
	}
	elseif($column_name == 'order') {
		return (int)gg_static::retrocomp_get_term_meta($term_id, 'gg_cat_order', "gg_cat_".$term_id."_order", 0);
	}
	else {
        return '&nbsp;';
    }
}




/////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////
// REMOVE PARENT FIELD FOR CUSTOM TAXONOMY
// ADD ICON MANAGEMENT SYSTEM
function gg_gall_cat_js(){
	global $current_screen;
	
	// icon wizard
	if($current_screen->id == 'edit-gg_gall_categories') {
		include_once(GG_DIR .'/classes/lc_fontAwesome_helper.php');

		echo '
		<div id="gg_icons_list" class="gg_displaynone">
            '. lc_fontawesome_helper::html_list(array(
                'extra_class'   => 'gg_lb_icon_picker',
                
                'labels'        => array(
                    '🔍 '. esc_html__('Search icons ..', 'gg_ml'), 
                    esc_html__('All categories', 'gg_ml'), 
                    esc_html__('Solid', 'gg_ml'), 
                    esc_html__('Regular', 'gg_ml'), 
                    esc_html__('Brands', 'gg_ml'),
                    esc_html__('no icon', 'gg_ml'),
                    esc_html__('.. no icons found ..', 'gg_ml'),
                )
            )) .'
		</div>';
		?>
		
		<script type="text/javascript">
        (function($) { 
            "use strict"; 

            let $sel_type_opt = false;

            // launch lightbox
            $(document).on('click', '.gg_gall_cat_icon_trigger i', function() {
                $sel_type_opt = $(this);

                let sel_val = $sel_type_opt.attr('class').trim();
                if(sel_val) {
                    sel_val = '.'+ sel_val.replace(' ', '.');    
                }


                tb_show("<?php esc_html_e('Galleries Category - choose an icon', 'gg_ml') ?>", '#TB_inline?inlineId=gg_icons_list');
                setTimeout(function() {
                    $('#TB_window').addClass('gg_icon_picker_lb')
                    $('input[name="lcfah-search"]').val('');

                    // reset search
                    $('select[name="lcfah-style"] option').removeAttr('selected');
                    $('select[name="lcfah-style"]').each(function() {
                        const event = new Event('change');
                        this.dispatchEvent(event);
                    });


                    // show selected value
                    const $sel_obj = (sel_val) ? $('.gg_icon_picker_lb '+sel_val).parent() : $('.lcfah-no-icon'); 

                    $('.gg_icon_picker_lb .gg_lb_icon_selected').removeClass('gg_lb_icon_selected');
                    $sel_obj.addClass('gg_lb_icon_selected');
                }, 10);
            });

            // select icon
            $(document).on("click", ".gg_icon_picker_lb .lcfah-list li:not(.lcfah-no-results)", function() {
                const val = ($(this).hasClass('lcfah-no-icon')) ? '' : $(this).find('i').attr('class');

                $sel_type_opt.parent().find('input').val(val);
                $sel_type_opt.attr('class', val);

                tb_remove();
                $sel_type_opt = false;
            });	
        })(jQuery);    
		</script>
		<?php
	}
}
add_action('admin_footer-edit-tags.php', 'gg_gall_cat_js');
add_action('admin_footer-term.php', 'gg_gall_cat_js');

