<?php

/////////////////////////////////////////////////////
// [g-slider]
function gg_slider_shortcode( $atts, $content = null ) {
	global $wp_version;
	
	extract( shortcode_atts( array(
		'gid' => '',
		'width' => '100%',
		'height' => '55%', 
		'random' => 0,
		'watermark' => 0,
		'autoplay' => 'auto',
		'wp_gall_hash' => '' // hidden parameter for WP galleries - images list hash
	), $atts ) );

	if($gid == '') {
        return '';
    }
	
	// width and height sanitization (for cornerstone)
	if(strpos($width, '%') === false && strpos($width, 'px') === false) {
        $width .= '%';
    }
	if(strpos($height, '%') === false && strpos($height, 'px') === false) {
        $height .= '%';
    }
	
	// init
	$slider = '';
	
	$thumb_q = get_option('gg_thumb_q', 90);
	$type = (!empty($wp_gall_hash)) ? 'wp_gall' : get_post_meta($gid, 'gg_type', true);
	$timestamp = current_time('timestamp');
	$unique_id = uniqid();
	$style = get_option('gg_slider_style', 'light');
	$thumbs = get_option('gg_slider_thumbs', 'yes');
	
	// slider thumbs visibility
	$thumbs_class = ($thumbs == 'yes' || $thumbs == 'always') ? 'gg_galleria_slider_show_thumbs' : '';	

	// no border class
	$borders_class = (get_option('gg_slider_no_border')) ? 'gg_slider_no_borders' : '';

	// slider proportions parameter
	if(strpos($height, '%') !== false) {
		$val = (int)str_replace("%", "", $height) / 100;
		$proportions_param = 'data-asp-ratio="'.$val.'"';
		$proportions_class = "gg_galleria_responsive";
		$slider_h = '';
	} 
    else {
		$proportions_param = '';	
		$proportions_class = "";
		$slider_h = 'height: '.$height.';';
	}

	//// prepare images
	// get them
	$images = gg_gall_static::frontend_img_prepare($gid, $type, $wp_gall_hash);
	if(!is_array($images) || !count($images)) {
        return '';
    }

	// randomize images 
	$randomized_order = ((int)$random) ? gg_static::random_img_indexes(count($images)) : false;

	// images array to be used (eventually watermarked) 
	$images = gg_gall_static::frontend_img_split($gid, $images, 'all', $randomized_order, $watermark);	
	if(!is_array($images) || !count($images)) {
        return '';
    }
	
	// build
	$slider .= '
    <div id="'.$unique_id.'" rel="'.$gid.'" data-gg-autoplay="'.$autoplay.'" 
		class="gg_galleria_slider_wrap gg_galleria_slider_'.$style.' '.$thumbs_class.' '.$borders_class.' '.$proportions_class.' ggs_'.$gid.'" 
		style="width: '.$width.'; '.$slider_h.'" '.$proportions_param.'
	>';
	  
	  foreach($images as $img) {

		// dunno why, but wp gall managed src must be managed // TODO
		if($wp_gall_hash) {
		  $img['url'] = gg_static::img_id_to_url($img['url']);  
		}
		

		$thumb = gg_static::thumb_src($img['path'], (int)get_option('gg_slider_thumb_w', 60), (int)get_option('gg_slider_thumb_h', 40), $thumb_q, $img['thumb']);
		$slider .= '
		<a href="'. gg_gall_static::gdrive_img_url_trick($img['url']) .'">
			<img src="'. esc_attr($thumb) .'" data-big="'. esc_attr($img['url']) .'" data-description="'. esc_attr($img['descr']) .'" alt="'. esc_attr($img['title']) .'" />
		</a>';
	}

	$slider .= '
        <div style="clear: both;"></div>
	</div>'; // slider wrap closing
	
    
	// slider init
	$slider .= '
    <script type="text/javascript"> 
	(function() { 
        "use strict"; 
        
        const intval = setInterval(() => {
            if(typeof(jQuery) == "undefined" || typeof(gg_galleria_init) == "undefined") {
                return true;
            }
            else {
                clearTimeout(intval);
            
                gg_galleria_show("#'.$unique_id.'");
                gg_galleria_init("#'.$unique_id.'");
            }
        }, 50);
    })();   
	</script>';

	return str_replace(array("\r", "\n", "\t", "\v"), '', $slider);
}
add_shortcode('g-slider', 'gg_slider_shortcode');

