<?php
// GENERIC ADD-ON STATIC METHODS
class mgom_static {
    
    
    // return overlays list - array(id => name)
    public static function ol_list() {

        // get all terms 
        $ols = get_terms('mgom_overlays', array(
            'hide_empty'    => 0,
            'orderby'       => 'name',
            'order'         => 'ASC'     
        ));

        // clean terms array
        $clean_ols = array();

        foreach($ols as $ol) {
            $clean_ols[$ol->term_id] = esc_html($ol->name);
        }

        return $clean_ols;
    }
    
    
    
    // graphical overlay types
    public static function graphic_types($type = false) {
        $opts = array(
            'full_img_layer' 	=> esc_html__('Full image layer', MGOM_ML),
            'vert_split_layer' 	=> esc_html__('Vertical split layers', MGOM_ML),
            'horiz_split_layer' => esc_html__('Horizontal split layers', MGOM_ML),
            'crossing_layer' 	=> esc_html__('Crossing layer', MGOM_ML),
            'corner_slice' 		=> esc_html__('Corner slice', MGOM_ML),

            'single_border' 	=> esc_html__('Single-side border', MGOM_ML),
            'outlined_box' 		=> esc_html__('Outlined box', MGOM_ML),

            'central_shape' 	=> esc_html__('Central shape', MGOM_ML),
            'corner_shape' 		=> esc_html__('Corner shape', MGOM_ML),
            'icon' 				=> esc_html__('Standalone icon', MGOM_ML),
            'img_ol' 			=> esc_html__('Image layer', MGOM_ML),
        );	

        if($type) {
            return (isset($opts[$type])) ? $opts[$type] : false;	
        } else {
            return $opts;	
        }
    }
    
    

    // textual overlay types
    public static function txt_types($type = false) {
        $opts = array(
            'txt_block' 	=> __("Text block <small>(not for text under images)</small>", MGOM_ML),
            'title' 		=> esc_html__("Item's title", MGOM_ML),
            'descr' 		=> esc_html__("Item's excerpt", MGOM_ML),
            'separator' 	=> esc_html__("Separator", MGOM_ML),
            'button' 		=> esc_html__("Button", MGOM_ML),
            'socials' 		=> esc_html__("Social buttons", MGOM_ML),
            'custom_txt' 	=> esc_html__("Custom content", MGOM_ML)
        );	

        if($type) {
            return (isset($opts[$type])) ? $opts[$type] : false;	
        } else {
            return $opts;	
        }
    }

    
    
    // overlay types
    public static function ol_types($type = false) {
        $opts = array_merge(self::txt_types(), self::graphic_types());  

        if($type !== false) {
            return (isset($opts[$type])) ? $opts[$type] : false;    
        }
        else {
            return $opts;   
        }
    }



    // fields for each type
    public static function type_fields($type) {
        $opts = array(
            // TODO - create a new background field allowing gradients
            
            'full_img_layer' 	=> array('position', 'bg_color', 'bg_color_h', 'full_img_padding', 'full_img_padding_h', 'transitions', 'animation_time', 'easing', 'animation_delay'),
            'vert_split_layer' 	=> array('bg_color', 'bg_color_h', 'animation_time', 'easing', 'animation_delay'),
            'horiz_split_layer' => array('bg_color', 'bg_color_h', 'animation_time', 'easing', 'animation_delay'),
            'crossing_layer'	=> array('cross_pos', 'bg_color', 'bg_color_h', 'over_txt_block', 'animation_time', 'easing', 'animation_delay'),
            'corner_slice'		=> array('slice_pos', 'bg_color', 'bg_color_h', 'over_txt_block', 'animation_time', 'easing', 'animation_delay'),

            'single_border' 	=> array('singl_border_side', 'singl_border_show', 'border_width', 'border_color', 'border_color_h', 'over_txt_block', 'animation_time', 'easing', 'animation_delay'),
            'outlined_box' 		=> array('position', 'border_width', 'border_width_h', 'border_color', 'border_color_h', 'full_img_padding', 'full_img_padding_h', 'over_txt_block', 'transitions', 'animation_time', 'easing', 'animation_delay'),

            'central_shape' => array('cent_ol_shape', 'position','bg_color', 'bg_color_h', 'opacity', 'opacity_h', 'inner_icon', 'color', 'over_txt_block', 'transitions', 'animation_time', 'easing', 'animation_delay'),
            'corner_shape' 	=> array('corn_ol_shape', 'corner_pos', 'bg_color', 'inner_icon', 'color', 'over_txt_block', 'animation_time', 'easing', 'animation_delay'),
            'icon' 			=> array('icon_type', 'icon_position', 'font_size', 'font_size_h', 'color', 'color_h', 'over_txt_block', 'transitions', 'animation_time', 'easing', 'animation_delay'),

            'img_ol' 		=> array('img_ol_src', 'img_ol_bg_size', 'img_ol_pos', 'full_img_padding', 'position', 'opacity', 'opacity_h', 'over_txt_block', 'transitions', 'animation_time', 'easing', 'animation_delay'),

            'title' 		=> array('txt_align', 'font_size', 'line_height', 'color', 'color_h', 'highlight', 'highlight_h', 'txt_shadow', 'txt_shadow_h', 'txt_styles', 'txt_vert_margin', 'font_family', 'animation_delay'),
            'descr' 		=> array('txt_align', 'font_size', 'line_height', 'color', 'color_h', 'highlight', 'highlight_h', 'txt_shadow', 'txt_shadow_h', 'txt_styles', 'txt_max_h', 'txt_vert_margin', 'font_family', 'animation_delay'),
            'separator' 	=> array('color', 'thickness', 'sep_style', 'txt_vert_margin', 'animation_delay'),
            'button' 		=> array('btn_txt', 'btn_behavior', 'font_size', 'line_height', 'btn_full_width', 'btn_align', 'txt_styles', 'font_family', 'txt_padding', 'border_width', 'border_style', 'border_color', 'border_color_h', 'border_radius', 'bg_color', 'bg_color_h', 'color', 'color_h', 'txt_vert_margin', 'animation_delay'),
            'socials' 		=> array('socials_style', 'socials_align', 'color', 'color_h', 'highlight', 'highlight_h', 'font_size', 'txt_vert_margin', 'animation_delay'),
            'custom_txt' 	=> array('cust_txt', 'txt_align', 'font_size', 'line_height', 'color', 'color_h', 'highlight', 'highlight_h', 'txt_shadow', 'txt_shadow_h', 'opacity', 'opacity_h', 'txt_styles', 'txt_vert_margin', 'font_family', 'animation_delay'),
            'txt_block'		=> array('position', 'txt_behaviors', 'txt_visibility', 'hide_txt_on_mobile', 'txt_vert_center', 'bg_color', 'bg_color_h', 'txt_padding', 'transitions', 'animation_time', 'easing'),
            
            'img_fx' 		=> array('img_zoom', 'img_no_borders', 'img_h_fx', 'img_fx_behav', 'blur_fx', 'brightness_fx', 'contrast_fx', 'grayscale_fx', 'hue_fx', 'invert_fx', 'saturate_fx', 'sepia_fx', 'animation_time', 'easing', 'animation_delay'),
            
            'custom_css' 	=> array('custom_css'),
        );	

        return $opts[$type];	
    }



    // type block builder
    public static function type_block($type, $values = false) {
        $name = self::ol_types($type);
        if(!in_array($type, array('img_fx', 'custom_css')) && !$name) {
            return '';
        }

        $fields = self::type_fields($type);
        $commands = (in_array($type, array('txt_block', 'img_fx', 'custom_css'))) ? '' : '<span class="mg_move_row dashicons dashicons-move"></span><span class="mg_del_row dashicons dashicons-no-alt"></span>';

        $code = '
        <div class="mgom_type_block tb_'. esc_attr($type) .'" data-type="'. esc_attr($type) .'">
        <h4>
            '. $name;  
            
            if(!in_array($type, array('img_fx', 'custom_css'))) {
                $code .= '   
                <div class="mgom_css_selector"> | '. __('CSS selector', MGOM_ML) .' <span></span></div>
                <div class="mgom_cmd">
                    <small class="mgom_ec">(<em class="collapse">'. __('collapse', MGOM_ML) .'</em><em class="expand mg_displaynone">'. __('expand', MGOM_ML) .'</em>)</small>
                    '.$commands.'
                </div>';
            }
                     
        $code .= '             
        </h4>';

        foreach($fields as $field) {
            $val = (isset($values[$field])) ? $values[$field] : ''; 
            $code .= mgom_fields_builder($field, $val, $values);
        }

        return $code . '<div class="mgom_btm_border_fix"></div></div>';
    }


    
    // overlay saved data to blocks
    public static function saved_to_blocks($layers) {
        if(!is_array($layers)) {
            return '';
        }
        if(isset($layers['txt_block'])) {
            unset($layers['txt_block']);
        }

        $code = '';
        foreach($layers as $type => $values) {
            if(!in_array($type, array('txt_block', 'img_fx'))) {
                $code .= self::type_block($type, $values);
            }
        }

        return $code;
    }

    

    // JS ajax array to PHP proper array
    public static function js_ajax_sanitize($data) {

        // base
        $init_arr = array(
            "graphic"       => $data->graphic,
            "txt"           => $data->txt,
            "img_fx"        => (property_exists($data, 'img_fx')) ? $data->img_fx : array(),
            "custom_css"    => (property_exists($data, 'custom_css')) ? $data->custom_css : '',
        );

        $final_arr = array(
            "graphic"       => array(),
            "txt"           => array(),
            "img_fx"        => array(),
            "custom_css"    => '',
        );

        foreach($init_arr as $subj => $values) {
            if(!in_array($subj, array('img_fx', 'custom_css'))) {
            
                foreach($values as $type => $vals) {
                    foreach($vals as $val) {

                        if(strpos($val->name, '[]') === false) {
                            $index = $val->name;
                            $val = esc_attr($val->value);
                        }
                        else {
                            $index = str_replace('[]', '', $val->name);
                            $val = array( esc_textarea($val->value) );
                        }

                        if(isset($final_arr[$subj][$type][$index])) {
                            $final_arr[$subj][$type][$index][] = $val[0];
                        } else {
                            $final_arr[$subj][$type][$index] = $val;	
                        }
                    }
                }
            }
            
            elseif($subj == 'img_fx') {
                $vals = $values;
                
                foreach($vals as $val) {

                    if(strpos($val->name, '[]') === false) {
                        $index = $val->name;
                        $val = esc_attr($val->value);
                    }
                    else {
                        $index = str_replace('[]', '', $val->name);
                        $val = array( esc_textarea($val->value) );
                    }

                    if(isset($final_arr[$subj][$index])) {
                        $final_arr[$subj][$index][] = $val[0];
                    } else {
                        $final_arr[$subj][$index] = $val;	
                    }
                }        
            }
            
            elseif($subj == 'custom_css') {
                $final_arr[$subj] = esc_textarea($values); 
            }
        }


        return $final_arr;	
    }

    

    // recalculate serialized elements length - fix for DB get issues 
    public static function fix_serialization($string) {
        return str_replace('&amp;', '&', $string);	
    }


    
    // handles custom CSS written in LESS and returns a CSS string
    public static function custom_css_less_parser() {
        ob_start();
        require_once(MGOM_DIR .'/frontend_css.php');

        $css = ob_get_clean();
        if(!trim($css)) { 
            return '';    
        }

        // Divi fix
        if(class_exists('ET_Builder_Module')) {
            $css .= mg_static::getPrefixedCss($css, '#et-boc .et-l');
        }

        return $css;
    }
}
