<?php
///////////////////////////////////////////
// DYNAMICALLY CREATE THE OVERLAYS CSS ////
///////////////////////////////////////////


// is live preview?
if(isset($GLOBALS['mgom_preview_data'])) {
    $preview = new stdClass;
    $preview->term_id       = (int)$_GET['ol_id'];
    $preview->name          = 'LIVE-PREVIEW';
    $preview->description   = serialize($GLOBALS['mgom_preview_data']);
    
    $ols = array($preview);
}
else {    
    $ols = get_terms('mgom_overlays', 'hide_empty=0&orderby=id'); // get overlays
}


foreach($ols as $ol) :

	// layers counter
	$lc = 0;
	
?>
/* ***** <?php echo $ol->term_id ?> - <?php echo $ol->name ?> OVERLAY ***** */ 
  <?php  
  // get layers
  $layers = unserialize($ol->description);

  if(is_array($layers) && isset($layers['graphic'])) {
	
    ##########################################
    ###### GRAPHICALS ########################
    ##########################################
    foreach($layers['graphic'] as $lname => $layer) {

        // layer over text block 
        $over_txt = (isset($layer['over_txt_block']) && $layer['over_txt_block']) ? true : false; 

        // standard
        echo '
        .mgom_'.$ol->term_id.'_'.$lc.' { /* '.$lname.' */
            ';

            foreach ($layer as $opt => $val) {
                // outlined box - ignore everything but position, opacity and animations
                if($lname == 'outlined_box' && !in_array($opt, array('position', 'full_img_padding', 'opacity', 'transitions', 'animation_time', 'easing', 'animation_delay'))) {
                    continue;
                }

                echo mgom_opt_to_css($opt, $val, $layer);
            }

            $z_index = 900 - (10 * ($lc + 1));
            if($over_txt) {
                $z_index = $z_index + 200;
            }

            echo '
            z-index: '.$z_index.'; 
        }';

        // hover
        echo '
        body:not(.mg_cust_touch_ol_behav) .mg_box:hover .mgom_'.$ol->term_id.'_'.$lc.',
        .mg_box.mg_ctob_show .mgom_'.$ol->term_id.'_'.$lc.' {
            ';

            foreach ($layer as $opt => $val) {
                // outlined box - ignore everything but position, opacity and animations
                if($lname == 'outlined_box' && !in_array($opt, array('position', 'full_img_padding_h', 'opacity_h', 'transitions')))  {
                    continue;
                }

                echo mgom_opt_to_css($opt, $val, $layer, true);
            }

        echo '
        }
        ';


        /*******************************************************************/


        // special rule for split overlays
        if($lname == 'vert_split_layer' || $lname == 'horiz_split_layer') {
            // standard
            echo '
            .mgom_'.$ol->term_id.'_'.$lc.' div {
                    ';

            foreach ($layer as $opt => $val) {
                if($opt != 'opacity') {
                    echo mgom_opt_to_css($opt, $val, $layer);
                }
            }
                echo '
            }';

            // hover
            echo '
            body:not(.mg_cust_touch_ol_behav) .mg_box:hover .mgom_'.$ol->term_id.'_'.$lc.' div,
            .mg_box.mg_ctob_show .mgom_'.$ol->term_id.'_'.$lc.' div {
                    ';

            foreach ($layer as $opt => $val) {
                if($opt != 'opacity_h') {
                    echo mgom_opt_to_css($opt, $val, $layer, true);
                }
            }

            echo '
            }
            ';	
        }


        // special rule for shapes
        if($lname == 'central_shape') {
            $bg_color = isset($layer['bg_color']) ? $layer['bg_color'] : '#fefefe'; 
            $bg_color_h = isset($layer['bg_color_h']) ? $layer['bg_color_h'] : false; 

            echo '
            .mgom_'.$ol->term_id.'_'.$lc.' div, .mgom_'.$ol->term_id.'_'.$lc.' div:before, .mgom_'.$ol->term_id.'_'.$lc.' div:after {
                background-color: '.$bg_color.';	
                border-color: '.$bg_color.'; 
            }';

            if($bg_color_h) {
            echo '
            body:not(.mg_cust_touch_ol_behav) .mg_box:hover .mgom_'.$ol->term_id.'_'.$lc.' div, 
            body:not(.mg_cust_touch_ol_behav) .mg_box:hover .mgom_'.$ol->term_id.'_'.$lc.' div:before, 
            body:not(.mg_cust_touch_ol_behav) .mg_box:hover .mgom_'.$ol->term_id.'_'.$lc.' div:after,

            .mg_box.mg_ctob_show .mgom_'.$ol->term_id.'_'.$lc.' div, 
            .mg_box.mg_ctob_show .mgom_'.$ol->term_id.'_'.$lc.' div:before, 
            .mg_box.mg_ctob_show .mgom_'.$ol->term_id.'_'.$lc.' div:after {
                background-color: '.$bg_color_h.';	
                border-color: '.$bg_color_h.';	
            }
            ';
            }
        }


        // special rule for single-side border (border-width on hover)
        if($lname == 'single_border') {
            echo '
            body:not(.mg_cust_touch_ol_behav) .mg_box:hover .mgom_'.$ol->term_id.'_'.$lc.',
            .mg_box.mg_ctob_show .mgom_'.$ol->term_id.'_'.$lc.' {
                border-width: '. (int)$layer['border_width'] .'px; 
            }
            ';
        }


        // special rule for outlined box
        if($lname == 'outlined_box') {
            echo '
            .mgom_'.$ol->term_id.'_'.$lc.':before {
                ';

                foreach($layer as $opt => $val){
                    if(in_array($opt, array('position', 'full_img_padding', 'border_width', 'opacity', 'transitions'))) {
                        continue;
                    }	
                    echo mgom_opt_to_css($opt, $val, $layer);
                }

                echo '
                top: '. (int)$layer['full_img_padding'] .'px; 
                right: '. (int)$layer['full_img_padding'] .'px;
                bottom: '. (int)$layer['full_img_padding'] .'px;
                left: '. (int)$layer['full_img_padding'] .'px;
                box-shadow: 0 0 0 '.(int)$layer['border_width'].'px '.$layer['border_color'].';
            }
            body:not(.mg_cust_touch_ol_behav) .mg_box:hover .mgom_'.$ol->term_id.'_'.$lc.':before,
            .mg_box.mg_ctob_show .mgom_'.$ol->term_id.'_'.$lc.':before {
                ';

                foreach($layer as $opt => $val){
                    if(in_array($opt, array('position', 'full_img_padding_h', 'border_width_h', 'opacity_h', 'transitions'))) {
                        continue;
                    }	
                    echo mgom_opt_to_css($opt, $val, $layer, true);
                }

            echo '
                top: '. (int)$layer['full_img_padding_h'] .'px; 
                right: '. (int)$layer['full_img_padding_h'] .'px;
                bottom: '. (int)$layer['full_img_padding_h'] .'px;
                left: '. (int)$layer['full_img_padding_h'] .'px;
                box-shadow: 0 0 0 '.(int)$layer['border_width_h'].'px '.$layer['border_color_h'].';
            }
            ';
        }


        $lc++;	
    }

	
	
	##########################################
	###### TEXTUALS ##########################
	##########################################
	foreach($layers['txt'] as $lname => $layer) {
		
		// standard
		echo '
		.mgom_'.$ol->term_id.'_'.$lc.' { /* '.$lname.' */
			';
				
			foreach ($layer as $opt => $val) {
				if(in_array($opt, array('highlight', 'easing', 'transitions'))) {continue;} // highlight animations and transitions will be applied globally later
				echo mgom_opt_to_css($opt, $val, $layer, false, $lname);
			}
		echo '
		}';
		
		// hover
		echo '
		body:not(.mg_cust_touch_ol_behav) .mg_box:hover .mgom_'.$ol->term_id.'_'.$lc.',
        .mg_box.mg_ctob_show .mgom_'.$ol->term_id.'_'.$lc.' {
			';
		
			foreach ($layer as $opt => $val) {
				if(in_array($opt, array('highlight_h', 'easing', 'transitions'))) {continue;} // highlight animations and transitions will be applied globally later
				echo mgom_opt_to_css($opt, $val, $layer, true, $lname);
			}
		echo '
		}
		';
		
		// special rules for text highlight
		if(in_array($lname, array('title', 'descr', 'custom_txt', 'socials'))) {
			if(isset($layer['highlight']) && !empty($layer['highlight'])) {
				echo '
				.mgom_'.$ol->term_id.'_'.$lc.' .mgom_mark {
					'. mgom_opt_to_css('highlight', $layer['highlight'], $layer) .'
					'. mgom_opt_to_css('color', $layer['color'], $layer) .'
				}';
			}
			if(isset($layer['highlight_h']) && !empty($layer['highlight_h'])) {
				echo '
				body:not(.mg_cust_touch_ol_behav) .mg_box:hover .mgom_'.$ol->term_id.'_'.$lc.' .mgom_mark,
                .mg_box.mg_ctob_show .mgom_'.$ol->term_id.'_'.$lc.' .mgom_mark {
					'. mgom_opt_to_css('highlight_h', $layer['highlight_h'], $layer, true) .'
					'. mgom_opt_to_css('color_h', $layer['color'], $layer, true) .'
				}';	
			}
		}
		
		
		// special rules for socials block
		if($lname == 'socials') {
			echo '
			.mgom_'.$ol->term_id.'_'.$lc.' span {
				'. mgom_opt_to_css('font_size', $layer['font_size'], $layer) .'
                width: '. str_replace(array('font-size', ':'), '', mgom_opt_to_css('font_size', $layer['font_size'], $layer)) .'
                height: '. str_replace(array('font-size', ':'), '', mgom_opt_to_css('font_size', $layer['font_size'], $layer)) .'
			}
			.mg_box .mgom_'.$ol->term_id.'_'.$lc.' span {
				'. mgom_opt_to_css('color', $layer['color'], $layer) .'
			}
            .mg_box .mgom_'.$ol->term_id.'_'.$lc.' span.mg-twitter-icon:before {
                '. mgom_opt_to_css('bg_color', $layer['color'], $layer) .'    
            }
			body:not(.mg_cust_touch_ol_behav) .mg_box:hover .mgom_'.$ol->term_id.'_'.$lc.' span:hover,
			.mg_box.mg_ctob_show .mgom_'.$ol->term_id.'_'.$lc.' span {
				'. mgom_opt_to_css('color_h', $layer['color_h'], $layer, true) .'
			}
            body:not(.mg_cust_touch_ol_behav) .mg_box:hover .mgom_'.$ol->term_id.'_'.$lc.' span.mg-twitter-icon:hover:before,
            .mg_box:not(.mg_touch_off):hover .mgom_'.$ol->term_id.'_'.$lc.' span.mg-twitter-icon:hover:before,
			.mg_box.mg_ctob_show .mgom_'.$ol->term_id.'_'.$lc.' span.mg-twitter-icon:hover:before {
				'. mgom_opt_to_css('bg_color_h', $layer['color_h'], $layer, true) .'
			}
            .mgom_'.$ol->term_id.'_'.$lc.' .mg_round_social_trick {
                box-shadow: 0 0 0 3px '. $layer['color'] .' inset;
            }
            .mgom_'.$ol->term_id.'_'.$lc.' .mg_round_social_trick:hover {
                box-shadow: 0 0 0 3px '. $layer['color_h'] .' inset;
            }';
		}
		
		
		// special rules for custom text block
		if($lname == 'custom_txt') {
		
			// standard
			echo '
			.mgom_'.$ol->term_id.'_'.$lc.' * {
					';
			
			foreach ($layer as $opt => $val) {
				echo mgom_opt_to_css($opt, $val, $layer);
			}
			
			echo '
			}';
			
			// hover
			echo '
			body:not(.mg_cust_touch_ol_behav) .mg_box:hover .mgom_'.$ol->term_id.'_'.$lc.' *,
            .mg_box.mg_ctob_show .mgom_'.$ol->term_id.'_'.$lc.' * {
					';
			
			foreach ($layer as $opt => $val) {
				echo mgom_opt_to_css($opt, $val, $layer, true);
			}
			
			echo '
			}
			';	
		}
		
		$lc++;	
	}

	
	//// specific rules for overlay text wrapper and global text ones
	$layer = $layers['txt']['txt_block'];
	if(!isset($layer['transitions'])) {
        $layer['transitions'] = '';
    }

	// animations and transitions 
	echo '
    .mg_box .mgom_'.$ol->term_id.'_'.$lc.'.mgom_txt_wrap {
        '. mgom_opt_to_css('easing', $layer['easing'], $layer) .'	    
    }
	.mg_box .mgom_'.$ol->term_id.'_'.$lc.'.mgom_txt_wrap .mgom_layer,
    .mg_box .mgom_'.$ol->term_id.'_'.$lc.'.mgom_txt_wrap .mg-twitter-icon:before {
		'. mgom_opt_to_css('easing', $layer['easing'], $layer) .'	
		'. mgom_opt_to_css('transitions', $layer['transitions'], $layer) .'
	}
	body:not(.mg_cust_touch_ol_behav) .mg_box:hover .mgom_'.$ol->term_id.'_'.$lc.'.mgom_txt_wrap .mgom_layer,
    .mg_box.mg_ctob_show .mgom_'.$ol->term_id.'_'.$lc.'.mgom_txt_wrap .mgom_layer,
    
    body:not(.mg_cust_touch_ol_behav) .mg_box:hover .mgom_'.$ol->term_id.'_'.$lc.'.mgom_txt_wrap .mg-twitter-icon:before,
    .mg_box.mg_ctob_show .mgom_'.$ol->term_id.'_'.$lc.'.mgom_txt_wrap .mg-twitter-icon:before {
		'. mgom_opt_to_css('transitions', $layer['transitions'], $layer, true) .'
	}
	.mg_box .mgom_'.$ol->term_id.'_'.$lc.' .mgom_mark,
	.mgom_'.$ol->term_id.' .mg_title_under .mgom_layer,
	.mgom_'.$ol->term_id.' .mg_title_under .mgom_layer * {
		'. mgom_opt_to_css('easing', $layer['easing'], $layer) .'	
	}
	';
      
      
	// text layers visibility
	if(isset($layer['txt_visibility']) && ($layer['txt_visibility'] == 'hide' || $layer['txt_visibility'] == 'hide_h')) {
		echo'
			.mg_box .mgom_'.$ol->term_id.'_'.$lc.'.mgom_txt_wrap {
				'. mgom_opt_to_css('easing', $layer['easing'], $layer) .'	
			}
			';	
		
		if($layer['txt_visibility'] == 'hide') {
			echo'
			.mg_box .mgom_'.$ol->term_id.'_'.$lc.'.mgom_txt_wrap .mgom_layer {
				opacity: 0;
			}
			body:not(.mg_cust_touch_ol_behav) .mg_box:hover .mgom_'.$ol->term_id.'_'.$lc.'.mgom_txt_wrap .mgom_layer,
            .mg_box.mg_ctob_show .mgom_'.$ol->term_id.'_'.$lc.'.mgom_txt_wrap .mgom_layer {
				opacity: 1;
			}
			'; 	
		}
		else if($layer['txt_visibility'] == 'hide_h') {
			echo'
			body:not(.mg_cust_touch_ol_behav) .mg_box:hover .mgom_'.$ol->term_id.'_'.$lc.'.mgom_txt_wrap .mgom_layer,
            .mg_box.mg_ctob_show .mgom_'.$ol->term_id.'_'.$lc.'.mgom_txt_wrap .mgom_layer {
				opacity: 0;
			}
			'; 	
		}
    }
        
      
    // hide texts on mobile? (not for preview)
    if(isset($layer['hide_txt_on_mobile']) && $layer['hide_txt_on_mobile'] && !isset($GLOBALS['mgom_preview_data'])) {
        echo '
        .mg_mobile_mode .mg_box .mgom_'.$ol->term_id.'_'.$lc.'.mgom_txt_wrap {   
            display: none !important;    
        }';
    }
      
      
        
    // text wrapper - padding and positioning
    if(!isset($layer['txt_vert_center'])) {
        $layer['txt_vert_center'] = false;    
    }
      
	echo '
	.mgom_'.$ol->term_id.'_'.$lc.'.mgom_txt_wrap {
		'. mgom_opt_to_css('position', $layer['position'], $layer) .'	
		'. mgom_opt_to_css('easing', $layer['easing'], $layer) .'
		'. mgom_opt_to_css('txt_padding', $layer['txt_padding'], $layer) .'
        '. mgom_opt_to_css('txt_vert_center', $layer['txt_vert_center'], $layer) .' 
	}
	body:not(.mg_cust_touch_ol_behav) .mg_box:hover .mgom_'.$ol->term_id.'_'.$lc.'.mgom_txt_wrap,
    .mg_box.mg_ctob_show .mgom_'.$ol->term_id.'_'.$lc.'.mgom_txt_wrap {
		'. mgom_opt_to_css('position', $layer['position'], $layer, true) .'	
	}
	';  
      
      
      
    // special text wrap rule for special showing behaviors
    if($layer['position'] == 'bottom' && 
        (
            in_array($layer['txt_behaviors'], array('show_title', 'show_title_fh')) && isset($layers['txt']['title']) ||
            $layer['txt_behaviors'] == 'hide_all'
        )
    ) {
        echo '
        .mgom_'.$ol->term_id .' .mgom_txt_wrap {
            justify-content: flex-start;
        }';    
    }
      
    
    // show title + use contents height on hover - CSS fixing flexbox positioning
    if(
        is_array($layer['txt_padding']) && count($layer['txt_padding']) >= 3 && $layer['txt_padding'][2] &&
        $layer['position'] == 'bottom' && in_array($layer['txt_behaviors'], array('show_title', 'show_title_fh')) && isset($layers['txt']['title'])
    ) {
        echo '
        .mgom_'.$ol->term_id .' .mgom_title {
            padding-bottom: '. $layer['txt_padding'][2] .'px;
        }
        body:not(.mg_cust_touch_ol_behav) .mgom_'.$ol->term_id .' .mg_box:hover .mgom_title,
        .mgom_'.$ol->term_id .' .mg_box.mg_ctob_show .mgom_title {
            padding-bottom: 0;
        }';
    }
      
      
      
      
    ##########################################
    ###### IMG EFFECTS #######################
    ##########################################

    if(isset($layers['img_fx'])) {
        $layer = $layers['img_fx'];

        // easing
        if(!isset($layer['easing'])) {
            $layer['easing'] = 'ease';
        }
        echo '
        .mgom_'.$ol->term_id.' .mg_box:not(.mg_item_no_ol):not(.mg_to_kenburn) .mgi_thumb {
            backface-visibility: hidden;
            transform-style: flat;
            '. mgom_opt_to_css('easing', $layer['easing'], $layer) .'
        }
        body:not(.mg_cust_touch_ol_behav) .mgom_'.$ol->term_id.' .mg_box:not(.mg_item_no_ol):not(.mg_to_kenburn):hover .mgi_thumb,
        .mgom_'.$ol->term_id.' .mg_box.mg_ctob_show:not(.mg_item_no_ol):not(.mg_to_kenburn) .mgi_thumb {
            '. mgom_opt_to_css('animation_delay', $layer['animation_delay'], $layer, true) .'
        }
        ';

        // zoom (if isn't using scale hover effects)
        if(!empty($layer['img_zoom']) && (!isset($layer['img_h_fx']) || !in_array($layer['img_h_fx'], array('zoom-in-hide', 'zoom-out-hide'))) ) {
            $val = ($layer['img_zoom'] + 100) / 100;
            echo '
            body:not(.mg_cust_touch_ol_behav) .mgom_'.$ol->term_id.' .mg_box:not(.mg_item_no_ol):not(.mg_to_kenburn):hover .mgi_thumb,
            .mgom_'.$ol->term_id.' .mg_box.mg_ctob_show:not(.mg_item_no_ol):not(.mg_to_kenburn) .mgi_thumb {
                transform: scale('.$val.', '.$val.');
            }
            ';	
        }

        // no borders
        if(isset($layer['img_no_borders']) && !empty($layer['img_no_borders'])) {
            echo '
            .mgom_'.$ol->term_id.' .mg_box:not(.mg_item_no_ol) .mg_box_inner,
            .mgom_'.$ol->term_id.' .mg_box:not(.mg_item_no_ol) .mgi_overlays {
                '. mgom_opt_to_css('easing', $layer['easing'], $layer) .'
            }
            body:not(.mg_cust_touch_ol_behav) .mgom_'.$ol->term_id.' .mg_box:not(.mg_item_no_ol):not(.mg_to_kenburn):hover .mg_box_inner,
            .mgom_'.$ol->term_id.' .mg_box.mg_ctob_show:not(.mg_item_no_ol) .mg_box_inner {
                padding: 0 !important;
                border-width: 0 !important;
            }
            body:not(.mg_cust_touch_ol_behav) .mgom_'.$ol->term_id.' .mg_box:not(.mg_item_no_ol):not(.mg_to_kenburn):hover .mgi_overlays,
            .mgom_'.$ol->term_id.' .mg_box.mg_ctob_show:not(.mg_item_no_ol) .mgi_overlays {
                top: 0 !important;
                right: 0 !important;
                bottom: 0 !important;
                left: 0 !important;	
            }
            ';	
        }

        // hover effect - zoom and hide
        if(isset($layer['img_h_fx'])) {

            // scale and hide
            if(in_array($layer['img_h_fx'], array('zoom-in-hide', 'zoom-out-hide'))) {
                $val = ($layer['img_h_fx'] == 'zoom-in-hide') ? 4 : 0.1;

                echo '
                body:not(.mg_cust_touch_ol_behav) .mgom_'.$ol->term_id.' .mg_box:not(.mg_item_no_ol):hover .mgi_thumb,
                .mgom_'.$ol->term_id.' .mg_box.mg_ctob_show:not(.mg_item_no_ol) .mgi_thumb {
                    opacity: 0;
                    transform: scale('.$val.', '.$val.');
                }
                ';
            }

            // flip - use perspective - issues with matrix3d + translate
            elseif(in_array($layer['img_h_fx'], array('flip-vert', 'flip-horiz'))) {
                $trans_base = 'perspective(750px)';

                echo '
                .mgom_'.$ol->term_id.' .mg_box:not(.mg_item_no_ol) .mgi_thumb {
                    transform: '. $trans_base .';
                }
                body:not(.mg_cust_touch_ol_behav) .mgom_'.$ol->term_id.' .mg_box:not(.mg_item_no_ol):hover .mgi_thumb,
                .mgom_'.$ol->term_id.' .mg_box.mg_ctob_show:not(.mg_item_no_ol) .mgi_thumb {
                    transform: '. $trans_base .' rotateY(180deg);
                }
                ';	
            }

            // door effects
            elseif(strpos($layer['img_h_fx'], 'door') !== false) {
                $axis = (in_array($layer['img_h_fx'], array('door-top' ,'door-bottom'))) ? 'X' : 'Y';
                $trans_base = 'perspective(750px)';

                switch($layer['img_h_fx']) {
                    case 'door-top' 	: 
                        $orig = 'center top';
                        $val = '-90'; 
                        break;
                    case 'door-right' 	: 
                        $orig = 'right center'; 
                        $val = '-90'; 
                        break;
                    case 'door-bottom' 	: 
                        $orig = 'center bottom'; 
                        $val = '90'; 
                        break;
                    case 'door-left' 	: 
                        $orig = 'left center'; 
                        $val = '90'; 
                        break; 	
                }

                echo '
                .mgom_'.$ol->term_id.' .mg_box:not(.mg_item_no_ol) .mgi_thumb {
                    transform-origin: '. $orig .';
                    transform: '. $trans_base .';
                }
                body:not(.mg_cust_touch_ol_behav) .mgom_'.$ol->term_id.' .mg_box:not(.mg_item_no_ol):hover .mgi_thumb,
                .mgom_'.$ol->term_id.' .mg_box.mg_ctob_show:not(.mg_item_no_ol) .mgi_thumb {
                    transform: '. $trans_base .' rotate'. $axis.'('. $val .'deg);
                }
                ';	
            }
        }
        
        
        // photographic img effects
        if($layer['img_fx_behav']) {

            if($layer['img_fx_behav'] == 'initial') {
                echo '
                body:not(.mg_cust_touch_ol_behav) .mgom_'.$ol->term_id.' .mg_box:not(.mg_item_no_ol) .mgi_thumb,
                .mgom_'.$ol->term_id.' .mg_box:not(.mg_ctob_show):not(.mg_item_no_ol) .mgi_thumb'; 
            }
            elseif($layer['img_fx_behav'] == 'hover') {
                echo '
                body:not(.mg_cust_touch_ol_behav) .mgom_'.$ol->term_id.' .mg_box:not(.mg_item_no_ol):hover .mgi_thumb,
                .mgom_'.$ol->term_id.' .mg_box.mg_ctob_show:not(.mg_item_no_ol) .mgi_thumb';
            }
            else {
                echo '
                .mgom_'.$ol->term_id.' .mg_box:not(.mg_item_no_ol) .mgi_thumb';            
            }
                
            echo '
            {
                filter: 
                blur('. (float)$layer['blur_fx'] .'px) 
                brightness('. (float)$layer['brightness_fx'] .'%) 
                contrast('. (float)$layer['contrast_fx'] .') 
                grayscale('. (float)$layer['grayscale_fx'] .'%) 
                hue-rotate('. (float)$layer['hue_fx'] .'deg) 
                invert('. (float)$layer['invert_fx'] .'%) 
                saturate('. (float)$layer['saturate_fx'] .')     
                sepia('. (float)$layer['sepia_fx'] .'%);
            }';
            
            
            if($layer['img_fx_behav'] == 'initial') {
                echo '
                body:not(.mg_cust_touch_ol_behav) .mgom_'.$ol->term_id.' .mg_box:not(.mg_item_no_ol):hover .mgi_thumb,
                .mgom_'.$ol->term_id.' .mg_box.mg_ctob_show:not(.mg_item_no_ol) .mgi_thumb {
                    filter: none;    
                }';
            }
        }
    }


    // overlay's custom CSS
    if(is_array($layers) && isset($layers['custom_css']) && !empty($layers['custom_css'])) {
        echo '/* ***** '. $ol->term_id .' - '. $ol->name .' OVERLAY - CUSTOM CSS ***** */
        '. $layers['custom_css'];
    }

  } // end line #32 condition
      

endforeach;  ?>