<?php


// SETTINGS FIELD to set custom overlay globally
function mgom_settings_field($structure) {
	
	$ols_opt = array(
		'' => '('. esc_html__('original one', MGOM_ML) .')'
	);
	foreach(get_terms('mgom_overlays', 'hide_empty=0') as $ol) {
		$ols_opt[ $ol->term_id ] = $ol->name;	
	}
	
	
	$structure['main_opts']['grid_layout']['fields']['mg_default_overlay'] = array(
		'label' 	=> __("Default overlay", MGOM_ML),
		'type'		=> 'select',
		'val' 		=> $ols_opt,
		'note'		=> __("This overlay will be applied by default to every grid", MGOM_ML) .' - Overlay Manager add-on', 
	);
	return $structure;
}
add_filter('mg_settings_structure', 'mgom_settings_field');






// OVERLAY CLASS to be applied to grid's wrapper
function mgom_grid_class($classes, $grid_atts) {
	
	if(!isset($grid_atts['overlay']) || !$grid_atts['overlay'] || $grid_atts['overlay'] == 'default') {
		if(get_option('mg_default_overlay', '')) {
			$classes[] = 'mgom_'.get_option('mg_default_overlay', '');
		}
	} 
	else {
		$classes[] = 'mgom_'.$grid_atts['overlay'];	
	}
	
	return $classes;		
}
add_filter('mg_grid_classes', 'mgom_grid_class', 10, 2);






// OVERLAYS CSS injected in mg_custom_css action 
function mgom_overlays_css() {
	include_once(MGOM_DIR .'/frontend_css.php');
}
add_action('mg_custom_css', 'mgom_overlays_css', 200);

