(function($) {
	"use strict"; 
    
    const dike_slug = (lcmg.dike_slug == 'mgbp') ? lcmg.dike_slug : 'mgom';
    
    if(typeof(window.dike_plc) != 'undefined' && !window.dike_plc('lcweb', dike_slug)) {
        console.error('Media Grid Overlay Manager add-on - validate the license');
        return false;    
    }
    
    
    let mgom_vc_paddings = [];
    
    
	window.mgom_init = function(grid_id) {	
        
		// direction aware overlays
		$('.mgom_mouse_dir').parents('.mgi_elems_wrap').lc_hoverdir({
			hoverDelay : 25,
			overlaySelector: '.mgom_mouse_dir',
			noTransitionClass: 'mgom_md_init_pos'  
		});
		
		mgom_set_border_radius(grid_id);

		mgom_txt_shortening(grid_id);	
		mgom_txt_vis(grid_id);	
	};
	
	
	// initialize on grid's initialization
	$(window).on('mg_items_ready', function(e, grid_id, $boxes, grid_initiated) {
		if(grid_initiated) {
            return true;
        }
		
		setTimeout(function() { // wait a bit to allow sizes to setup
			mgom_init(grid_id);
		}, 70);
	});

	
	
	// setup border radius values for full-img layers
	const mgom_set_border_radius = function(grid_id) {
		var pre = '#'+grid_id;
		if(
			!$(pre +' .mgom_outlined_box').length && 
			!$(pre +' .mgom_single_border').length &&
			!$(pre +' .mgom_txt_block').length
		) { 
			return false;
		}

		var val = parseInt( $(pre +' .mg_box_inner').first().css("borderTopLeftRadius"));
		if(val) {
			$('head').append(
			'<style type="text/css">'+ 
			pre +' .mgom_outlined_box:before, '+ pre +' .mgom_single_border, '+ pre +' .mgom_txt_block {'+
				'border-radius: '+ val +'px;'+ 
			'}</style>');	
		}
	};
	
	
	// remove empty textual divs
	const mgom_del_empty_txt = function(grid_id) {
		$('#'+grid_id).find('.mg_box .mgom_txt_inner > *, .mg_box .mg_title_under > *').not('.mgom_txt_block, .mgom_separator').each(function() {

			if(!$.trim( $(this).html() )) {
				$(this).remove();	
			}
        });
	};
	
	
	// overlays visibility on small sizes
	$(window).on('mg_resize_grid', function(e, grid_id) {

		// find every item with custom overlays
		$('#'+grid_id+' .mg_box .mgi_overlays > .mgom_layer').parents('.mg_items_container').find('.mg_box_inner').each(function() {
			
            if($(this).parents('.mg_box').hasClass('mg-muuri-hidden')) {
                $(this).find('.mgom_corner_triangle, .mgom_corner_square, .mgom_corner_circle, .mgom_txt_wrap, .mgom_circle, .mgom_exagon, .mgom_octagon').show();        
            }
            else {
                var box_w = $(this).outerWidth();
                var box_h = $(this).outerHeight();

                // hide corners
                if( box_w < 90 || box_h < 90 ) { 
                    $(this).find('.mgom_corner_triangle, .mgom_corner_square, .mgom_corner_circle').hide(); 
                }
                else {
                    $(this).find('.mgom_corner_triangle, .mgom_corner_square, .mgom_corner_circle').show();
                }

                // hide text layer and shapes
                if( box_w < 60 || box_h < 60 ) { 
                    $(this).find('.mgom_txt_wrap, .mgom_circle, .mgom_exagon, .mgom_octagon').hide(); 
                }
                else {
                    $(this).find('.mgom_txt_wrap, .mgom_circle, .mgom_exagon, .mgom_octagon').show();
                }
            }
		});	
	});
	
	
	
	
	/* *** TEXT LAYER EFFECTS *** */

	// default state - prepare attributes
	const mgom_txt_vis = function(grid_id) {
		const $subj = $('#'+grid_id+' .mgom_txt_vis:not(.mgom_show_all) .mg_box:not(.mg-muuri-hidden) .mgom_txt_wrap');
		const $wrapper = $subj.parents('.mg_items_container');

		$subj.each(function() {
            const $txt_wrap = $(this);    
            
			// show title + rest on hover with contents height
			if(($wrapper.hasClass('mgom_show_title') || $wrapper.hasClass('mgom_show_title_fh')) && $(this).find('.mgom_title').length) {
				
				// keep showing the title 
                const tit_h         = $txt_wrap.find('.mgom_title').height(),
                      txt_top_padd  = parseInt($txt_wrap.css('padding-top'), 10),
                      txt_btm_padd  = parseInt($txt_wrap.css('padding-bottom'), 10),
                      
                      flap_h        = txt_top_padd + txt_btm_padd + tit_h,
                      item_h        = $txt_wrap.parents('.mgi_overlays').outerHeight(true);
				
				// recursive check to avoid zero values - wait for the grid to be displayed
				// if title exists and wrong height is got
				if(item_h < 5 || ( $.trim($txt_wrap.find('.mgom_title').text()) && tit_h < 5 )) {
					setTimeout(function() {
						mgom_txt_vis(grid_id);
					}, 50);
					return false;
				}
				
				var init_top = Math.round(item_h - flap_h);
				if(init_top < 0) {
                    init_top = 0;
                }
                
				$txt_wrap.css('top', init_top);
			}
			else {
				var init_top = '100%';
				$txt_wrap.css('top', init_top);
			}
			$txt_wrap.attr('data-init-top', init_top);
			

			// set top position on hover - for contents height
			if($wrapper.hasClass('mgom_show_title') || $wrapper.hasClass('mgom_hide_all')) {				
				var item_h = $txt_wrap.parents('.mgi_overlays').outerHeight(true);
				
				// recursive check to avoid zero values - wait for the grid to be displayed
				if(item_h < 5) {
					setTimeout(function() {
						mgom_txt_vis(grid_id);
					}, 50);
					return false;
				}
				
				var tot_h = parseInt($txt_wrap.css('padding-top'), 10) + parseInt($txt_wrap.css('padding-bottom'), 10);
				
				if($wrapper.hasClass('mgom_show_title')) {
					tot_h = tot_h + parseInt($txt_wrap.find('.mgom_title').outerHeight(true), 10) - parseInt($txt_wrap.find('.mgom_title').css('padding-bottom'), 10);	
				}
				
				var exclude_tit = ($wrapper.hasClass('mgom_show_title')) ? ', .mgom_title' : ''; 
				$txt_wrap.find('> *').not('.mgom_txt_block' + exclude_tit).each(function() {
					tot_h = tot_h + $(this).outerHeight(true);   
				});
				
				var hover_top = Math.ceil(item_h - tot_h);
				if(hover_top < 0) {
                    hover_top = 0;
                }
			}
			else {
				var hover_top = 0;
			}
			$txt_wrap.attr('data-hover-top', hover_top);

            
            if($wrapper.hasClass('mgom_show_title_fh')) {
                let txt_elems_tot_h = 0;
                
                $txt_wrap.find('> *').not('.mgom_txt_block').each(function() {
					txt_elems_tot_h = txt_elems_tot_h + $(this).outerHeight(true) - parseInt($(this).css('padding-bottom'), 10) - parseInt($(this).css('padding-bottom'), 10);   
				}); 
                
                let teth_diff = Math.floor(($txt_wrap.height() - txt_elems_tot_h) / 2);
                if(teth_diff < 0) {
                    teth_diff = 0;    
                }
                
                $txt_wrap.attr('data-texts-h-diff', teth_diff);
            }
        });	
		
		 mgom_txt_vis_hover(grid_id);
	};


	// hover effects
	const mgom_txt_vis_hover = function(grid_id) {
		$('#'+grid_id+' .mgom_txt_vis').on('mouseenter', '.mg_box:not(.mg-muuri-hidden)', function(e) {
            
            // show title + rest on hover
			if(!$(this).parents('.mg_items_container').hasClass('mgom_curtain')) { 
				var val = parseInt($(this).find('.mgom_txt_wrap').attr('data-hover-top'), 10);
				$(this).find('.mgom_txt_wrap').css('top', val);
                
                val = parseInt($(this).find('.mgom_txt_wrap').attr('data-texts-h-diff'), 10);
                $(this).find('.mgom_title').css('margin-top', val);
			}
            
            // curtain
			else {
				var val = $(this).find('.mgom_txt_wrap').outerHeight() * -1;
				$(this).find('.mgom_graphic_wrap, .mg_media_wrap').clearQueue().animate({'top' : val}, 400);
			}
		}).
        
		on('mouseleave', '.mg_box:not(.mg-muuri-hidden)', function(e) {
                
            // show title + rest on hover
			if(!$(this).parents('.mg_items_container').hasClass('mgom_curtain')) { 
			
				var val = $(this).find('.mgom_txt_wrap').attr('data-init-top');
				if(typeof(val) != 'undefined') {
					if(val.indexOf('%') === -1) {
                        val = val + 'px';
                    }
					$(this).find('.mgom_txt_wrap').css('top', val);
				}
                
                $(this).find('.mgom_title').css('margin-top', 0);
			}
            
            // curtain
			else {
				$(this).find('.mgom_graphic_wrap, .mg_media_wrap').clearQueue().animate({'top' : 0}, 400);	
			}
		});	
	};
	


	// text shortening
	window.mgom_txt_shortening = function(grid_id) {
		var $grid = $('#'+grid_id);
		var $subj = $grid.find('.mg_box:not(.mg-muuri-hidden) .mgom_descr');	

		// shorten
		if($subj.length) {
			$subj.each(function() {
				
				// check for highlighted text
				if($(this).find('.mgom_mark').length) {
					var $this = $(this).find('.mgom_mark');
					var $elem = $(this);
				} else {
					var $this = $(this).find('> div');
					var $elem = $(this);	
				}
				
				// be sure the grid sizes are executed
				if($this.parents('.mg_box').outerHeight() < 5) {
					setTimeout(function() {
						mgom_txt_shortening(grid_id);
					}, 50);
					return false;
				}
				
				
                // find max-height
				var fixed_max_h = parseInt( $(this).css('max-height'));
				
				if($grid.find('.mgi_txt_under').length) { // text under items
					var max_h = (!fixed_max_h || isNaN(fixed_max_h)) ? 150 : fixed_max_h;
				}
				else {
					var max_h = $this.parents('.mgi_overlays').height();
					max_h = max_h - parseInt($this.parents('.mgom_txt_wrap').css('padding-top'), 10) - parseInt($this.parents('.mgom_txt_wrap').css('padding-bottom'), 10);
					max_h = max_h - parseInt($elem.css('margin-top'), 10) - parseInt($elem.css('margin-bottom'), 10);

					// exclude other elements from max-height
					$elem.parent().find('> *').not('.mgom_descr, .mgom_txt_block, p').each(function() {
                    	 max_h = max_h - $(this).outerHeight(true); 
                    });

					// title always visible - remove extra padding
					if(($grid.hasClass('mgom_show_title_fh') || $grid.hasClass('mgom_show_title')) && $this.parents('.mgom_txt_wrap').find('.mgom_title').length) {
						max_h = max_h + parseInt($this.parents('.mgom_txt_wrap').find('.mgom_title').css('padding-bottom'));	
					}

					// if is higher than fixed - replace
					if(!isNaN(fixed_max_h) && fixed_max_h && max_h > fixed_max_h) {
						max_h = fixed_max_h;	
					}
				}

				var allow_links = ($(this).parents('.mg_box').hasClass('mg_static_img')) ? 'a' : '';
				$this.lcweb_txt_shortener('..', max_h, allow_links);
            });	
			
			// if some has been shortened - trigger grid resize to adjust masonry placement
			if($grid.find('.mgi_txt_under .lcnb_shorten').length) {
				$(window).trigger('mg_resize_grid', [grid_id]);
			}	
		}
	};
	
	
	
	// on resize - DO NOT use mg_resize_grid to not create a loop
	let mgom_on_resize, mgom_on_resize_masonry;
    
    $(window).resize(function() {
		if(mgom_on_resize) {
			clearTimeout(mgom_on_resize);
		}
		if(mgom_on_resize_masonry) {
			clearTimeout(mgom_on_resize_masonry);
		}
		
		mgom_on_resize = setTimeout(function() {
			
			$('.mg_grid_wrap').each(function(index, element) {
                var gid = $(this).attr('id');
				mgom_txt_vis(gid);
			
				// adjust text after isotope animation 
				mgom_on_resize_masonry = setTimeout(function() {
					mgom_txt_vis(gid);
					
					$('.mg_items_container').each(function() {
						mgom_txt_shortening(gid);
					});
				}, 710);
            });
			
		}, 50);
	});
	
	
    
	// on filter/pagination
	$(window).on('mg_filtered_grid mg_resize_grid', function(e, grid_id) {   
        actions_on_filter(grid_id);	
	});
    
    const actions_on_filter = function(grid_id) {
        
        if($('#'+grid_id+' > .mg_loader').is(':visible')) {
            setTimeout(function() {
                actions_on_filter(grid_id);    
            }, 50);
        }
        else {
            mgom_txt_vis(grid_id);
            mgom_txt_shortening(grid_id);      
        }
    };
	
    
	
	// disable linked item click on socials usage
	$(document).on('click', '.mgom_socials span', function(e) {
        e.preventDefault();
	});
    
	
})(jQuery);