<?php
//////////////////////////////////////////////////////////////
// if not exist - load WP functions
if(!function_exists('get_option')) {
	$abspath = urldecode($_GET['abspath']);

	// main functions
	if(!file_exists($abspath .'/wp-load.php')) {
        die('<p>wordpress - wp-load.php file not found</p>');
    } else {
        require_once($abspath .'/wp-load.php');
    }
}

if(!function_exists('get_filesystem_method')) {
    
	// wp-admin/includes/file.php - for wp_filesys
	if(!file_exists(ABSPATH .'wp-admin/includes/file.php')) {
        die('<p>wordpress - file.php file not found</p>');
    } else {
        require_once(ABSPATH .'wp-admin/includes/file.php');
    }	
}
/////////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////
// CREATE THE OVERLAY FOR THE PREVIEW /////
///////////////////////////////////////////

include_once(MG_DIR .'/classes/overlay_manager.php');
include_once(MGOM_DIR .'/classes/mgom_static.php');


// check overlay ID
if(!isset($_GET['ol_id'])) {
    die('overlay ID missing');
}
$ol_id = (int)$_GET['ol_id'];


// check and process overlay data 
if(!isset($_GET['ol_data'])) {
    die('overlay data missing');
}


// uncompress overlay data passed
foreach(glob(MGOM_DIR ."/classes/LZCompressor/*.php") as $filename) {
    include_once($filename);
}
use LZCompressor\LZString as LZString;


$GLOBALS['mgom_preview_data'] = json_decode(LZString::decompressFromEncodedURIComponent( urldecode($_GET['ol_data']) ));
$GLOBALS['mgom_preview_data'] = mgom_static::js_ajax_sanitize($GLOBALS['mgom_preview_data']);

if(!is_array($GLOBALS['mgom_preview_data']) || !isset($GLOBALS['mgom_preview_data']['graphic'])) {
    die('invalid overlay data');
}


// add-on version for scripts cache/refresh
$mgom_ver = isset($_GET['mgom_v']) ? $_GET['mgom_v'] : time(); 
?>

<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Media Grid Overlay Manager add-on - live preview</title>

<style type="text/css">
:root {
    --mg-x-twitter: url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA1MTIgNTEyIj48IS0tISBGb250IEF3ZXNvbWUgUHJvIDYuNC4yIGJ5IEBmb250YXdlc29tZSAtIGh0dHBzOi8vZm9udGF3ZXNvbWUuY29tIExpY2Vuc2UgLSBodHRwczovL2ZvbnRhd2Vzb21lLmNvbS9saWNlbnNlIChDb21tZXJjaWFsIExpY2Vuc2UpIENvcHlyaWdodCAyMDIzIEZvbnRpY29ucywgSW5jLiAtLT48cGF0aCBkPSJNMzg5LjIgNDhoNzAuNkwzMDUuNiAyMjQuMiA0ODcgNDY0SDM0NUwyMzMuNyAzMTguNiAxMDYuNSA0NjRIMzUuOEwyMDAuNyAyNzUuNSAyNi44IDQ4SDE3Mi40TDI3Mi45IDE4MC45IDM4OS4yIDQ4ek0zNjQuNCA0MjEuOGgzOS4xTDE1MS4xIDg4aC00MkwzNjQuNCA0MjEuOHoiLz48L3N2Zz4=");
    
    --mg-x-twitter-squared: url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA0NDggNDQ4Ij48cG9seWdvbiBwb2ludHM9IjEyNy42NSAxMTQuNDggMjk0LjA4IDMzMi4wOCAzMTkuNTcgMzMyLjA4IDE1NS4wMyAxMTQuNDggMTI3LjY1IDExNC40OCIvPjxwYXRoIGQ9Ik00MDAsMEg0OEE0OCw0OCwwLDAsMCwwLDQ4VjQwMGE0OCw0OCwwLDAsMCw0OCw0OEg0MDBhNDgsNDgsMCwwLDAsNDgtNDhWNDhBNDgsNDgsMCwwLDAsNDAwLDBaTTI4MS40MywzNTkuNTlsLTcyLjU1LTk0Ljc4TDEyNiwzNTkuNTlINzkuODdMMTg3LjM2LDIzNi43MSw3NCw4OC40MWg5NC45MkwyMzQuNDMsMTc1bDc1LjgyLTg2LjYzaDQ2TDI1NS43NSwyMDMuMjcsMzc0LDM1OS41OVoiLz48L3N2Zz4="); 
}

    
/* CSS resetter */
html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{border:0;font-size:100%;font:inherit;vertical-align:baseline;margin:0;padding:0}article,aside,details,figcaption,figure,footer,header,hgroup,menu,nav,section{display:block}body{line-height:1}ol,ul{list-style:none}blockquote,q{quotes:none}blockquote:before,blockquote:after,q:before,q:after{content:none}table{border-collapse:collapse;border-spacing:0}


.mg_grid_wrap { 
	min-width: 100px;  
	width: 100%;
	margin: auto;
	position: relative;
	overflow: visible;
}
.mg_grid_wrap:after {
    display: block;
    content: "";
    clear: both;
}
.mg_grid_wrap, .mg_grid_wrap * {
	box-sizing: border-box;	
	-webkit-font-smoothing: antialiased;
}
.mg_grid_wrap a:focus {
	outline: none; 	
}


/*items wrapper*/
.mg_items_container {
	width: 100%;
	margin: auto;  
	overflow: visible;
	min-height: 180px;
	position: relative;
	margin-top: 0; 
}
.mg_items_container:after {
	content: '';
	display: block;
	clear: both;
}


/* items*/
.mgi_elems_wrap {
	position: absolute;
	height: 100%;
	width: 100%;
}
.mg_box {  	
	background-clip: padding-box !important;
	border-style: solid;
	border-color: transparent !important;
    display: inline-block;
    float: left;
	position: absolute;
    height: 0;
	padding: 0;
	z-index: 10;
}
.mg_box_inner {
	display: block;
    height: 100%;
    position: absolute;
    width: 100%;
	overflow: hidden;
}
.mg_media_wrap, .mgi_thumb_wrap {
    position: relative;
	height: 100%;
	width: 100%;
	overflow: hidden;
	z-index: 10;
}
.mgi_thumb {
	height: 100%;
	width: 100%;
	position: absolute;
	background-repeat: no-repeat;
	background-position: center center;
	background-size: cover;
	background-color: transparent;
}
.mgi_overlays {
    position: absolute;
    z-index: 100;
	overflow: hidden;
	cursor: pointer;
}
.mgi_txt_under {
	-webkit-hyphens: auto;  
    -moz-hyphens: auto;  
    hyphens: auto;  
	line-height: normal;
	
	position: absolute;
	width: 100%;
	top: 100%;
}
.mg-twitter-icon:before {
    content: "x";
	background-color: #555;
	-webkit-mask-image: var(--mg-x-twitter);
	mask-image: var(--mg-x-twitter);
    text-indent: -99999px;
    mask-repeat: no-repeat;
    mask-position: center;
    display: block; 
    width: 100%;
    line-height: normal !important;
}
.fa-twitter-square.mg-twitter-icon:before {
	-webkit-mask-image: var(--mg-x-twitter-squared);
	mask-image: var(--mg-x-twitter-squared);
    position: relative;
    top: -2px;
    width: 89%;
}
.mg_round_social_trick {
	border-radius: 50%;
}
.mg_round_social_trick:before {
    position: relative;
    left: 2px;
}
.mg_round_social_trick.fa-twitter-square:before {
    left: 2px;
    top: -1px; 
    width: 83%;
}
    
    

/******/

html {
    font-size: 100%;
	font-family: "Source Sans Pro", Helvetica,sans-serif;	
}
body {
    color: #141412;
}
.mgom_txt_wrap * {
	-webkit-hyphens: auto;
	-moz-hyphens: auto;
	hyphens: auto;
	
	font-family: "Source Sans Pro", Helvetica,sans-serif;
}
.mg_grid_wrap {
    margin: 0;        
}
.mg_box.mg_video {
    position: absolute; 
    top: 0;
    left: 0; 
    width: 255px;
}
    
    
<?php 
$items_border_w         = (int)get_option('mg_cells_img_border', 3);
$items_border_radius    = (int)get_option('mg_cells_radius', 2);
$items_border_color     = get_option('mg_img_border_color', '#ccc');
$outer_border_color     = get_option('mg_cells_border_color', '#444');
?>    
.mg_box_inner {
	border-style: solid;
    padding: <?php echo $items_border_w ?>px;
	background: <?php echo $items_border_color ?>;
    border: <?php echo (get_option('mg_cells_border')) ? 1 : 0; ?>px solid <?php echo $outer_border_color ?>; 
}
.mg_box_inner, 
.mg_box .mg_media_wrap,
.mgi_overlays,
.mg_inl_txt_media_bg,
.mg_inl_slider_wrap .lcms_content,
.mg_inl_slider_wrap .lcms_nav *,
.mg_inl_slider_wrap .lcms_play {
  border-radius: <?php echo $items_border_radius ?>px;
}
.mgi_overlays {
    top: <?php echo $items_border_w ?>px;
    left: <?php echo $items_border_w ?>px;
    right: <?php echo $items_border_w ?>px;
	bottom: <?php echo $items_border_w ?>px;
}    
.mg_tu_attach .mgi_txt_under {
    border-bottom-left-radius: <?php echo $items_border_radius ?>px;
    border-bottom-right-radius: <?php echo $items_border_radius ?>px;	
}    
.mgi_txt_under {
	margin-top: 3px;
	
	<?php
	$pdg = 0; 
	 
	$pdg_t = ($pdg < 6) ? 6 : (int)$pdg;
	$pdg_r = ($pdg < 10) ? 10 : (int)$pdg; 
	$pdg_b = ($pdg < 10) ? 10 : (int)$pdg; 
	$pdg_l = ($pdg < 6) ? 6 : (int)$pdg; 
	
	$cust_pdg = get_option('mg_tu_custom_padding');
	if(is_array($cust_pdg)) {
		if($cust_pdg[0] != '') {$pdg_t = (int)$cust_pdg[0];}
		if($cust_pdg[1] != '') {$pdg_r = (int)$cust_pdg[1];}
		if($cust_pdg[2] != '') {$pdg_b = (int)$cust_pdg[2];}
		if($cust_pdg[3] != '') {$pdg_l = (int)$cust_pdg[3];}
	}
	
	?>	
    padding-top: 	<?php echo $pdg_t; ?>px !important;
    padding-right: 	<?php echo $pdg_r; ?>px;
    padding-bottom: <?php echo $pdg_b; ?>px;
    padding-left: 	<?php echo $pdg_l; ?>px;
}
</style>

    
<link rel="stylesheet" href="<?php echo MG_URL ?>/css/fontAwesome/css/all.min.css?v5.15.2" type="text/css" />    
<link rel="stylesheet" href="<?php echo MGOM_URL ?>/css/frontend.min.css?v=<?php echo $mgom_ver ?>" type="text/css" />
    
<?php 
echo '<style type="text/css">';
require_once(MGOM_DIR.'/frontend_css.php');
echo '</style>';

      

// image overlay code 
$ol_man = new mg_overlay_manager($ol_id, $_REQUEST['txt_under'], true);

if($_REQUEST['txt_under'] == 1) {
	$img_ol = '<div class="mgi_overlays">' . $ol_man->get_img_ol('fake_id') . '</div>';
	$txt_under = $ol_man->get_txt_under('fake_id');
} 
else {
	$img_ol = '<div class="mgi_overlays">' . $ol_man->get_img_ol('fake_id') . '</div>';
	$txt_under = '';
}

$grid_h = ($_REQUEST['txt_under']) ? 430 : 194;
$elem_h = 194;
?>

<script type='text/javascript' src='<?php echo MGOM_URL ?>/js/jquery-3.7.0.min.js'></script>
</head>

<body>
	<div id="999" class="mg_grid_wrap mg_deeplink mgom_<?php echo $ol_id ?>" style="height: <?php echo $grid_h ?>px;">
		<div class="mg_items_container <?php echo $ol_man->txt_vis_class ?>" rel="auto" <?php echo $ol_man->img_fx_attr ?> style="height: <?php echo $elem_h ?>px;">
			
            <div class="mg_box mg_video" style="padding-bottom: <?php echo $elem_h ?>px;">				
				<div class="mgi_elems_wrap">
					<div class="mg_box_inner">
						<div class="mg_media_wrap">
							<div class="mgi_thumb_wrap">
                            	<div class="mgi_thumb mgi_main_thumb" style="background-image: url(<?php echo MG_URL ?>/img/demo_picture.jpg);" data-fullurl="<?php echo MG_URL ?>/img/demo_picture.jpg"></div>
                            </div>
						</div>
						<?php echo $img_ol; ?>
					</div>
                    
                    <?php echo $txt_under; ?>
				</div>
			</div>
			
		</div>      
	</div>       

    
    <script type="text/javascript">
    (function($) { 
        "use strict"; 
        
        window.lcmg = {
            dike_slug : 'foo'
        };
        
        window.dike_plc = () => {
            return true;    
        };
    })();
    </script>
    

    <script type='text/javascript' src='<?php echo MGOM_URL ?>/js/DirectionAwareHoverEffect/jquery.hoverdir.min.js'></script>
    <script type='text/javascript' src='<?php echo MGOM_URL ?>/js/lcweb-text-shortener/lc_text_shortener.min.js'></script>

	<script type='text/javascript' src='<?php echo MGOM_URL ?>/js/overlays.js?v=<?php echo $mgom_ver ?>'></script>
	<script type="text/javascript">
    (function($) { 
        "use strict"; 
        
        $(document).ready(function($) { 
            window.mg_mobile = 800; 

            // initialize
            mgom_init(999);
        });
    })(jQuery); 
    </script>
	
	
</body>
</html>