<?php
/* 
Plugin Name: Media Grid - Overlay Manager add-on
Plugin URI: https://lcweb.it/media-grid/overlay-manager-addon
Description: Boost Media Grid with unique overlays. Customize preset overlays or create you one. With hundreds of possible combinations, the limit is only your creativity.
Author: Luca Montanari (LCweb)
Version: 2.1.0
Author URI: https://lcweb.it/
*/  


/////////////////////////////////////////////
/////// MAIN DEFINES ////////////////////////
/////////////////////////////////////////////

// plugin path
$wp_plugin_dir = substr(plugin_dir_path(__FILE__), 0, -1);
define('MGOM_DIR', $wp_plugin_dir);

// plugin url
$wp_plugin_url = substr(plugin_dir_url(__FILE__), 0, -1);
define('MGOM_URL', $wp_plugin_url);



// multilang key
define('MGOM_ML', 'mgom_ml');

// add-on version
define('MGOM_VER', '2.1.0');






///////////////////////////////////////////////
/////// CHECK IF MEDIA GRID IS ACTIVE /////////
///////////////////////////////////////////////

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if(!is_plugin_active('media-grid/media-grid.php') && !isset($GLOBALS['is_mg_bundle'])) {
	function mgom_no_plugin_warning() {
		echo '
		<div class="error">
		   <p>'. __('Please activate Media Grid plugin to use Overlay Manager add-on', MGOM_ML) .'</p>
		</div>';
	}
	add_action('admin_notices', 'mgom_no_plugin_warning');
}



else {	

	/////////////////////////////////////////////
	/////// MULTILANGUAGE SUPPORT ///////////////
	
	function mgom_multilanguage() {
		$param_array = explode(DIRECTORY_SEPARATOR, MGOM_DIR);
		$folder_name = end($param_array);
		load_plugin_textdomain(MGOM_ML, false, $folder_name .'/languages'); 
	}
	add_action('init', 'mgom_multilanguage', 1);
	
	
	
	
	
	/////////////////////////////////////////////
	/////// MAIN SCRIPT & CSS INCLUDES //////////
	
	// global script enqueuing
	function mgom_global_scripts() {
		$is_admin = is_admin();
	
		// admin css & js
		if($is_admin) {  
            global $current_screen;
            if(!$current_screen) {
                return;     
            }
            
			wp_enqueue_style('mgom_admin', MGOM_URL .'/css/admin.css', 999, MGOM_VER);
            
            if($current_screen->base == 'mg_items_page_mgom_builder') {
                wp_enqueue_script('lz-string', MGOM_URL .'/js/LZ-String/lz-string.min.js', 200, '1.4.3', true);
                
                $baseurl = MG_URL .'/js';
                
                wp_enqueue_style('codemirror',          $baseurl .'/codemirror/codemirror.css');
                wp_enqueue_script('codemirror',         $baseurl .'/codemirror/codemirror.min.js', 200, '1.0', true);
                wp_enqueue_script('codemirror-lang-css',$baseurl .'/codemirror/languages/css.min.js', 201, '1.0', true);    
            }
		}
        
		
		if(!$is_admin || isset($GLOBALS['lc_guten_scripts'])) {
            $in_footer = (get_option('mg_js_head')) ? false : true;
            
			wp_enqueue_script('mgom-hoverdir', MGOM_URL .'/js/DirectionAwareHoverEffect/jquery.hoverdir.min.js', array('jquery', 'mg-frontend'), '1.1.0', $in_footer);	
			wp_enqueue_script('mgom-lc-txt-shortener', MGOM_URL .'/js/lcweb-text-shortener/lc_text_shortener.min.js', array('jquery', 'mg-frontend'), '1.1.0', $in_footer);	
			wp_enqueue_script('mgom-overlays-js', MGOM_URL .'/js/overlays.min.js', array('jquery', 'mg-frontend'), MGOM_VER, $in_footer);	
		
			// frontend CSS
			wp_enqueue_style('mgom-frontend-css', MGOM_URL. '/css/frontend.min.css', 'mg-frontend-css', MGOM_VER);
            
            // Divi
            if(class_exists('ET_Builder_Module')) {
                wp_enqueue_style('mgom-divi-frontend', MGOM_URL .'/css/frontend.min_for_divi.css', 'mgom-frontend-css', MGOM_VER);	     
            }
		}
	}
	add_action('wp_enqueue_scripts', 'mgom_global_scripts', 999);
	add_action('admin_enqueue_scripts', 'mgom_global_scripts');
	add_action('lc_guten_scripts', 'mgom_global_scripts');
	


    
	// USE FRONTEND CSS INLINE
	function mgom_inline_css() {
		if(isset($GLOBALS['mgom_printed_inline_css'])) { // avoid double enqueuing with Gutenberg
			return false;	
		}
		$GLOBALS['mgom_printed_inline_css'] = true;
		
		echo '<style type="text/css">';
		include_once(MGOM_DIR.'/frontend_css.php');
		echo '</style>';
	}
	
	
	
	
		

	//////////////////////////////////////////////
	// ADD SUBMENU
	
	function mgom_add_menu() {	
		add_submenu_page('edit.php?post_type=mg_items', esc_html__('Overlay Manager', MGOM_ML), esc_html__('Overlay Manager', MGOM_ML), 'upload_files', 'mgom_builder', 'mgom_builder');
	}
	add_action('admin_menu', 'mgom_add_menu', 2);
    
	function mgom_builder() {
		include(MGOM_DIR .'/ol_builder/builder.php');	
	}
	
    
    
	
	
	
	//////////////////////
	// OVERLAYS TAXONOMY
	
	function register_taxonomy_mgom() {
		$labels = array( 
			'name'                       => esc_html__('MG Overlays', MGOM_ML),
			'singular_name'              => esc_html__('MG Overlay', MGOM_ML),
			'search_items'               => esc_html__('Search MG Overlays', MGOM_ML),
			'popular_items'              => esc_html__('Popular MG Overlays', MGOM_ML),
			'all_items'                  => esc_html__('All MG Overlays', MGOM_ML),
			'parent_item'                => esc_html__('Parent MG Overlay', MGOM_ML),
			'parent_item_colon'          => esc_html__('Parent MG Overlay:', MGOM_ML),
			'edit_item'                  => esc_html__('Edit MG Overlay', MGOM_ML),
			'update_item'                => esc_html__('Update MG Overlay', MGOM_ML),
			'add_new_item'               => esc_html__('Add New MG Overlay', MGOM_ML),
			'new_item_name'              => esc_html__('New MG Overlay', MGOM_ML),
			'separate_items_with_commas' => esc_html__('Separate mg overlays with commas', MGOM_ML),
			'add_or_remove_items'        => esc_html__('Add or remove MG Overlays', MGOM_ML),
			'choose_from_most_used'      => esc_html__('Choose from most used MG Overlays', MGOM_ML),
			'menu_name'                  => esc_html__('MG Overlays', MGOM_ML),
		);
	
		$args = array( 
			'labels' => $labels,
			'public' => false,
			'show_in_nav_menus' => false,
			'show_ui' => false,
			'show_tagcloud' => false,
			'show_admin_column' => false,
			'hierarchical' => false,
			'rewrite' => false,
			'query_var' => true
		);
	
		register_taxonomy('mgom_overlays', null, $args);
	}
	add_action( 'init', 'register_taxonomy_mgom');
	
	
	
	
    
	
	/////////////////////////////////////////////
	/////// MAIN INCLUDES ///////////////////////
	/////////////////////////////////////////////
	
	include_once(MGOM_DIR .'/classes/mgom_static.php');
	
	// mg hooks integration
	include_once(MGOM_DIR .'/integrations.php');
    
    // image layer sidebox
	include_once(MGOM_DIR .'/post_types_metabox.php');
    
    
    // ol builder
    include_once(MGOM_DIR .'/ol_builder/fields_code.php');
    include_once(MGOM_DIR .'/ol_builder/ol_fields.php');
	include_once(MGOM_DIR .'/ol_builder/ol_select_opts.php');
    include_once(MGOM_DIR .'/ol_builder/opts_to_css.php');
    include_once(MGOM_DIR .'/ol_builder/ajax.php');
    
    
	// item attribute shortcode
	include_once(MGOM_DIR .'/shortcodes.php');
	
	// overlay code - MG integration
	include_once(MGOM_DIR .'/overlay_code.php');
	
	// actions on add-on activation
	include_once(MGOM_DIR .'/on_activation.php');
	
	
	
	
	
    
	
    ////////////
    // DIKE WP DASHBOARD

    $mgom_dike_slug = (isset($GLOBALS['is_mg_bundle'])) ? 'mgbp' : 'mgom';
    define('MGOM_DIKE_SLUG', $mgom_dike_slug);
    
    function mgom_dike_updater_data($data) {
        $data['mgom'] = array(
            'callback' => 'mgom_preset_ol_install',
            'no_files_del' => false,
        );
        return $data;
    }
    add_filter('dike_lcweb_updater', 'mgom_dike_updater_data');

    
    function mgom_dike_plc_sc($sc) {
        if(!isset($sc[MG_DIKE_SLUG])) {
            $sc[MG_DIKE_SLUG] = array();    
        }

        $sc[MG_DIKE_SLUG] = array_merge($sc[MG_DIKE_SLUG], array('mgom-item-attr', 'mgom-type-txt', 'mgom-mgaf-sect'));
        return $sc;
    }
    add_filter('dike_lcweb_sc', 'mgom_dike_plc_sc');
}



////////////
// REQUIRE RIGHT MG VERSION
function mgom_requirements_check() {
    $req_v = '7.5.3';

    if(!defined('MG_VER') || version_compare(MG_VER, $req_v, '<')) {
        deactivate_plugins( plugin_basename( __FILE__ ) );

        $btn = '<br/><a href="'. esc_attr(network_admin_url('plugins.php')) .'">'. esc_html__('Return to plugins page', MGOM_ML) .'</a>';
        wp_die('Overlay Manager add-on '. esc_html__('requires at least', MGOM_ML) .' Media Grid v'. $req_v .' '. __('installed', MGOM_ML) .'!'. $btn);	
    }
}
register_activation_hook(__FILE__, 'mgom_requirements_check');
add_action('admin_init', 'mgom_requirements_check', 1);