<?php
////////////////////////////////////////////////
////// ADD OVERLAY TERM ////////////////////////
////////////////////////////////////////////////

function mgom_add_ol_term() {
	if(!isset($_POST['lcwp_nonce']) || !wp_verify_nonce($_POST['lcwp_nonce'], 'lcwp_nonce')) {
        wp_die(json_encode(array(
            'status'    => 'error',
            'message'   => 'Cheating?'
        )));
    }
	if(!isset($_POST['ol_name'])) {
        wp_die(json_encode(array(
            'status'    => 'error',
            'message'   => 'Overlay name missing'
        )));
    }
	$name = $_POST['ol_name'];
	
	$resp = wp_insert_term($name, 'mgom_overlays', array(
        'slug'  => sanitize_title($name))
    );
	
	if(is_array($resp)) {
        wp_die(json_encode(array(
            'status'    => 'success',
            'term_id'   => $resp['term_id']
        )));
    }
	else {
		$err_mes = $resp->errors['term_exists'][0];
        
        wp_die(json_encode(array(
            'status'    => 'error',
            'message'   => $err_mes
        )));
	}
}
add_action('wp_ajax_mgom_add_ol_term', 'mgom_add_ol_term');





////////////////////////////////////////////////
////// RENAME OVERLAY TERM /////////////////////
////////////////////////////////////////////////

function mgom_rename_ol() {
	if(!isset($_POST['lcwp_nonce']) || !wp_verify_nonce($_POST['lcwp_nonce'], 'lcwp_nonce')) {
        wp_die('Cheating?');
    }
	if(!isset($_POST['ol_id']) || !isset($_POST['new_name']) || empty($_POST['new_name'])) {
        wp_die('data is missing');
    }

	$ol_id = (int)$_POST['ol_id'];
	$name = $_POST['new_name'];
	
	
	// check if name is already taken
	$check = get_term_by('name', $name, 'mgom_overlays');
	if($check && $check->term_id != $ol_id) {
		wp_die( __('Another overlay has this name', MGOM_ML) );	
	}

	// update
	$args = array(
  		'name' => $name,
	);
	$resp = wp_update_term($ol_id, 'mgom_overlays', $args);
	
	if(is_wp_error($resp)) {
		echo $resp->get_error_message();
		wp_die();
	} 
	else {	
		wp_die('success');
	}
}
add_action('wp_ajax_mgom_rename_ol', 'mgom_rename_ol');





////////////////////////////////////////////////
////// CLONE OVERLAY TERM //////////////////////
////////////////////////////////////////////////

function mgom_clone_ol() {
    if(!isset($_POST['lcwp_nonce']) || !wp_verify_nonce($_POST['lcwp_nonce'], 'lcwp_nonce')) {
        wp_die(json_encode(array(
            'status'    => 'error',
            'message'   => 'Cheating?'
        )));
    }
    
	if(!isset($_POST['ol_id']) || !isset($_POST['new_name']) || empty($_POST['new_name'])) {
        wp_die(json_encode(array(
            'status'    => 'error',
            'message'   => __('Overlay ID missing', MGOM_ML)
        )));
    }
	
	$ol_id = (int)$_POST['ol_id'];
	$name = $_POST['new_name'];
	
	$to_clone = get_term($ol_id, 'mgom_overlays');
	if(empty($to_clone) || is_wp_error($to_clone)) {
        wp_die(json_encode(array(
            'status'    => 'error',
            'message'   => __('Source overlay not found', MGOM_ML)
        )));
	}
	
	
	$resp = wp_insert_term($name, 'mgom_overlays', array(
		'slug' 			=> sanitize_title($name),
		'description' 	=> $to_clone->description
	));
	
	if(is_wp_error($resp)) {
        wp_die(json_encode(array(
            'status'    => 'error',
            'message'   => $resp->get_error_message()
        )));
	} 
	else {
		if(!get_option('mg_inline_css') && class_exists('mg_static') && method_exists('mg_static', 'create_frontend_css')) {
            mg_static::create_frontend_css(); 
        }
		
        wp_die(json_encode(array(
            'status'    => 'success',
            'term_id'   => $resp['term_id']
        )));
	}
}
add_action('wp_ajax_mgom_clone_ol', 'mgom_clone_ol');





////////////////////////////////////////////////
////// DELETE OVERLAY TERM /////////////////////
////////////////////////////////////////////////

function mgom_del_ol_term() {
    if(!isset($_POST['lcwp_nonce']) || !wp_verify_nonce($_POST['lcwp_nonce'], 'lcwp_nonce')) {
        wp_die('Cheating?');
    }
    
	if(!isset($_POST['ol_id'])) {
        wp_die('data is missing');
    }
	$id = (int)$_POST['ol_id'];
    
	$resp = wp_delete_term($id, 'mgom_overlays');
	($resp === true) ? wp_die('success') : wp_die( __('error during the overlay deletion', MGOM_ML));
}
add_action('wp_ajax_mgom_del_ol_term', 'mgom_del_ol_term');






////////////////////////////////////////////////
////// DISPLAY OVERLAY BUILDER /////////////////
////////////////////////////////////////////////

function mgom_ol_builder() {
    if(!isset($_POST['lcwp_nonce']) || !wp_verify_nonce($_POST['lcwp_nonce'], 'lcwp_nonce')) {
        wp_die('Cheating?');
    }
    
	if(!isset($_POST['ol_id'])) {wp_die('data is missing');}
	$ol_id = addslashes($_POST['ol_id']);

	// get term and unserialize contents
	$ol = get_term($ol_id, 'mgom_overlays');
	$data = (empty($ol->description)) ? '' : unserialize(mgom_static::fix_serialization($ol->description));
	
	// graphic and textual arrays
	$graphic   = (empty($data)) ? array() : $data['graphic'];
	$txt       = (empty($data)) ? array() : $data['txt'];
	$img_fx    = (empty($data) || !isset($data['img_fx'])) ? array() : $data['img_fx'];
    $custom_css= (empty($data) || !isset($data['custom_css'])) ? '' : $data['custom_css'];
    
	
	////////////////////////////////
	// graphical elements //////////
	?>
    <div id="mgom_graphic_layers" class="postbox">
        <div class="postbox-header">
            <h2 class="hndle"><?php _e('Graphical elements', MGOM_ML) ?></h2>
        </div>
        <div class="inside">

            <div class="mg_mainbox_meta">
                <div class="mgom_add_layer">
                    <span><?php _e('Add new layer', MGOM_ML) ?></span> 

                    <select class="mg_lcsel_dd" autocomplete="off">
                        <?php 
                        $graph_types = mgom_static::graphic_types();
                        asort($graph_types);
        
                        foreach($graph_types as $k => $v) {
                            echo '<option value="'. esc_attr($k) .'">'. esc_html($v) .'</option>';	
                        }
                        ?>
                    </select>
                    <input type="button" class="button-secondary" value="<?php esc_attr_e('Add', MGOM_ML) ?>" />
                </div>
                <div class="mgom_elements">
                    <?php echo mgom_static::saved_to_blocks($graphic); ?>
                </div>
            </div> 

        </div>
    </div>

    <?php
    ////////////////////////////////
	// textual elements ////////////
	?>
    <div id="mgom_txt_layers" class="postbox">
        <div class="postbox-header">
            <h2 class="hndle"><?php _e('Textual elements', MGOM_ML) ?></h2>
        </div>
        
        <div class="inside">

            <div class="mg_mainbox_meta">
                <div class="mgom_add_layer">
                    <span><?php _e('Add new element', MGOM_ML) ?></span> 

                    <select class="mg_lcsel_dd" autocomplete="off">
                        <?php 
                        $txt_types = mgom_static::txt_types();
                        asort($txt_types);
    
                        unset( $txt_types['txt_block'] );

                        foreach($txt_types as $k => $v) {
                            echo '<option value="'. esc_attr($k) .'">'. esc_html($v) .'</option>';	
                        }
                        ?>
                    </select>
                    <input type="button" class="button-secondary" value="<?php esc_attr_e('Add', MGOM_ML) ?>" />
                </div>
                <div class="mgom_elements">
                    <?php 
                    echo mgom_static::saved_to_blocks($txt);

                    // text block - mandatory
                    $values = (isset($txt['txt_block'])) ? $txt['txt_block'] : array();             
                    echo mgom_static::type_block('txt_block', $values); 
                    ?>
                </div>
            </div>
        </div>        
    </div>
    

    <?php
    ////////////////////////////////
	// image effects ////////////
	?>
    <div id="mgom_img_fx" class="postbox">
        <div class="postbox-header">
            <h2 class="hndle"><?php _e('Image effects', MGOM_ML) ?></h2>
        </div>
        
        <div class="inside">
            <div class="mg_mainbox_meta">
                <?php       
                echo mgom_static::type_block('img_fx', $img_fx); 
                ?>
            </div>
        </div>        
    </div>


    <?php
    ////////////////////////////////
	// custom CSS ////////////
	?>
    <div id="mgom_custom_css" class="postbox">
        <div class="postbox-header">
            <h2 class="hndle"><?php _e('Custom CSS', MGOM_ML) ?></h2>
        </div>
        
        <div class="inside">
            <div class="mg_mainbox_meta">
                <?php       
                echo mgom_static::type_block('custom_css', $custom_css); 
                ?>
            </div>
        </div>        
    </div>
	<?php
	wp_die();
}
add_action('wp_ajax_mgom_ol_builder', 'mgom_ol_builder');




////////////////////////////////////////////////
////// ADD LAYER TO OVERLAY ////////////////////
////////////////////////////////////////////////

function mgom_add_layer() {
    if(!isset($_POST['lcwp_nonce']) || !wp_verify_nonce($_POST['lcwp_nonce'], 'lcwp_nonce')) {
        wp_die('Cheating?');
    }
    
	if(!isset($_POST['mgom_type'])) {
        wp_die('data is missing');
    }
	$type = addslashes($_POST['mgom_type']);
	
	wp_die( mgom_static::type_block($type, array()) );
}
add_action('wp_ajax_mgom_add_layer', 'mgom_add_layer');




////////////////////////////////////////////////
////// SAVE OVERLAY ////////////////////////////
////////////////////////////////////////////////

function mgom_save_ol() {
    if(!isset($_POST['lcwp_nonce']) || !wp_verify_nonce($_POST['lcwp_nonce'], 'lcwp_nonce')) {
        wp_die('Cheating?');
    }
    
	if(!isset($_POST['ol_id']) || !isset($_POST['ol_data'])) {
        wp_die('data is missing');
    }
    
	$ol_id = $_POST['ol_id'];
	$ol_data = json_decode(rawurldecode(stripslashes($_POST['ol_data'])));

	// JS objects to array
	$true_data = mgom_static::js_ajax_sanitize($ol_data);	
	
	// save
	$result = wp_update_term($ol_id, 'mgom_overlays', array(
	  'description' => serialize($true_data)
	));
	
	if ( is_wp_error($result) ) {
  		echo $result->get_error_message();
	}
	else {

		// create dynamic CSS file for the overlay
		if(!get_option('mg_inline_css') && class_exists('mg_static') && method_exists('mg_static', 'create_frontend_css')) {
            mg_static::create_frontend_css(); 
        }

		
		//echo serialize($true_data); // get data for preset styles
		echo 'success';	
	}
	
	wp_die();
}
add_action('wp_ajax_mgom_save_ol', 'mgom_save_ol');




////////////////////////////////////////////////
////// PREVIEW OVERLAY /////////////////////////
////////////////////////////////////////////////

function mgom_live_preview() {
    if(!isset($_POST['lcwp_nonce']) || !wp_verify_nonce($_POST['lcwp_nonce'], 'lcwp_nonce')) {
        wp_die('Cheating?');
    }
    
	if(!isset($_POST['ol_id'])) {wp_die('data is missing');}
	$id = (int)$_POST['ol_id'];
	
	$txt_under = (isset($_POST['txt_under']) && $_POST['txt_under']) ? 1 : 0;
	$iframe_h = ($txt_under) ? 430 : 194;

	echo '<iframe src="'.MGOM_URL.'/live_preview.php?ol_id='.$id.'&txt_under='.$txt_under.'&abspath='.urlencode(ABSPATH).'" height="'.$iframe_h.'" frameborder="0"></iframe>';
	wp_die();
}
add_action('wp_ajax_mgom_live_preview', 'mgom_live_preview');

