<?php
dike_lc('lcweb', MGOM_DIKE_SLUG, true);
?>

<div class="wrap mg_form">  
    <h1 class="mg_page_title">
        Media Grid - <?php _e( 'Overlay Manager', MGOM_ML) ?>
        <a href="javascript:void(0)" class="page-title-action mgom_add_ol_btn"><?php _e('Add New Overlay', MG_ML) ?></a>
    </h1>  

    <form id="poststuff" class="form-wrap">
        
        <?php // OVERLAYS DROPDOWN AND MAIN BUTTONS TO PREVIEW AND SAVE ?>
        <div id="mgom_ol_choice">
            <select name="mgom_selected_ol" class="mgom_selected_ol" autocomplete="off" data-placeholder="<?php esc_attr_e('select an overlay', MGOM_ML) ?>">
                <?php 
                foreach(mgom_static::ol_list() as $ol_id => $ol_name) {
                    echo '<option value="'. $ol_id .'">'. $ol_name .'</option>';    
                }
                ?>    
            </select>

            <div id="mgom_builder_ol_cmd_wrap" class="mg_displaynone">
                <span class="mgom_rename_ol mg_move_row dashicons dashicons-edit" title="<?php esc_attr_e('rename overlay') ?>"></span> 
                <span class="mgom_clone_ol mg_move_row dashicons dashicons-admin-page" title="<?php esc_attr_e('clone overlay') ?>"></span> 
                <span class="mgom_del_ol mg_del_row dashicons dashicons-no-alt" title="<?php esc_attr_e('delete overlay') ?>"></span>    
                <span></span>
                <span class="mgom_export_ol mg_move_row dashicons dashicons-database-export" title="<?php esc_attr_e('export overlay JSON data') ?>"></span>    
                <span class="mgom_import_ol mg_move_row dashicons dashicons-database-import" title="<?php esc_attr_e('import overlay JSON data') ?>"></span>    
            </div>  
        </div>



        <div id="mgom_builder_wrap">

            <?php // PAGE CONTENT ?>
            <div id="mgom_builder_main">
                <div id="post-body-content" class="mg_displaynone"></div>
            </div>
            
            <?php // SIDEBAR ?>
            <div id="mgom_builder_sidebar">
                <div id="mgom_preview" class="postbox mg_displaynone">
                    <h3 class="hndle">
                        <?php _e('Preview', MGOM_ML) ?> 
                        <a id="mgom_txt_under_toggle" href="javascript:void(0)"><?php _e('text-under', MGOM_ML) ?> <span>OFF</span></a>
                    </h3> 
                    <div class="inside" data-error-txt="<?php esc_attr_e("Fill and check everything to see the preview", MGOM_ML) ?>"></div>
                    <div id="mgom_save_to_preview"><span><?php _e('save to preview the overlay', MGOM_ML) ?></span></div>
                </div>

                <div id="save_ol_box" class="postbox mg_sidebox_meta">
                    <input type="button" name="save-overlay" value="<?php esc_attr_e('Save overlay', MGOM_ML) ?>" class="button-primary" />
                    <input type="button" name="mgom_discard_changes" value="<?php esc_attr_e('Discard changes', MGOM_ML) ?>" class="button-secondary" />
                    <div></div>
                </div>
            </div>
            
        </div>  
    </form>
</div>  




<?php // SCRIPTS ?>
<script type="text/javascript">
(function($) { 
    "use strict";
    
    let sel_ol                  = false,
        is_loading_ol           = false,
        is_adding_layer         = false,
        ajax_acting_in_popup    = false,
        txt_under               = false,
        custom_css_f            = false,
        nonce                   = '<?php echo wp_create_nonce('lcwp_nonce') ?>';

    $(document).ready(function($) {

        // overlay selection dropdown
        new lc_select('.mgom_selected_ol', {
            wrap_width      : 'calc(100% - 200px)',
            addit_classes   : ['lcslt-lcwp', 'mgom_ol_select'],
            autofocus_search: true,
            pre_placeh_opt  : true, 
            labels : [ 
                '<?php esc_attr_e('search overlays', MGOM_ML) ?>',
                'add options',
                'Select options ..',
                '.. <?php esc_attr_e('no matching overlays', MGOM_ML) ?> ..',
            ],
        });
        
        
        // prepend overlays ID into the dropdown context
        const ol_ids_in_dd = function() {
            $('.mgom_ol_select .lcslt-dd-opt').each(function() {
                if($(this).find('span em').length) {
                    return true;    
                }

                const curr_txt = $(this).find('span').text();
                $(this).find('span').html('<em>'+ $(this).data('val') +'</em>' + curr_txt);
            });    
        };
        
        $(document).on('click', '.lcslt-f-mgom_selected_ol', function() {
            ol_ids_in_dd();
        });
        
        
        
        // refresh lc-select for overlay choice
        const resync_ol_select_dd = function() {
            const resyncEvent = new Event('lc-select-refresh');
            $('.mgom_selected_ol')[0].dispatchEvent(resyncEvent);    
            
            const reSelEvent = new Event('change');
            $('.mgom_selected_ol')[0].dispatchEvent(reSelEvent);    
        };
        
        

        ///////////////////////////
        
        
          
        // add overlay
        $('.mgom_add_ol_btn').on('click', function() {
            if(ajax_acting_in_popup) {
                return false;
            }

            var html = 
            "<form id='mgom_add_ol_form'><input type='text' placeholder='<?php esc_attr_e("Overlay name", MG_ML) ?> ..' autocomplete='off' maxlength='100' />"+
            "<input type='button' value='<?php esc_attr_e('Add Overlay', MG_ML) ?>' class='button-primary' />"+
            "<input type='button' value='<?php esc_attr_e('Close', MG_ML) ?>' class='button-secondary' /></form>";

            lc_wp_popup_message('modal', html);
        });
        $(document).on('click', '#mgom_add_ol_form .button-secondary', function() {
            if(ajax_acting_in_popup) {
                return false;
            }
            lcwpm_close();
        });


        // perform addition
        $(document).on('click', '#mgom_add_ol_form .button-primary', function() {
            $('.mg_toast_ajax_response').remove();
            
            const ol_name = $.trim($('#mgom_add_ol_form input[type=text]').val());
            if(!$.trim(ol_name)) {
                return false;
            }

            ajax_acting_in_popup = true;
            $('#mgom_add_ol_form input[type=text]').attr('disabled', 'disabled');

            var data = {
                action      : 'mgom_add_ol_term',
                ol_name     : ol_name,
                lcwp_nonce  : nonce,
            };
            $.post(ajaxurl, data, function(response) {
                try {
                    var resp = $.parseJSON(response);

                    if(resp.status == 'error') {
                        $('#mgom_add_ol_form input[type=text]').after('<div class="mg_toast_ajax_response mg_tar_error">'+ resp.message +'</div>');   
                    }
                    else {
                        $('.mgom_selected_ol option[data-lcslt-placeh="1"]').after('<option value="'+ resp.term_id +'">'+ ol_name +'</option>');
                        
                        // select it
                        $('.mgom_selected_ol option').removeAttr('selected');
                        $('.mgom_selected_ol option[value="'+ resp.term_id +'"]')[0].selected = true;
                        
                        resync_ol_select_dd();
                        
                        $('#mgom_add_ol_form input[type=text]').after('<div class="mg_toast_ajax_response mg_tar_success"><?php esc_attr_e('Overlay successfully added!', MGOM_ML) ?></div>');  
                        
                        setTimeout(function() {
                            lcwpm_close();
                        }, 1200);
                    }
                }
                catch(e) {
                    console.error(e);
                    $('#mgom_add_ol_form input[type=text]').after('<div class="mg_toast_ajax_response mg_tar_error"><?php esc_attr_e("Error creating the overlay", MGOM_ML) ?></div>');  
                }
            })
            .fail(function(e) {
                console.error(e);
                $('#mgom_add_ol_form input[type=text]').after('<div class="mg_toast_ajax_response mg_tar_error"><?php esc_attr_e("Error creating the overlay", MGOM_ML) ?></div>');  
            })
            .always(function() {
                ajax_acting_in_popup = false;
                $('#mgom_add_ol_form input[type=text]').removeAttr('disabled');
            });	
        });



        // clone overlay
        $(document).on('click', '.mgom_clone_ol', function() {
            if(ajax_acting_in_popup) {
                return false;
            }

            var html = 
            "<form id='mgom_clone_ol_form'><input type='text' placeholder='<?php esc_attr_e("Cloned overlay name", MGOM_ML) ?> ..' autocomplete='off' maxlength='100' />"+
            "<input type='button' value='<?php esc_attr_e('Clone', MGOM_ML) ?>' class='button-primary' />"+
            "<input type='button' value='<?php esc_attr_e('Close', MGOM_ML) ?>' class='button-secondary' /></form>";

            lc_wp_popup_message('modal', html);
        });
        $(document).on('click', '#mgom_clone_ol_form .button-secondary', function() {
            if(ajax_acting_in_popup) {
                return false;
            }
            lcwpm_close();
        });


        // perform cloning
        $(document).on('click', '#mgom_clone_ol_form .button-primary', function() {
            $('.mg_toast_ajax_response').remove();

            var new_name = $('#mgom_clone_ol_form input[type=text]').val();
            if(!$.trim(new_name)) {
                return false;
            }

            ajax_acting_in_popup = true;
            $('#mgom_clone_ol_form input[type=text]').attr('disabled', 'disabled');

            var data = {
                action       : 'mgom_clone_ol',
                ol_id        : sel_ol,
                new_name     : new_name,
                lcwp_nonce   : nonce,
            };

            $.post(ajaxurl, data, function(response) {
                try {
                    var resp = $.parseJSON(response);

                    if(resp.status == 'error') {
                        $('#mgom_clone_ol_form input[type=text]').after('<div class="mg_toast_ajax_response mg_tar_error">'+ resp.message +'</div>');   
                    }
                    else {
                        $('.mgom_selected_ol option[data-lcslt-placeh="1"]').after('<option value="'+ resp.term_id +'">'+ new_name +'</option>');
                        
                        // select it
                        $('.mgom_selected_ol option').removeAttr('selected');
                        $('.mgom_selected_ol option[value="'+ resp.term_id +'"]')[0].selected = true;
                        
                        resync_ol_select_dd();

                        $('#mgom_clone_ol_form input[type=text]').after('<div class="mg_toast_ajax_response mg_tar_success"><?php esc_attr_e('Overlay successfully cloned!', MGOM_ML) ?></div>');  
                        
                        setTimeout(function() {
                            lcwpm_close();
                        }, 1200);
                    }
                }
                catch(e) {
                    console.error(e);
                    $('#mgom_clone_ol_form input[type=text]').after('<div class="mg_toast_ajax_response mg_tar_error"><?php esc_attr_e("Error cloning the overlay", MGOM_ML) ?></div>');  
                }
            })
            .fail(function(e) {
                console.error(e);
                $('#mgom_clone_ol_form input[type=text]').after('<div class="mg_toast_ajax_response mg_tar_error"><?php esc_attr_e("Error cloning the overlay", MGOM_ML) ?></div>'); 
            })
            .always(function() {
                ajax_acting_in_popup = false;
                $('#mgom_clone_ol_form input[type=text]').removeAttr('disabled');
            });
        });



        // rename overlay
        $(document).on('click', '.mgom_rename_ol', function() {
            if(ajax_acting_in_popup) {
                return false;
            }
            var curr_name = $('.lcslt-f-mgom_selected_ol span').text(); 

            var html = 
            "<form id='mgom_rename_ol_form'><input type='text' value='"+ curr_name +"' placeholder='<?php esc_attr_e("New overlay name", MGOM_ML) ?> ..' autocomplete='off' maxlength='100' />"+
            "<input type='button' value='<?php esc_attr_e('Rename', MGOM_ML) ?>' class='button-primary' />"+
            "<input type='button' value='<?php esc_attr_e('Close', MGOM_ML) ?>' class='button-secondary' /></form>";

            lc_wp_popup_message('modal', html);
        });
        $(document).on('click', '#mgom_rename_ol_form .button-secondary', function() {
            if(ajax_acting_in_popup) {
                return false;
            }
            lcwpm_close();
        });


        // perform renaming
        $(document).on('click', '#mgom_rename_ol_form .button-primary', function() {
            $('.mg_toast_ajax_response').remove();

            var old_name = $('.lcslt-f-mgom_selected_ol span').text();
            var new_name = $.trim($('#mgom_rename_ol_form input[type=text]').val());
            if(!$.trim(new_name) || old_name === new_name) {
                return false;
            }

            ajax_acting_in_popup = true;
            $('#mgom_rename_ol_form input[type=text]').attr('disabled', 'disabled');

            var data = {
                action       : 'mgom_rename_ol',
                ol_id        : sel_ol,
                new_name     : new_name,
                lcwp_nonce   : nonce,
            };

            $.post(ajaxurl, data, function(response) {
                if($.trim(response) == 'success') {
                    $('.mgom_selected_ol option[value="'+ sel_ol +'"]').text( new_name );
                    resync_ol_select_dd();

                    $('#mgom_rename_ol_form input[type=text]').after('<div class="mg_toast_ajax_response mg_tar_success"><?php esc_attr_e('Overlay successfully renamed!', MGOM_ML) ?></div>');

                    setTimeout(function() {
                        lcwpm_close();
                    }, 1200);
                } 
                else {
                    $('#mgom_rename_ol_form input[type=text]').after('<div class="mg_toast_ajax_response mg_tar_error">'+ response +'</div>');
                }
            })
            .fail(function(e) {
                console.error(e);
                $('#mgom_rename_ol_form input[type=text]').after('<div class="mg_toast_ajax_response mg_tar_error"><?php esc_attr_e("Error renaming the overlay", MGOM_ML) ?></div>');
            })
            .always(function() {
                ajax_acting_in_popup = false;
                $('#mgom_rename_ol_form input[type=text]').removeAttr('disabled');
            });
        });



        // delete overlay
        $(document).on('click', '.mgom_del_ol', function() {
            if(ajax_acting_in_popup || is_loading_ol || !confirm('<?php esc_attr_e('This will DEFINITIVELY delete the overlay. Continue?', MGOM_ML) ?>')) {
                return false;    
            }
                
            is_loading_ol = true;
            ajax_acting_in_popup = true;

            $('.lcslt-f-mgom_selected_ol span').fadeTo(200, 0.5);

            var data = {
                action      : 'mgom_del_ol_term',
                ol_id       : sel_ol,
                lcwp_nonce  : nonce,
            };
            $.post(ajaxurl, data, function(response) {
                if($.trim(response) == 'success') {

                    $('.mgom_selected_ol option[value="'+ sel_ol +'"]').remove();
                    resync_ol_select_dd();
                    
                    $('#mgom_builder_main > *').empty();
                    $('#mgom_builder_ol_cmd_wrap, #mgom_builder_main > *, #mgom_builder_sidebar').addClass('mg_displaynone');
                }
                else {
                    lc_wp_popup_message('error', response);
                }
            })
            .fail(function(e) {
                console.error(e);
                lc_wp_popup_message('error', "<?php esc_attr_e("Error deleting the overlay", MGOM_ML) ?>");
            })
            .always(function() {
                $('.lcslt-f-mgom_selected_ol span').fadeTo(200, 1);
                
                is_loading_ol = false;
                ajax_acting_in_popup = false;
            });	
        });
        
        
        
        // export overlay data in JSON (copy to clipboard)
        $(document).on('click', '.mgom_export_ol', function() {
            const $temp = $("<input>");
            $("body").append($temp);
            
            const val = get_overlay_data();
            $temp.val(val).select();
            
            document.execCommand("copy");
            $temp.remove();
            
            lc_wp_popup_message('success', "<?php esc_attr_e("Overlay data copied to your clipboard!", MGOM_ML) ?>");
        });
        
        
        
        // import overlay data in JSON format
        $(document).on('click', '.mgom_import_ol', function() {
            if(ajax_acting_in_popup) {
                return false;
            }

            var html = 
            "<form id='mgom_import_ol_form'><textarea placeholder='<?php esc_attr_e("Paste overlay JSON data", MGOM_ML) ?> ..' autocomplete='off'></textarea>"+
            "<input type='button' value='<?php esc_attr_e('Import', MGOM_ML) ?>' class='button-primary' />"+
            "<input type='button' value='<?php esc_attr_e('Close', MGOM_ML) ?>' class='button-secondary' /></form>";

            lc_wp_popup_message('modal', html);
        });
        $(document).on('click', '#mgom_import_ol_form .button-secondary', function() {
            if(ajax_acting_in_popup) {
                return false;
            }
            lcwpm_close();
        });


        // perform import
        $(document).on('click', '#mgom_import_ol_form .button-primary', function() {
            $('.mg_toast_ajax_response').remove();
            const $textarea = $('#mgom_import_ol_form textarea');
            
            var import_data = encodeURIComponent( $.trim($textarea.val()) );
            if(!import_data) {
                return false;
            }

            ajax_acting_in_popup = true;
            $textarea.attr('disabled', 'disabled');

            var data = {
                action      : 'mgom_save_ol',
                ol_id       : sel_ol,
                ol_data     : import_data,
                lcwp_nonce  : '<?php echo wp_create_nonce('lcwp_nonce') ?>'
            };

            $.post(ajaxurl, data, function(response) {
                if($.trim(response) == 'success') {
                    $textarea.after('<div class="mg_toast_ajax_response mg_tar_success"><?php esc_attr_e('Overlay data successfully imported!', MGOM_ML) ?></div>');

                    setTimeout(function() {
                        lcwpm_close();
                        $('.mgom_selected_ol').trigger('change');   
                    }, 1200);
                } 
                else {
                    $textarea.after('<div class="mg_toast_ajax_response mg_tar_error">'+ response +'</div>');
                }
            })
            .fail(function(e) {
                console.error(e);
                $textarea.after('<div class="mg_toast_ajax_response mg_tar_error"><?php esc_attr_e("Error importing overlay data", MGOM_ML) ?></div>');
            })
            .always(function() {
                ajax_acting_in_popup = false;
                $textarea.removeAttr('disabled');
            });
        });


        ///////////////////////////
        

        

        // select an overlay
        $('.mgom_selected_ol').on('change', function() {
            sel_ol = parseInt($(this).val(), 10);
            
            $('#mgom_builder_main > *').empty();
            $('#mgom_builder_ol_cmd_wrap, #mgom_builder_main > *, #mgom_builder_sidebar').addClass('mg_displaynone');
            
            // hide overlay preview
            if($('#mgom_preview').is(':visible')) {
                $('#mgom_preview, #mgom_save_to_preview').hide();
                $('#mgom_preview').find('.inside').empty();	
            }

            is_loading_ol = true;
            $('#mgom_builder_wrap').after('<div class="mg_spinner mg_spinner_big mgom_spinner_big"></div>');

            var data = {
                action      : 'mgom_ol_builder',
                ol_id       : sel_ol,
                lcwp_nonce  : '<?php echo wp_create_nonce('lcwp_nonce') ?>'
            };

            $.post(ajaxurl, data, function(response) {
                $('#mgom_builder_main > *').html(response);
                $('#mgom_builder_ol_cmd_wrap, #mgom_builder_main > *, #mgom_builder_sidebar').removeClass('mg_displaynone');
                
                mgom_set_css_selectors();
                mgom_async_form();
                mgom_sort_layers();

                // reset text under toggle
                txt_under = false;
                $('#mgom_txt_under_toggle').removeClass('mgom_active');
                $('#mgom_txt_under_toggle span').text('OFF');

                // text block - button - note to support transparent - TODO CHECK 
                $('.tb_button .mgom_f_bg_color, .tb_button .mgom_f_bg_color_h').parents('div.mgom_field').find('label').append(' <small>(<?php esc_attr_e('supports "transparent"', MGOM_ML) ?>)</small>');

                // save and preview boxes
                $('#save_ol_box, #mgom_preview').fadeIn();

                mgom_live_preview(true);
            })
            .fail(function(e) {
                console.error(e);
                lc_wp_popup_message('error', "<?php esc_attr_e("Error loading overlay data", MGOM_ML) ?>");
            })
            .always(function() {
                is_loading_ol = false;   
                $('.mgom_spinner_big').remove();
            });	
        });
        
        
        
        /* keep sidebar elements always visible */
        $(window).scroll(function() {
            const initial_y_pos = $('#mgom_builder_sidebar').offset().top,
                  diff          = Math.round($(window).scrollTop() - initial_y_pos);
            
            (diff > 0) ? $('#mgom_preview').css('margin-top', diff + 45) : $('#mgom_preview').css('margin-top', 0); 
        });
        
        

        // add a layer
        $(document).on('click', '.mgom_add_layer input', function() {
            let $btn    = $(this),
                type    = $(this).parent().find('select').val(),
                $subj   = $(this).parents('.mg_mainbox_meta').first().find('.mgom_elements');
            
            if(is_adding_layer) {
                return false;    
            }

            // avoid duplicates
            if($subj.find('.tb_'+type).length) {
                lc_wp_popup_message('error', "<?php esc_attr_e('Element already added', MGOM_ML) ?>");
                return false;	
            }

            // add
            $btn.fadeTo(200, 0.6); 
            is_adding_layer = true;
            
            var data = {
                action      : 'mgom_add_layer',
                mgom_type   : type,
                lcwp_nonce  : '<?php echo wp_create_nonce('lcwp_nonce') ?>'
            };

            $.post(ajaxurl, data, function(response) {
                $subj.prepend(response);

                mgom_set_css_selectors();
                mgom_async_form();
                mgom_sort_layers();
                
                mgom_live_preview();
            })
            .fail(function(e) {
                console.error(e);
                lc_wp_popup_message('error', "<?php esc_attr_e("Error adding layer", MGOM_ML) ?>");
            })
            .always(function() {
                $btn.fadeTo(200, 1);
                is_adding_layer = false;
            });	
        });

        
        
        // retrieves overlay fields data (object), to be used in preview and saving. Returns false if there's a mandatory field empty
        const get_overlay_data = function() {
            let mgom_abort_saving   = false,
                types               = ['mgom_graphic_layers', 'mgom_txt_layers', 'mgom_img_fx'],
                graph_ol            = {},
                txt_ol              = {},
                img_fx              = {};

            // check against empty fields
            $('#post-body-content .mgom_field > input').not('.mgom_optional_f').each(function() {
                if( $.trim($(this).val()) === '') {
                    mgom_abort_saving = true;
                    return false;	
                }
            });
            if(mgom_abort_saving) {
                return false;
            }

            // get values
            $.each(types, function(k, v) {

                // for each block
                $('#'+v).find('.mgom_type_block').each(function() {
                    const type = $(this).data('type');
                    const vals = $(this).find(`
                                        .mgom_field > input, 
                                        .mgom_full_field > input, 
                                        .mgom_slider_f[type="number"],
                                        .mgom_color_f, 
                                        .mgom_check,
                                        select, 
                                        .mgom_field > textarea, 
                                        .mgom_full_field > textarea
                                `).serializeArray();

                    if(v == 'mgom_graphic_layers') {
                        graph_ol[type] = vals;
                    } 
                    else if(v == 'mgom_txt_layers') {
                        txt_ol[type] = vals;
                    }
                    else {
                        img_fx = vals;       
                    }
                });
            });

            // wrap-up
            const final_data = JSON.stringify({
                graphic     : graph_ol, 
                txt         : txt_ol,
                img_fx      : img_fx,
                custom_css  : custom_css_f.getValue()
            });
            
            return final_data;
        };
        
        

        // save overlay
        $(document).on('click', '#save_ol_box input[name="save-overlay"]', function() {
            const ol_data = get_overlay_data();
            
            if(!ol_data) {
                lc_wp_popup_message('error', "<?php esc_attr_e('One or more mandatory fields are empty', MGOM_ML) ?>");
                return false;    
            }

            $('#save_ol_box div').html('<div class="mg_spinner mg_spinner_inline"></div>');
            
            var data = {
                action      : 'mgom_save_ol',
                ol_id       : sel_ol,
                ol_data     : encodeURIComponent(ol_data),
                lcwp_nonce  : '<?php echo wp_create_nonce('lcwp_nonce') ?>'
            };

            $.post(ajaxurl, data, function(response) {
                if($.trim(response) == 'success') {
                    lc_wp_popup_message('success', "<?php esc_attr_e('Overlay saved', MGOM_ML) ?>");
                    $('input[name="mgom_discard_changes"]').hide();
                }
                else {
                    lc_wp_popup_message('error', response);
                }
            })
            .fail(function(e) {
                console.error(e);
                lc_wp_popup_message('error', "<?php esc_attr_e("Error saving the overlay", MGOM_ML) ?>");
            })
            .always(function() {
                $('#save_ol_box div').empty();	
            });	
        });


        
        // show preview
        const mgom_live_preview = function(on_ol_select = false) {
            const $subj     = $('#mgom_preview .inside'),
                  iframe_h  = (txt_under) ? 430 : 194,
                  ol_data   = get_overlay_data();
            
            (txt_under) ? $subj.addClass('mgom_txt_under_preview') : $subj.removeClass('mgom_txt_under_preview'); 
            
            
            // there are errors - show 
            if(!ol_data) {
                $subj.addClass('mgom_has_errors');
                return false;    
            }
            $subj.removeClass('mgom_has_errors');
            
            // compose iframe URL
            const txt_under_param = (txt_under) ? 1 : 0;
            const url = '<?php echo MGOM_URL ?>/live_preview.php?mgom_v=<?php urlencode(MGOM_VER) ?>&ol_id='+ sel_ol +'&txt_under='+ txt_under_param +'&abspath=<?php echo urlencode(ABSPATH) ?>&ol_data='+ encodeURIComponent( LZString.compressToEncodedURIComponent(ol_data) );
            
            $subj.html('<iframe src="'+ url +'" height="'+ iframe_h +'" width="100%" frameborder="0"></iframe>');
            
            
            // discard changes btn visibility
            (on_ol_select) ? $('input[name="mgom_discard_changes"]').hide() : $('input[name="mgom_discard_changes"]').show();
        };
        

        
        // text under toggle
        $(document).on('click', '#mgom_txt_under_toggle', function() {
            const text = (!txt_under) ? 'ON' : 'OFF';
            
            $('#mgom_txt_under_toggle span').text(text);
            txt_under = !txt_under;

            $('#mgom_txt_under_toggle').toggleClass('mgom_active');
            mgom_live_preview();
        });


        
        // discard changes reloading the overlay data
        $(document).on('click', 'input[name="mgom_discard_changes"]', function() {
            if($('#save_ol_box div').is(':empty') && confirm('<?php esc_attr_e('Discard all unsaved changes?', MGOM_ML) ?>')) {
                $('.mgom_selected_ol').trigger('change');    
            }
        });

        
        
        // blur preview on fields change
        $(document).on('keyup lcs-statuschange input change', '.mgom_field input, .mgom_field textarea, .mgom_type_block select', function() {
            if( $('.mgom_type_block').length && sel_ol != 0) {
                mgom_live_preview();
            }
        });
        
        

        //////////////////////////////////////////////

        
        
        
        // calculate CSS selector
        const mgom_set_css_selectors = function() {
            $('.mgom_type_block').each(function(k, v) {
                $(this).find('.mgom_css_selector span').text('.mgom_'+ sel_ol +'_'+ k);
            });	
        };


        // sort
        const mgom_sort_layers = function() { 
            $('.mgom_elements').sortable({
                placeholder: {
                    element: function(currentItem) {
                        return $('<div class="mgom_sortable_placeh"></div>')[0];	
                    },
                    update: function(container, p) {
                        return;
                    }
                },
                tolerance: 'pointer',
                handle: '.mg_move_row',
                items: '.mgom_type_block:not(.tb_txt_block)',
                opacity: 0.9,
                create: function() {
                    $(".mgom_elements input, .mgom_elements textarea").on('mousedown.ui-disableSelection selectstart.ui-disableSelection', function(e) {
                        e.stopImmediatePropagation();
                    });
                },
                stop: function () {
                    $(".mgom_elements input, .mgom_elements textarea").on('mousedown.ui-disableSelection selectstart.ui-disableSelection', function(e) {
                        e.stopImmediatePropagation();
                    });
                    mgom_set_css_selectors();
                },
                update: function () {
                    mgom_live_preview();
                }
            }); 
        };


        // remove  layer
        $(document).on('click', '.mgom_type_block .mg_del_row', function() {
            if(confirm('<?php esc_attr_e('Remove layer?', MGOM_ML) ?>')) {
                $(this).parents('.mgom_type_block').slideUp(function() {
                    $(this).remove();
                    mgom_set_css_selectors();
                    mgom_live_preview();
                });
            }
        });


        // collapse/expand layer options
        $(document).on('click', '.mgom_ec', function() {
            var $subj = $(this);

            if($(this).hasClass('collapsed')) {
                $(this).parents('.mgom_type_block').css('height', '100%').css('overflow', 'visible');
                $subj.toggleClass('collapsed');
            } 
            else {
                $(this).parents('.mgom_type_block').css('overflow', 'hidden').animate({'height' : 0}, 250);	

                setTimeout(function() {
                    $subj.toggleClass('collapsed');
                }, 250);
            }
        });


        
        
        //----------- EXTRA ------------//

        
        // image layer - picture selection wizard
        const mgom_pic_chooser_wizard = function() {
            var file_frame = false;
            var wp_media_post_id = wp.media.model.settings.post.id;
            var set_to_post_id = 99999999;

            $(document).on('click', '#mgom_img_ol_wizard', function(e){
                var $field = $(this).parents('.mgom_field').find('input');

                if (file_frame) {
                    file_frame.uploader.uploader.param('post_id', set_to_post_id);
                    file_frame.open();
                    return true;
                } 
                else {
                    wp.media.model.settings.post.id = set_to_post_id;
                }

                // Create media frame
                file_frame = wp.media.frames.file_frame = wp.media({
                    title: "<?php esc_attr_e('Picture chooser', MGOM_ML) ?>",
                    button: {
                        text: "<?php esc_attr_e('Select Image', MGOM_ML) ?>",
                    },
                    library : {type : 'image'},
                    multiple: false
                });

                // open the modal
                file_frame.open();

                // When an image is selected, run a callback.
                file_frame.on('select', function() {
                    const attachment = file_frame.state().get('selection').first().toJSON();
                    $field.val(attachment.url);
                    
                    mgom_live_preview();

                    // Restore main post ID
                    wp.media.model.settings.post.id = wp_media_post_id;
                });
            });
        };
        mgom_pic_chooser_wizard();


        
        // image layer set item meta value as source
        $(document).on('click', '#mgom_img_ol_use_meta', function() {
            $(this).parents('.mgom_field').find('input.mgom_f_img_ol_src').val('%MGOM-IMG-META-VAL%');    
            mgom_live_preview();
        });
        
        
        
        // async form elements init
        const mgom_async_form = function () {
            lc_switch('.mgom_check', {
                on_txt      : "<?php echo strtoupper(esc_attr__('yes')) ?>",
                off_txt     : "<?php echo strtoupper(esc_attr__('no')) ?>",   
            });
            
            
            new lc_range_n_num('.mgom_slider_f', {
                unit_width: 17    
            });

            
            new lc_select('.mgom_lcsel', {
                wrap_width : '100%',
                addit_classes : ['lcslt-lcwp'],
            });
            
            
            // colorpicker
            $('.mgom_color_f').each(function() {
                if($(this).parents('.lccp-el-wrap').length) {
                    return true;    
                }
                
                let modes = $(this).data('modes'),
                    alpha = (modes && modes.indexOf('alpha') !== -1) ? true : false;

                modes = (modes) ? modes.trim().split(' ') : [];
                modes.push('solid');

                // remove alpha mode
                const index = modes.indexOf('alpha');
                if(index !== -1) {
                  modes.splice(index, 1);
                }

                // def colors 
                let def_color = $(this).data('def-color');
                def_color = (def_color.indexOf('gradient') !== -1) ? ['#008080', def_color] : [def_color, 'linear-gradient(90deg, #ffffff 0%, #000000 100%)']; 

                new lc_color_picker('input[name="'+ $(this).attr('name') +'"]', {
                    modes           : modes,
                    transparency    : alpha,
                    no_input_mode   : false,
                    wrap_width      : '100%',
                    fallback_colors : def_color,
                    preview_style   : {
                        input_padding   : 40,
                        side            : 'right',
                        width           : 35,
                    },
                    on_change : function() {
                        mgom_live_preview()
                    },
                });
            });
            
            
            if(!$('#mgom_custom_css_f').parents('.mgom_field').find('.CodeMirror').length) {
                custom_css_f = CodeMirror.fromTextArea( $('#mgom_custom_css_f')[0], {
                    lineNumbers: true,
                    mode: "css"
                });
            }
        };
    });
    
})(jQuery); 
</script>
