<?php 
// fields builder

function mgom_fields_builder($field, $value = '', $all_vals = array()) {
	$data = mgom_types_opt($field);
	$pre_code = ($data['type'] == 'textarea') ? '<div class="mgom_full_field">' : '<div class="mgom_field">';
	$pre_code .= '<label>'.$data['label'].'</label>';
	
	$def_val = (isset($data['def'])) ? $data['def'] : '';
	if((empty($value) && $value !== '0') && isset($def_val)) {
        $value = $def_val;
    }
	
    // custom CSS - value is "all_vals"
    if($field == 'custom_css') {
        $value = $all_vals;    
    }
    
    
	$optional = (isset($data['optional'])) ? 'mgom_optional_f' : '';
	
	switch($data['type']) {

		case 'color':
            $modes = (isset($data['extra_modes']) && is_array($data['extra_modes'])) ? $data['extra_modes'] : array(); // specific modes classes
            $def_color = (isset($data['def'])) ? $data['def'] : '#bbbbbb';
            
			$code = '
			<input type="text" name="'. esc_attr($field) .'" value="'. esc_attr($value) .'" class="mgom_color_f mgom_f_'.esc_attr($field).' '.$optional.'" data-modes="'. implode(' ', $modes) .'" data-def-color="'. esc_attr($def_color) .'" autocomplete="off" />';
			break;
			
		case 'slider':
			if(!isset($data['value'])) {
                $data['value'] = '';
            }
            $respect_limits = (!isset($data['respect_limits']) || !$data['respect_limits']) ? 0 : 1;
            
            $code = '
			<input type="number" value="'. (float)$value .'" name="'. esc_attr($field) .'" class="mgom_slider_f mgom_f_'.esc_attr($field).' '.$optional.'" step="'. (float)$data['step'] .'" max="'. (float)$data['max_val'] .'" min="'. (float)$data['min_val'] .'" data-unit="'. esc_attr($data['value']) .'" data-respect-limits="'. $respect_limits .'" autocomplete="off" />';
			break;
		
		case 'select':
			if(isset($data['multiple'])) { 
				$multiple = 'multiple="multiple"';
				$mfn = '[]';
			} else {
				$multiple = '';
				$mfn = '';
			}
			
			$options = '';
			foreach($data['opts'] as $k => $v) {
				if(is_array($value)) {
					$sel = (in_array($k, $value)) ? 'selected="selected"' : ''; 
				} else {
					$sel = ($value == $k) ? 'selected="selected"' : '';	
				}
				
				$options .= '<option value="'. esc_attr($k) .'" '.$sel.'>'. esc_html($v) .'</option>';
			}
			
			$code = '
			<select name="'. esc_attr($field.$mfn) .'" class="mgom_lcsel mgom_f_'. esc_attr($field) .' '. $optional .'" '. $multiple .' autocomplete="off">
				'. $options .'
			</select> ';
			break;
			
		case 'bool':
			$sel = ($value == 1) ? 'checked="checked"' : '';
			$code = '<input type="checkbox" value="1" name="'. esc_attr($field) .'" class="mgom_check mgom_f_'. esc_attr($field) .'" '. $sel .' autocomplete="off" />';
			break;	
		
		case 'textarea':
			$code = '<textarea name="'. $field .'" class="mgom_f_'. $field .' '. $optional .'">'. htmlspecialchars_decode(esc_textarea($value)) .'</textarea>';
			break;
            
        case 'code_editor' :
            $code = '
            <textarea id="mgom_'. esc_attr($field) .'_f" name="'. esc_attr($field) .'" autocomplete="off" class="mgom_code_editor" data-language="'. esc_attr($data['language']) .'">'. htmlspecialchars_decode(esc_textarea($value)) .'</textarea>';
            break;	    
            
        case 'val_n_type' :
            $code = '
            <input type="text" class="mgom_2num_f" name="'. esc_attr($field) .'" value="'. esc_attr($value) .'" maxlength="'. (int)$data['max_val_len'] .'" autocomplete="off" />

            <select name="'. esc_attr($field) .'_type" class="mgom_2num_f" autocomplete="off">';

                $sel = (isset($all_vals[$field .'_type'])) ? $all_vals[$field .'_type'] : '';
                foreach($data['types'] as $i => $val) {
                    $code .= '<option val="'. esc_attr($i) .'" '. selected($sel, $i, false) .'>'. esc_html($val) .'</option>';	
                }

            $code .= '
            </select>';
            break;
			
		case 'padding_arr':
			if(!is_array($value)) {
                $value = array('','','','');
            }
			
			$code = '
			<input type="number" value="'. (int)$value[0] .'" name="'.$field.'[]" class="mgom_4num_f mgom_f_'.$field.' '.$optional.'" autocomplete="off" />
			<input type="number" value="'. (int)$value[1] .'" name="'.$field.'[]" class="mgom_4num_f mgom_f_'.$field.' '.$optional.'" autocomplete="off" />
			<input type="number" value="'. (int)$value[2] .'" name="'.$field.'[]" class="mgom_4num_f mgom_f_'.$field.' '.$optional.'" autocomplete="off" />
			<input type="number" value="'. (int)$value[3] .'" name="'.$field.'[]" class="mgom_4num_f mgom_f_'.$field.' '.$optional.'" autocomplete="off" />
			<span>'. $data['value'] .'</span>';
			break;
			
		case 'vert_margin_arr':
			if(!is_array($value)) {
                $value = array('','');
            }
			
			$code = '
			<input type="number" value="'. (int)$value[0] .'" name="'.$field.'[]" class="mgom_2num_f mgom_f_'.$field.' '.$optional.'" step="1" min="1" max="80" autocomplete="off" />
			<input type="number" value="'. (int)$value[1] .'" name="'.$field.'[]" class="mgom_2num_f mgom_f_'.$field.' '.$optional.'" step="1" min="1" max="80" autocomplete="off" />
			<span>'.$data['value'].'</span>';
			break;	
            
        case 'text_shadow':
        case 'text_shadow_h':
			if(!is_array($value)) {
                $value = array('0','0','0','#000');
            }
			
			$code = '
			<input type="number" value="'. (int)$value[0] .'" name="'. $field .'[]" class="mgom_4num_f mgom_f_'. $field .' '. $optional .'" autocomplete="off" />
			<input type="number" value="'. (int)$value[1] .'" name="'. $field .'[]" class="mgom_4num_f mgom_f_'. $field .' '. $optional .'" autocomplete="off" />
			<input type="number" value="'. (int)$value[2] .'" name="'. $field .'[]" class="mgom_4num_f mgom_f_'. $field .' '. $optional .'" autocomplete="off" />
            <span>px</span>
            
			<input type="color" value="'. $value[3] .'" name="'. $field .'[]" class="mgom_4num_f mgom_4num_col_f mgom_f_'. $field .' '. $optional .'" autocomplete="off" />';
			break;

		default : // text
			$code = '<input type="text" name="'.$field.'" class="mgom_f_'.$field.' '.$optional.'" value="'. esc_attr($value) .'" autocomplete="off" />';
			break;
	}
	
	return $pre_code . $code . '</div>';
}

