<?php 

// all types option - global cumulative array
function mgom_types_opt($index) {
	$opts = array(
		'cent_ol_shape' => array(
			'type' => 'select',
			'label' => __("Shape", MGOM_ML),
			'opts' => mgom_central_shapes()
		),
		'corn_ol_shape' => array(
			'type' => 'select',
			'label' => __("Shape", MGOM_ML),
			'opts' => mgom_corner_shapes()
		),
		'icon_type' => array(
			'type' => 'select',
			'label' => __("Icon type", MGOM_ML),
			'opts' => mgom_inner_icons(true)
		),
		
		
		'bg_color' => array(
			'type' => 'color',
			'label' => __("Background color", MGOM_ML),
			'def' => 'rgba(255, 255, 255, 1)',
            'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
		),
		'bg_color_h' => array(
			'type' => 'color',
			'label' => __("Background color (on hover)", MGOM_ML),
			'def' => 'rgba(255, 255, 255, 1)',
            'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
		),
		'color' => array(
			'type' => 'color',
			'label' => __("Color", MGOM_ML),
			'def' => '#222222',
            'extra_modes' => array('alpha'),
		),
		'color_h' => array(
			'type' => 'color',
			'label' => __("Color (on hover)", MGOM_ML),
			'def' => '#383838',
            'extra_modes' => array('alpha'),
		),
		'highlight' => array(
			'type' => 'color',
			'label' => __("Highlight", MGOM_ML),
			'def' => 'rgba(255, 0, 0 ,0)',
            'extra_modes' => array('alpha'),
			'optional' => true
		),
		'highlight_h' => array(
			'type' => 'color',
			'label' => __("Highlight on hover", MGOM_ML),
			'def' => 'rgba(255, 0, 0 ,0)',
            'extra_modes' => array('alpha'),
			'optional' => true
		),
		'opacity' => array(
			'type' => 'slider',
			'label' => __("Opacity", MGOM_ML),
			'min_val' => '0',
			'max_val' => '100',
			'step' => '5',
			'value' => '%',
			'def' => '70'
		),
		'opacity_h' => array(
			'type' => 'slider',
			'label' => __("Opacity (on hover)", MGOM_ML),
			'min_val' => '0',
			'max_val' => '100',
			'step' => '5',
			'value' => '%',
			'def' => '100',
			'optional' => true
		),
		
		
		'position' => array(
			'type' => 'select',
			'label' => __("Initial position", MGOM_ML),
			'opts' => mgom_positions()
		),
		'position_h' => array(
			'type' => 'select',
			'label' => __("Position (on hover)", MGOM_ML),
			'opts' => mgom_positions()
		),
		'icon_position' => array(
			'type' => 'select',
			'label' => __("Position", MGOM_ML),
			'opts' => mgom_icon_positions()
		),
		'corner_pos' => array(
			'type' => 'select',
			'label' => __("Corner", MGOM_ML),
			'opts' => mgom_corners()
		),
		'cross_pos' => array(
			'type' => 'select',
			'label' => __("Initial position", MGOM_ML),
			'opts' => mgom_positions(array('center', 'top', 'left', 'right', 'bottom', 'mouse_dir'))
		),
		'slice_pos' => array(
			'type' => 'select',
			'label' => __("Position", MGOM_ML),
			'opts' => mgom_positions(array('center', 'top', 'left', 'right', 'bottom', 'mouse_dir'))
		),
		'singl_border_side' => array(
			'type' => 'select',
			'label' => __("Border side", MGOM_ML),
			'opts' => mgom_positions(array('center', 'top-left', 'top-right', 'bottom-right', 'bottom-left', 'mouse_dir'))
		),
		'singl_border_show' => array(
			'type' => 'select',
			'label' => __("Show from", MGOM_ML),
			'opts' => mgom_positions(array('top-left', 'top-right', 'bottom-right', 'bottom-left', 'mouse_dir'))
		),
		'inner_icon' => array(
			'type' => 'select',
			'label' => __("Icon", MGOM_ML),
			'opts' => mgom_inner_icons()
		),
		'over_txt_block' => array(
			'type' => 'bool',
			'label' => __("Layer over text block?", MGOM_ML),
		),
		
		
		'img_ol_src' => array(
			'type' => 'text',
			'label' => __("Image URL", MGOM_ML) . ' <a href="javascript:void(0)" id="mgom_img_ol_wizard">('. __('set image', MGOM_ML) .')</a> <a href="javascript:void(0)" id="mgom_img_ol_use_meta">('. __('use meta', MGOM_ML) .')</a>',
		),
		'img_ol_bg_size' => array(
			'type' => 'select',
			'label' => __("Image size", MGOM_ML),
			'opts' => array(
				'auto' 		=> __("auto", MGOM_ML), 
				'cover' 	=> __("fill", MGOM_ML), 
				'contain' 	=> __("fit", MGOM_ML)
			),
		),
		'img_ol_pos' => array(
			'type' => 'select',
			'label' => __("Image position <small>(not for background-size = cover)</small>", MGOM_ML),
			'opts' => mgom_positions(array('mouse_dir')),
		),
        
        'font_size' => array(
			'type'			=> 'val_n_type',
			'label'         => __("Font size", MGOM_ML),
            'max_val_len'	=> 4,
            'def'			=> 14,
            'types' 		=> array(
                'px'	=> 'px',
                'rem'	=> 'rem',
                'vmax'	=> 'vmax',
            ),
		),
        
		'font_size_h' => array(
			'type'			=> 'val_n_type',
			'label'         => __("Font size (on hover)", MGOM_ML),
            'max_val_len'	=> 4,
            'def'			=> 14,
            'types' 		=> array(
                'px'	=> 'px',
                'rem'	=> 'rem',
                'vmax'	=> 'vmax',
            ),
            'optional' => true
		),
		
		
		'animation_time' => array(
			'type' => 'slider',
			'label' => __("Animation time", MGOM_ML),
			'min_val' => '0',
			'max_val' => '1500',
			'step' => '50',
			'value' => '<span title="milliseconds">ms</span>',
			'def' => '400'
		),
		'easing' => array(
			'type' => 'select',
			'label' => __("Animation easing", MGOM_ML),
			'opts' =>  mgom_easings()
		),
		'transitions' => array(
			'type' => 'select',
			'label' => __("Transitions", MGOM_ML),
			'opts' =>  mgom_transitions(),
			'multiple' => true,
			'optional' => true
		),
		'animation_delay' => array(
			'type' => 'slider',
			'label' => __("Animation delay", MGOM_ML),
			'min_val' => '0',
			'max_val' => '1000',
			'step' => '50',
			'value' => '<span title="milliseconds">ms</span>',
			'def' => '0'
		),
		
		
		'thickness' => array(
			'type' => 'slider',
			'label' => __("Thickness", MGOM_ML),
			'min_val' => '1',
			'max_val' => '4',
			'step' => '1',
			'value' => 'px',
			'def' => '1'
		),
		'sep_style' => array(
			'type' => 'select',
			'label' => __("Style", MGOM_ML),
			'opts' => mgom_border_styles(),
		),
		
		'socials_style' => array(
			'type' => 'select',
			'label' => __("Style", MGOM_ML),
			'opts' => mgom_social_btn_styles()
		),
		'socials_align' => array(
			'type' => 'select',
			'label' => __("Alignment", MGOM_ML),
			'opts' => mgom_socials_align()
		),
		
		
		'txt_behaviors' => array(
			'type' => 'select',
			'label' => __("Layers behavior <small>(only for bottom position)</small>", MGOM_ML),
			'opts' => mgom_txt_behaviors(),
		),
		'txt_visibility' => array(
			'type' => 'select',
			'label' => __("Texts visibility", MGOM_ML),
			'opts' =>  array(
				'always' 	=> __("always visible", MGOM_ML), 
				'hide' 		=> __("hidden by default", MGOM_ML), 
				'hide_h' 	=> __("hidden on hover", MGOM_ML)
			),
		),
		'txt_vert_center' => array(
			'type' => 'bool',
			'label' => __("Text vertically centered?", MGOM_ML),
		),
        'hide_txt_on_mobile' => array(
			'type' => 'bool',
			'label' => __("Hide text in mobile mode?", MGOM_ML),
		),
		'txt_max_h' => array(
			'type' => 'slider',
			'label' => __("Text max height", MGOM_ML),
			'min_val' => '20',
			'max_val' => '600',
			'step' => '20',
			'value' => 'px',
			'def' => '600'
		),
		'txt_padding' => array(
			'type' => 'padding_arr',
			'label' => __("Padding <small>(top right bottom left)</small>", MGOM_ML),
			'value' => 'px',
			'optional' => true
		),
		'txt_vert_margin' => array(
			'type' => 'vert_margin_arr',
			'label' => __("Vertical margins <small>(top bottom)</small>", MGOM_ML),
			'value' => 'px',
			'optional' => true
		),
		'txt_align' => array(
			'type' => 'select',
			'label' => __("Text alignment", MGOM_ML),
			'opts' => mgom_txt_align(),
		), 
		'line_height' => array(
            'type'       => 'slider',
			'label'      => __("Line-height", MGOM_ML),
			'min_val'    => '10',
			'max_val'    => '300',
			'step'       => '1',
			'value'      => '%',
			'def'        => '100'
		),
        'txt_shadow' => array(
            'type'       => 'text_shadow',
			'label'      => __("Text Shadow", MGOM_ML),
		),
        'txt_shadow_h' => array(
            'type'       => 'text_shadow',
			'label'      => __("Text Shadow (on hover)", MGOM_ML),
		),
		'txt_styles' => array(
			'type' => 'select',
			'label' => __("Text styles", MGOM_ML),
			'opts' =>  array(
				'bold' => __("bold", MGOM_ML), 
				'italic' => __("italic", MGOM_ML), 
				'uppercase' => __("uppercase", MGOM_ML)
			),
			'multiple' => true,
			'optional' => true
		),
		'font_family' => array(
			'type' => 'text',
			'label' => __("Font family", MGOM_ML),
			'optional' => true
		),
		'btn_txt' => array(
			'type' => 'text',
			'label' => __("Text", MGOM_ML)
		),
		'btn_full_width' => array(
			'type' => 'bool',
			'label' => __("Full width?", MGOM_ML)
		),
		'btn_align' => array(
			'type' => 'select',
			'label' => __("Alignment", MGOM_ML),
			'opts' => mgom_txt_align(false),
		),
        'btn_behavior' => array(
			'type' => 'bool',
			'label' => __("Link to post? (where available)", MGOM_ML)
		),
		'border_radius' => array(
			'type' => 'slider',
			'label' => __("Border radius", MGOM_ML),
			'min_val' => '0',
			'max_val' => '50',
			'step' => '1',
			'value' => 'px',
			'def' => '2'
		),
		'border_width' => array(
			'type' => 'slider',
			'label' => __("Border width", MGOM_ML),
			'min_val' => '0',
			'max_val' => '20',
			'step' => '1',
			'value' => 'px',
			'def' => '1'
		),
		'border_width_h' => array(
			'type' => 'slider',
			'label' => __("Border width (on hover)", MGOM_ML),
			'min_val' => '0',
			'max_val' => '20',
			'step' => '1',
			'value' => 'px',
			'def' => '1'
		),
		'border_style' => array(
			'type' => 'select',
			'label' => __("Border Style", MGOM_ML),
			'opts' => mgom_border_styles(),
		),
		'border_color' => array(
			'type' => 'color',
			'label' => __("Border color", MGOM_ML),
			'def' => '#444444',
            'extra_modes' => array('alpha'),
		),
		'border_color_h' => array(
			'type' => 'color',
			'label' => __("Border color (on hover)", MGOM_ML),
			'def' => '#666666',
            'extra_modes' => array('alpha'),
			'optional' => true
		),
		'cust_txt' => array(
			'type' => 'textarea',
			'label' => __("Custom text", MGOM_ML)
		),
		
		'full_img_padding' => array(
			'type' => 'slider',
			'label' => __("Edges margin", MGOM_ML),
			'min_val' => '0',
			'max_val' => '100',
			'step' => '1',
			'value' => 'px',
			'def' => '0'
		),
		'full_img_padding_h' => array(
			'type' => 'slider',
			'label' => __("Edges margin (on hover)", MGOM_ML),
			'min_val' => '0',
			'max_val' => '100',
			'step' => '1',
			'value' => 'px',
			'def' => '0'
		),
        
        
        'img_fx_behav' => array(
			'type' => 'select',
			'label' => __("Effects behavior", MGOM_ML),
			'opts' =>  array(
                ''          => __("do not apply", MGOM_ML), 
				'initial' 	=> __('apply on initial status', MGOM_ML), 
				'hover' 	=> __("apply on hover", MGOM_ML), 
				'always' 	=> __("always applied", MGOM_ML)
			),
		),
        'img_zoom' => array(
			'type'       => 'slider',
			'label'      => __("Image zoom (on hover)", MGOM_ML),
			'min_val'    => 0,
			'max_val'    => 40,
			'step'       => 1,
			'value'      => '%',
			'def'        => 0
		),
		'img_no_borders' => array(
			'type' => 'bool',
			'label' => __("Remove borders (on hover)", MGOM_ML),
		),
		'img_h_fx' => array(
			'type' => 'select',
			'label' => __("Hover extra effects", MGOM_ML),
			'opts' =>  mgom_img_h_fx(),
			'optional' => true
		),
        'blur_fx' => array(
			'type'       => 'slider',
			'label'      => __("Blur", MGOM_ML),
			'min_val'    => 0,
			'max_val'    => 10,
			'step'       => 0.1,
			'value'      => 'px',
			'def'        => 0
		),
        'brightness_fx' => array(
			'type'       => 'slider',
			'label'      => __("Brightness", MGOM_ML),
			'min_val'	=> 0,
            'max_val'	=> 400,	
            'step'		=> 1,
            'def'		=> 100,
            'value'		=> '%',
		),
        'contrast_fx' => array(
			'type'       => 'slider',
			'label'      => __("Contrast", MGOM_ML),
			'min_val'	=> 0.3,
            'max_val'	=> 10,	
            'step'		=> 0.1,
            'def'		=> 1,
            'value'		=> '<span style="opacity: 0;">-</span>',
		),
        'grayscale_fx' => array(
			'type'       => 'slider',
			'label'      => __("Grayscale", MGOM_ML),
			'min_val'	=> 0,
            'max_val'	=> 100,	
            'step'		=> 1,
            'def'		=> 0,
            'value'		=> '%',
		),
        'hue_fx' => array(
			'type'       => 'slider',
			'label'      => __("Hue-rotate", MGOM_ML),
			'min_val'	=> 0,
            'max_val'	=> 360,	
            'step'		=> 1,
            'def'		=> 0,
            'value'		=> '<span style="opacity: 0;">-</span>',
		),
        'invert_fx' => array(
			'type'       => 'slider',
			'label'      => __("Invert", MGOM_ML),
			'min_val'	=> 0,
            'max_val'	=> 100,	
            'step'		=> 1,
            'def'		=> 0,
            'value'		=> '%',
		),
        'saturate_fx' => array(
			'type'       => 'slider',
			'label'      => __("Saturation", MGOM_ML),
			'min_val'	=> 1,
            'max_val'	=> 20,	
            'step'		=> 0.1,
            'def'		=> 1,
            'value'		=> '<span style="opacity: 0;">-</span>',
		),
        'sepia_fx' => array(
			'type'       => 'slider',
			'label'      => __("Sepia", MGOM_ML),
			'min_val'	=> 0,
            'max_val'	=> 100,	
            'step'		=> 1,
            'def'		=> 0,
            'value'		=> '%',
		),
        
        
        'custom_css' => array(
            'label' 	=> __('Custom CSS', MGOM_ML),
            'type'		=> 'code_editor',
            'language'	=> 'css',
        ),
	);
	
	return $opts[$index];	
}
