<?php 

// central overlay shapes 
function mgom_central_shapes() {
	return array(
		'circle' 			=> __('circle', MGOM_ML),
		'diamond' 			=> __('diamond', MGOM_ML),
		'exagon' 			=> __('exagon', MGOM_ML),
		'octagon' 			=> __('octagon', MGOM_ML),
		'outline_circle' 	=> __('outlined circle', MGOM_ML),
		'outline_diamond' 	=> __('outlined diamond', MGOM_ML),
	);
}


// corner overlay shapes 
function mgom_corner_shapes() {
	return array(
		'corner_triangle' => __('triangle', MGOM_ML),
		'corner_square' => __('square', MGOM_ML),
		'corner_circle' => __('circle', MGOM_ML)
	);	
}


// positions
function mgom_positions($strip = array()) {
	$opts = array(
		'center' 		=> __("center", MGOM_ML),
		'top-left' 		=> __("top-left", MGOM_ML),
		'top' 			=> __("top", MGOM_ML),
		'top-right'		=> __("top-right", MGOM_ML),
		'right' 		=> __("right", MGOM_ML),
		'bottom-right' 	=> __("bottom-right", MGOM_ML),
		'bottom' 		=> __("bottom", MGOM_ML),
		'bottom-left' 	=> __("bottom-left", MGOM_ML),
		'left' 			=> __("left", MGOM_ML),
		'mouse_dir' 	=> __("on mouse direction", MGOM_ML),
	);	
	
	if(!empty($strip)) {
		foreach($strip as $to_strip) {
			if(isset($opts[$to_strip])) {
                unset($opts[$to_strip]);
            }	
		}
	}
	
	return $opts;
}


// positions
function mgom_icon_positions() {
	return array(
		'center'          => __("center", MGOM_ML),
		'top-left'        => __("top-left corner", MGOM_ML),
		'top-right'       => __("top-right corner", MGOM_ML),
		'bottom-right'    => __("bottom-right corner", MGOM_ML),
		'bottom-left'     => __("bottom-left corner", MGOM_ML)
	);	
}


// corners
function mgom_corners() {
	$opts = array(
		'top-left'        => __("top-left", MGOM_ML),
		'top-right'       => __("top-right", MGOM_ML),
		'bottom-right'    => __("bottom-right", MGOM_ML),
		'bottom-left'     => __("bottom-left", MGOM_ML)
	);	
	
	return $opts;
}


// inner icons
function mgom_inner_icons($always_icon = false) {
	$opts = array(
		'none'            => __('none', MGOM_ML),
		'subj_icon'       => __('Item type icon', MGOM_ML),
        'custom_icon'     => __("Item's custom icon", MGOM_ML),
		'magnfier_icon'   => __('Magnifier icon', MGOM_ML),
		'plus_icon'       => __('Plus icon', MGOM_ML),
		'eye_icon'        => __('Eye icon', MGOM_ML)
	);
		
	if($always_icon) {
        unset($opts['none']);
    }	
	return $opts;
}


// image hover effects
function mgom_img_h_fx() {
	return array(
		'' 				=> __("(no effect)", MGOM_ML),
		'zoom-in-hide' 	=> __("zoom-in and hide", MGOM_ML),
		'zoom-out-hide' => __("zoom-out and hide", MGOM_ML),
		
		'flip-vert' 	=> __("flip vertically", MGOM_ML),
		'flip-horiz' 	=> __("flip horizontally", MGOM_ML),
		
		'door-top'		=> __("door upward", MGOM_ML),
		'door-right'	=> __("door rightward", MGOM_ML),
		'door-bottom'	=> __("door downward", MGOM_ML),
		'door-left'		=> __("door leftward", MGOM_ML),
	);			
}


// easings
function mgom_easings() {
	return array(
		'ease' => __("ease", MGOM_ML),
		'linear' => __("linear", MGOM_ML),
		'ease-in' => __("ease-in", MGOM_ML),
		'ease-out' => __("ease-out", MGOM_ML),
		'ease-in-out' => __("ease-in-out", MGOM_ML),
		'ease-in-back' => __("ease-in-back", MGOM_ML),
		'ease-out-back' => __("ease-out-back", MGOM_ML),
		'ease-in-out-back' => __("ease-in-out-back", MGOM_ML)
	);	
}


// transions
function mgom_transitions() {
	return array(
		'zoom-in' 		=> __("zoom-in", MGOM_ML),
		'zoom-out' 		=> __("zoom-out", MGOM_ML),
		'slide-vert' 	=> __("flip vertically", MGOM_ML),
		'slide-horiz' 	=> __("flip horizontally", MGOM_ML),
		'flip-vert' 	=> __("spin vertically", MGOM_ML),
		'flip-horiz' 	=> __("spin horizontally", MGOM_ML),
		'rotate' 		=> __("rotate", MGOM_ML),
		
		'door-top'		=> __("door upward", MGOM_ML),
		'door-right'	=> __("door rightward", MGOM_ML),
		'door-bottom'	=> __("door downward", MGOM_ML),
		'door-left'		=> __("door leftward", MGOM_ML),
		
		'upward'	=> __("upward", MGOM_ML),
		'leftward'	=> __("leftward", MGOM_ML),
		'downward'	=> __("downward", MGOM_ML),
		'rightward'	=> __("rightward", MGOM_ML),
	);	
}


// text layer behaviors
function mgom_txt_behaviors() {
	return array(
		'none' 			=> __("(standard behavior)", MGOM_ML),
		'show_all' 		=> __("always visible + use contents height", MGOM_ML),
		'show_title'	=> __("always show title + use contents height", MGOM_ML),
		'show_title_fh' => __("always show title + full height", MGOM_ML),
		'hide_all' 		=> __("show on hover + use contents height", MGOM_ML),
		'sh_vert_center'=> __("slide on hover vertically centered + use contents height", MGOM_ML),
		'curtain'	 	=> __("curtain effect", MGOM_ML)
	);	
}


// text alignments
function mgom_txt_align($justify = true) {
	$opts = array(
		'left' => __("left", MGOM_ML),
		'center' => __("center", MGOM_ML),
		'right' => __("right", MGOM_ML)
	);	
	if($justify) {
		$opts['justify'] = __("justify", MGOM_ML);	
	}
	
	return $opts;
}


// social button styles
function mgom_social_btn_styles() {
	return array(
		'minimal' => __("minimal", MGOM_ML),
		'rounded' => __("rounded", MGOM_ML),
		'squared' => __("squared", MGOM_ML)
	);	
}


// socials alignment
function mgom_socials_align() {
	return array(
		'left'	 => __("left", MGOM_ML),
		'center' => __("center", MGOM_ML),
		'right'	 => __("right", MGOM_ML)
	);
}


// border styles
function mgom_border_styles() {
	return array(
		'solid' => __("solid", MGOM_ML),
		'dotted' => __("dotted", MGOM_ML),
		'dashed' => __("dashed", MGOM_ML),
		'double' => __("double", MGOM_ML)
	);
}
