<?php
// PRESET OVERLAYS ON FIRST INSTALLATION

function mgom_on_activation() {
    include_once(MGOM_DIR .'/classes/mgom_static.php');
    
	register_taxonomy_mgom();
	$presets = array();
	

	
	// full overlay + magnifier
	$presets[] = array(
		'name' => 'Full overlay + magnifier',
		'opts' => '{"graphic":{"icon":[{"name":"icon_type","value":"magnfier_icon"},{"name":"icon_position","value":"center"},{"name":"font_size","value":"35"},{"name":"font_size_type","value":"px"},{"name":"font_size_h","value":"43"},{"name":"font_size_h_type","value":"px"},{"name":"color","value":"rgba(85,85,85,0)"},{"name":"color_h","value":"#555"},{"name":"transitions[]","value":"upward"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease-out-back"},{"name":"animation_delay","value":"200"}],"full_img_layer":[{"name":"position","value":"top"},{"name":"bg_color","value":"rgba(255,255,255,0.4)"},{"name":"bg_color_h","value":"rgba(255,255,255,0.6)"},{"name":"full_img_padding","value":"0"},{"name":"full_img_padding_h","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}]},"txt":{"txt_block":[{"name":"position","value":"center"},{"name":"txt_behaviors","value":"none"},{"name":"txt_visibility","value":"always"},{"name":"bg_color","value":"#ffffff"},{"name":"bg_color_h","value":"#ffffff"},{"name":"txt_padding[]","value":"0"},{"name":"txt_padding[]","value":"0"},{"name":"txt_padding[]","value":"0"},{"name":"txt_padding[]","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"}]},"img_fx":[{"name":"img_zoom","value":"0"},{"name":"img_h_fx","value":""},{"name":"img_fx_behav","value":""},{"name":"blur_fx","value":"0"},{"name":"brightness_fx","value":"100"},{"name":"contrast_fx","value":"1"},{"name":"grayscale_fx","value":"0"},{"name":"hue_fx","value":"0"},{"name":"invert_fx","value":"0"},{"name":"saturate_fx","value":"1"},{"name":"sepia_fx","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}],"custom_css":""}'
	);
	
	
	// Rotating circle + type icon
	$presets[] = array(
		'name' => 'Rotating circle + type icon',
		'opts' => '{"graphic":{"central_shape":[{"name":"cent_ol_shape","value":"circle"},{"name":"position","value":"mouse_dir"},{"name":"bg_color","value":"rgba(79,79,79,1)"},{"name":"bg_color_h","value":"rgba(79,79,79,1)"},{"name":"opacity","value":"70"},{"name":"opacity_h","value":"100"},{"name":"inner_icon","value":"subj_icon"},{"name":"color","value":"#fdfdfd"},{"name":"over_txt_block","value":"1"},{"name":"transitions[]","value":"rotate"},{"name":"animation_time","value":"550"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}],"full_img_layer":[{"name":"position","value":"mouse_dir"},{"name":"bg_color","value":"rgba(253,253,253,0.3)"},{"name":"bg_color_h","value":"rgba(253,253,253,0.3)"},{"name":"full_img_padding","value":"0"},{"name":"full_img_padding_h","value":"0"},{"name":"animation_time","value":"550"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"150"}]},"txt":{"txt_block":[{"name":"position","value":"center"},{"name":"txt_behaviors","value":"none"},{"name":"txt_visibility","value":"always"},{"name":"bg_color","value":"#ffffff"},{"name":"bg_color_h","value":"#ffffff"},{"name":"txt_padding[]","value":"0"},{"name":"txt_padding[]","value":"0"},{"name":"txt_padding[]","value":"0"},{"name":"txt_padding[]","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"}]},"img_fx":[{"name":"img_zoom","value":"0"},{"name":"img_h_fx","value":""},{"name":"img_fx_behav","value":""},{"name":"blur_fx","value":"0"},{"name":"brightness_fx","value":"100"},{"name":"contrast_fx","value":"1"},{"name":"grayscale_fx","value":"0"},{"name":"hue_fx","value":"0"},{"name":"invert_fx","value":"0"},{"name":"saturate_fx","value":"1"},{"name":"sepia_fx","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}],"custom_css":""}'
	);
	
	
	// Mouse aware direction + title and excerpt
	$presets[] = array(
		'name' => 'Mouse aware + title and excerpt',
		'opts' => '{"graphic":{},"txt":{"title":[{"name":"txt_align","value":"center"},{"name":"font_size","value":"1.1"},{"name":"font_size_type","value":"rem"},{"name":"line_height","value":"100"},{"name":"color","value":"#fdfdfd"},{"name":"color_h","value":"#fdfdfd"},{"name":"highlight","value":"rgba(255, 0, 0 ,0)"},{"name":"highlight_h","value":"rgba(255, 0, 0 ,0)"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"#000000"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"#000000"},{"name":"txt_styles[]","value":"bold"},{"name":"txt_vert_margin[]","value":"0"},{"name":"txt_vert_margin[]","value":"15"},{"name":"font_family","value":""},{"name":"animation_delay","value":"0"}],"descr":[{"name":"txt_align","value":"center"},{"name":"font_size","value":"0.9"},{"name":"font_size_type","value":"rem"},{"name":"line_height","value":"120"},{"name":"color","value":"#ffffff"},{"name":"color_h","value":"#ffffff"},{"name":"highlight","value":"rgba(255, 0, 0 ,0)"},{"name":"highlight_h","value":"rgba(255, 0, 0 ,0)"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"#000000"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"#000000"},{"name":"txt_max_h","value":"600"},{"name":"txt_vert_margin[]","value":"0"},{"name":"txt_vert_margin[]","value":"15"},{"name":"font_family","value":""},{"name":"animation_delay","value":"0"}],"txt_block":[{"name":"position","value":"mouse_dir"},{"name":"txt_behaviors","value":"none"},{"name":"txt_visibility","value":"always"},{"name":"txt_vert_center","value":"1"},{"name":"bg_color","value":"rgba(34,34,34,0.3)"},{"name":"bg_color_h","value":"rgba(34,34,34,0.8)"},{"name":"txt_padding[]","value":"20"},{"name":"txt_padding[]","value":"20"},{"name":"txt_padding[]","value":"20"},{"name":"txt_padding[]","value":"20"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease-out"}]},"img_fx":[{"name":"img_zoom","value":"0"},{"name":"img_h_fx","value":""},{"name":"img_fx_behav","value":""},{"name":"blur_fx","value":"0"},{"name":"brightness_fx","value":"100"},{"name":"contrast_fx","value":"1"},{"name":"grayscale_fx","value":"0"},{"name":"hue_fx","value":"0"},{"name":"invert_fx","value":"0"},{"name":"saturate_fx","value":"1"},{"name":"sepia_fx","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}],"custom_css":""}'
	);
	
	
	// title + angular plus icon
	$presets[] = array(
		'name' => 'Title + angular plus icon',
		'opts' => '{"graphic":{"icon":[{"name":"icon_type","value":"plus_icon"},{"name":"icon_position","value":"bottom-right"},{"name":"font_size","value":"18"},{"name":"font_size_type","value":"px"},{"name":"font_size_h","value":"18"},{"name":"font_size_h_type","value":"px"},{"name":"color","value":"rgba(255,255,255,0.9)"},{"name":"color_h","value":"rgba(68,68,68,0.9)"},{"name":"over_txt_block","value":"1"},{"name":"animation_time","value":"200"},{"name":"easing","value":"linear"},{"name":"animation_delay","value":"0"}],"outlined_box":[{"name":"position","value":"center"},{"name":"border_width","value":"0"},{"name":"border_width_h","value":"2"},{"name":"border_color","value":"rgba(136,136,136,0.4)"},{"name":"border_color_h","value":"rgba(136,136,136,0.4)"},{"name":"full_img_padding","value":"0"},{"name":"full_img_padding_h","value":"35"},{"name":"over_txt_block","value":"1"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"300"}]},"txt":{"title":[{"name":"txt_align","value":"center"},{"name":"font_size","value":"1"},{"name":"font_size_type","value":"rem"},{"name":"line_height","value":"100"},{"name":"color","value":"#4f4f4f"},{"name":"color_h","value":"#555"},{"name":"highlight","value":"rgba(255, 0, 0 ,0)"},{"name":"highlight_h","value":"rgba(255, 0, 0 ,0)"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"#000000"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"#000000"},{"name":"txt_styles[]","value":"bold"},{"name":"txt_styles[]","value":"uppercase"},{"name":"txt_vert_margin[]","value":"0"},{"name":"txt_vert_margin[]","value":"0"},{"name":"font_family","value":""},{"name":"animation_delay","value":"150"}],"txt_block":[{"name":"position","value":"center"},{"name":"txt_behaviors","value":"none"},{"name":"txt_visibility","value":"hide"},{"name":"txt_vert_center","value":"1"},{"name":"bg_color","value":"rgba(255,255,255,0.8)"},{"name":"bg_color_h","value":"rgba(255,255,255,0.8)"},{"name":"txt_padding[]","value":"35"},{"name":"txt_padding[]","value":"35"},{"name":"txt_padding[]","value":"35"},{"name":"txt_padding[]","value":"35"},{"name":"transitions[]","value":"zoom-in"},{"name":"animation_time","value":"350"},{"name":"easing","value":"ease-out-back"}]},"img_fx":[{"name":"img_zoom","value":"0"},{"name":"img_h_fx","value":""},{"name":"img_fx_behav","value":""},{"name":"blur_fx","value":"0"},{"name":"brightness_fx","value":"100"},{"name":"contrast_fx","value":"1"},{"name":"grayscale_fx","value":"0"},{"name":"hue_fx","value":"0"},{"name":"invert_fx","value":"0"},{"name":"saturate_fx","value":"1"},{"name":"sepia_fx","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}],"custom_css":""}'
	);
	
	
	// Bottom title shown + text on hover (old Flickr)
	$presets[] = array(
		'name' => 'Bottom title shown + text on hover',
		'opts' => '{"graphic":{},"txt":{"title":[{"name":"txt_align","value":"left"},{"name":"font_size","value":"0,90"},{"name":"font_size_type","value":"rem"},{"name":"line_height","value":"100"},{"name":"color","value":"#ffffff"},{"name":"color_h","value":"#ffffff"},{"name":"highlight","value":"rgba(255, 0, 0 ,0)"},{"name":"highlight_h","value":"rgba(255, 0, 0 ,0)"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"#000000"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"#000000"},{"name":"txt_styles[]","value":"bold"},{"name":"txt_vert_margin[]","value":"0"},{"name":"txt_vert_margin[]","value":"0"},{"name":"font_family","value":""},{"name":"animation_delay","value":"0"}],"descr":[{"name":"txt_align","value":"left"},{"name":"font_size","value":"0.85"},{"name":"font_size_type","value":"rem"},{"name":"line_height","value":"130"},{"name":"color","value":"#fefefe"},{"name":"color_h","value":"#fefefe"},{"name":"highlight","value":"rgba(255, 0, 0 ,0)"},{"name":"highlight_h","value":"rgba(255, 0, 0 ,0)"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"#000000"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"#000000"},{"name":"txt_max_h","value":"600"},{"name":"txt_vert_margin[]","value":"12"},{"name":"txt_vert_margin[]","value":"0"},{"name":"font_family","value":""},{"name":"animation_delay","value":"100"}],"txt_block":[{"name":"position","value":"bottom"},{"name":"txt_behaviors","value":"show_title"},{"name":"txt_visibility","value":"always"},{"name":"bg_color","value":"rgba(21,21,21,0.7)"},{"name":"bg_color_h","value":"rgba(21,21,21,0.7)"},{"name":"txt_padding[]","value":"20"},{"name":"txt_padding[]","value":"20"},{"name":"txt_padding[]","value":"20"},{"name":"txt_padding[]","value":"20"},{"name":"animation_time","value":"500"},{"name":"easing","value":"ease"}]},"img_fx":[{"name":"img_zoom","value":"0"},{"name":"img_h_fx","value":""},{"name":"img_fx_behav","value":""},{"name":"blur_fx","value":"0"},{"name":"brightness_fx","value":"100"},{"name":"contrast_fx","value":"1"},{"name":"grayscale_fx","value":"0"},{"name":"hue_fx","value":"0"},{"name":"invert_fx","value":"0"},{"name":"saturate_fx","value":"1"},{"name":"sepia_fx","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}],"custom_css":""}'
	);
	
	
	// blur + corner circle on hover
	$presets[] = array(
		'name' => 'Blur + corner circle on hover',
		'opts' => '{"graphic":{"corner_shape":[{"name":"corn_ol_shape","value":"corner_circle"},{"name":"corner_pos","value":"bottom-right"},{"name":"bg_color","value":"#fdfdfd"},{"name":"inner_icon","value":"subj_icon"},{"name":"color","value":"#535353"},{"name":"over_txt_block","value":"1"},{"name":"animation_time","value":"500"},{"name":"easing","value":"ease-out-back"},{"name":"animation_delay","value":"250"}],"crossing_layer":[{"name":"cross_pos","value":"bottom-right"},{"name":"bg_color","value":"rgba(255,255,255,0.2)"},{"name":"bg_color_h","value":"rgba(255,255,255,0.6)"},{"name":"animation_time","value":"700"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"100"}]},"txt":{"txt_block":[{"name":"position","value":"center"},{"name":"txt_behaviors","value":"none"},{"name":"txt_visibility","value":"always"},{"name":"bg_color","value":"#ffffff"},{"name":"bg_color_h","value":"#ffffff"},{"name":"txt_padding[]","value":"0"},{"name":"txt_padding[]","value":"0"},{"name":"txt_padding[]","value":"0"},{"name":"txt_padding[]","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"}]},"img_fx":[{"name":"img_zoom","value":"0"},{"name":"img_h_fx","value":""},{"name":"img_fx_behav","value":"hover"},{"name":"blur_fx","value":"1.5"},{"name":"brightness_fx","value":"100"},{"name":"contrast_fx","value":"1"},{"name":"grayscale_fx","value":"0"},{"name":"hue_fx","value":"0"},{"name":"invert_fx","value":"0"},{"name":"saturate_fx","value":"1"},{"name":"sepia_fx","value":"10"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}],"custom_css":""}'
	);
	
	
	// zoom image + magnifier icon
	$presets[] = array(
		'name' => 'Zoom image + magnifier icon',
		'opts' => '{"graphic":{"icon":[{"name":"icon_type","value":"magnfier_icon"},{"name":"icon_position","value":"center"},{"name":"font_size","value":"2"},{"name":"font_size_type","value":"rem"},{"name":"font_size_h","value":"2"},{"name":"font_size_h_type","value":"rem"},{"name":"color","value":"rgba(255,255,255,0)"},{"name":"color_h","value":"rgba(255,255,255,0.9)"},{"name":"transitions[]","value":"zoom-out"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease-out"},{"name":"animation_delay","value":"100"}],"crossing_layer":[{"name":"cross_pos","value":"bottom-left"},{"name":"bg_color","value":"rgba(51,51,51,0.1)"},{"name":"bg_color_h","value":"rgba(51,51,51,0.15)"},{"name":"animation_time","value":"350"},{"name":"easing","value":"linear"},{"name":"animation_delay","value":"50"}]},"txt":{"txt_block":[{"name":"position","value":"center"},{"name":"txt_behaviors","value":"none"},{"name":"txt_visibility","value":"always"},{"name":"bg_color","value":"#ffffff"},{"name":"bg_color_h","value":"#ffffff"},{"name":"txt_padding[]","value":"0"},{"name":"txt_padding[]","value":"0"},{"name":"txt_padding[]","value":"0"},{"name":"txt_padding[]","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"}]},"img_fx":[{"name":"img_zoom","value":"10"},{"name":"img_h_fx","value":""},{"name":"img_fx_behav","value":""},{"name":"blur_fx","value":"0"},{"name":"brightness_fx","value":"100"},{"name":"contrast_fx","value":"1"},{"name":"grayscale_fx","value":"0"},{"name":"hue_fx","value":"0"},{"name":"invert_fx","value":"0"},{"name":"saturate_fx","value":"1"},{"name":"sepia_fx","value":"0"},{"name":"animation_time","value":"600"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}],"custom_css":""}'
	);
	
	
	// Split overlay + circle
	$presets[] = array(
		'name' => 'Split overlay + circle',
		'opts' => '{"graphic":{"central_shape":[{"name":"cent_ol_shape","value":"circle"},{"name":"position","value":"center"},{"name":"bg_color","value":"#333"},{"name":"bg_color_h","value":"#333"},{"name":"opacity","value":"0"},{"name":"opacity_h","value":"80"},{"name":"inner_icon","value":"eye_icon"},{"name":"color","value":"#fff"},{"name":"over_txt_block","value":"1"},{"name":"transitions[]","value":"zoom-in"},{"name":"transitions[]","value":"slide-vert"},{"name":"animation_time","value":"450"},{"name":"easing","value":"ease-out-back"},{"name":"animation_delay","value":"150"}],"vert_split_layer":[{"name":"bg_color","value":"rgba(255,255,255,0.1)"},{"name":"bg_color_h","value":"rgba(255,255,255,0.4)"},{"name":"animation_time","value":"250"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}]},"txt":{"txt_block":[{"name":"position","value":"center"},{"name":"txt_behaviors","value":"none"},{"name":"txt_visibility","value":"always"},{"name":"bg_color","value":"#ffffff"},{"name":"bg_color_h","value":"#ffffff"},{"name":"txt_padding[]","value":"0"},{"name":"txt_padding[]","value":"0"},{"name":"txt_padding[]","value":"0"},{"name":"txt_padding[]","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"}]},"img_fx":[{"name":"img_zoom","value":"0"},{"name":"img_h_fx","value":""},{"name":"img_fx_behav","value":""},{"name":"blur_fx","value":"0"},{"name":"brightness_fx","value":"100"},{"name":"contrast_fx","value":"1"},{"name":"grayscale_fx","value":"0"},{"name":"hue_fx","value":"0"},{"name":"invert_fx","value":"0"},{"name":"saturate_fx","value":"1"},{"name":"sepia_fx","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}],"custom_css":""}'
	);
	
	
	// Curtain + type icon + socials 
	$presets[] = array(
		'name' => 'Curtain + type icon + socials',
		'opts' => '{"graphic":{"icon":[{"name":"icon_type","value":"subj_icon"},{"name":"icon_position","value":"center"},{"name":"font_size","value":"1.8"},{"name":"font_size_type","value":"rem"},{"name":"font_size_h","value":"1.8"},{"name":"font_size_h_type","value":"rem"},{"name":"color","value":"rgba(255,255,255,1)"},{"name":"color_h","value":"#ffffff"},{"name":"over_txt_block","value":"1"},{"name":"transitions[]","value":"zoom-out"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease-in-out"},{"name":"animation_delay","value":"0"}],"full_img_layer":[{"name":"position","value":"center"},{"name":"bg_color","value":"rgba(36,36,36,0)"},{"name":"bg_color_h","value":"rgba(36,36,36,0.1)"},{"name":"full_img_padding","value":"0"},{"name":"full_img_padding_h","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}]},"txt":{"title":[{"name":"txt_align","value":"center"},{"name":"font_size","value":"0.8"},{"name":"font_size_type","value":"rem"},{"name":"line_height","value":"100"},{"name":"color","value":"#383838"},{"name":"color_h","value":"#5c5c5c"},{"name":"highlight","value":"rgba(255, 0, 0 ,0)"},{"name":"highlight_h","value":"rgba(255, 0, 0 ,0)"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"#000000"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"#000000"},{"name":"txt_styles[]","value":"uppercase"},{"name":"txt_vert_margin[]","value":"0"},{"name":"txt_vert_margin[]","value":"0"},{"name":"font_family","value":""},{"name":"animation_delay","value":"50"}],"separator":[{"name":"color","value":"#cfcfcf"},{"name":"thickness","value":"1"},{"name":"sep_style","value":"dotted"},{"name":"txt_vert_margin[]","value":"0"},{"name":"txt_vert_margin[]","value":"0"},{"name":"animation_delay","value":"50"}],"socials":[{"name":"socials_style","value":"rounded"},{"name":"socials_align","value":"center"},{"name":"color","value":"#b2b2b2"},{"name":"color_h","value":"#808080"},{"name":"highlight","value":"rgba(255, 0, 0 ,0)"},{"name":"highlight_h","value":"rgba(255, 0, 0 ,0)"},{"name":"font_size","value":"20"},{"name":"font_size_type","value":"px"},{"name":"txt_vert_margin[]","value":"4"},{"name":"txt_vert_margin[]","value":"0"},{"name":"animation_delay","value":"0"}],"txt_block":[{"name":"position","value":"bottom"},{"name":"txt_behaviors","value":"curtain"},{"name":"txt_visibility","value":"always"},{"name":"bg_color","value":"#ffffff"},{"name":"bg_color_h","value":"#ffffff"},{"name":"txt_padding[]","value":"13"},{"name":"txt_padding[]","value":"15"},{"name":"txt_padding[]","value":"8"},{"name":"txt_padding[]","value":"15"},{"name":"transitions[]","value":"zoom-in"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"}]},"img_fx":[{"name":"img_zoom","value":"0"},{"name":"img_h_fx","value":""},{"name":"img_fx_behav","value":""},{"name":"blur_fx","value":"0"},{"name":"brightness_fx","value":"100"},{"name":"contrast_fx","value":"1"},{"name":"grayscale_fx","value":"0"},{"name":"hue_fx","value":"0"},{"name":"invert_fx","value":"0"},{"name":"saturate_fx","value":"1"},{"name":"sepia_fx","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}],"custom_css":""}'
	);
	
	
	// Outlined diamond + type
	$presets[] = array(
		'name' => 'Outlined diamond + type',
		'opts' => '{"graphic":{"central_shape":[{"name":"cent_ol_shape","value":"outline_diamond"},{"name":"position","value":"center"},{"name":"bg_color","value":"#ffffff"},{"name":"bg_color_h","value":"#ffffff"},{"name":"opacity","value":"0"},{"name":"opacity_h","value":"100"},{"name":"inner_icon","value":"subj_icon"},{"name":"color","value":"#ffffff"},{"name":"over_txt_block","value":"1"},{"name":"transitions[]","value":"zoom-out"},{"name":"animation_time","value":"500"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}],"full_img_layer":[{"name":"position","value":"center"},{"name":"bg_color","value":"rgba(255,255,255,0)"},{"name":"bg_color_h","value":"rgba(255,255,255,0.1)"},{"name":"full_img_padding","value":"10"},{"name":"full_img_padding_h","value":"0"},{"name":"animation_time","value":"600"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}]},"txt":{"txt_block":[{"name":"position","value":"center"},{"name":"txt_behaviors","value":"none"},{"name":"txt_visibility","value":"always"},{"name":"bg_color","value":"#ffffff"},{"name":"bg_color_h","value":"#ffffff"},{"name":"txt_padding[]","value":"0"},{"name":"txt_padding[]","value":"0"},{"name":"txt_padding[]","value":"0"},{"name":"txt_padding[]","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"}]},"img_fx":[{"name":"img_zoom","value":"0"},{"name":"img_h_fx","value":""},{"name":"img_fx_behav","value":""},{"name":"blur_fx","value":"0"},{"name":"brightness_fx","value":"100"},{"name":"contrast_fx","value":"2"},{"name":"grayscale_fx","value":"0"},{"name":"hue_fx","value":"0"},{"name":"invert_fx","value":"0"},{"name":"saturate_fx","value":"1.2"},{"name":"sepia_fx","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}],"custom_css":""}'
	);
	
	
	// Central sliding text + button
	$presets[] = array(
		'name' => 'Central sliding text + button',
		'opts' => '{"graphic":{"horiz_split_layer":[{"name":"bg_color","value":"rgba(41,41,41,0)"},{"name":"bg_color_h","value":"rgba(41,41,41,0.1)"},{"name":"animation_time","value":"300"},{"name":"easing","value":"ease-in-out"},{"name":"animation_delay","value":"0"}]},"txt":{"title":[{"name":"txt_align","value":"center"},{"name":"font_size","value":"1"},{"name":"font_size_type","value":"rem"},{"name":"line_height","value":"100"},{"name":"color","value":"#ffffff"},{"name":"color_h","value":"#ffffff"},{"name":"highlight","value":"rgba(255, 0, 0 ,0)"},{"name":"highlight_h","value":"rgba(255, 0, 0 ,0)"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"#000000"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"#000000"},{"name":"txt_vert_margin[]","value":"0"},{"name":"txt_vert_margin[]","value":"0"},{"name":"font_family","value":""},{"name":"animation_delay","value":"100"}],"button":[{"name":"btn_txt","value":"read more"},{"name":"font_size","value":"0.75"},{"name":"font_size_type","value":"rem"},{"name":"line_height","value":"100"},{"name":"btn_align","value":"center"},{"name":"txt_styles[]","value":"uppercase"},{"name":"font_family","value":""},{"name":"txt_padding[]","value":"6"},{"name":"txt_padding[]","value":"15"},{"name":"txt_padding[]","value":"6"},{"name":"txt_padding[]","value":"15"},{"name":"border_width","value":"2"},{"name":"border_style","value":"solid"},{"name":"border_color","value":"#ffffff"},{"name":"border_color_h","value":"#ffffff"},{"name":"border_radius","value":"2"},{"name":"bg_color","value":"transparent"},{"name":"bg_color_h","value":"transparent"},{"name":"color","value":"#ffffff"},{"name":"color_h","value":"#ffffff"},{"name":"txt_vert_margin[]","value":"15"},{"name":"txt_vert_margin[]","value":"0"},{"name":"animation_delay","value":"150"}],"txt_block":[{"name":"position","value":"bottom"},{"name":"txt_behaviors","value":"sh_vert_center"},{"name":"txt_visibility","value":"always"},{"name":"bg_color","value":"#424242"},{"name":"bg_color_h","value":"#292929"},{"name":"txt_padding[]","value":"20"},{"name":"txt_padding[]","value":"20"},{"name":"txt_padding[]","value":"20"},{"name":"txt_padding[]","value":"20"},{"name":"transitions[]","value":"slide-horiz"},{"name":"animation_time","value":"600"},{"name":"easing","value":"ease"}]},"img_fx":[{"name":"img_zoom","value":"0"},{"name":"img_h_fx","value":""},{"name":"img_fx_behav","value":""},{"name":"blur_fx","value":"0"},{"name":"brightness_fx","value":"100"},{"name":"contrast_fx","value":"1"},{"name":"grayscale_fx","value":"0"},{"name":"hue_fx","value":"0"},{"name":"invert_fx","value":"0"},{"name":"saturate_fx","value":"1"},{"name":"sepia_fx","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}],"custom_css":""}'
	);
	
	
	// Highlighted title + image effects
	$presets[] = array(
		'name' => 'Highlighted title + image effects',
		'opts' => '{"graphic":{},"txt":{"title":[{"name":"txt_align","value":"center"},{"name":"font_size","value":"1"},{"name":"font_size_type","value":"rem"},{"name":"line_height","value":"100"},{"name":"color","value":"rgba(255,255,255,1)"},{"name":"color_h","value":"rgba(255,255,255,1)"},{"name":"highlight","value":"rgba(249,118,0,0.75)"},{"name":"highlight_h","value":"rgba(249,118,0,1)"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"#ffffff"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"#ffffff"},{"name":"txt_styles[]","value":"uppercase"},{"name":"txt_vert_margin[]","value":"0"},{"name":"txt_vert_margin[]","value":"0"},{"name":"font_family","value":""},{"name":"animation_delay","value":"0"}],"txt_block":[{"name":"position","value":"center"},{"name":"txt_behaviors","value":"none"},{"name":"txt_visibility","value":"always"},{"name":"txt_vert_center","value":"1"},{"name":"bg_color","value":"rgba(255,255,255,0)"},{"name":"bg_color_h","value":"rgba(255,255,255,0)"},{"name":"txt_padding[]","value":"20"},{"name":"txt_padding[]","value":"20"},{"name":"txt_padding[]","value":"20"},{"name":"txt_padding[]","value":"20"},{"name":"transitions[]","value":"door-top"},{"name":"transitions[]","value":"upward"},{"name":"animation_time","value":"450"},{"name":"easing","value":"ease-in-out-back"}]},"img_fx":[{"name":"img_zoom","value":"2"},{"name":"img_h_fx","value":""},{"name":"img_fx_behav","value":"hover"},{"name":"blur_fx","value":"0"},{"name":"brightness_fx","value":"98"},{"name":"contrast_fx","value":"1.3"},{"name":"grayscale_fx","value":"0"},{"name":"hue_fx","value":"10"},{"name":"invert_fx","value":"5"},{"name":"saturate_fx","value":"1.5"},{"name":"sepia_fx","value":"15"},{"name":"animation_time","value":"450"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}],"custom_css":""}'
	);
	
	
	// Highlighted texts
	$presets[] = array(
		'name' => 'Highlighted texts',
		'opts' => '{"graphic":{"single_border":[{"name":"singl_border_side","value":"bottom"},{"name":"singl_border_show","value":"bottom"},{"name":"border_width","value":"6"},{"name":"border_color","value":"rgba(255,85,28,0.7)"},{"name":"border_color_h","value":"#ff551c"},{"name":"animation_time","value":"450"},{"name":"easing","value":"ease-out-back"},{"name":"animation_delay","value":"550"}],"full_img_layer":[{"name":"position","value":"top"},{"name":"bg_color","value":"rgba(0,0,0,0)"},{"name":"bg_color_h","value":"rgba(0,0,0,0.2)"},{"name":"full_img_padding","value":"0"},{"name":"full_img_padding_h","value":"0"},{"name":"animation_time","value":"600"},{"name":"easing","value":"ease-out"},{"name":"animation_delay","value":"0"}]},"txt":{"title":[{"name":"txt_align","value":"left"},{"name":"font_size","value":"1"},{"name":"font_size_type","value":"rem"},{"name":"line_height","value":"100"},{"name":"color","value":"#fefefe"},{"name":"color_h","value":"#fefefe"},{"name":"highlight","value":"#ff551c"},{"name":"highlight_h","value":"#ff551c"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"#000000"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"#000000"},{"name":"txt_styles[]","value":"bold"},{"name":"txt_vert_margin[]","value":"0"},{"name":"txt_vert_margin[]","value":"20"},{"name":"font_family","value":""},{"name":"animation_delay","value":"0"}],"descr":[{"name":"txt_align","value":"left"},{"name":"font_size","value":"0.85"},{"name":"font_size_type","value":"rem"},{"name":"line_height","value":"170"},{"name":"color","value":"#fff"},{"name":"color_h","value":"#fff"},{"name":"highlight","value":"#ff551c"},{"name":"highlight_h","value":"#ff551c"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"#000000"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"#000000"},{"name":"txt_max_h","value":"40"},{"name":"txt_vert_margin[]","value":"0"},{"name":"txt_vert_margin[]","value":"25"},{"name":"font_family","value":""},{"name":"animation_delay","value":"300"}],"txt_block":[{"name":"position","value":"bottom"},{"name":"txt_behaviors","value":"show_all"},{"name":"txt_visibility","value":"hide"},{"name":"bg_color","value":"rgba(255,255,255,0)"},{"name":"bg_color_h","value":"rgba(255,255,255,0)"},{"name":"txt_padding[]","value":"15"},{"name":"txt_padding[]","value":"15"},{"name":"txt_padding[]","value":"4"},{"name":"txt_padding[]","value":"15"},{"name":"transitions[]","value":"door-top"},{"name":"animation_time","value":"500"},{"name":"easing","value":"ease-in-out-back"}]},"img_fx":[{"name":"img_zoom","value":"0"},{"name":"img_h_fx","value":""},{"name":"img_fx_behav","value":""},{"name":"blur_fx","value":"0"},{"name":"brightness_fx","value":"100"},{"name":"contrast_fx","value":"1"},{"name":"grayscale_fx","value":"0"},{"name":"hue_fx","value":"0"},{"name":"invert_fx","value":"0"},{"name":"saturate_fx","value":"1"},{"name":"sepia_fx","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}],"custom_css":""}'
	);
	
	
	// Flipping image + text
	$presets[] = array(
		'name' => 'Flip image + text and button',
		'opts' => '{"graphic":{"icon":[{"name":"icon_type","value":"subj_icon"},{"name":"icon_position","value":"center"},{"name":"font_size","value":"28"},{"name":"font_size_type","value":"px"},{"name":"font_size_h","value":"28"},{"name":"font_size_h_type","value":"px"},{"name":"color","value":"rgba(255,255,255,0)"},{"name":"color_h","value":"#ffffff"},{"name":"over_txt_block","value":"1"},{"name":"transitions[]","value":"zoom-in"},{"name":"transitions[]","value":"upward"},{"name":"animation_time","value":"300"},{"name":"easing","value":"ease-out-back"},{"name":"animation_delay","value":"600"}]},"txt":{"title":[{"name":"txt_align","value":"center"},{"name":"font_size","value":"19"},{"name":"font_size_type","value":"px"},{"name":"line_height","value":"40"},{"name":"color","value":"#fefefe"},{"name":"color_h","value":"#fefefe"},{"name":"highlight","value":"rgba(255, 0, 0 ,0)"},{"name":"highlight_h","value":"rgba(255, 0, 0 ,0)"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"#000000"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"#000000"},{"name":"txt_vert_margin[]","value":"10"},{"name":"txt_vert_margin[]","value":"60"},{"name":"font_family","value":""},{"name":"animation_delay","value":"150"}],"button":[{"name":"btn_txt","value":"discover"},{"name":"font_size","value":"0.85"},{"name":"font_size_type","value":"rem"},{"name":"line_height","value":"100"},{"name":"btn_align","value":"center"},{"name":"txt_styles[]","value":"uppercase"},{"name":"font_family","value":""},{"name":"txt_padding[]","value":"6"},{"name":"txt_padding[]","value":"12"},{"name":"txt_padding[]","value":"5"},{"name":"txt_padding[]","value":"12"},{"name":"border_width","value":"0"},{"name":"border_style","value":"solid"},{"name":"border_color","value":"#444444"},{"name":"border_color_h","value":"#666666"},{"name":"border_radius","value":"2"},{"name":"bg_color","value":"#7eb551"},{"name":"bg_color_h","value":"#7eb551"},{"name":"color","value":"#fefefe"},{"name":"color_h","value":"#fefefe"},{"name":"txt_vert_margin[]","value":""},{"name":"txt_vert_margin[]","value":"0"},{"name":"animation_delay","value":"150"}],"txt_block":[{"name":"position","value":"center"},{"name":"txt_behaviors","value":"none"},{"name":"txt_visibility","value":"always"},{"name":"txt_vert_center","value":"1"},{"name":"bg_color","value":"#63a031"},{"name":"bg_color_h","value":"#63a031"},{"name":"txt_padding[]","value":"20"},{"name":"txt_padding[]","value":"20"},{"name":"txt_padding[]","value":"20"},{"name":"txt_padding[]","value":"20"},{"name":"transitions[]","value":"slide-vert"},{"name":"animation_time","value":"700"},{"name":"easing","value":"ease-in-out-back"}]},"img_fx":[{"name":"img_zoom","value":"0"},{"name":"img_h_fx","value":""},{"name":"img_fx_behav","value":""},{"name":"blur_fx","value":"0"},{"name":"brightness_fx","value":"100"},{"name":"contrast_fx","value":"1"},{"name":"grayscale_fx","value":"0"},{"name":"hue_fx","value":"0"},{"name":"invert_fx","value":"0"},{"name":"saturate_fx","value":"1"},{"name":"sepia_fx","value":"0"},{"name":"animation_time","value":"400"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}],"custom_css":""}'
	);
	
	
	// Tilt image + texts
	$presets[] = array(
		'name' => 'Tilt image + texts',
		'opts' => '{"graphic":{"icon":[{"name":"icon_type","value":"subj_icon"},{"name":"icon_position","value":"bottom-right"},{"name":"font_size","value":"18"},{"name":"font_size_type","value":"px"},{"name":"font_size_h","value":"18"},{"name":"font_size_h_type","value":"px"},{"name":"color","value":"rgba(255,255,255,0)"},{"name":"color_h","value":"#ffffff"},{"name":"over_txt_block","value":"1"},{"name":"transitions[]","value":"zoom-in"},{"name":"animation_time","value":"300"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"500"}],"outlined_box":[{"name":"position","value":"center"},{"name":"border_width","value":"2"},{"name":"border_width_h","value":"2"},{"name":"border_color","value":"rgba(255,255,255,0.4)"},{"name":"border_color_h","value":"rgba(255,255,255,0.4)"},{"name":"full_img_padding","value":"0"},{"name":"full_img_padding_h","value":"8"},{"name":"over_txt_block","value":"1"},{"name":"transitions[]","value":"zoom-out"},{"name":"animation_time","value":"350"},{"name":"easing","value":"ease-out-back"},{"name":"animation_delay","value":"500"}]},"txt":{"title":[{"name":"txt_align","value":"left"},{"name":"font_size","value":"1.05"},{"name":"font_size_type","value":"rem"},{"name":"line_height","value":"100"},{"name":"color","value":"#fefefe"},{"name":"color_h","value":"#fefefe"},{"name":"highlight","value":"#7eb551"},{"name":"highlight_h","value":"#7eb551"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"#000000"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"#000000"},{"name":"txt_styles[]","value":"uppercase"},{"name":"txt_vert_margin[]","value":"0"},{"name":"txt_vert_margin[]","value":"20"},{"name":"font_family","value":""},{"name":"animation_delay","value":"0"}],"descr":[{"name":"txt_align","value":"left"},{"name":"font_size","value":"0.92"},{"name":"font_size_type","value":"rem"},{"name":"line_height","value":"150"},{"name":"color","value":"#fefefe"},{"name":"color_h","value":"#fefefe"},{"name":"highlight","value":"rgba(255, 0, 0 ,0)"},{"name":"highlight_h","value":"rgba(255, 0, 0 ,0)"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"0"},{"name":"txt_shadow[]","value":"#000000"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"0"},{"name":"txt_shadow_h[]","value":"#000000"},{"name":"txt_max_h","value":"50"},{"name":"txt_vert_margin[]","value":"0"},{"name":"txt_vert_margin[]","value":"0"},{"name":"font_family","value":""},{"name":"animation_delay","value":"0"}],"txt_block":[{"name":"position","value":"center"},{"name":"txt_behaviors","value":"none"},{"name":"txt_visibility","value":"always"},{"name":"txt_vert_center","value":"1"},{"name":"bg_color","value":"rgba(99,160,49,0.9)"},{"name":"bg_color_h","value":"#63a031"},{"name":"txt_padding[]","value":"25"},{"name":"txt_padding[]","value":"30"},{"name":"txt_padding[]","value":"25"},{"name":"txt_padding[]","value":"30"},{"name":"transitions[]","value":"door-right"},{"name":"animation_time","value":"600"},{"name":"easing","value":"ease"}]},"img_fx":[{"name":"img_zoom","value":"0"},{"name":"img_h_fx","value":"door-left"},{"name":"img_fx_behav","value":""},{"name":"blur_fx","value":"0"},{"name":"brightness_fx","value":"100"},{"name":"contrast_fx","value":"1"},{"name":"grayscale_fx","value":"0"},{"name":"hue_fx","value":"0"},{"name":"invert_fx","value":"0"},{"name":"saturate_fx","value":"1"},{"name":"sepia_fx","value":"0"},{"name":"animation_time","value":"600"},{"name":"easing","value":"ease"},{"name":"animation_delay","value":"0"}],"custom_css":""}'
	);
	
	
	/////////////////////////////////////////////////////////////////////
		
		
	// check if there are already overlays
	$args =  array('number' => 100, 'offset' => 0, 'hide_empty' => 0);
	$items = get_terms('mgom_overlays', $args);	
	
	if(!count($items)) {
		foreach($presets as $preset) {
            $content = serialize(mgom_static::js_ajax_sanitize(json_decode($preset['opts'])));
			wp_insert_term($preset['name'], 'mgom_overlays', $args = array('description' => $content) );	
		}
	}
	
	
	// save again custom CSS file
	if(!get_option('mg_inline_css') && class_exists('mg_static') && method_exists('mg_static', 'create_frontend_css')) {
        mg_static::create_frontend_css(); 
	}
}
register_activation_hook( MGOM_DIR.'/mg_overlay_manager.php', 'mgom_on_activation');

