<?php 
////////////////////////////////////////////////
//// OVERLAY FRONTEND CODE /////////////////////

// title plceholder 	-> %MG-TITLE-OL%
// descr placeholder 	-> %MG-DESCR-OL%
// socials placeholder	-> %MG-SOCIALS-OL%

function mgom_ol_frontend_code($ol_id, $title_under = false) {
	$data = get_term($ol_id, 'mgom_overlays');	
	$code = array('graphic' => '', 'txt' => '', 'img_fx_elem' => '', 'txt_vis_class' => '');	
	$lc = 0;
	
	if(!isset($GLOBALS['mgom_preview_data']) && (!$data || empty($data->description))) {
        return $code;
    }
	else {
        // ol_data passed by live preview
        $layers = (isset($GLOBALS['mgom_preview_data'])) ? $GLOBALS['mgom_preview_data'] : unserialize(mgom_static::fix_serialization($data->description));
    }

	/////////////////////////////////////////////////////////////////////////////////
	// graphic layers
	if(is_array($layers['graphic'])) {
		foreach($layers['graphic'] as $type => $opts) {
			$contents  = '';
			$classes = array();
			$atts    = array(); 
            
			// split layers
			if($type == 'vert_split_layer' || $type == 'horiz_split_layer') {
				$contents  = '<div></div>';	
			}
			
			// crossing layer
			if($type == 'crossing_layer') {
				$classes[] = 'mgom_'.$opts['cross_pos'];
			}
			
			// corner slice
			if($type == 'corner_slice') {
				$classes[] = 'mgom_'.$opts['slice_pos'];	
			}
			
			// single border
			if($type == 'single_border') {
				$classes[] = 'mgom_sb_'.$opts['singl_border_side'].'_side';	
				$classes[] = 'mgom_sb_from_'.$opts['singl_border_show'];	
			}
			
			// corners
			elseif($type == 'corner_shape') {
				$contents  = '<span></span>';
				
                $classes[] = 'mgom_'.$opts['corn_ol_shape'];
				$classes[] = 'mgom_'.$opts['corner_pos']; 
                
				if($opts['inner_icon'] != 'none') {
				    $classes[] = 'mgom_'.$opts['inner_icon'];
                    
                    // item's custom icon case
                    if(isset($opts['inner_icon']) && $opts['inner_icon'] == 'custom_icon') {
                        $contents = str_replace('<span', '<span class="%MGOM-CUST-ITEM-ICON%"', $contents);    
                    }
                }
			}
			
			// shapes
			else if($type == 'central_shape') {
				$contents  = '<div><span></span></div>';
				$classes[] = 'mgom_'.$opts['cent_ol_shape'];
                
                if($opts['inner_icon'] != 'none') {
				    $classes[] = 'mgom_'.$opts['inner_icon'];
                    
                    // item's custom icon case
                    if($opts['inner_icon'] == 'custom_icon') {
                        $contents = str_replace('<span', '<span class="%MGOM-CUST-ITEM-ICON%"', $contents);    
                    }
                }
			}
			
			// icons
			else if($type == 'icon') {
                // item's custom icon case
                $ici_class = ($opts['icon_type'] == 'custom_icon') ? ' class="%MGOM-CUST-ITEM-ICON%"' : ''; 
                
				$contents  = '<span '. $ici_class .'></span>';
				$classes[] = 'mgom_icon_layer';
				$classes[] = 'mgom_'.$opts['icon_type'];
			}
			
			// mouse direction class
			if(isset($opts['position']) && $opts['position'] == 'mouse_dir') {
				$classes[] = 'mgom_mouse_dir';	
			}
			
            // image overlay - item-specific image
            if($type == 'img_ol' && isset($opts['img_ol_src']) && $opts['img_ol_src'] == '%MGOM-IMG-META-VAL%') {
                $classes[] = 'mgom_spec_img_ol';
                $atts['mgom-img-ol-url'] = $opts['img_ol_src'];
            }
                
			if($type != 'img_fx') {
                $atts_code = [];
                foreach($atts as $ak => $av) {
                    $atts_code[] = $ak .'="'. esc_attr($av) .'"';    
                }
                
				$code['graphic'] .= 
                    '<div class="mgom_layer mgom_'.$type.' mgom_'.$data->term_id.'_'.$lc.' '. implode(' ', $classes) .'" '. implode(' ', $atts_code) .'>'. $contents .'</div>';	
			}
			
			$lc++;
		}
		
		// if image and overlays will scroll on top of text
		if(!empty($code['graphic']) && count((array)$code['graphic']) && count((array)$layers['txt']) > 1 && !$title_under) {
			if($layers['txt']['txt_block']['position'] == 'bottom' && $layers['txt']['txt_block']['txt_behaviors'] == 'curtain') {
				$code['graphic'] = '<div class="mgom_graphic_wrap">'. $code['graphic'] . '</div>';	
			}
		}
	}
	


	/////////////////////////////////////////////////////////////////////////////////////////
	// textual layers
	if(count((array)$layers['txt']) > 1) {
		foreach($layers['txt'] as $type => $opts) {
			$classes    = array();
            $atts       = array(); 
            
			// contents switch
			if($type == 'title') {
				$content = '%MG-TITLE-OL%';
			}
			elseif($type == 'descr') {
				$content = '%MG-DESCR-OL%';
			}
			elseif($type == 'custom_txt') 	{
				$content = str_replace(array('&apos;', '&quot;', '&lt;', '&gt;'), array("'", '"', '<', '>'), $opts['cust_txt']);
			}
			elseif($type == 'button') {
				$content = str_replace(array('&apos;', '&quot;', '&lt;', '&gt;'), array("'", '"', '<', '>'), $opts['btn_txt']);
                
                // button - custom beavior
                if(isset($opts['btn_behavior']) && $opts['btn_behavior']) {
                    $classes[] = 'mgom_linked_btn mg_custom_behav_btn';  
                    $atts['onclick'] = "location.href = '%MGOM-POST-LINK%';";
                }
			}		
			elseif($type == 'socials') {
				$content = '<div class="mgom_'.$opts['socials_style'].'_socials mgom_soc_align_'.$opts['socials_align'].'">%MG-SOCIALS-OL%</div>';
			}
			else {
                $content = '';
            }
			
			// highlight wrap
			if(
                (isset($opts['highlight']) && !empty($opts['highlight']) && strpos($opts['highlight'], '0)') === false) || 
                (isset($opts['highlight_h']) && !empty($opts['highlight_h']) && strpos($opts['highlight'], '0)') === false)
            ) {
				if(in_array($type, array('title', 'descr', 'custom_txt'))) {
					$content = '<mark class="mgom_mark">'. $content . '</mark>';	
				} else {
					$content = str_replace('%MG-SOCIALS-OL%', '<mark class="mgom_mark">%MG-SOCIALS-OL%</mark>', $content);		
				}
			}
			
			// add description wrapper to allow max-height shortening
			else {
				if($type == 'descr') {
					$content = '<div class="mgom_displayinl">'. $content . '</div>';		
				}
			}
            
            
            $atts_code = [];
            foreach($atts as $ak => $av) {
                $atts_code[] = $ak .'="'. esc_attr($av) .'"';    
            }
			
			$code['txt'] .= '<div class="mgom_layer mgom_'. esc_attr($type) .' mgom_'. esc_attr($data->term_id) .'_'.$lc.' '. implode(' ', $classes) .'" '. implode(' ', $atts_code) .'>'. $content .'</div>';	
            
			$lc++;
		}
		
        
		if(!$title_under) {
			$classes = array();
			$pos = $layers['txt']['txt_block']['position'];
			$behav = (isset($layers['txt']['txt_block']['txt_behaviors'])) ? $layers['txt']['txt_block']['txt_behaviors'] : 'none';
			
			// custom behavior classes
			if($pos == 'bottom' && $behav != 'none')  {
				$code['txt_vis_class'] .= ' mgom_txt_vis mgom_'.$behav;
			}
			
			// mouse direction class
			if($pos == 'mouse_dir') {
				$classes[] = 'mgom_mouse_dir';	
			}
			
			$code['txt'] = '
			<div class="mgom_txt_wrap mgom_'. esc_attr($data->term_id) .'_'.$lc.' '. esc_attr(implode(' ', $classes)) .'">
				'. $code['txt'] .'
			</div>';
		}
	}
	
	return $code;
}



////////////////////////////////////////////////
//// FILTERS REPLACING PLACEHOLDERS ////////////

function mgom_txt_management($txt, $item_id, $overlay_id, $preview_mode) {
	
	if($preview_mode) {
		$descr = 'dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat. Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.';
        
		$txt = str_replace('%MG-TITLE-OL%', 'Lorem ipsum', $txt);
		$txt = str_replace('%MG-DESCR-OL%', $descr, $txt);	
		
        if(strpos($txt, '%MG-SOCIALS-OL%') !== false) {
            $socials_style = $GLOBALS['mgom_preview_data']['txt']["socials"]["socials_style"];

            $code = '';
            if(get_option('mg_facebook')) {
                $code .= "<span class='mgom_fb ". mg_lb_static::get_social_icon('facebook', $socials_style) ."'></span>";
            }
            if(get_option('mg_twitter')) {
                $code .= "<span class='mgom_tw ". mg_lb_static::get_social_icon('twitter', $socials_style) ."'></span>";
            }
            if(get_option('mg_pinterest')) {
                $code .= "<span class='mgom_pt ". mg_lb_static::get_social_icon('pinterest', $socials_style) ."'></span>";
            }
            if(get_option('mg_whatsapp_share')) {
                $code .= "<span class='mgom_wa ". mg_lb_static::get_social_icon('whatsapp', $socials_style) ."'></span>";        
            }

            $txt = str_replace('%MG-SOCIALS-OL%', $code, $txt);	
        }
		
        
        // button's custom behavior - post link
        $txt = str_replace('%MGOM-POST-LINK%', 'javascript:void(0)', $txt);
		
		// replace placeholders
		$txt = str_replace(array('%DATE%', '%AUTHOR%', '%WC-PRODUCT-PRICE%'), array(date(get_option('date_format')), 'Author', '100.00 $'), $txt);
	}
	
    
	else {
		$GLOBALS['mg_item_id'] = $item_id; // global for attribute shortcode
		
		// do_shortcode to allow MGOM attr execution
		$txt = do_shortcode($txt);
		
        
		/*** title ***/
		if(strpos($txt, '%MG-TITLE-OL%') !== false) {
			$title = get_the_title($item_id);
			$txt = str_replace('%MG-TITLE-OL%', $title, $txt);
		}

		
		/*** description ***/
		if(strpos($txt, '%MG-DESCR-OL%') !== false) {
			$descr = do_shortcode( nl2br(get_post_field('post_excerpt', $item_id)));
			if(empty($descr)) {
                $descr = nl2br(strip_shortcodes( strip_tags( get_post_field('post_content', $item_id), '<p><br><i><span>')));
            }
			
			$txt = str_replace('%MG-DESCR-OL%', $descr, $txt);
		}
		else {
            $descr = '';
        }


		/*** date and author placeholders ***/
		$txt = str_replace(array('%DATE%', '%AUTHOR%'), array( 
			get_the_date(get_option('date_format'), $item_id),
			get_the_author_meta('user_nicename', get_post_field('post_author', $item_id))
		), $txt);
		
        
        /*** button's custom behavior - post link ***/
        if(strpos($txt, '%MGOM-POST-LINK%') !== false) {
            $cpt = get_post_types(array(
                'public'    => true,
                'show_ui'   => true, 
                'publicly_queryable' => true
            ));
            
            $cpt = array_keys($cpt);
            unset($cpt['attachment']);
            
            if(in_array(get_post_type($item_id), $cpt)) {
                $link = get_permalink($item_id);
                $txt = str_replace('%MGOM-POST-LINK%', $link, $txt);
            }
            else {
                $txt = str_replace(array('mgom_linked_btn mg_custom_behav_btn', 'onclick'), array('mgom_linked_btn', 'data-onclick'), $txt);        
            }
        }
        

		/*** woocommerce price placeholder ***/
		if(strpos($txt, '%WC-PRODUCT-PRICE%') !== false) { 
			if(function_exists('wc_get_product') && get_post_type($item_id) == 'product') {
				$product = wc_get_product($item_id);
				
				$to_replace = ($product->is_in_stock()) ? wc_price($product->get_price()) : __('Out of stock', MGOM_ML); 
				$txt = str_replace('%WC-PRODUCT-PRICE%', $to_replace, $txt);
			}
			else {
				$txt = str_replace('%WC-PRODUCT-PRICE%', '', $txt);	
			}
		}


		/*** socials ***/
		if(strpos($txt, '%MG-SOCIALS-OL%') !== false) {
			$fi_img_id = get_post_thumbnail_id($item_id);
			$fi_src = wp_get_attachment_image_src($fi_img_id, 'medium');
			
			$deeplinked_elems = get_option('mg_deeplinked_elems', array_keys(mg_static::elem_to_deeplink()) );
			$share_curr_url = urlencode(mg_static::curr_url());  
			
            $ol_data = get_term($overlay_id, 'mgom_overlays');	
            $layers = unserialize(mgom_static::fix_serialization($ol_data->description));
            $socials_style = $layers['txt']["socials"]["socials_style"];
            
            $socials_descr = nl2br(strip_shortcodes( strip_tags( get_post_field('post_content', $item_id), '<p><br><i><span>')));
            
			$code = '';
			if(get_option('mg_facebook')) {
				
				if(get_option('mg_fb_direct_share_app_id') && function_exists('lcsism_share_url')) {
					$lcsism_share_url = lcsism_share_url(get_the_title($item_id), strip_shortcodes(get_post_field('post_content', $item_id)), $fi_src[0]);
					$lcsism_fb = 'https://www.facebook.com/dialog/share?app_id='. get_option('mg_fb_direct_share_app_id') .'&href='. urlencode($lcsism_share_url) .'&redirect_uri='.lcsism_redirect_url();

					$onclick = "window.open('". $lcsism_fb ."&display=popup','sharer','toolbar=0,status=0,width=548,height=500');";	
				} 
				else {
					$onclick = "window.open('https://www.facebook.com/sharer?u=". $share_curr_url ."&display=popup','sharer','toolbar=0,status=0,width=548,height=325');";		
				}
				
				$code .= "
				<span class='mgom_fb ". mg_lb_static::get_social_icon('facebook', $socials_style) ."' onClick=\"". $onclick ."\"></span>";
			}
			if(get_option('mg_twitter')) {
				$code .= "
				<span class='mgom_tw ". mg_lb_static::get_social_icon('twitter', $socials_style) ."' onClick=\"window.open('https://twitter.com/share?text=". urlencode('Check out "'. get_the_title($item_id) .'" on '.get_bloginfo("name"))."&url=". $share_curr_url ."','sharer','toolbar=0,status=0,width=575,height=330');\"></span>";
			}
			if(get_option('mg_pinterest')) {
				$code .= "
				<span class='mgom_pt ". mg_lb_static::get_social_icon('pinterest', $socials_style) ."' onClick=\"window.open('http://pinterest.com/pin/create/button/?url=".$share_curr_url."&media=".urlencode($fi_src[0])."&description=".urlencode($socials_descr)."','sharer','toolbar=0,status=0,width=575,height=330');\"></span>";
			}
            if(get_option('mg_whatsapp_share')) {
                $code .= "<span class='mgom_wa ". mg_lb_static::get_social_icon('whatsapp', $socials_style) ."' onClick=\"window.open('whatsapp://send?text=". urlencode($share_curr_url) ."'\"></span>";        
            }
	
			$txt = str_replace('%MG-SOCIALS-OL%', $code, $txt);
		}
	}

	return $txt;
}
add_filter('mg_txt_ol_manag', 'mgom_txt_management', 100, 4);






function mgom_graphic_ol_manag($code, $item_id, $overlay_id, $preview_mode) {
    
    if($preview_mode) {
        // image overlay
        $code = str_replace('%MGOM-IMG-META-VAL%', '" style="background-image: url(\''. MGOM_URL .'/img/demo_ol_img.jpg\');"', $code); 
        
        // custom icon
        $code = str_replace('%MGOM-CUST-ITEM-ICON%', 'fas fa-star', $code);
    }
    
    else {
        // image overlay - retrieve item image
        if(strpos($code, '%MGOM-IMG-META-VAL%') !== false) {
            $img_id = (int)get_post_meta($item_id, 'mgom_ol_img_layer', true);
            
            if(mg_static::img_is_gif($img_id)) {
                $img_data = wp_get_attachment_image_src($img_id, 'full');
                $img_url = (empty($img_data)) ? '' : $img_data[0];
            }
            else {
                $img_url = mg_static::thumb_src($img_id, 600, 600);        
            }

            $code = str_replace('%MGOM-IMG-META-VAL%', '" style="background-image: url(\''. $img_url .'\');"', $code); 
        }
        
        
        // custom icon
        if(strpos($code, '%MGOM-CUST-ITEM-ICON%') !== false) {
            $icon = get_post_meta($item_id, 'mg_cust_icon', true);
            
            if($icon) {
                $code = str_replace('%MGOM-CUST-ITEM-ICON%', mg_static::fontawesome_v4_retrocomp($icon), $code);
            } else {
                $code = str_replace('%MGOM-CUST-ITEM-ICON%', '', $code);        
            }
        }
    }
    
    return $code;
}
add_filter('mg_graphic_ol_manag', 'mgom_graphic_ol_manag', 100, 4);
