<?php
// ADDS SIDE METABOX to allow overlay image selection



// register sidebox
function mgom_pt_sidebox_register() {
	
	// register
	foreach(mg_static::pt_list() as $pt) {
		add_meta_box('mgom_ol_img_layer', 'Media Grid Overlay Manager - '. esc_html__('Overlay Image', MGOM_ML), 'mgom_ol_img_layer', $pt, 'side');
	}		
}
add_action('admin_init', 'mgom_pt_sidebox_register');




// sidebox code
function mgom_ol_img_layer() {
	global $post;
    $img_id = (int)get_post_meta($post->ID, 'mgom_ol_img_layer', true);
    $img_data = (!$img_id) ? false : wp_get_attachment_image_src($img_id, 'large');
    
    $placeh_vis = (!empty($img_data)) ? 'style="display: none;"' : ''; 
    $img_vis    = (!empty($img_data)) ? '' : 'display: none;'; 
    
    $bg = (!empty($img_data)) ? 'background-image: url(\''. $img_data[0] .'\');' : ''; 
	?>
	<div class="mg_sidebox_meta">
        <div class="misc-pub-section mgom_img_layer_sidebox">    
    	
            <div class="mgom_ils_img" style="<?php echo $bg ?> <?php echo $img_vis ?>">
                <span class="dashicons dashicons-trash" title="<?php _e('remove selected image', MGOM_ML) ?>"></span>
            </div>
            
            <div class="mgom_ils_placeh" <?php echo $placeh_vis ?>>
                <a href="javascript:void(0)">
                    <span class="dashicons dashicons-plus-alt"></span>
                    <?php _e('Select image', MGOM_ML) ?>
                </a>
            </div>
    	</div>
    </div>
    
    <input type="hidden" name="mgom_ol_img_layer" value="<?php echo $img_id ?>" autocomplete="off" />
    <input type="hidden" name="mgom_sidebox_nonce" value="<?php echo wp_create_nonce('lcwp_nonce') ?>" />

    <script type="text/javascript">
    (function($) { 
        "use strict";
        
        $(document).ready(function() {
        
            // remove image
            $(document).on('click', '.mgom_ils_img span', function() {
                const $wrap = $(this).parents('.mgom_img_layer_sidebox');
                $wrap.find('.mgom_ils_img').removeAttr('style').hide();
                
                $('input[name="mgom_ol_img_layer"]').val('');
                $('.mgom_ils_placeh').show();
            });
            
            
            
            // image selection
            var file_frame = false;
            var wp_media_post_id = wp.media.model.settings.post.id;
            var set_to_post_id = 99999999;

            $(document).on('click', '.mgom_ils_placeh', function(e){
                var $field = $(this).parents('.mgom_field').find('input');

                if (file_frame) {
                    file_frame.uploader.uploader.param('post_id', set_to_post_id);
                    file_frame.open();
                    return true;
                } 
                else {
                    wp.media.model.settings.post.id = set_to_post_id;
                }

                // Create media frame
                file_frame = wp.media.frames.file_frame = wp.media({
                    title: "<?php esc_attr_e('Picture chooser', MGOM_ML) ?>",
                    button: {
                        text: "<?php esc_attr_e('Select Image', MGOM_ML) ?>",
                    },
                    library : {
                        type : 'image'
                    },
                    multiple: false
                });

                // open the modal
                file_frame.open();

                // When an image is selected, run a callback.
                file_frame.on('select', function() {
                    const attachment = file_frame.state().get('selection').first().toJSON();
                    const url = (typeof(attachment.sizes.large) == 'undefined') ? attachment.sizes.full.url : attachment.sizes.large.url;
                    
                    $('.mgom_img_layer_sidebox .mgom_ils_img').css('background-image', 'url(\''+ url +'\')').show();
                    $('input[name="mgom_ol_img_layer"]').val(attachment.id);
                    
                    $('.mgom_ils_placeh').hide();
                });
            });
        });
     })(jQuery);
    </script>
    <?php
	return true;	
}





// SAVE - assign terms and saving range value
// NB: two params passed only by the WP media filter - first parameter is the media $post array
function mgom_ol_img_save($post, $attachment = false) {
    $post_id = (is_array($post)) ? $post['post_ID'] : $post;
    
	// security checks
	if(!isset($_POST['mgom_sidebox_nonce']) || !wp_verify_nonce($_POST['mgom_sidebox_nonce'], 'lcwp_nonce') || !current_user_can('edit_post', $post_id)) {
		return $post;
	}
	
    $val = (isset($_POST['mgom_ol_img_layer'])) ? (int)$_POST['mgom_ol_img_layer'] : '';
	
    if($val) {
        $img_data = wp_get_attachment_image_src($val, array(600, 600));    
        if(empty($img_data)) {
            $val = '';    
        }
    }
    
    update_post_meta($post_id, 'mgom_ol_img_layer', $val);    
    return $post;
}
add_action('save_post', 'mgom_ol_img_save');
add_filter('attachment_fields_to_save', 'mgom_ol_img_save', 20, 2);

