<?php
////////// SHORCODES LIST

// [mgom-item-attr] 
//// prints item's attribute value
function mgom_item_attr_shortcode($atts, $content = null) {
	extract( shortcode_atts( array(
		'name' => '', // CASE SENSITIVE!
		'label' => 0,
		'icon' => 0
	), $atts ) );
	
	// must have a name and $GLOBALS['mg_item_id'] must exist
	if(!$name || !isset($GLOBALS['mg_item_id'])) {
        return '';
    }

	$code = '';
	$item_id = $GLOBALS['mg_item_id'];
	
	$orig_type = get_post_type($item_id);
	$type = ($orig_type == 'product') ? 'woocom' : get_post_meta($item_id, 'mg_main_type', true);
	
	// retrocompatibility
	if($type == 'single_img') {$type = 'image';}


	// MG items or any other post type
	if($type != 'woocom') {
		$target_type = ($orig_type == 'mg_items') ? $type : 'post';
		$cust_opt = mg_static::item_copts_array($target_type, $item_id);
		
		// avoid too many queries 
		if($icon) {
			$type_opts = get_option('mg_'.$type.'_opt');
			$icons = get_option('mg_'.$type.'_opt_icon');
		}
		else {$type_opts = array($name);}
		
		if(count($cust_opt)) {
			$a = 0;
			foreach($type_opts as $opt) {
				if(isset($cust_opt[$opt]) && $name == $opt) {				
					if($icon && isset($icons[$a]) && !empty($icons[$a])) {
						$code .= '<i class="mg_cust_opt_icon fa '. esc_attr($icons[$a]) .'">&nbsp;</i> ';	// TODO - check new fa
					}
					
					if($label) {
						$code .= '<span class="mgom_ol_attr_label">'. mg_static::wpml_string($type, $opt) .'</span> ';	
					}
					
					$code .= do_shortcode(str_replace(array('&lt;', '&gt;'), array('<', '>'), $cust_opt[$opt]));
					break;
				}
				$a++;
			}
		}
	}
	
	// woocomm attributes
	else {
		$wc_prod = new WC_Product($item_id);
		$prod_attr = mg_static::wc_prod_attr($wc_prod);
		
		if(is_array($prod_attr) && count($prod_attr) > 0 && !get_option('mg_wc_hide_attr')) {
	
			foreach($prod_attr as $attr => $val) {					
				if($attr  == $name) {
					if($icon) {
						$icon = get_option('mg_wc_attr_'.sanitize_title($attr).'_icon');
						$code .= (!empty($icon)) ? '<i class="mg_cust_opt_icon fa '. esc_attr($icon) .'">&nbsp;</i> ': ''; // TODO - check new fa
					}
					if($label) {
						$code .= '<span class="mgom_ol_attr_label">'.$attr.'</span> ';	
					}
					
					$code .= do_shortcode(implode(', ', $val));
					break;
				}
			}
		}
	}
	
	return $code;
}
add_shortcode('mgom-item-attr', 'mgom_item_attr_shortcode');






// [mgom-type-txt] 
//// prints content only for targeted item types
function mgom_type_txt_shortcode($atts, $content = null) {
	extract( shortcode_atts( array(
		'type' => ''
	), $atts ) );
	
	// must have a type and $GLOBALS['mg_item_id'] must exist
	if(!$type || !isset($GLOBALS['mg_item_id'])) {
        return '';
    }
	
	$types = mg_static::item_types();
	unset($types['spacer'], $types['inl_text'], $types['inl_slider']);
	
	$item_id = $GLOBALS['mg_item_id'];
	
	switch(get_post_type($item_id)) {
		
		case 'product' 	: 
			$curr_type = 'woocom'; 
			break;
		
		case 'mg_items' : 
			$curr_type = get_post_meta($item_id, 'mg_main_type', true);
			break;
			
		default 		: 
			$curr_type = 'post'; 
			break;
	}

	foreach($types as $id => $name) {
		if($id == $curr_type && $curr_type == $type) {
			return nl2br(do_shortcode($content));
			break;	
		}
	}
	return '';
}
add_shortcode('mgom-type-txt', 'mgom_type_txt_shortcode');






// [mgom-mgaf-sect] 
//// prints item's value related to Advanced 
function mgom_mgaf_sect_shortcode($atts, $content = null) {

	extract( shortcode_atts( array(
		'slug' => ''
	), $atts ) );
	
	// must have a slug and $GLOBALS['mg_item_id'] must exist
	if(!$slug || !isset($GLOBALS['mg_item_id']) || !isset($GLOBALS['mgaf_sections'])) {
        return '';
    }
	
	global $mgaf_sections, $mgaf_atts;
	
	$item_id 	= $GLOBALS['mg_item_id']; 
	$sections 	= $mgaf_sections->get_sections();
	
	// section exists?
	if(!isset($sections[ $slug ])) {
		return '';	
	}
	
	
	
	$sect = $sections[ $slug ];
	$sect_icon = $sect['icon'];
	
	
	// range or options?
	if($sect['type'] == 'range') {
		$item_val = get_post_meta($item_id, $slug, true);
		
		if(is_numeric($item_val)) {
			return ($sect_icon) ? '<i class="fa '. $sect_icon .'"></i> '.$item_val : $item_val; // TODO - check new fa
		} else {
			return '';	
		}
	}
	
	else {
		$terms = wp_get_post_terms($item_id, $slug);
		
		if(empty($terms) || is_wp_error($terms)) {
			return '';	
		}
		else {
			$managed_terms = array();
			
			foreach($terms as $term) {
				
				$icon = $mgaf_atts->get_term_meta($slug, $term->term_id, 'mgaf_icon');
				$managed_terms[] = ($icon) ? '<i class="fa '. $icon .'"></i> '.$term->name : $term->name; // TODO - check new fa	
			}
			
			return implode(', ', $managed_terms);
		}
	}

	return '';
}
add_shortcode('mgom-mgaf-sect', 'mgom_mgaf_sect_shortcode');