<?php
/**
 * @author WP Cloud Plugins
 * @copyright Copyright (c) 2023, WP Cloud Plugins
 *
 * @since       2.10
 * @see https://www.wpcloudplugins.com
 */

namespace TheLion\OutoftheBox;

class Update
{
    public static function init()
    {
        add_action('in_plugin_update_message-'.OUTOFTHEBOX_SLUG, [__CLASS__, 'in_plugin_update_message'], 10, 2);
        // add_filter('auto_update_plugin', [__CLASS__, 'enable_plugin_auto_updates'], 10, 2);

        License::is_valid();

        require_once OUTOFTHEBOX_ROOTDIR.'/vendors/plugin-update-checker/plugin-update-checker.php';
        \YahnisElsts\PluginUpdateChecker\v5\PucFactory::buildUpdateChecker('https://www.wpcloudplugins.com/updates_v2/?action=get_metadata&slug=out-of-the-box&purchase_code='.License::get().'&plugin_id='.Core::$plugin_id.'&siteurl='.License::get_home_url(), plugin_dir_path(__DIR__).'/out-of-the-box.php');
    }

    /**
     *  Add custom Update messages in plugin dashboard.
     *
     * @param mixed $data
     * @param mixed $response
     */
    public static function in_plugin_update_message($data, $response)
    {
        if (isset($data['upgrade_notice'])) {
            printf(
                '<br /><br /><span style="display:inline-block;background-color: #590e54; padding: 10px; color: white;"><span class="dashicons dashicons-warning"></span>&nbsp;<strong>UPGRADE NOTICE</strong> <br /><br />%s</span><br /><br />',
                $data['upgrade_notice']
            );
        }
    }

    /**
     * Enable automatic updates for this plugin.
     *
     * @param bool   $value current auto-update status
     * @param object $item  plugin update object
     *
     * @return bool updated auto-update status
     */
    public static function enable_plugin_auto_updates($value, $item)
    {
        if ('out-of-the-box' === $item->slug) {
            return true; // Enable auto-updates for this plugin
        }

        return $value; // Preserve auto-update status for other plugins
    }
}
