jQuery(function ($) {
    var outofthebox_wc = {
        // hold a reference to the last selected Dropbox button
        lastSelectedButton: false,
        module: $('#wpcp-modal-selector-dropbox .wpcp-module'),

        init: function () {
            // place wpcp container bottom body
            $('#wpcp-modal-selector-dropbox').parent().appendTo('body');

            // add button for simple product
            this.addButtons();
            this.addButtonEventHandler();
            // add buttons when variable product added
            $('#variable_product_options').on('woocommerce_variations_added', function () {
                outofthebox_wc.addButtons();
                outofthebox_wc.addButtonEventHandler();
            });
            // add buttons when variable products loaded
            $('#woocommerce-product-data').on('woocommerce_variations_loaded', function () {
                outofthebox_wc.addButtons();
                outofthebox_wc.addButtonEventHandler();
            });

            // Select the already added files in the File Browser module
            this.initSelectAdded();
            this.initAddButton();

            return this;
        },

        addButtons: function () {
            var self = this;

            var button = $('<a class="button wpcp-insert-dropbox-content">' + outofthebox_woocommerce_translation.choose_from + '</a>');
            $('.downloadable_files').each(function (index) {
                // we want our button to appear next to the insert button
                var insertButton = $(this).find('a.button.insert');
                // check if button already exists on element, bail if so
                if ($(this).find('a.button.wpcp-insert-dropbox-content').length > 0) {
                    return;
                }

                // finally clone the button to the right place
                insertButton.after(button.clone());
            });

            /* START Support for WooCommerce Product Documents */

            $('.wc-product-documents .button.wc-product-documents-set-file').each(function (index) {
                // check if button already exists on element, bail if so
                if ($(this).parent().find('a.button.wpcp-insert-dropbox-content').length > 0) {
                    return;
                }

                // finally clone the button to the right place
                $(this).after(button.clone());
            });

            $('#wc-product-documents-data').on('click', '.wc-product-documents-add-document', function () {
                self.addButtons();
            });
            /* END Support for WooCommerce Product Documents */
        },
        /**
         * Adds the click event to the dropbox buttons
         * and opens the Dropbox chooser
         */
        addButtonEventHandler: function () {
            var self = this;

            $('#woocommerce-product-data').on('click', 'a.button.wpcp-insert-dropbox-content', function (e) {
                self.openSelector();
                e.preventDefault();

                // save a reference to clicked button
                outofthebox_wc.lastSelectedButton = $(this);
            });

            $('#wpcp-modal-selector-dropbox .wpcp-dialog-close').on('click', function (e) {
                self.closeSelector();
            });

            $('#wpcp-modal-selector-dropbox .wpcp-wc-dialog-entry-select').on('click', function (e) {
                const account_id = self.module.attr('data-account-id');
                const entries_data = self.module
                    .find("input[name='selected-files[]']:checked")
                    .map(function () {
                        const $entry = $('.entry[data-id="' + $(this).val() + '"]');

                        return {
                            entry_id: $entry.attr('data-id'),
                            entry_name: $entry.attr('data-name'),
                            account_id: account_id,
                            entry_path: decodeURIComponent($entry.attr('data-url'))
                        };
                    })
                    .get();

                if (entries_data.length === 0) {
                    return self.closeSelector();
                }

                // Send the data via postMessage
                window.top.postMessage(
                    {
                        slug: 'outofthebox',
                        action: 'wpcp-select-entries',
                        entries: entries_data
                    },
                    window.location.origin
                );

                setTimeout(function () {
                    self.closeSelector();
                }, 100);
            });
        },

        openSelector: function () {
            var self = this;

            window.addEventListener('message', outofthebox_wc.afterFileSelected);

            // Refresh File List to render the selected items
            if (self.module.hasClass('wpcp-thumb-view') || self.module.hasClass('wpcp-list-view')) {
                self.module.data('cp-OutoftheBox')._getFileList({});
            }

            $('#wpcp-modal-selector-dropbox').show();
            $('#wpcp-modal-selector-dropbox .wpcp-wc-dialog-entry-select').prop('disabled', 'disabled');
        },

        closeSelector: function () {
            window.removeEventListener('message', outofthebox_wc.afterFileSelected);
            $('#wpcp-modal-selector-dropbox').fadeOut();
        },

        /**
         * Mark already added file in the File Browser moulde
         */
        initSelectAdded: function () {
            const self = this;

            self.module.on('content-loaded', function (e, plugin) {
                plugin.element.find("input[name='selected-files[]']:checked").prop('checked', false).removeClass('is-selected');

                const added_files = $('.downloadable_files .file_url > input')
                    .filter(function (index) {
                        return $(this).val().includes('https://dropbox.com/');
                    })
                    .toArray();

                added_files.forEach(function (input, index, array) {
                    const url = new URL($(input).val());
                    const entry_id = Base64.decode(decodeURIComponent(url.searchParams.get('id')));
                    const account_id = url.searchParams.get('account_id');

                    // Show the entry as selected
                    $('.wpcp-module[data-account-id="' + account_id + '"] .entry[data-id="' + entry_id + '"]').addClass('is-selected');
                });
            });
        },

        /**
         * Enable & Disable add button based on selection of entries
         */
        initAddButton: function () {
            var self = this;
            $(self.module).on(
                {
                    change: function (e) {
                        if (self.module.find("input[name='selected-files[]']:checked").length) {
                            $('#wpcp-modal-selector-dropbox .wpcp-wc-dialog-entry-select').prop('disabled', '');
                        } else {
                            $('#wpcp-modal-selector-dropbox .wpcp-wc-dialog-entry-select').prop('disabled', 'disabled');
                        }
                    }
                },
                "input[name='selected-files[]']"
            );
        },

        /**
         * Handle selected files
         */
        afterFileSelected: function (event) {
            var self = this;

            if (event.origin !== window.location.origin) {
                return;
            }

            if (typeof event.data !== 'object' || event.data === null || typeof event.data.action === 'undefined') {
                return;
            }

            if (event.data.action !== 'wpcp-select-entries') {
                return;
            }

            if (event.data.slug !== 'outofthebox') {
                return;
            }

            let files_added = [];
            let files_failed = [];

            event.data.entries.forEach(function (entry, index, array) {
                // Make sure only a single instance of the file can be added
                if (
                    $('.downloadable_files .file_url > input').filter(function (index) {
                        return $(this)
                            .val()
                            .includes(encodeURIComponent(Base64.encode(entry.entry_id)) + '&account_id=' + entry.account_id);
                    }).length
                ) {
                    files_failed.push(entry.entry_name);
                    return false;
                }

                if ($(outofthebox_wc.lastSelectedButton).closest('.downloadable_files').length > 0) {
                    var table = $(outofthebox_wc.lastSelectedButton).closest('.downloadable_files').find('tbody');
                    var template = $(outofthebox_wc.lastSelectedButton).parent().find('.button.insert:first').data('row');
                    var fileRow = $(template);

                    fileRow.find('.file_name > input:first').val(entry.entry_name).change();
                    fileRow
                        .find('.file_url > input')
                        .val(
                            'https://dropbox.com/' +
                                decodeURIComponent(entry.entry_id) +
                                outofthebox_woocommerce_translation.download_url +
                                encodeURIComponent(Base64.encode(entry.entry_id)) +
                                '&account_id=' +
                                entry.account_id
                        );
                    table.append(fileRow);

                    // trigger change event so we can save variation
                    $(table).find('input').last().change();
                }

                /* START Support for WooCommerce Product Documents */
                if ($(outofthebox_wc.lastSelectedButton).closest('.wc-product-document').length > 0) {
                    var row = $(outofthebox_wc.lastSelectedButton).closest('.wc-product-document');

                    row.find('.wc-product-document-label input:first').val(entry.entry_name).change();
                    row.find('.wc-product-document-file-location input:first').val(
                        outofthebox_woocommerce_translation.wcpd_url +
                            encodeURIComponent(Base64.encode(entry.entry_id)) +
                            '&account_id=' +
                            entry.account_id
                    );
                }
                /* END Support for WooCommerce Product Documents */

                // Show the entry as selected
                $('.wpcp-module[data-account-id="' + entry.account_id + '"] .entry[data-id="' + entry.entry_id + '"]').addClass(
                    'is-selected'
                );

                files_added.push(entry.entry_name);
            });

            if (files_failed.length) {
                $('p.wpcp-notification-failed').html(
                    outofthebox_woocommerce_translation.notification_failed_file_msg.replace(
                        '{filename}',
                        '<strong>' + files_failed.join(', ') + '</strong>'
                    )
                );
                window.showNotification(false);
            }

            if (files_added.length) {
                $('p.wpcp-notification-success').html(
                    outofthebox_woocommerce_translation.notification_success_file_msg.replace(
                        '{filename}',
                        '<strong>' + files_added.join(', ') + '</strong>'
                    )
                );
                window.showNotification(true);
            }
        }
    };
    window.outofthebox_wc = outofthebox_wc.init();

    /* Callback function to add shortcode to WC field */
    if (typeof window.wpcp_outofthebox_wc_add_content === 'undefined') {
        window.wpcp_outofthebox_wc_add_content = function (data) {
            $('#outofthebox_upload_box_shortcode').val(data);
            tb_remove();
        };
    }

    $('input#_uploadable').on('change', function () {
        var is_uploadable = $('input#_uploadable:checked').length;
        $('.show_if_uploadable').hide();
        $('.hide_if_uploadable').hide();
        if (is_uploadable) {
            $('.hide_if_uploadable').hide();
        }
        if (is_uploadable) {
            $('.show_if_uploadable').show();
        }
    });
    $('input#_uploadable').trigger('change');

    $('input#outofthebox_upload_box').on('change', function () {
        var outofthebox_upload_box = $('input#outofthebox_upload_box:checked').length;
        $('.show_if_outofthebox_upload_box').hide();
        if (outofthebox_upload_box) {
            $('.show_if_outofthebox_upload_box').show();
        }
    });
    $('input#outofthebox_upload_box').trigger('change');

    /* Shortcode Generator Popup */
    $('.OutoftheBox-shortcodegenerator').on('click', function (e) {
        var shortcode = $('#outofthebox_upload_box_shortcode').val();
        shortcode = shortcode.replace('[outofthebox ', '').replace('"]', '');
        var query = encodeURIComponent(shortcode).split('%3D%22').join('=').split('%22%20').join('&');
        tb_show(
            'Build Shortcode for Product',
            ajaxurl +
                '?action=outofthebox-getpopup&' +
                query +
                '&type=shortcodebuilder&for=woocommerce&asuploadbox=1&callback=wpcp_outofthebox_wc_add_content&TB_iframe=true&height=600&width=1024'
        );
    });

    // Create Base64 Object
    let Base64 = {
        _keyStr: 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=',
        encode: function (e) {
            var t = '';
            var n, r, i, s, o, u, a;
            var f = 0;
            e = Base64._utf8_encode(e);
            while (f < e.length) {
                n = e.charCodeAt(f++);
                r = e.charCodeAt(f++);
                i = e.charCodeAt(f++);
                s = n >> 2;
                o = ((n & 3) << 4) | (r >> 4);
                u = ((r & 15) << 2) | (i >> 6);
                a = i & 63;
                if (isNaN(r)) {
                    u = a = 64;
                } else if (isNaN(i)) {
                    a = 64;
                }
                t = t + this._keyStr.charAt(s) + this._keyStr.charAt(o) + this._keyStr.charAt(u) + this._keyStr.charAt(a);
            }
            return t;
        },
        decode: function (e) {
            var t = '';
            var n, r, i;
            var s, o, u, a;
            var f = 0;
            e = e.replace(/[^A-Za-z0-9+/=]/g, '');
            while (f < e.length) {
                s = this._keyStr.indexOf(e.charAt(f++));
                o = this._keyStr.indexOf(e.charAt(f++));
                u = this._keyStr.indexOf(e.charAt(f++));
                a = this._keyStr.indexOf(e.charAt(f++));
                n = (s << 2) | (o >> 4);
                r = ((o & 15) << 4) | (u >> 2);
                i = ((u & 3) << 6) | a;
                t = t + String.fromCharCode(n);
                if (u != 64) {
                    t = t + String.fromCharCode(r);
                }
                if (a != 64) {
                    t = t + String.fromCharCode(i);
                }
            }
            t = Base64._utf8_decode(t);
            return t;
        },
        _utf8_encode: function (e) {
            e = e.replace(/rn/g, 'n');
            var t = '';
            for (var n = 0; n < e.length; n++) {
                var r = e.charCodeAt(n);
                if (r < 128) {
                    t += String.fromCharCode(r);
                } else if (r > 127 && r < 2048) {
                    t += String.fromCharCode((r >> 6) | 192);
                    t += String.fromCharCode((r & 63) | 128);
                } else {
                    t += String.fromCharCode((r >> 12) | 224);
                    t += String.fromCharCode(((r >> 6) & 63) | 128);
                    t += String.fromCharCode((r & 63) | 128);
                }
            }
            return t;
        },
        _utf8_decode: function (e) {
            var t = '';
            var n = 0;
            var r, c1, c2;
            r = c1 = c2 = 0;
            while (n < e.length) {
                r = e.charCodeAt(n);
                if (r < 128) {
                    t += String.fromCharCode(r);
                    n++;
                } else if (r > 191 && r < 224) {
                    c2 = e.charCodeAt(n + 1);
                    t += String.fromCharCode(((r & 31) << 6) | (c2 & 63));
                    n += 2;
                } else {
                    c2 = e.charCodeAt(n + 1);
                    c3 = e.charCodeAt(n + 2);
                    t += String.fromCharCode(((r & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                    n += 3;
                }
            }
            return t;
        }
    };
});
