'use strict';

(function () {
    var oftb_toolbarActive = false;

    // CallBack function to add content to Classic MCE editor //
    window.wpcp_add_content_to_mce = function (content) {
        tinymce.activeEditor.execCommand('mceInsertContent', false, content);
        tinymce.activeEditor.windowManager.close();
        tinymce.activeEditor.focus();
    };

    tinymce.create('tinymce.plugins.outofthebox', {
        init: function (ed, url) {
            var t = this;
            t.url = url;

            ed.addCommand('mceOutoftheBox', function (query) {
                ed.windowManager.open(
                    {
                        file: ajaxurl + '?action=outofthebox-getpopup&type=shortcodebuilder&' + query + '&callback=wpcp_add_content_to_mce',
                        width: 1024,
                        height: 600,
                        inline: 1
                    },
                    {
                        plugin_url: url
                    }
                );
            });
            ed.addCommand('mceOutoftheBox_links', function () {
                ed.windowManager.open(
                    {
                        file: ajaxurl + '?action=outofthebox-getpopup&type=links&callback=wpcp_add_content_to_mce',
                        width: 1024,
                        height: 600,
                        inline: 1
                    },
                    {
                        plugin_url: url
                    }
                );
            });
            ed.addCommand('mceOutoftheBox_embedded', function () {
                ed.windowManager.open(
                    {
                        file: ajaxurl + '?action=outofthebox-getpopup&type=embedded&callback=wpcp_add_content_to_mce',
                        width: 1024,
                        height: 600,
                        inline: 1
                    },
                    {
                        plugin_url: url
                    }
                );
            });
            ed.addButton('outofthebox', {
                title: 'Out-of-the-Box shortcode',
                image: url + '/../../css/images/dropbox_logo.png',
                cmd: 'mceOutoftheBox'
            });
            ed.addButton('outofthebox_links', {
                title: 'Out-of-the-Box links',
                image: url + '/../../css/images/dropbox_logo_link.png',
                cmd: 'mceOutoftheBox_links'
            });
            ed.addButton('outofthebox_embedded', {
                title: 'Embed Files from Dropbox',
                image: url + '/../../css/images/dropbox_logo_embedded.png',
                cmd: 'mceOutoftheBox_embedded'
            });

            ed.on('mousedown', function (event) {
                if (ed.dom.getParent(event.target, '#wp-oftb-toolbar')) {
                    if (tinymce.Env.ie) {
                        // Stop IE > 8 from making the wrapper resizable on mousedown
                        event.preventDefault();
                    }
                } else {
                    removeOftBToolbar(ed);
                }
            });

            ed.on('mouseup', function (event) {
                var image,
                    node = event.target,
                    dom = ed.dom;

                // Don't trigger on right-click
                if (event.button && event.button > 1) {
                    return;
                }

                if (node.nodeName === 'DIV' && dom.getParent(node, '#wp-oftb-toolbar')) {
                    image = dom.select('img[data-wp-oftbselect]')[0];

                    if (image) {
                        ed.selection.select(image);

                        if (dom.hasClass(node, 'remove')) {
                            removeOftBToolbar(ed);
                            removeOftBImage(image, ed);
                        } else if (dom.hasClass(node, 'edit')) {
                            var shortcode = ed.selection.getContent();
                            shortcode = shortcode.replace('</p>', '').replace('<p>', '').replace('[outofthebox ', '').replace('"]', '');
                            var query = encodeURIComponent(shortcode).split('%3D%22').join('=').split('%22%20').join('&');
                            removeOftBToolbar(ed);
                            ed.execCommand('mceOutoftheBox', query);
                        }
                    }
                } else if (node.nodeName === 'IMG' && !ed.dom.getAttrib(node, 'data-wp-oftbselect') && isOftBPlaceholder(node, ed)) {
                    addOftBToolbar(node, ed);
                } else if (node.nodeName !== 'IMG') {
                    removeOftBToolbar(ed);
                }
            });

            ed.on('keydown', function (event) {
                var keyCode = event.keyCode;
                // Key presses will replace the image so we need to remove the toolbar
                if (oftb_toolbarActive) {
                    if (event.ctrlKey || event.metaKey || event.altKey || (keyCode < 48 && keyCode > 90) || keyCode > 186) {
                        return;
                    }

                    removeOftBToolbar(ed);
                }
            });

            ed.on('cut', function () {
                removeOftBToolbar(ed);
            });

            ed.on('BeforeSetcontent', function (ed) {
                ed.content = t._do_oftb_shortcode(ed.content, t.url);
            });
            ed.on('PostProcess', function (ed) {
                if (ed.get) ed.content = t._get_oftb_shortcode(ed.content);
            });
        },
        _do_oftb_shortcode: function (co, url) {
            return co.replace(/\[outofthebox([^\]]*)\]/g, function (a, b) {
                return (
                    '<img src="' +
                    url +
                    '/../../css/images/transparant.png" class="wp_oftb_shortcode mceItem" title="Out-of-the-Box" data-mce-placeholder="1" data-code="' +
                    toBinary(b) +
                    '"/>'
                );
            });
        },
        _get_oftb_shortcode: function (co) {
            function getAttr(s, n) {
                n = new RegExp(n + '="([^"]+)"', 'g').exec(s);
                return n ? n[1] : '';
            }

            return co.replace(/(?:<p[^>]*>)*(<img[^>]+>)(?:<\/p>)*/g, function (a, im) {
                var cls = getAttr(im, 'class');

                if (cls.indexOf('wp_oftb_shortcode') != -1)
                    return '<p>[outofthebox ' + tinymce.trim(fromBinary(getAttr(im, 'data-code'))) + ']</p>';

                return a;
            });
        },
        createControl: function (n, cm) {
            return null;
        }
    });

    tinymce.PluginManager.add('outofthebox', tinymce.plugins.outofthebox);

    function removeOftBImage(node, editor) {
        editor.dom.remove(node);
        removeOftBToolbar(editor);
    }

    function addOftBToolbar(node, editor) {
        var toolbarHtml,
            toolbar,
            dom = editor.dom;

        removeOftBToolbar(editor);

        // Don't add to placeholders
        if (!node || node.nodeName !== 'IMG' || !isOftBPlaceholder(node, editor)) {
            return;
        }

        dom.setAttrib(node, 'data-wp-oftbselect', 1);

        toolbarHtml =
            '<div class="dashicons dashicons-edit edit" data-mce-bogus="1"></div>' +
            '<div class="dashicons dashicons-no-alt remove" data-mce-bogus="1"></div>';

        toolbar = dom.create(
            'div',
            {
                id: 'wp-oftb-toolbar',
                'data-mce-bogus': '1',
                contenteditable: false
            },
            toolbarHtml
        );

        var parentDiv = node.parentNode;
        parentDiv.insertBefore(toolbar, node);

        oftb_toolbarActive = true;
    }

    function removeOftBToolbar(editor) {
        var toolbar = editor.dom.get('wp-oftb-toolbar');

        if (toolbar) {
            editor.dom.remove(toolbar);
        }

        editor.dom.setAttrib(editor.dom.select('img[data-wp-oftbselect]'), 'data-wp-oftbselect', null);

        oftb_toolbarActive = false;
    }

    function isOftBPlaceholder(node, editor) {
        var dom = editor.dom;

        if (dom.hasClass(node, 'wp_oftb_shortcode')) {
            return true;
        }

        return false;
    }

    function toBinary(str) {
        return btoa(
            encodeURIComponent(str).replace(/%([0-9A-F]{2})/g, function toSolidBytes(match, p1) {
                return String.fromCharCode('0x' + p1);
            })
        );
    }

    function fromBinary(str) {
        return decodeURIComponent(
            atob(str)
                .split('')
                .map(function (c) {
                    return '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2);
                })
                .join('')
        );
    }
})();
