<?php

namespace TheLion\OutoftheBox\Vendors\GuzzleHttp;

use TheLion\OutoftheBox\Vendors\Psr\Http\Message\MessageInterface;

final class BodySummarizer implements BodySummarizerInterface
{
    /**
     * @var null|int
     */
    private $truncateAt;

    public function __construct(int $truncateAt = null)
    {
        $this->truncateAt = $truncateAt;
    }

    /**
     * Returns a summarized message body.
     */
    public function summarize(MessageInterface $message): ?string
    {
        return null === $this->truncateAt
            ? \TheLion\OutoftheBox\Vendors\GuzzleHttp\Psr7\Message::bodySummary($message)
            : \TheLion\OutoftheBox\Vendors\GuzzleHttp\Psr7\Message::bodySummary($message, $this->truncateAt);
    }
}
