<?php

namespace TheLion\OutoftheBox\Vendors\GuzzleHttp\Handler;

use TheLion\OutoftheBox\Vendors\GuzzleHttp\Promise\PromiseInterface;
use TheLion\OutoftheBox\Vendors\Psr\Http\Message\RequestInterface;

/**
 * HTTP handler that uses cURL easy handles as a transport layer.
 *
 * When using the CurlHandler, custom curl options can be specified as an
 * associative array of curl option constants mapping to values in the
 * **curl** key of the "client" key of the request.
 *
 * @final
 */
class CurlHandler
{
    /**
     * @var CurlFactoryInterface
     */
    private $factory;

    /**
     * Accepts an associative array of options:.
     *
     * - handle_factory: Optional curl factory used to create cURL handles.
     *
     * @param array{handle_factory?: ?CurlFactoryInterface} $options Array of options to use with the handler
     */
    public function __construct(array $options = [])
    {
        $this->factory = $options['handle_factory']
            ?? new CurlFactory(3);
    }

    public function __invoke(RequestInterface $request, array $options): PromiseInterface
    {
        if (isset($options['delay'])) {
            \usleep($options['delay'] * 1000);
        }

        $easy = $this->factory->create($request, $options);

        // DEBUG: Verbose
        
        // file_put_contents(OUTOFTHEBOX_CACHEDIR.'api.log', ' ***********'.date('c')."************* \r\n", FILE_APPEND);
        // file_put_contents(OUTOFTHEBOX_CACHEDIR.'api.log', var_export($request->getUri()->getPath()."\r\n", true), FILE_APPEND);
        // file_put_contents(OUTOFTHEBOX_CACHEDIR.'api.log', var_export($request->getBody()."\r\n", true), FILE_APPEND);
        // file_put_contents(OUTOFTHEBOX_CACHEDIR.'api.log', var_export($request->getBody()->getContents()."\r\n", true), FILE_APPEND);

        // curl_setopt($easy->handle, CURLOPT_VERBOSE, true);
        // $verbose = fopen('php://temp', 'w+');
        // curl_setopt($easy->handle, CURLOPT_STDERR, $verbose);

        \curl_exec($easy->handle);

        // DEBUG: Output Verbose
        // rewind($verbose);
        // $verboseLog = stream_get_contents($verbose);
        // file_put_contents(OUTOFTHEBOX_CACHEDIR.'api.log', $verboseLog, FILE_APPEND);

        $easy->errno = \curl_errno($easy->handle);

        return CurlFactory::finish($this, $easy, $this->factory);
    }
}