<?php

/**
Plugin Name: PDF Wizard - Responsive FlipBook WP Extension
Plugin URI: http://codecanyon.net/user/mpc
Description: This plugin extend Responsive Flip Book Wordpress Plugin with PDF support.
Version: 3.0.3
Author: MassivePixelCreation
Author URI: http://codecanyon.net/user/mpc
Text Domain: rfbwp-pdf
Domain Path: /languages/
**/

add_action( 'plugins_loaded', 'rfb_pdf_localization' );
function rfb_pdf_localization() {
	load_plugin_textdomain( 'rfbwp-pdf', false, basename( dirname( __FILE__ ) ) . 'languages/' );
}

add_action( 'admin_init', 'rfb_pdf_init', 99999 );
function rfb_pdf_init() {
	if ( ! defined( 'MPC_PLUGIN_FILE' ) ) {
		return;
	}

	$plugin_path = plugin_basename( MPC_PLUGIN_FILE );

	if ( is_plugin_inactive( $plugin_path ) ) {
		return;
	}

	define( 'RFB_PDF_PLUGIN_ROOT', plugin_dir_url( __FILE__ ) );

	add_action( 'rfbwp/scripts', 'rfb_pdf_enqueue_scripts' );

	add_filter( 'rfbwp/addNewBook', 'rfb_pdf_convert_button' );
	add_filter( 'rfbwp/afterTable', 'rfb_pdf_display_wizard' );
	add_filter( 'rfbwp/addNewBookBottom', 'rfb_pdf_convert_button' );
	add_filter( 'rfbwp/addNewBookBottom', 'rfb_pdf_cancel_button' );

	require_once( plugin_dir_path( __FILE__ ) . 'pdf_wizard.php' );
}

function rfb_pdf_enqueue_scripts() {
	/* PDF Wizard */
	wp_enqueue_style( 'rfbwp-pdf-css', RFB_PDF_PLUGIN_ROOT . 'css/pdf_wizard.css' );
	wp_enqueue_script( 'rfbwp-pdf-worker-js-js', RFB_PDF_PLUGIN_ROOT . 'js/pdf.worker.js' );
	wp_enqueue_script( 'rfbwp-pdf-js-js', RFB_PDF_PLUGIN_ROOT . 'js/pdf.js' );
	wp_enqueue_script( 'rfbwp-pdf-js', RFB_PDF_PLUGIN_ROOT . 'js/pdf_wizard' . ( defined( 'MPC_DEBUG' ) ? '' : '.min' ) . '.js', array( 'jquery', 'rfbwp-pdf-js-js', 'rfbwp-pdf-worker-js-js' ) );

	wp_localize_script( 'rfbwp-pdf-js', 'mpcthPDFLocalize', array(
		'refreshBlockMessage' => __( "Are you sure you want to end conversion? If the process don't finish your FlipBook wont be created.", 'rfbwp-pdf' ),
		'processingFile'      => __( "Processing file. Please wait...", 'rfbwp-pdf' ),
		'convertFile'         => __( "Convert PDF", 'rfbwp-pdf' )
	) );
}

function rfb_pdf_convert_button( $content ) {
	return '<a class="convert-book mpc-button revert" href="#"><i class="dashicons dashicons-book"></i> ' . __( 'Convert PDF', 'rfbwp-pdf' ) .'</a>' . $content;
}

function rfb_pdf_display_wizard( $content ) {
	return rfbwp_display_pdf_wizard();
}

function rfb_pdf_cancel_button( $content ) {
	return $content . '<a class="cancel-convert-book mpc-button revert close" href="#"><i class="dashicons dashicons-no"></i> ' . __( 'Cancel', 'rfbwp-pdf' ) .'</a>';
}