/* PDF Wizard */

PDFJS.disableWorker = true;

jQuery( document ).ready( function( $ ) {
	"use strict";
	//----------------------------------------------------------------------------//
	//	REINIT FORM
	//----------------------------------------------------------------------------//
	function check_reinit() {
		if( ! jQuery.contains( document.documentElement, $input_name[ 0 ] ) ) {
			reinit_form();
		}
	}

	function reinit_form() {
		$error_box         = $( '#rfbwp_error_box' );
		$step_name         = $( '#rfbwp_step_options' );
		$step_pdf          = $( '#rfbwp_step_pdf' );
		$step_convert      = $( '#rfbwp_step_convert' );
		$input_name        = $( '#rfbwp_name' );
		$input_pdf         = $( '#rfbwp_pdf' );
		$input_pdf_overlay = $( '#rfbwp_pdf_overlay' );
		$input_convert     = $( '#rfbwp_convert' );
		$progress          = $( '#rfbwp_converting' );
		page_canvas        = document.getElementById( 'rfbwp_canvas' );
		page_context       = page_canvas.getContext( '2d' );
		page_image         = document.getElementById( 'rfbwp_image' );

		$step_name.addClass( 'rfbwp-active' );
		$input_convert.removeClass( 'converting' );
		$input_convert.text( mpcthPDFLocalize.convertFile );

		$input_name.on( 'keyup', init_input_name );
		$input_pdf.on( 'change', init_input_pdf );

		if ( ! $input_convert.hasClass( 'converting' ) ) {
			$input_convert.on( 'click', init_input_convert );
		}
	}

	//----------------------------------------------------------------------------//
	//	RESET FORM
	//----------------------------------------------------------------------------//
	function reset_form() {
		$input_name.val( '' );

		$input_pdf.val( '' );
		$input_pdf.prop( 'disabled', false );

		$input_pdf_overlay.text( $input_pdf_overlay.attr( 'data-text' ) );

		$error_box.attr( 'data-error', '' );

		$window.unbind( 'beforeunload' );

		$step_pdf.removeClass( 'rfbwp-active' );
		$step_convert.removeClass( 'rfbwp-active' );
		$step_name.addClass( 'rfbwp-active' );
	}

	//----------------------------------------------------------------------------//
	//	PROGRESS
	//----------------------------------------------------------------------------//
	function update_progress() {
		var _value = 0;

		if ( _page_index !== _pdf_file.numPages ) {
			_value = ( ( _page_index / _pdf_file.numPages ) * 100 * .9 ) >> 0; // Multiply by 0.9 to limit rendering to 90% of full progress.
		}

		set_progress( _value );
	}

	function set_progress( value ) {
		value += '%';

		$progress._value.text( value );
		$progress._line.width( value );
	}

	//----------------------------------------------------------------------------//
	//	READ PDF INFO
	//----------------------------------------------------------------------------//
	function read_pdf_info( pdf_file ) {
		var _name = _pdf_file.name;

		_pdf_file = pdf_file;

		if ( _pdf_file.numPages > 3 ) {
			$input_pdf_overlay
				.text( _name )
				.addClass( 'rfbwp-active' );

			$step_convert.addClass( 'rfbwp-active' );
		} else {
			$error_box.attr( 'data-error', 'pages' );
		}
	}

	//----------------------------------------------------------------------------//
	//	GET PDF PAGE
	//----------------------------------------------------------------------------//
	function get_pdf_page() {
		_pdf_file.getPage( _page_index ).then( render_single_page );
	}

	//----------------------------------------------------------------------------//
	//	RENDER SINGLE IMAGE
	//----------------------------------------------------------------------------//
	function render_single_page( pdf_page ) {
		var _viewport = pdf_page.getViewport( _scale );

		page_canvas.height = _viewport.height;
		page_canvas.width  = _viewport.width;

		page_context.clearRect( 0, 0, page_canvas.width, page_canvas.height );

		var _task = pdf_page.render( {
			canvasContext: page_context,
			viewport:      _viewport
		} );

		_task.promise.then( function() {
			page_image.setAttribute( 'src', page_canvas.toDataURL( 'image/jpeg' ) );

			local_import_single_image();
		} );
	}

	//----------------------------------------------------------------------------//
	//	IMPORT SINGLE IMAGE
	//----------------------------------------------------------------------------//
	function local_import_single_image() {
		$.post( ajaxurl, {
			action: 'rfbwp_local_import_single_image',
			fb_name: _flipbook_name,
			image_index: _page_index,
			image_sring: page_image.getAttribute( 'src' )
		}, function( response ) {
			update_progress();

			if ( response !== null && typeof response.data !== 'undefined' ) {
				_uploaded_images.push( response.data );

				++_page_index;

				if ( _page_index <= _pdf_file.numPages ) {
					_pdf_file.getPage( _page_index ).then( render_single_page );
				} else {
					create_new_flipbook();
				}
			} else {
				import_error();
			}
		}, 'json' ).fail( function() {
			import_error();
		} );
	}

	function import_error() {
		$input_pdf.val( '' );
		$input_pdf.prop( 'disabled', false );

		$step_convert.removeClass( 'rfbwp-active' );

		$window.unbind( 'beforeunload' );

		$error_box.attr( 'data-error', 'import' );

		set_progress( 0 );
	}

	//----------------------------------------------------------------------------//
	//	CREATE NEW FLIPBOOK
	//----------------------------------------------------------------------------//
	function create_new_flipbook() {
		set_progress( 95 );

		_flipbook.rfbwp_fb_name   = _flipbook_name;
		_flipbook.rfbwp_fb_width  = _uploaded_images[ 0 ].width;
		_flipbook.rfbwp_fb_height = _uploaded_images[ 0 ].height;

		var _single_width = _uploaded_images[ 0 ].width,
			_page_index   = 1;

		_flipbook.pages.push( {
			'rfbwp_fb_page_type':         'Single Page',
			'rfbwp_fb_page_bg_image':     _uploaded_images[ 0 ].url,
			'rfbwp_fb_page_index':        0,
			'rfbwp_fb_page_custom_class': '',
			'rfbwp_page_css':             '',
			'rfbwp_page_html':            '',
			'rfbwp_fb_page_url':          ''
		} );

		for ( var index = 1; index < _uploaded_images.length - 1; index++ ) {

			var _page_ratio = _uploaded_images[ index ].width / _single_width;

			_flipbook.pages.push( {
				'rfbwp_fb_page_type':         ( _page_ratio >= 2 ) ? 'Double Page' : 'Single Page',
				'rfbwp_fb_page_bg_image':     _uploaded_images[ index ].url,
				'rfbwp_fb_page_index':        _page_index,
				'rfbwp_fb_page_custom_class': '',
				'rfbwp_page_css':             '',
				'rfbwp_page_html':            '',
				'rfbwp_fb_page_url':          ''
			} );

			_page_index += ( _page_ratio >= 2 ) ? 2 : 1;
		}

		_flipbook.pages.push( {
			'rfbwp_fb_page_type':         'Single Page',
			'rfbwp_fb_page_bg_image':     _uploaded_images[ _uploaded_images.length - 1 ].url,
			'rfbwp_fb_page_index':        _page_index,
			'rfbwp_fb_page_custom_class': '',
			'rfbwp_page_css':             '',
			'rfbwp_page_html':            '',
			'rfbwp_fb_page_url':          ''
		} );

		save_new_flipbook();
	}

	//----------------------------------------------------------------------------//
	//	CREATE NEW FLIPBOOK
	//----------------------------------------------------------------------------//
	function save_new_flipbook() {
		$.post( ajaxurl, {
			action: 'rfbwp_create_new_flipbook',
			flipbook: _flipbook
		}, function() {
			set_progress( 100 );

			$window.unbind( 'beforeunload' );

			setTimeout( function() {
				location.reload();
			}, 100 );
		} );
	}

	//----------------------------------------------------------------------------//
	//	FLIPBOOK NAME - INPUT
	//----------------------------------------------------------------------------//
	function init_input_name() {
		_flipbook_name = $input_name.val().trim();

		if ( _flipbook_name.length >= 3 ) {
			$step_pdf.addClass( 'rfbwp-active' );
		} else {
			$step_pdf.removeClass( 'rfbwp-active' );
			$step_convert.removeClass( 'rfbwp-active' );
		}
	}

	//----------------------------------------------------------------------------//
	//	SELECT PDF FILE - INPUT
	//----------------------------------------------------------------------------//
	function init_input_pdf() {
		if ( _pdf_file = $input_pdf[ 0 ].files[ 0 ] ) {
			if ( _pdf_file.type !== 'application/pdf' ) {
				$error_box.attr( 'data-error', 'file' );

				return;
			} else {
				$error_box.attr( 'data-error', '' );
			}

			_file_reader = new FileReader();
			_file_reader.onload = function() {
				PDFJS.getDocument( _file_reader.result ).then( read_pdf_info, function( error ) {
					$step_convert.removeClass( 'rfbwp-active' );

					$error_box.attr( 'data-error', 'file' );
				} );
			};

			_file_reader.readAsArrayBuffer( _pdf_file );
		}
	}

	//----------------------------------------------------------------------------//
	//	BEGIN CONVERTION - INPUT
	//----------------------------------------------------------------------------//
	function init_input_convert( event ) {
		event.preventDefault();

		$window.bind( 'beforeunload', function() {
			return mpcthPDFLocalize.refreshBlockMessage;
		});

		$input_pdf.prop( 'disabled', true );
		$input_convert.addClass( 'converting' );
		$input_convert.text( mpcthPDFLocalize.processingFile );

		$step_name.removeClass( 'rfbwp-active' );
		$step_pdf.removeClass( 'rfbwp-active' );

		get_pdf_page();
	}

	/* Form elements */
	var $window            = $( window ),
		$panel             = $( '#field-rfbwp_books' ),
		$panel_wrap        = $( '.wrap' ),
		$error_box         = $( '#rfbwp_error_box' ),
		$step_name         = $( '#rfbwp_step_options' ),
		$step_pdf          = $( '#rfbwp_step_pdf' ),
		$step_convert      = $( '#rfbwp_step_convert' ),
		$input_name        = $( '#rfbwp_name' ),
		$input_pdf         = $( '#rfbwp_pdf' ),
		$input_pdf_overlay = $( '#rfbwp_pdf_overlay' ),
		$input_convert     = $( '#rfbwp_convert' ),
		$progress          = $( '#rfbwp_converting' ),
		page_canvas        = document.getElementById( 'rfbwp_canvas' ),
		page_context       = page_canvas.getContext( '2d' ),
		page_image         = document.getElementById( 'rfbwp_image' );

	$progress._value = $progress.find( '.rfbwp-value' );
	$progress._line  = $progress.find( '.rfbwp-line' );
	$progress._time  = $progress.find( '.rfbwp-time' );

	/* Global variables */
	var _flipbook_name   = '',
		_pdf_file,
		_file_reader,
		_page_index      = 1,
		_image_index     = 0,
		_scale           = 1.5,
		_uploaded_images = [];

	/* Flipbook base */
	var _flipbook = {
		rfbwp_fb_name:   'Flipbook',
		rfbwp_fb_width:  '400',
		rfbwp_fb_height: '500',
		pages:           []
	};

	//----------------------------------------------------------------------------//
	//	RESET VALUES
	//----------------------------------------------------------------------------//
	$window.on( 'rfbwp-init-pdf-wizard', function() {
		_flipbook_name   = '';
		_pdf_file        = null;
		_file_reader     = null;
		_page_index      = 1;
		_image_index     = 0;
		_uploaded_images = [];

		_flipbook = {
			rfbwp_fb_name:   'Flipbook',
			rfbwp_fb_width:  '400',
			rfbwp_fb_height: '500',
			pages:           []
		};

		setTimeout( function() {
			$input_name.focus();
		}, 500 );
	} );

	//----------------------------------------------------------------------------//
	//	INPUTS
	//----------------------------------------------------------------------------//
	$input_name.on( 'keyup', init_input_name );
	$input_pdf.on( 'change', init_input_pdf );
	$input_convert.on( 'click', init_input_convert );

	//----------------------------------------------------------------------------//
	//	PDF WIZARD TOGGLE
	//----------------------------------------------------------------------------//
	$panel_wrap.on( 'click', 'a.convert-book', function( e ) {
		e.preventDefault();

		$panel.hide();

		$panel_wrap.addClass( 'rfbwp-mode-pdf-wizard' );
		$window.trigger( 'rfbwp-init-pdf-wizard' );

		$panel.fadeIn( '250' );

		check_reinit();
	});

	$panel_wrap.on( 'click', 'a.cancel-convert-book', function( e ) {
		e.preventDefault();

		$panel.hide();

		$panel_wrap.removeClass( 'rfbwp-mode-pdf-wizard' );

		reset_form();

		$panel.fadeIn( '250' );
	});

	$panel_wrap.on( 'click', 'a.rfbwp-restart', function( e ) {
		$window.unbind( 'beforeunload' );

		location.reload();
	} );

	$window.on( 'rfbwp-pdf-convert-end', function() {
		$( '.wrap a.cancel-convert-book' ).click();
	} );
} );