### What's New

#### 2.15.8
- Bug Fix : switches CDNs (the old one added a redirect that caused errors in Safari)

#### 2.15.7
- Bug Fix : updates dependencies to correct PHP error

#### 2.15.6
- Bug Fix : corrects a minor PHP error

#### 2.15.5
- Bug Fix : updates dependencies to correct PHP error

#### 2.15.4
- Bug Fix : updates dependencies to correct PHP error

#### 2.15.3
- Bug Fix : some people were still seeing that blasted error!

#### 2.15.2
- Bug Fix : corrects a bug that caused an Error Message to appear when updating the plugin

#### 2.15.1
- Bug Fix : corrects bug that prevented the lightbox from being turned-off via Inline Attributes

#### 2.15
- Enhancement : better support for galleries loaded via AJAX

#### 2.14
- Bug Fix : updates dependencies that threw errors in PHP7

#### 2.13
- Enhancement : the default lightbox now works with links to images when "Link Behavior" is set to "Custom"
- Bug Fix : fixes the bug that caused some mosaics to intermittently fail to load
- Bug Fix : corrects the image size used in the non-JS fallback gallery

#### 2.12.4
- Enhancement : Adds support for HiDPI (aka "retina") screens
- Enhancement : Adds caching to improve page-load response times
- Breaking Change : (could break custom CSS) spinner element is now a DIV
- Bug Fix : prevents Lightbox Bridges from assuming control before they've been activated

#### 2.12.3
- Enhancement : Randomized mosaics now have a less jagged bottom edge (when 'Prevent Cropping' is turned on)
- Bug Fix : corrects a regression that caused the wp_photomosaic() template tag to fail
- Bug Fix : corrects a regression that caused 'Category' mosaics not to link to posts

#### 2.12.2
- Bug Fix : corrects custom lightbox regression introduced in 2.12 commit
- Bug Fix : adds logic check to suppress "array_diff_key" warning

#### 2.12.1
- Bug Fix : adds deprecation adjustment for "onready_callback" changes

#### 2.12
- Enhancement : adds lightbox-bridge capacity
- Enhancement : JS is now loaded in the page footer
- Enhancement : adds 'Minimum Column Width' setting
- Enhancement : adds support for Media Library categories/tags when using "category" to filter a taxonomy 
- Bug Fix : inline CSS is now only included once per page
- Bug Fix : corrects bug that caused loading spinners to disappear prematurely in certain conditions

#### 2.11
- Breaking Change : (could break custom CSS) prefixes '.loading' and '.loaded' classes with 'photomosaic-' to prevent collisions.
- Breaking Change : (could break custom CSS) separates the image and the loading-spinner into unique containers
- Enhancement : moves from absolute positioning to translations (performance improvements)
- Enhancement : unsupported browsers (e.g. IE 8 & Safari 5.5) now fallback to the default WP or NextGen gallery
- Enhancement : "width" and "height" now accept %
- Enhancement : "category" mosaics now use post_title as the caption
- Enhancement : updates React 0.11.2 >>> 0.12.2
- Enhancement : updates Github Updater 2.7.0 >>> 3.2.6
- Bulletproofing : css bulletproofing to prevent problems caused by themes with crazy-specific selectors
- Bulletproofing : prevents array_count_values from getting an empty array because of plugins that nuke image metadata
- Bug Fix : escaped characters no longer appear in the Gallery Settings select inputs
- Bug Fix : corrects a bug that threw an error when the number of images was less than the number of hardcoded columns
- Bug Fix : corrects a regressions that broke automatic Jetpack support
- Bug Fix : removes a debug statement

#### 2.10
- Enhancement : 'Columns' now accepts a range (for responsive min/max values)
- Enhancement : adds option to set which image size opens in the lightbox
- Enhancement : adds 2 new layouts ('Rows' and 'Grid') (currently in alpha) (only available as inline attributes)
- Bug Fix : corrects an error that caused "category" to throw an error when "limit" was omitted
- Bug Fix : corrected a bug that prevented multiple "category" shortcodes from appearing on the same page

#### 2.9.1
- Enhancement : adds support for HTML in captions

#### 2.9
- Enhancement : "category" now accepts taxonomic prefixes
- Enhancement : adds custom_css and onready_callback buckets
- Enhancement : adds unique class to each mosaic
- Enhancement : reduced file size by 50% (offloading libs to a CDN, stronger minification)
- Change : makes the loading spinner an element (allows more styling options)

#### 2.8.5
- Enhancement : updates ReactJS 0.10.0 >>> 0.11.1 and removes unused addons
- Bug Fix : refines transform settings (large galleries should see drastic performance improvements on mobile)

#### 2.8.4
- Bug Fix : corrects an error that caused lazyloading to load images prematurely

#### 2.8.3
- Enhancement : "category" now accepts multiple slugs (separated by commas)
- Bug Fix : corrects min-width/height on the CSS reset (should quiet some warnings)
- Bug Fix : adds an initial transform to images (an attempt to fix the Chrome (Win) scroll/flicker issue)

#### 2.8.2
- Bug Fix : corrects a regression that prevented captions from appearing on the page
- Bug Fix : Lazyloading now targets the bottom of the viewport when set to '0'

#### 2.8.1
- Enhancement : "Group Images" now includes better deeplinking support

#### 2.8
- Bug Fix : corrects $ --> jQuery that broken Jetpack Carousel support
- Bug Fix : loading spinner is no longer visible after the image has loaded
- Bug Fix : corrects the bug that caused large galleries to, randomly, fail to render
- Enhancement : events are now debounced
- Enhancement : moves from static HTML manipulation to ReactJS
- Enhancement : updates Moderizr 2.6.2 >>> 2.8.3
- Change : removes JSTween dependency
- Change : removes Mustache dependency
- Change : 'Responsive Transition' has been renamed to 'Resize Transition' for clarity

#### 2.7.5
- Enhancement : increased the amount of the viewport the default lightbox (PrettyPhoto) uses
- Bug Fix : corrects the bug that prevented items that should line up in a perfect grid from doing so
- Bug Fix : corrects the bug that allowed mosaics to be placed incorrectly

#### 2.7.4
- Enhancement: updates WaypointsJS to v2.0.5
- Bug Fix : prevents conflicts with other versions of WaypointsJS

#### 2.7.3
- Bug Fix : prevents the default gallery from appearing before PM loads (fouc)

#### 2.7.2
- Bug Fix: corrects bug that caused older IEs to throw window.console errors

#### 2.7.1
- Enhancement: adds ability to bypass lazyloading

#### 2.7
- Enhancement: adds ability to make a mosaic from all recent posts
- Enhancement: adds ability to make a mosaic from recent posts from a category
- Enhancement: mosaic images are now lazyloaded by default

#### 2.6.4
- Bug Fix: corrects a bug that caused apostrophes to be improperly escaped

#### 2.6.3
- Bug Fix: corrects a bug that caused PrettyPhoto to fail to load in certain server environments

#### 2.6.2
- Bug Fix: corrects a regression that caused images without dimension data to fail to load

#### 2.6.1
- Change: uses jQuery.Migrate.sub() to create an isolated jQuery instance (JQPM)
- Bug Fix: corrects filename capitalization

#### 2.6
- Enhancement: minified JS is now 60% smaller
- Enhancement: falls back to the default [gallery] layout for users with JS turned off or for pages with JS errors
- Enhancement: updates ImagesLoaded to v3.1.4
- Change: updates admin icon to the new WP3.8 style
- Bug Fix: corrects the check that looks for a preexisting 'theme' select
- Bug Fix: corrects 'addPreloadData' regression introduced in the last release

#### 2.5.3
- Enhancement: adds the ability to be updated through the Wordpress Admin
- Change: switches to the jQuery included with Wordpress (no longer supports WP older than v3.3)

#### 2.5.2
- Bug Fix: cleans up some leaking JS vars
- Bug Fix: NextGen mosaics no longer uses thumbnails when they shouldn't
- Bug Fix: removes politeness check that sometimes prevented [gallery theme="photomosaic"] shortcodes from being mosaic'd

#### 2.5.1
- Update: changes run-priority to support the recent Jetpack Carousel update
- Change: ignores the 'thumbnail' size if it doesn't have the same aspect ratio as the full-sized image
- Change: protects references to the native Date object in case it has been modified by MooTools
- Deleted: removes PHP Output Buffer as it is no longer needed

#### 2.5
- Enhancement: adds "Link Behavior" setting
- Enhancement: adds ability to link to WP Image Attachment Page
- Deleted: removed 'Image Links' setting (now part of 'Link Behavior') (shortcodes using "links" will continue to work)
- Deleted: removed 'Link to URL' setting (now part of 'Link Behavior') (shortcodes using "link_to_url" will continue to work)

#### 2.4.9
- Bug Fix: corrects a regression that caused images to fail to appear in certain conditions

#### 2.4.8
- Enhancement: improves animation support for older browsers
- Bug Fix: guards against multiple instances of Modernizr introducing whitespace bugs in classnames
- Change: adopts Wordpress' prefered method for checking the post_content to see if other post_gallery filters have already been applied

#### 2.4.7
- Bug Fix: the image loading animation wasn't being shown in some cases if images's weren't links

#### 2.4.6
- Bug Fix: corrects issue that caused PhotoMosaic to break some other [gallery] plugins

#### 2.4.5
- Bug Fix: 'Theme' option wasn't appearing on New Post/Page pages
- Bug Fix: accounts for the odd situation when Jetpack's markup isn't properly escaped
- FAQ: updates 'Why are my images stretched and distorted?'

#### 2.4.4
- Enhancement: improved logic for selecting and hot-swapping NextGen thumbnails
- Enhancement: default PrettyPhoto has PhotoMosaic-specific event namespacing (should prevent event conflicts with non-PM PrettyPhoto plugins)
- FAQ: Why are my images stretched and distorted?
- Bug Fix: 'Theme' option wasn't displaying in certain browsers

#### 2.4.3
- Bug Fix: corrects bug that prevented the PhotoMosaic admin page from rendering correctly under certain server configurations
- Bug Fix: loading spinner was disappearing early in certain conditions
- Bug Fix: corrects image-selection logic that caused the wrong size to be chosen for extremely tall images

#### 2.4.2
- Bug Fix: adds Output Buffering; prevents errors when deleting posts and when activating the plugin
- Bug Fix: prevents Kriesi's Avia framework from overwriting PM's image position
- Bug Fix: corrects AutoCols logic (comparing an int to a str)
- Change: preloaded image matching is now based on the unique ID (rather than URL)

#### 2.4.1
- Enhancement: Adds support for Jetpack :: Carousel
- Change: Renames "Template" gallery setting to "Theme" (shortcodes using "template" will continue to work)
- Bug Fix: Renames Markdown files from .md to .txt to prevent IIS mime type blocking
- Bug Fix: Corrects behavior that caused disabling "Image Links" to also disable "Image Loading Transition"

#### 2.4
- Enhancement: now supports `[gallery]` shortcode with `photomosaic` attribute -- `[gallery photomosaic="true"]`
- Enhancement: now supports `[gallery]` shortcode with `template` attribute -- `[gallery template="photomosaic"]`
- Enhancement: PhotoMosaic can now be selected during the "Create Gallery" / "Edit Gallery" workflow -- Edit Gallery --> template
- Change: custom menu icon

#### 2.3.8
- Bug Fix: Auto-column math is no longer dynamic (it depended on WP image sizes and was problematic)

#### 2.3.7
- Bug Fix: PrettyPhoto: all global jQuery references now point to the scoped reference

#### 2.3.6
- Enhancement: now supports NextGen Albums with `ngaid` attribute -- `[photomosaic ngaid="1"]`

#### 2.3.5
- Bug Fix: images that 404 get removed from the mosaic

#### 2.3.4
- Enhancement: NextGen: "Link to URL" no longer cares which field contains a URL and which a caption
- Bug Fix: corrects regression introduced in v2.3.3 - responsive stopped working

#### 2.3.3
- Enhancement: WP image "Alt Text" conveys to IMG 'alt' attribute
- Enhancement: JS has been concatenated in order to load fewer files

#### 2.3.2
- Bug Fix: prevents WP from injecting `<p>` tags in output JS

#### 2.3.1
- Bug Fix: caption are no longer removed when opening non-image content in the lightbox
- Bug Fix: lightbox-gallery order now matches input-gallery order regardless of layout-order
- Bug Fix: not all mosaics on a page were being actively responsive
- Bug Fix: shortcode wasn't honoring inline "lightbox" and "custom_lightbox" settings

#### 2.3
- Enhancement: adds "Prevent Cropping" setting
- Enhancement: adds "Lightbox REL" setting
- Enhancement: adds "Group Images" setting
- Enhancement: updates jQuery to v1.9.1
- Enhancement: updates prettyPhoto to v3.1.5
- Deleted: new feature tour
- Change: better form messages
- Change: form validation allows link_to_url and lightbox to coexist
- Bug Fix: NextGen link_to_url URLs no longer appear as captions
- FAQ: adds Custom Lightbox question

#### 2.2.5
- Bug Fix: corrects NextGen image size usage

#### 2.2
- Enhancement: new layout uses absolute positioning instead of fixed-markup
- Enhancement: actively responsive (reacts, in real time, to the resizing of your browser)
- Enhancement: new auto-columns logic is responsive and generates mosaics with larger images
- Enhancement: image-size selection is now actively responsive
- Enhancement: added "Order" setting
- Enhancement: added "Responsive Transition" setting
- Enhancement: "Columns" setting now accepts "0" and "auto" for auto-columns
- Enhancement: added FAQ section
- Enhancement: added What's New section
- Enhancement: uses WP_Pointers to step through new features
- Refactor: major pattern overhaul
- Deleted: removed "Force Order" setting (now part of "Order")
- Deleted: removed "Randomize" setting (now part of "Order")
- Deleted: removed "Auto-Columns" setting (now part of "Columns")

#### 2.1.3
- Enhancement: Improves column scaling logic; now much more forgiving of short mosaics.
- Bug Fix: blind attempt to fix reported console.log IE errors
- Bug Fix: transform-style:preserve-3d causes scaled images to be 'soft' in Safari
- Bug Fix: WP sometimes reports image dims as 0x0 - PM was failing to load these images
- Bug Fix: corrects regression that caused NextGen galleries not to load

#### 2.1.2
- Enhancement: updates to match new [gallery ids='...'] behavior (new in WPv3.5)
- Enhancement: detects best image size based on width of the columns
- Bug Fix: corrects default shortcode behavior in WPv3.5

#### 2.1.1
- Bug Fix: prevents loading spinner from disappearing early in Firefox
- Bug Fix: captions weren't properly escaped
- Bug Fix: corrects malformed JSON when is 'Link to URL' is used
- Bug Fix: auto-columns now accounts for galleries with less than 3 images (the default number of columns)
- Cleanup: whitespace
- Cleanup: valid JSON encoding of PHP-generated gallery JSON
- Cleanup: removes an unnecessary 'eval' for the JS
- Demo: corrects 'random' param
- Demo: Error messages print (better to show an error than nothing at all)
- Proofing: adds escaping to image descriptions

#### 2.1
- Refactor: moved to WP 'init' event (should eliminate some Debug statements)
- Refactor: moved from "attribute_escape" (deprecated in 2.8) to "esc_attr"
- Refactor: made things much more object-y

#### 2.0
- Enhancement: significant increase to loading performance
- Enhancement: significant decrease in page memory usage
- Enhancement: now uses WP/NextGen thumbnails for mosaic images
- Enhancement: adds option for a CSS transition to each images as it loads
- Enhancement: CSS bulletproofing - should prevent a number of inheritance issues
- Bug Fix: multiple galleries shoud no longer swap places or exchange images

#### 1.9
- Refactor: merges PhotoMosaic (WP) and PhotoMosaic (JS)

#### 1.8
- Enhancement: moves to PhotoMosaic (JS) v1.7.4

#### 1.7
- Enhancement: updates jQuery requirements to 1.7+ (includes 1.8.2)
- Changed: custom jQuery namespace changed to "JQPM"

#### 1.6
- Enhancement: adds option to Center gallery

#### 1.5
- Enhancement: improved "auto_col" results
- Deleted: removed "ideal_width" option - the new "auto_col" logic produces better results w/o

#### 1.4
- Enhancement: better adherence to WP Plugin best-practices
- Enhancement: redesigned Options / Doc - hopefully people will read them now

#### 1.3
- Enhancement: adds "loading gallery" spinner option
- Enhancement: stronger CSS reset
- Bug Fix: corrects jQuery context bug that was effecting Custom Lightbox behavior
- Bug Fix: prevents conflicts with other jQuery instances by adding a super-specific namespace
- Bug Fix: corrects "Link as URL" for WP and NextGen galleries

#### 1.2.5
- Bug Fix: corrects a bug that caused images to display that aren't in the specified gallery
- Bug Fix: corrects a bug that prevented the lightbox from being bound correctly

#### 1.2
- Enhancement: adds NextGallery support
- Enhancement: adds Widget support
- Enhancement: adds Template Tag support
- Enhancement: adds the ability to use a custom lightbox
- Enhancement: adds ability to have the same gallery appear multiple times on the same page
- Enhancement: moves to PhotoMosaic (JS) v1.6 

#### 1.1
- Enhancement: add "link_to_url" option
- Enhancement: add "external_links" option
- Enhancement: add "auto_columns" option
- Enhancement: add "ideal_column_width" option (used with 'auto_columns')
- Enhancement: moves to PhotoMosaic (JS) v1.5
- Bug Fix: corrects a bug that sometimes prevented the gallery from displaying (PHP 1.1)

#### 1.0
- Initial Release