![GitHub Updater](./assets/GitHub_Updater_logo.png)

[![Build Status](https://travis-ci.org/afragen/github-updater.svg?branch=develop)](https://travis-ci.org/afragen/github-updater)

# GitHub Updater
* Contributors: [Andy Fragen](https://github.com/afragen), [Gary Jones](https://github.com/GaryJones), [Seth Carstens](https://github.com/scarstens), [Mikael Lindqvist](https://github.com/limikael), [contributors](https://github.com/afragen/github-updater/graphs/contributors)
* Tags: plugin, theme, update, updater, github, bitbucket, gitlab, remote install
* Requires at least: 4.0
* Requires PHP: 5.3
* Tested up to: 4.7
* Stable tag: master
* Donate link: http://thefragens.com/github-updater-donate
* License: GPLv2 or later
* License URI: http://www.gnu.org/licenses/gpl-2.0.html


A simple plugin to enable automatic updates to your GitHub, Bitbucket, or GitLab hosted WordPress plugins, themes, and language packs. It also allows for the remote installation of plugins or themes.

This plugin is [not allowed in the wp.org repo](https://github.com/afragen/github-updater/issues/34). :frowning:

## Description

This plugin was designed to simply update any GitHub hosted WordPress plugin or theme. Your plugin or theme **must** contain a header in the style.css header or in the plugin's header denoting the location on GitHub. The format is as follows.

`GitHub Plugin URI: afragen/github-updater`  
`GitHub Plugin URI: https://github.com/afragen/github-updater`

or 

`GitHub Theme URI: afragen/test-child`  
`GitHub Theme URI: https://github.com/afragen/test-child`

...where the above URI leads to the __owner/repository__ of your theme or plugin. The URI may be in the format `https://github.com/<owner>/<repo>` or the short format `<owner>/<repo>`. You do not need both. Only one Plugin or Theme URI is required. You **should not** include any extensions like `.git`.

## Slack

We now have a [Slack team for GitHub Updater](https://github-updater.slack.com). Please ping me for an invite.

## Installation

### Composer

Run the composer command: ```composer require afragen/github-updater```


### Upload

1. Download the latest [tagged archive](https://github.com/afragen/github-updater/releases) (choose the "zip" option).
2. Unzip the archive, rename the folder correctly to `github-updater`, then re-zip the file.
3. Go to the __Plugins -> Add New__ screen and click the __Upload__ tab.
4. Upload the zipped archive directly.
5. Go to the Plugins screen and click __Activate__.

### Manual

1. Download the latest [tagged archive](https://github.com/afragen/github-updater/releases) (choose the "zip" option).
2. Unzip the archive, rename the folder to `github-updater`.
3. Copy the folder to your `/wp-content/plugins/` directory.
4. Go to the Plugins screen and click __Activate__.

Check out the Codex for more information about [installing plugins manually](http://codex.wordpress.org/Managing_Plugins#Manual_Plugin_Installation).

### Git

Using git, browse to your `/wp-content/plugins/` directory and clone this repository:

`git clone https://github.com/afragen/github-updater.git`

Then go to your Plugins screen and click __Activate__.

### Install GitHub Updater as a Must Use Plugin (optional)

1. Choose a method from above for installation.
1. **DO NOT** activate!
1. Symlink `wp-content/plugins/github-updater/mu/ghu-loader.php` in `wp-content/mu-plugins`.
1. You should use full filepaths when creating your symlink.

#### in Linux
```
cd <WordPress root>
ln -sv wp-content/plugins/github-updater/mu/ghu-loader.php wp-content/mu-plugins
```

#### in Windows (Vista, 7, 8)
```
cd /D <WordPress root>
mklink wp-content\mu-plugins\ghu-loader.php wp-content\plugins\github-updater\mu\ghu-loader.php
```

This way you get automatic updates and cannot deactivate the plugin.

## Usage

### Plugins 

There must be a `GitHub Plugin URI`, `Bitbucket Plugin URI`, or `GitLab Plugin URI` declaration in the plugin's header.

~~~php
/**
 * Plugin Name:       GitHub Updater
 * Plugin URI:        https://github.com/afragen/github-updater
 * Description:       A plugin to automatically update GitHub, Bitbucket or GitLab hosted plugins and themes. It also allows for remote installation of plugins or themes into WordPress.
 * Version:           1.0.0
 * Author:            Andy Fragen
 * License:           GNU General Public License v2
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.html
 * Domain Path:       /languages
 * Text Domain:       github-updater
 * GitHub Plugin URI: https://github.com/afragen/github-updater
 * GitHub Branch:     master
 * GitHub Languages:  https://github.com/afragen/github-updater-translations
 */
~~~

### Themes

There must be a `GitHub Theme URI`, `Bitbucket Theme URI`, or `GitLab Theme URI` declaration in the `style.css` file. When initially adding a theme, the directory **must** be identical to the repo name.

~~~php
/**
 * Theme Name:       Test
 * Theme URI:        http://thefragens.net/
 * Version:          0.1.0
 * Description:      Child theme of TwentyTwelve.
 * Author:           Andy Fragen
 * Template:         twentytwelve
 * Template Version: 1.0.0
 * GitHub Theme URI: https://github.com/afragen/test-child
 * GitHub Branch:    master
 */
~~~

### Language Packs

A separate git hosted repository may be used for updating Language Packs. This repository must be a public repository. What's the point of putting translation files in a private repository.

Simply add the header `GitHub Languages`, `Bitbucket Languages`, or `GitLab Languages` to the headers of the plugin or theme. The URI for this header are in the same format as for the plugins or themes.

Example, `GitHub Languages: https://github.com/afragen/github-updater-translations`

In order to create your Language Pack repository. You will need to install and use the [Language Pack Maker](https://github.com/afragen/github-updater-language-pack-maker). You will need to follow those directions to create a properly formatted language pack repository. All translation files must be in branch `master`.

See [GitHub Updater Translations](https://github.com/afragen/github-updater-translations) as an example. I have set `.gitignore` to hide the `vendor` directory.

Many thanks to [Ulrich Pogson](https://github.com/grappler).

### Optional Headers

`GitHub Branch`, `Bitbucket Branch`, and `GitLab Branch` are available but not required.

### Enterprise and Self-Hosted Support

#### GitHub Enterprise Support

Add the `GitHub Enterprise` header to the plugin or theme that is hosted on your GitHub self-hosted installation. The settings should be similar to `GitHub Enterprise: https://github.yourhost.com`.

GitHub Enterprise **requires** authentication with either a personal access token or a repository-dependent access token.

#### GitLab CE/Enterprise Support

Add the `GitLab CE` or `GitLab Enterprise` header to the plugin or theme that is hosted on your GitLab self-hosted installation. The settings should be similar to `GitLab CE: https://gitlab.yourhost.com` or `GitLab Enterprise: https://gitlab.yourhost.com`.

### Versions

GitHub Updater reads the `Version` headers from both the local file and the remote file. For an update to show as available the remote version number **must** be greater than the local version number. It is **required** to have a `Version` header in your main plugin file or your theme's `style.css` file. It is better to use [Semantic Versioning](http://semver.org).

If you tag releases the version number of the tag must be the same as in the file inside of the tag. Otherwise a circle of updating may ensue. You do not have to tag releases; but if you do the tagged version will be downloaded preferentially. Please refer to the sections below on branches and tags.

When testing I find it simpler to decrease the version number in the local file rather than continually push updates with version number increments or new tags.

## Branch Support

To specify a branch that you would like to use for updating, just add a branch header.  If you develop on `master` and are pushing tags, GitHub Updater will update to the newest tag. If there are no tags or the specified branch is not `master` GitHub Updater will use the specified branch for updating.

The default state is either `GitHub Branch: master` or nothing at all. They are equivalent.

If you want to update against branch of your repository other than `master` and have that branch push updates out to users make sure you specify the testing branch in a header, i.e. `GitHub Branch: develop`. When you want users to update against the release branch just have them manually change the header to `GitHub Branch: master` or remove it completely. Tags will be ignored when a branch other than `master` is specified. In this case I would suggest semantic version numbering similar to the following, `<major>.<minor>.<patch>.<development>`.

In the GitHub Updater Settings there is a new setting to enable branch switching for plugins and themes. When checked there will be a new ability from the Plugins and Themes pages to switch between branches. Switching to the current branch will reinstall the current branch.

## Tagging

If the branch header, i.e. `GitHub Branch` or `Bitbucket Branch`, is not specified (or is set to `master`), then the latest tag will be used. GitHub Updater will preferentially use a tag over a branch in this instance.

## Bitbucket Support

Instead of the `GitHub Plugin URI` header you will need to use the `Bitbucket Plugin URI` header.

Instead of the `GitHub Theme URI` header you will need to use the `Bitbucket Theme URI` header.

The `Bitbucket Branch` header is supported for both plugins and themes.

## GitLab Support

Instead of the `GitHub Plugin URI` header you will need to use the `GitLab Plugin URI` header.

Instead of the `GitHub Theme URI` header you will need to use the `GitLab Theme URI` header.

The `GitLab Branch` header is supported for both plugins and themes.

You must set a GitLab private token or a GitLab personal access token. 

* Go to your GitLab Settings page under the Account tab. From here you can retrieve or reset your GitLab private token.
* Go to your GitLab Profile Settings page under the Access Tokens tab. From here you can create a personal access token.

## Private Repositories

Only private repositories that require some sort of additional authentication or acknowledgment will show up in the Settings page.


### GitHub Private Repositories

![GitHub Settings Tab](./assets/screenshot-1.png)

In order to specify a private repository you will need to obtain a [personal access token](https://github.com/settings/tokens/new). Once you have this, simply add the token in the GitHub Settings tab. If a plugin or theme will not work with your personal access token; add the appropriate access token in the Install tab.

Leave this empty if the plugin or theme is in a public repository. If your personal access token allows `read` access to a private repository, that repository will not display as needing an access token.

### Bitbucket Private Repositories

![Bitbucket Settings Tab](./assets/screenshot-4.png)

Add your personal Bitbucket username and password in the Bitbucket Settings tab or in the Install tab. In order to authenticate with the Bitbucket API you will need to have at least `read` privileges for the Bitbucket private repository.

In order to specify a private repository you will need to check the box next to the repository name in the Settings tab.

Leave this unchecked if the plugin or theme is in a public repository.

Do not include your username or password in the plugin or theme URI.

## WordPress and PHP Requirements

There are two **optional** headers for setting minimum requirements for both WordPress and PHP.

Use `Requires WP:` to set the minimum required version of WordPress needed for your plugin or theme. eg. `Requires WP: 4.0`

Use `Requires PHP:` to set the minimum required version of PHP needed for your plugin or theme. eg. `Requires PHP: 5.3`

At the moment the default values are **WordPress 4.0** and **PHP 5.3**

## Release Assets

An **optional header** is available for use if your plugin or theme requires updating via a release asset.

Use `Release Asset:`. eg., `Release Asset: true`.

Your release asset filename is generated automatically and **must** have the following format or there will be an update error.

Example, `$repo-$tag.zip` where `$repo` is the repository slug and `$tag` is the newest release tag, example `test-plugin-0.7.3.zip`.

There is support for [GitLab Build Artifacts](https://gitlab.com/help/user/project/builds/artifacts.md) which may be used as a release asset. You must also add the header, `GitLab CI Job:`, with the build job name.

Release assets do not work for private GitHub repositories at this time. [#475](https://github.com/afragen/github-updater/issues/475)

**You must tag your releases to use this feature.**

## Hosting Plugin in WP.org Repository

If you develop your plugin on GitHub and it also resides in the WP.org repo, the plugin will preferentially pull updates from WP.org if `GitHub Branch: master`. If `GitHub Branch` is anything other than `master` then the update will pull from GitHub. Make sure that the version of your plugin uploaded to WP.org has `GitHub Branch: master`.

The same applies for Bitbucket or GitLab hosted plugins.

## Remote Installation of Repositories

From the `GitHub Updater Settings Page` there is a tabbed interface for remote installation of plugins or themes. You may use either a full URI or short `<owner>/<repo>` format. The URI is case sensitive, so make sure the repo name is correctly entered.

![Remote Install of Plugin Tab](./assets/screenshot-2.png)

## Refreshing Cache

Use the **Refresh Cache** button in the `GitHub Updater Settings Page` screen and all the transients will be deleted and the API will be queried again. This may cause timeout issues against the API, especially the GitHub API which only allows 60 unauthenticated calls per hour. Please set a Personal GitHub Access Token to avoid these timeouts.

Be careful about refreshing the browser window after this as you may be continually deleting the transients and hitting the API. 

## Error Messages

GitHub Updater now reports a small error message on certain pages in the dashboard. The error codes are HTTP status codes. Most often the code will be either 403 or 401. If you don't have an Access Token set for a private GitHub repo you will get a 404 error.

### Personal GitHub Access Token

There is a new setting for a personal GitHub Access Token. I **strongly** encourage everyone to create a [personal access token](https://github.com/settings/tokens/new). Create one with at least `public_repo` access and your rate limit will be increased to 5000 API hits per hour. Unauthenticated calls to the GitHub API are limited to 60 API calls per hour and in certain circumstances, like shared hosting, these limits will be more frequently hit. Thanks [mlteal](https://github.com/mlteal).

### 403 - Unauthorized Access

#### GitHub
* usually this means that you have reached GitHub API's rate limit of 60 hits per hour. This is informative and should go away in less than an hour. See above regarding the setting of a personal access token to eliminate this entirely.
* a private GitHub repo without an Access Token designated in the Settings.
* will tell you how long until GitHub API's rate limit will be reset.

### 401 - Incorrect Authentication

#### Bitbucket
* incorrect Bitbucket user/pass, no `read` access to private Bitbucket repo
* private Bitbucket repo not checked in Settings

#### GitHub
* using an incorrect private repo GitHub Access Token for a public repo
* an incorrect Access Token for a private GitHub repo.

### 429 - Too Many Requests

I've seen this error code occasionally with Bitbucket.

## Remote Management Services

Currently, GitHub Updater works with iThemes Sync, InfiniteWP, ManageWP, and MainWP. If you desire support for another remote management service please invite the developer of that service to engage in discussion here. I am more that amenable to supporting any service. I will need some testing and support to add support for additional services.

Please go the Remote Management tab of the Settings page and check which remote management service you wish to use. There may be a small amount of overhead related to using any of these services which may impact performance, but only for **admin** level users in the dashboard.

![Remote Management Tab](./assets/screenshot-3.png)

### RESTful Endpoints for Remote Management

For a tutorial, see: [Continuous Integration for WordPress](https://medium.com/@limikael/continuous-integration-for-wordpress-d152ec4852e5)

GitHub Updater also supports other customized continuous integration workflows. It is possible to integrate with other services than those discussed above. For this, the RESTful endpoints are available in GitHub Updater to update themes and plugins to the latest version from their repositories.

On the Remote Management tab, you will see a URL that serves as the endpoint for this. This url will look something like this:

    http://localhost/wordpress/wp-admin/admin-ajax.php?action=github-updater-update&key=76bb2b7c819c36ee37292b6978a4ad61

The exact URL will of course depend on your system. The value for the `key` attribute is automatically generated on the first activation of the GitHub Updater plugin and is used for authentication. Any person or entity knowing this key will be able to change the versions of your installed plugins, but nothing else.

Now, if we would use `curl` to access the url exactly like it appears on the Remote Management tab, we would see something like this:

    $ curl "http://localhost/wordpress/wp-admin/admin-ajax.php?action=github-updater-update&key=76bb2b7c819c36ee37292b6978a4ad61"
    {
        "message": "No plugin or theme specified for update.",
        "error": true
    }

This error message is given because GitHub Updater requires us to specify either a theme or a plugin that we wish to update. This is specified using the `theme` or `plugin` attributes, and the theme or plugin is identified by its slug. Let's try to update a plugin:

    $ curl "http://localhost/wordpress/wp-admin/admin-ajax.php?action=github-updater-update&key=76bb2b7c819c36ee37292b6978a4ad61&plugin=mickesplugin"
    {
        "messages": [
            "Downloading update from <span class=\"code\">https:\/\/api.github.com\/repos\/limikael\/mickesplugin\/zipball\/master<\/span>&#8230;",
            "Unpacking the update&#8230;",
            "Installing the latest version&#8230;",
            "Removing the old version of the plugin&#8230;",
            "Plugin updated successfully."
        ],
        "success": true
    }

And our plugin is updated! The messages displayed are those that otherwise would be displayed in the non-shiny WordPress admin interface. The full list of attributes accepted by this RESTful service is shown here:

* __key__ - The key as displayed on the Remote Management tab. The key passed to the endpoint in the api call must match the key stored on the system.
* __plugin__ - Specify this to update a plugin. This is the plugin's slug.
* __theme__ - Specify this to update a theme. This is the theme's slug.
* __committish__ - Specify a particular tag, branch or commit for the update. If nothing is specified, it defaults to "master".
* __tag__ - An alias for the committish attribute.
* __updates__ - Displays available updates.

When using the RESTful endpoints for updating themes or plugins, you need to specify at least the `key` attribute, as well as one of the attributes `plugin`, `theme`, or `updates`. All other attributes are optional.

The RESTful endpoints are useful for automatically updating themes and plugins on events sent as webhooks from GitHub and the other services supported by this plugin. Some special functionality has been implemented to support this in order avoid race conditions, i.e. to make sure that the updated version is really the version that was just pushed to the repository. Specifically, GitHub Updater checks the headers to see if the incoming request is from a 
[GitHub Webhook](https://developer.github.com/v3/activity/events/types/#pushevent), a [Bitbucket Webhook](https://confluence.atlassian.com/bitbucket/event-payloads-740262817.html#EventPayloads-Push) or a [GitLab Webhook](https://gitlab.com/gitlab-org/gitlab-ce/blob/master/doc/web_hooks/web_hooks.md#push-events). If this is the case, and if the branch that was pushed to matches the branch specified in the `tag` attribute, then the update will be made according to the latest commit specified in the event.

Thanks to [Mikael Lindqvist](https://github.com/limikael) for the PRs, he really made this happen.

## Extended Naming

There's a hidden preference to use extended naming for plugin directories. Extended Naming follows the convention `<git>-<owner>-<repo>`. The normal method is to name the plugin directory `<repo>`. Unfortunately there may be a _potential_ conflict with a WP.org plugin. This preference mitigates that potential conflict. If you switch between normal and extended naming you might have to reactivate your plugins.

To set Extended Naming add `define( 'GITHUB_UPDATER_EXTENDED_NAMING', true );` in your `wp-config.php` or your theme's `functions.php`.

## Developer Hooks

There are 2 added filter hooks specifically for developers wanting to distribute private themes/plugins to clients without the client having to interact with the Settings page.

The first allows the developer to set the GitHub Access Token for a specific plugin or theme. The anonymous function must return key/value pairs where the key is the plugin/theme repo slug and the value is the token. You could also set the GitHub Access Token in a similar fashion where the key is `'github_access_token'`.

~~~php
add_filter( 'github_updater_token_distribution',
	function () {
		return array( 'my-private-theme' => 'kjasdp984298asdvhaljsg984aljhgosrpfiu' );
	} );
~~~

The second hook will simply make the Settings page unavailable.

~~~php
add_filter( 'github_updater_hide_settings', '__return_true' );
~~~

There is a hook to bypass the `wp_remote_get` calls for repo meta, readme.txt, and changelogs. These data provide for a richer experience in _View details_. If you are running GitHub Updater at scale you will certain get more performance by omitting these API calls. Add the following hook to enable.

~~~php
add_filter( 'github_updater_run_at_scale', '__return_true' );
~~~

There is a hook to enter into the _Refresh Transients_ path. I would be used in the following manner.

~~~php
add_action( 'ghu_refresh_transients', 'my_function_when_transients_are_deleted' );
~~~

## Extras

[szepeviktor](https://github.com/szepeviktor) has created an add-on plugin to GitHub Updater that identifies all plugins with an icon in the plugin view for GitHub or Bitbucket depending upon where they get updates. It's very clever.
<https://github.com/szepeviktor/github-link>

You can use the [GitHub Updater Additions](https://github.com/afragen/github-updater-additions) plugin to add plugins or themes that don't contain the proper headers via a JSON file. They can then be updated with GitHub Updater.

### Translations

Please submit translation PRs to [GitHub Updater Translations](https://github.com/afragen/github-updater-translations). This will allow me to keep language pack updates decoupled and independent of the main plugin and much more timely.

* French by
    * [Daniel Ménard](https://github.com/daniel-menard)
    * [fxbenard](https://github.com/fxbenard)
    * [Benoît Chantre](https://github.com/benoitchantre)
* Italian by [Enea Overclokk](https://github.com/overclokk)
* Portuguese by
    * [Valerio Souza](https://github.com/valeriosouza)
    * [Pedro Mendonça](https://github.com/pedro-mendonca)
* Ukrainian by [Andrii Ryzhkv](https://github.com/andriiryzhkov)
* Swedish by [Andréas Lundgren](https://github.com/Adevade)
* Arabic by [Hyyan Abo FAkher](https://github.com/hyyan)
* Spanish by [Jose Miguel Bejarano](https://github.com/xDae)
* German by [Linus Metzler](https://github.com/limenet)
* Romanian by [Corneliu Cirlan](https://github.com/corneliucirlan)
* Japanese by [ishihara](https://github.com/1shiharat)
* Russian by [Anatoly Yumashev](https://github.com/yumashev)
* Bulgarian by [Adrian Dimitrov](https://github.com/dimitrov-adrian)

## Issues

Please log issues on the GitHub at https://github.com/afragen/github-updater/issues

If you are using a WordPress Multisite installation, the plugin **should** be network activated.

When first downloading and installing a plugin from GitHub you might have to do the following, otherwise the next update may not be able to cleanup after itself and re-activate the updated plugin or theme. Or you can just use the remote install feature and this will be done for you. :wink:

1. Unzip the archive.
2. Fix the folder name to remove to extra stuff GitHub adds to the download, like _-master_.
3. Copy the folder to your plugins directory **or** re-zip folder and add from plugins page.

W3 Total Cache object cache also clears the transient cache. Unfortunately this hampers GitHub Updater's storage of API data using the Transient API. The solution is to turn off the object cache.

If a plugin loads earlier than GitHub Updater and calls `wp_get_theme()` that will prevent the current theme from seeing updates if it uses this plugin. The only solution to this is adding a call to `wp_cache_flush()` after that call. The only location inside of GHU that works is in `Base::__construct` but this will cause anyone using Redis to flush the cache with almost every page load.

## ChangeLog

See [CHANGES.md](CHANGES.md). In your project create a `CHANGES.md` or `CHANGELOG.md` file.

## Credits

This plugin's theme updater class was originally based upon [Whitelabel Framework's updater-plugin.php](https://github.com/WordPress-Phoenix/whitelabel-framework/blob/master/inc/admin/updater-plugin.php), which was based upon https://github.com/UCF/Theme-Updater.

The plugin updater class was originally based upon [codepress/github-plugin-updater](https://github.com/codepress/github-plugin-updater).

Includes

* [Emanuil Rusev's](https://github.com/erusev) [Parsedown](https://github.com/erusev/parsedown) for rendering ChangeLogs.
* [wp.org plugin readme parser](https://meta.trac.wordpress.org/browser/sites/trunk/wordpress.org/public_html/wp-content/plugins/plugin-directory/readme/class-parser.php) for parsing `readme.txt`.
* [Coen Jacobs'](https://github.com/coenjacobs) [WPupdatePHP library](https://github.com/WPupdatePHP/wp-update-php)

GitHub Updater logo by [LogoMajestic](http://www.logomajestic.com).

## Pull Requests

Pull requests are welcome. Please fork and submit pull requests against the `develop` branch.

Lovingly crafted with [PhpStorm](https://www.jetbrains.com/phpstorm/)
