<?php
class OTW_Portfolio_Template_Shortcode_Portfolio_Item_Details extends OTW_Portfolio_Template_Shortcodes{
	
	public function __construct(){
		
		$this->has_options = false;
		
		$this->has_custom_options = false;
		
		$this->has_preview = false;
		
		parent::__construct();
		
		$this->shortcode_name = 'otw_shortcode_portfolio_item_details';
	}
	
	/**
	 * apply settings
	 */
	public function apply_settings(){
		
		$this->settings = array();
	}
	/**
	 * Shortcode icon_link admin interface
	 */
	public function build_shortcode_editor_options(){
		
		$this->apply_settings();
		
		$html = '';
		
		$source = array();
		if( otw_post( 'shortcode_object', false, array(), 'json' ) ){
			$source = otw_post( 'shortcode_object', array(), array(), 'json' );
		}
		
		return $html;
	}
	
	/** build icon link shortcode
	 *
	 *  @param array
	 *  @return string
	 */
	public function build_shortcode_code( $attributes ){
		
		$code = '';
		
		if( !$this->has_error ){
		
			$code = '[otw_shortcode_portfolio_item_details]';
		}
		
		return $code;
	}
	
	/**
	 * Process shortcode icon link
	 */
	public function display_shortcode( $attributes, $content ){
		
		$html = '';
		
		$portfolio_item_id = $this->format_attribute( '', 'portfolio_item_id', $attributes, false, '' );
		
		if( is_admin() ){
			$html = '<img src="'.$this->component_url.'images/sidebars-icon-placeholder.png'.'" alt=""/>';
		}else{
			$html = '';
			
			if( $portfolio_item_id ){
			
				global $otw_porfolio_items_data;
				
				if( is_array( $otw_porfolio_items_data ) && isset( $otw_porfolio_items_data[ $portfolio_item_id ] ) && isset( $otw_porfolio_items_data[ $portfolio_item_id ]['data'] ) ){
					$html .= '<h3 class="otw_portfolio_manager-mb25">';
						if( !empty( $otw_porfolio_items_data[ $portfolio_item_id ]['data']['otw_pm_plugin_options']['otw_pm_details_title_text'] ) ){
							$html .= $otw_porfolio_items_data[ $portfolio_item_id ]['data']['otw_pm_plugin_options']['otw_pm_details_title_text'];
						}else{
							$html .= $this->get_label( 'Project Details' );
						}
						$html .= '</h3>';
						$html .= '<div class="otw_portfolio_manager-project-info">';
						//categories
						if( is_array( $otw_porfolio_items_data[ $portfolio_item_id ]['data']['categories'] ) && count( $otw_porfolio_items_data[ $portfolio_item_id ]['data']['categories'] ) ){
							$html .= '<div class="otw_portfolio_manager-project-info-box">';
								$html .= '<h4>'.$this->get_label( 'Categories' ).':</h4>';
								$html .= '<div class="otw_portfolio_manager-project-info-box-content">';
									$total_items = count( $otw_porfolio_items_data[ $portfolio_item_id ]['data']['categories'] ) - 1;
									foreach( $otw_porfolio_items_data[ $portfolio_item_id ]['data']['categories'] as $item_num => $cat ){
										$category = get_term($cat, $otw_porfolio_items_data[ $portfolio_item_id ]['dispatcher']->portfolio_category);
										$catUrl = get_term_link( $category, $otw_porfolio_items_data[ $portfolio_item_id ]['dispatcher']->portfolio_category );
										$html .= '<a href="'.esc_attr( $catUrl ).'" rel="tag">'.$category->name.'</a>';
										if( $item_num < $total_items ){
											$html .= ', ';
										}
									}
								$html .= '</div>';
							$html .= '</div>';
						}
						//tags
						if( is_array( $otw_porfolio_items_data[ $portfolio_item_id ]['data']['tags'] ) && count( $otw_porfolio_items_data[ $portfolio_item_id ]['data']['tags'] ) ){
							$html .= '<div class="otw_portfolio_manager-project-info-box">';
								$html .= '<h4>'.$this->get_label( 'Tags' ).':</h4>';
								$html .= '<div class="otw_portfolio_manager-project-info-box-content">';
								$total_items = count( $otw_porfolio_items_data[ $portfolio_item_id ]['data']['tags'] ) - 1;
								foreach( $otw_porfolio_items_data[ $portfolio_item_id ]['data']['tags'] as $item_num => $tag ){
									$tagUrl = get_term_link( $tag, $otw_porfolio_items_data[ $portfolio_item_id ]['dispatcher']->portfolio_tag );
									$html .= '<a href="'.esc_attr( $tagUrl ).'" rel="tag">'.$tag->name.'</a>';
									if( $item_num < $total_items ){
										$html .= ', ';
									}
								}
								$html .= '</div>';
							$html .= '</div>';
						}
						//details
						foreach( $otw_porfolio_items_data[ $portfolio_item_id ]['data']['otw_details'] as $detail_id => $detail ){
						
							if( !empty( $otw_porfolio_items_data[ $portfolio_item_id ]['data']['otw_details_value'][ 'otw_pm_portfolio_detail_'.$detail_id ] ) ){
								$html .= '<div class="otw_portfolio_manager-project-info-box">';
									$html .= '<h4>'.$detail['title'].'</h4>';
									$html .= '<div class="otw_portfolio_manager-project-info-box-content">';
									$html .= $otw_porfolio_items_data[ $portfolio_item_id ]['data']['otw_details_value'][ 'otw_pm_portfolio_detail_'.$detail_id ];
									$html .= '</div>';
								$html .= '</div>';
							}
						}
						
					$html .= '</div>';
				}
			}
		}
		
		return $this->format_shortcode_output( $html );
	}
	
	/**
	 * Return shortcode attributes
	 */
	public function get_shortcode_attributes( $attributes ){
		
		$shortcode_attributes = array();
		
		if( isset( $attributes['item_type'] ) ){
		
			if( isset( $this->settings['item_type_options'][ $attributes['item_type'] ] ) ){
				$shortcode_attributes['iname'] = $this->settings['item_type_options'][ $attributes['item_type'] ];
			}else{
				$shortcode_attributes['iname'] = ucfirst( $attributes['item_type'] );
			}
		}
		
		return $shortcode_attributes;
	}
}
?>