<?php
class Otw_Shortcode_Welcome_Text extends OTW_Shortcodes {
	
	function __construct() {
		$this->has_custom_options = true;
		
		$this->custom_options_label = $this->get_label( 'Styling Options' );
		
		parent::__construct();
	}

    /**
     * register external libs
     */
    public function register_external_libs() {

        $this->add_external_lib('css', 'otw-shortcode-general_foundicons', $this->component_url . 'css/general_foundicons.css', 'all', 10);
        $this->add_external_lib('css', 'otw-shortcode-social_foundicons', $this->component_url . 'css/social_foundicons.css', 'all', 20);
        $this->add_external_lib('css', 'otw-shortcode', $this->component_url . 'css/otw_shortcode.css', 'all', 100);
        $this->add_external_lib('css', 'otw-grid', $this->component_url . '../' . 'otw_grid_manager/' . 'css/otw-grid.css', 'all', 120);
    }

    /**
     * Attach all settings to code
     * @return Void
     */
	public function apply_settings() {
		$this->_applyBoxAnimations();
		$this->_applyBoxBackgroundPattern();
		$this->_applyBoxBackgrounds();
		$this->_applyBoxBorderColors();
		$this->_applyBoxBorderStyle();
		$this->_applyBoxBorderType();
		$this->_applyBoxBorderWidth();
		$this->_applyBoxRoundedCourners();
		$this->_applyBoxShadow();
		$this->_applyBoxType();
		$this->_applyButtonBackgrounds();
		$this->_applyCallActions();
		$this->_applyContentLinkColor();
		$this->_applyIconAnimations();
		$this->_applyIconBackgroundColors();
		$this->_applyIconBorderStyle();
		$this->_applyIconBorderWidth();
		$this->_applyIconColorBorders();
		$this->_applyIconColors();
		$this->_applyIconSizes();
		$this->_applyIconTypes();
		$this->_applyIconBoxRounds();
		
		$this->settings['title_sizes'] = array(
				
				'h1' => $this->get_label( 'H1 (default)' ),
				'h2' => $this->get_label( 'H2' ),
				'h3' => $this->get_label( 'H3' ),
				'h4' => $this->get_label( 'H4' ),
				'h5' => $this->get_label( 'H5' ),
				'h6' => $this->get_label( 'H6' )
		);
		$this->settings['default_title_size'] = 'h1';
		
		$this->settings['text_position'] = array(
				'otw-text-left'    => $this->get_label( 'left(default)' ),
				'otw-text-center'  => $this->get_label( 'center' ),
				'otw-text-right'   => $this->get_label( 'right' )
		);
		$this->settings['default_text_position'] = 'left';
		
		$this->settings['font_sizes'] = array(
				
				'' => $this->get_label( 'None (default)' )
		);
		$this->settings['default_font_size'] = '';
		
		for( $cF = 8; $cF <= 50; $cF += 2 )
		{
			$this->settings['font_sizes'][ $cF.'px' ] = $cF . $this->get_label( 'px' );
		}
		
		$this->settings['font_weights'] = array(
				
				'' => $this->get_label( 'None (default)' ),
				'regular' => $this->get_label( 'Regular' ),
				'bold' => $this->get_label( 'Bold' ),
				'italic' => $this->get_label( 'Italic' ),
				'bold_italic' => $this->get_label( 'Bold Italic' ),
		);
		$this->settings['default_font_weight'] = '';
		
		$this->settings['font_families'] = array(
				
			'' => $this->get_label( 'None (default)' ),
			'Arial' => $this->get_label( 'Arial' ),
			'Arial Black' => $this->get_label( 'Arial Black' ),
			'Comic Sans' => $this->get_label( 'Comic Sans' ),
			'Georgia' => $this->get_label( 'Georgia' ),
			'Impact' => $this->get_label( 'Impact' ),
			'Lucida Console' => $this->get_label( 'Lucida Console' ),
			'Lucida Sans Unicode' => $this->get_label( 'Lucida Sans Unicode' ),
			'Tahoma' => $this->get_label( 'Tahoma' ),
			'Times New Roman' => $this->get_label( 'Times New Roman' ),
			'Verdana' => $this->get_label( 'Verdana' ),
			'ABeeZee' => $this->get_label( 'ABeeZee' ),
			'Abel' => $this->get_label( 'Abel' ),
			'Abril Fatface' => $this->get_label( 'Abril Fatface' ),
			'Aclonica' => $this->get_label( 'Aclonica' ),
			'Acme' => $this->get_label( 'Acme' ),
			'Actor' => $this->get_label( 'Actor' ),
			'Adamina' => $this->get_label( 'Adamina' ),
			'Advent Pro' => $this->get_label( 'Advent Pro' ),
			'Aguafina Script' => $this->get_label( 'Aguafina Script' ),
			'Akronim' => $this->get_label( 'Akronim' ),
			'Aladin' => $this->get_label( 'Aladin' ),
			'Aldrich' => $this->get_label( 'Aldrich' ),
			'Alef' => $this->get_label( 'Alef' ),
			'Alegreya' => $this->get_label( 'Alegreya' ),
			'Alegreya SC' => $this->get_label( 'Alegreya SC' ),
			'Alegreya Sans' => $this->get_label( 'Alegreya Sans' ),
			'Alegreya Sans SC' => $this->get_label( 'Alegreya Sans SC' ),
			'Alex Brush' => $this->get_label( 'Alex Brush' ),
			'Alfa Slab One' => $this->get_label( 'Alfa Slab One' ),
			'Alice' => $this->get_label( 'Alice' ),
			'Alike' => $this->get_label( 'Alike' ),
			'Alike Angular' => $this->get_label( 'Alike Angular' ),
			'Allan' => $this->get_label( 'Allan' ),
			'Allerta' => $this->get_label( 'Allerta' ),
			'Allerta Stencil' => $this->get_label( 'Allerta Stencil' ),
			'Allura' => $this->get_label( 'Allura' ),
			'Almendra' => $this->get_label( 'Almendra' ),
			'Almendra Display' => $this->get_label( 'Almendra Display' ),
			'Almendra SC' => $this->get_label( 'Almendra SC' ),
			'Amarante' => $this->get_label( 'Amarante' ),
			'Amaranth' => $this->get_label( 'Amaranth' ),
			'Amatic SC' => $this->get_label( 'Amatic SC' ),
			'Amethysta' => $this->get_label( 'Amethysta' ),
			'Anaheim' => $this->get_label( 'Anaheim' ),
			'Andada' => $this->get_label( 'Andada' ),
			'Andika' => $this->get_label( 'Andika' ),
			'Angkor' => $this->get_label( 'Angkor' ),
			'Annie Use Your Telescope' => $this->get_label( 'Annie Use Your Telescope' ),
			'Anonymous Pro' => $this->get_label( 'Anonymous Pro' ),
			'Antic' => $this->get_label( 'Antic' ),
			'Antic Didone' => $this->get_label( 'Antic Didone' ),
			'Antic Slab' => $this->get_label( 'Antic Slab' ),
			'Anton' => $this->get_label( 'Anton' ),
			'Arapey' => $this->get_label( 'Arapey' ),
			'Arbutus' => $this->get_label( 'Arbutus' ),
			'Arbutus Slab' => $this->get_label( 'Arbutus Slab' ),
			'Architects Daughter' => $this->get_label( 'Architects Daughter' ),
			'Archivo Black' => $this->get_label( 'Archivo Black' ),
			'Archivo Narrow' => $this->get_label( 'Archivo Narrow' ),
			'Arimo' => $this->get_label( 'Arimo' ),
			'Arizonia' => $this->get_label( 'Arizonia' ),
			'Armata' => $this->get_label( 'Armata' ),
			'Artifika' => $this->get_label( 'Artifika' ),
			'Arvo' => $this->get_label( 'Arvo' ),
			'Asap' => $this->get_label( 'Asap' ),
			'Asset' => $this->get_label( 'Asset' ),
			'Astloch' => $this->get_label( 'Astloch' ),
			'Asul' => $this->get_label( 'Asul' ),
			'Atomic Age' => $this->get_label( 'Atomic Age' ),
			'Aubrey' => $this->get_label( 'Aubrey' ),
			'Audiowide' => $this->get_label( 'Audiowide' ),
			'Autour One' => $this->get_label( 'Autour One' ),
			'Average' => $this->get_label( 'Average' ),
			'Average Sans' => $this->get_label( 'Average Sans' ),
			'Averia Gruesa Libre' => $this->get_label( 'Averia Gruesa Libre' ),
			'Averia Libre' => $this->get_label( 'Averia Libre' ),
			'Averia Sans Libre' => $this->get_label( 'Averia Sans Libre' ),
			'Averia Serif Libre' => $this->get_label( 'Averia Serif Libre' ),
			'Bad Script' => $this->get_label( 'Bad Script' ),
			'Balthazar' => $this->get_label( 'Balthazar' ),
			'Bangers' => $this->get_label( 'Bangers' ),
			'Basic' => $this->get_label( 'Basic' ),
			'Battambang' => $this->get_label( 'Battambang' ),
			'Baumans' => $this->get_label( 'Baumans' ),
			'Bayon' => $this->get_label( 'Bayon' ),
			'Belgrano' => $this->get_label( 'Belgrano' ),
			'Belleza' => $this->get_label( 'Belleza' ),
			'BenchNine' => $this->get_label( 'BenchNine' ),
			'Bentham' => $this->get_label( 'Bentham' ),
			'Berkshire Swash' => $this->get_label( 'Berkshire Swash' ),
			'Bevan' => $this->get_label( 'Bevan' ),
			'Bigelow Rules' => $this->get_label( 'Bigelow Rules' ),
			'Bigshot One' => $this->get_label( 'Bigshot One' ),
			'Bilbo' => $this->get_label( 'Bilbo' ),
			'Bilbo Swash Caps' => $this->get_label( 'Bilbo Swash Caps' ),
			'Bitter' => $this->get_label( 'Bitter' ),
			'Black Ops One' => $this->get_label( 'Black Ops One' ),
			'Bokor' => $this->get_label( 'Bokor' ),
			'Bonbon' => $this->get_label( 'Bonbon' ),
			'Boogaloo' => $this->get_label( 'Boogaloo' ),
			'Bowlby One' => $this->get_label( 'Bowlby One' ),
			'Bowlby One SC' => $this->get_label( 'Bowlby One SC' ),
			'Brawler' => $this->get_label( 'Brawler' ),
			'Bree Serif' => $this->get_label( 'Bree Serif' ),
			'Bubblegum Sans' => $this->get_label( 'Bubblegum Sans' ),
			'Bubbler One' => $this->get_label( 'Bubbler One' ),
			'Buda' => $this->get_label( 'Buda' ),
			'Buenard' => $this->get_label( 'Buenard' ),
			'Butcherman' => $this->get_label( 'Butcherman' ),
			'Butterfly Kids' => $this->get_label( 'Butterfly Kids' ),
			'Cabin' => $this->get_label( 'Cabin' ),
			'Cabin Condensed' => $this->get_label( 'Cabin Condensed' ),
			'Cabin Sketch' => $this->get_label( 'Cabin Sketch' ),
			'Caesar Dressing' => $this->get_label( 'Caesar Dressing' ),
			'Cagliostro' => $this->get_label( 'Cagliostro' ),
			'Calligraffitti' => $this->get_label( 'Calligraffitti' ),
			'Cambo' => $this->get_label( 'Cambo' ),
			'Candal' => $this->get_label( 'Candal' ),
			'Cantarell' => $this->get_label( 'Cantarell' ),
			'Cantata One' => $this->get_label( 'Cantata One' ),
			'Cantora One' => $this->get_label( 'Cantora One' ),
			'Capriola' => $this->get_label( 'Capriola' ),
			'Cardo' => $this->get_label( 'Cardo' ),
			'Carme' => $this->get_label( 'Carme' ),
			'Carrois Gothic' => $this->get_label( 'Carrois Gothic' ),
			'Carrois Gothic SC' => $this->get_label( 'Carrois Gothic SC' ),
			'Carter One' => $this->get_label( 'Carter One' ),
			'Caudex' => $this->get_label( 'Caudex' ),
			'Cedarville Cursive' => $this->get_label( 'Cedarville Cursive' ),
			'Ceviche One' => $this->get_label( 'Ceviche One' ),
			'Changa One' => $this->get_label( 'Changa One' ),
			'Chango' => $this->get_label( 'Chango' ),
			'Chau Philomene One' => $this->get_label( 'Chau Philomene One' ),
			'Chela One' => $this->get_label( 'Chela One' ),
			'Chelsea Market' => $this->get_label( 'Chelsea Market' ),
			'Chenla' => $this->get_label( 'Chenla' ),
			'Cherry Cream Soda' => $this->get_label( 'Cherry Cream Soda' ),
			'Cherry Swash' => $this->get_label( 'Cherry Swash' ),
			'Chewy' => $this->get_label( 'Chewy' ),
			'Chicle' => $this->get_label( 'Chicle' ),
			'Chivo' => $this->get_label( 'Chivo' ),
			'Cinzel' => $this->get_label( 'Cinzel' ),
			'Cinzel Decorative' => $this->get_label( 'Cinzel Decorative' ),
			'Clicker Script' => $this->get_label( 'Clicker Script' ),
			'Coda' => $this->get_label( 'Coda' ),
			'Coda Caption' => $this->get_label( 'Coda Caption' ),
			'Codystar' => $this->get_label( 'Codystar' ),
			'Combo' => $this->get_label( 'Combo' ),
			'Comfortaa' => $this->get_label( 'Comfortaa' ),
			'Coming Soon' => $this->get_label( 'Coming Soon' ),
			'Concert One' => $this->get_label( 'Concert One' ),
			'Condiment' => $this->get_label( 'Condiment' ),
			'Content' => $this->get_label( 'Content' ),
			'Contrail One' => $this->get_label( 'Contrail One' ),
			'Convergence' => $this->get_label( 'Convergence' ),
			'Cookie' => $this->get_label( 'Cookie' ),
			'Copse' => $this->get_label( 'Copse' ),
			'Corben' => $this->get_label( 'Corben' ),
			'Courgette' => $this->get_label( 'Courgette' ),
			'Cousine' => $this->get_label( 'Cousine' ),
			'Coustard' => $this->get_label( 'Coustard' ),
			'Covered By Your Grace' => $this->get_label( 'Covered By Your Grace' ),
			'Crafty Girls' => $this->get_label( 'Crafty Girls' ),
			'Creepster' => $this->get_label( 'Creepster' ),
			'Crete Round' => $this->get_label( 'Crete Round' ),
			'Crimson Text' => $this->get_label( 'Crimson Text' ),
			'Croissant One' => $this->get_label( 'Croissant One' ),
			'Crushed' => $this->get_label( 'Crushed' ),
			'Cuprum' => $this->get_label( 'Cuprum' ),
			'Cutive' => $this->get_label( 'Cutive' ),
			'Cutive Mono' => $this->get_label( 'Cutive Mono' ),
			'Damion' => $this->get_label( 'Damion' ),
			'Dancing Script' => $this->get_label( 'Dancing Script' ),
			'Dangrek' => $this->get_label( 'Dangrek' ),
			'Dawning of a New Day' => $this->get_label( 'Dawning of a New Day' ),
			'Days One' => $this->get_label( 'Days One' ),
			'Delius' => $this->get_label( 'Delius' ),
			'Delius Swash Caps' => $this->get_label( 'Delius Swash Caps' ),
			'Delius Unicase' => $this->get_label( 'Delius Unicase' ),
			'Della Respira' => $this->get_label( 'Della Respira' ),
			'Denk One' => $this->get_label( 'Denk One' ),
			'Devonshire' => $this->get_label( 'Devonshire' ),
			'Didact Gothic' => $this->get_label( 'Didact Gothic' ),
			'Diplomata' => $this->get_label( 'Diplomata' ),
			'Diplomata SC' => $this->get_label( 'Diplomata SC' ),
			'Domine' => $this->get_label( 'Domine' ),
			'Donegal One' => $this->get_label( 'Donegal One' ),
			'Doppio One' => $this->get_label( 'Doppio One' ),
			'Dorsa' => $this->get_label( 'Dorsa' ),
			'Dosis' => $this->get_label( 'Dosis' ),
			'Dr Sugiyama' => $this->get_label( 'Dr Sugiyama' ),
			'Droid Sans' => $this->get_label( 'Droid Sans' ),
			'Droid Sans Mono' => $this->get_label( 'Droid Sans Mono' ),
			'Droid Serif' => $this->get_label( 'Droid Serif' ),
			'Duru Sans' => $this->get_label( 'Duru Sans' ),
			'Dynalight' => $this->get_label( 'Dynalight' ),
			'EB Garamond' => $this->get_label( 'EB Garamond' ),
			'Eagle Lake' => $this->get_label( 'Eagle Lake' ),
			'Eater' => $this->get_label( 'Eater' ),
			'Economica' => $this->get_label( 'Economica' ),
			'Electrolize' => $this->get_label( 'Electrolize' ),
			'Elsie' => $this->get_label( 'Elsie' ),
			'Elsie Swash Caps' => $this->get_label( 'Elsie Swash Caps' ),
			'Emblema One' => $this->get_label( 'Emblema One' ),
			'Emilys Candy' => $this->get_label( 'Emilys Candy' ),
			'Engagement' => $this->get_label( 'Engagement' ),
			'Englebert' => $this->get_label( 'Englebert' ),
			'Enriqueta' => $this->get_label( 'Enriqueta' ),
			'Erica One' => $this->get_label( 'Erica One' ),
			'Esteban' => $this->get_label( 'Esteban' ),
			'Euphoria Script' => $this->get_label( 'Euphoria Script' ),
			'Ewert' => $this->get_label( 'Ewert' ),
			'Exo' => $this->get_label( 'Exo' ),
			'Exo 2' => $this->get_label( 'Exo 2' ),
			'Expletus Sans' => $this->get_label( 'Expletus Sans' ),
			'Fanwood Text' => $this->get_label( 'Fanwood Text' ),
			'Fascinate' => $this->get_label( 'Fascinate' ),
			'Fascinate Inline' => $this->get_label( 'Fascinate Inline' ),
			'Faster One' => $this->get_label( 'Faster One' ),
			'Fasthand' => $this->get_label( 'Fasthand' ),
			'Fauna One' => $this->get_label( 'Fauna One' ),
			'Federant' => $this->get_label( 'Federant' ),
			'Federo' => $this->get_label( 'Federo' ),
			'Felipa' => $this->get_label( 'Felipa' ),
			'Fenix' => $this->get_label( 'Fenix' ),
			'Finger Paint' => $this->get_label( 'Finger Paint' ),
			'Fjalla One' => $this->get_label( 'Fjalla One' ),
			'Fjord One' => $this->get_label( 'Fjord One' ),
			'Flamenco' => $this->get_label( 'Flamenco' ),
			'Flavors' => $this->get_label( 'Flavors' ),
			'Fondamento' => $this->get_label( 'Fondamento' ),
			'Fontdiner Swanky' => $this->get_label( 'Fontdiner Swanky' ),
			'Forum' => $this->get_label( 'Forum' ),
			'Francois One' => $this->get_label( 'Francois One' ),
			'Freckle Face' => $this->get_label( 'Freckle Face' ),
			'Fredericka the Great' => $this->get_label( 'Fredericka the Great' ),
			'Fredoka One' => $this->get_label( 'Fredoka One' ),
			'Freehand' => $this->get_label( 'Freehand' ),
			'Fresca' => $this->get_label( 'Fresca' ),
			'Frijole' => $this->get_label( 'Frijole' ),
			'Fruktur' => $this->get_label( 'Fruktur' ),
			'Fugaz One' => $this->get_label( 'Fugaz One' ),
			'GFS Didot' => $this->get_label( 'GFS Didot' ),
			'GFS Neohellenic' => $this->get_label( 'GFS Neohellenic' ),
			'Gabriela' => $this->get_label( 'Gabriela' ),
			'Gafata' => $this->get_label( 'Gafata' ),
			'Galdeano' => $this->get_label( 'Galdeano' ),
			'Galindo' => $this->get_label( 'Galindo' ),
			'Gentium Basic' => $this->get_label( 'Gentium Basic' ),
			'Gentium Book Basic' => $this->get_label( 'Gentium Book Basic' ),
			'Geo' => $this->get_label( 'Geo' ),
			'Geostar' => $this->get_label( 'Geostar' ),
			'Geostar Fill' => $this->get_label( 'Geostar Fill' ),
			'Germania One' => $this->get_label( 'Germania One' ),
			'Gilda Display' => $this->get_label( 'Gilda Display' ),
			'Give You Glory' => $this->get_label( 'Give You Glory' ),
			'Glass Antiqua' => $this->get_label( 'Glass Antiqua' ),
			'Glegoo' => $this->get_label( 'Glegoo' ),
			'Gloria Hallelujah' => $this->get_label( 'Gloria Hallelujah' ),
			'Goblin One' => $this->get_label( 'Goblin One' ),
			'Gochi Hand' => $this->get_label( 'Gochi Hand' ),
			'Gorditas' => $this->get_label( 'Gorditas' ),
			'Goudy Bookletter 1911' => $this->get_label( 'Goudy Bookletter 1911' ),
			'Graduate' => $this->get_label( 'Graduate' ),
			'Grand Hotel' => $this->get_label( 'Grand Hotel' ),
			'Gravitas One' => $this->get_label( 'Gravitas One' ),
			'Great Vibes' => $this->get_label( 'Great Vibes' ),
			'Griffy' => $this->get_label( 'Griffy' ),
			'Gruppo' => $this->get_label( 'Gruppo' ),
			'Gudea' => $this->get_label( 'Gudea' ),
			'Habibi' => $this->get_label( 'Habibi' ),
			'Hammersmith One' => $this->get_label( 'Hammersmith One' ),
			'Hanalei' => $this->get_label( 'Hanalei' ),
			'Hanalei Fill' => $this->get_label( 'Hanalei Fill' ),
			'Handlee' => $this->get_label( 'Handlee' ),
			'Hanuman' => $this->get_label( 'Hanuman' ),
			'Happy Monkey' => $this->get_label( 'Happy Monkey' ),
			'Headland One' => $this->get_label( 'Headland One' ),
			'Henny Penny' => $this->get_label( 'Henny Penny' ),
			'Herr Von Muellerhoff' => $this->get_label( 'Herr Von Muellerhoff' ),
			'Holtwood One SC' => $this->get_label( 'Holtwood One SC' ),
			'Homemade Apple' => $this->get_label( 'Homemade Apple' ),
			'Homenaje' => $this->get_label( 'Homenaje' ),
			'IM Fell DW Pica' => $this->get_label( 'IM Fell DW Pica' ),
			'IM Fell DW Pica SC' => $this->get_label( 'IM Fell DW Pica SC' ),
			'IM Fell Double Pica' => $this->get_label( 'IM Fell Double Pica' ),
			'IM Fell Double Pica SC' => $this->get_label( 'IM Fell Double Pica SC' ),
			'IM Fell English' => $this->get_label( 'IM Fell English' ),
			'IM Fell English SC' => $this->get_label( 'IM Fell English SC' ),
			'IM Fell French Canon' => $this->get_label( 'IM Fell French Canon' ),
			'IM Fell French Canon SC' => $this->get_label( 'IM Fell French Canon SC' ),
			'IM Fell Great Primer' => $this->get_label( 'IM Fell Great Primer' ),
			'IM Fell Great Primer SC' => $this->get_label( 'IM Fell Great Primer SC' ),
			'Iceberg' => $this->get_label( 'Iceberg' ),
			'Iceland' => $this->get_label( 'Iceland' ),
			'Imprima' => $this->get_label( 'Imprima' ),
			'Inconsolata' => $this->get_label( 'Inconsolata' ),
			'Inder' => $this->get_label( 'Inder' ),
			'Indie Flower' => $this->get_label( 'Indie Flower' ),
			'Inika' => $this->get_label( 'Inika' ),
			'Irish Grover' => $this->get_label( 'Irish Grover' ),
			'Istok Web' => $this->get_label( 'Istok Web' ),
			'Italiana' => $this->get_label( 'Italiana' ),
			'Italianno' => $this->get_label( 'Italianno' ),
			'Jacques Francois' => $this->get_label( 'Jacques Francois' ),
			'Jacques Francois Shadow' => $this->get_label( 'Jacques Francois Shadow' ),
			'Jim Nightshade' => $this->get_label( 'Jim Nightshade' ),
			'Jockey One' => $this->get_label( 'Jockey One' ),
			'Jolly Lodger' => $this->get_label( 'Jolly Lodger' ),
			'Josefin Sans' => $this->get_label( 'Josefin Sans' ),
			'Josefin Slab' => $this->get_label( 'Josefin Slab' ),
			'Joti One' => $this->get_label( 'Joti One' ),
			'Judson' => $this->get_label( 'Judson' ),
			'Julee' => $this->get_label( 'Julee' ),
			'Julius Sans One' => $this->get_label( 'Julius Sans One' ),
			'Junge' => $this->get_label( 'Junge' ),
			'Jura' => $this->get_label( 'Jura' ),
			'Just Another Hand' => $this->get_label( 'Just Another Hand' ),
			'Just Me Again Down Here' => $this->get_label( 'Just Me Again Down Here' ),
			'Kameron' => $this->get_label( 'Kameron' ),
			'Kantumruy' => $this->get_label( 'Kantumruy' ),
			'Karla' => $this->get_label( 'Karla' ),
			'Kaushan Script' => $this->get_label( 'Kaushan Script' ),
			'Kavoon' => $this->get_label( 'Kavoon' ),
			'Kdam Thmor' => $this->get_label( 'Kdam Thmor' ),
			'Keania One' => $this->get_label( 'Keania One' ),
			'Kelly Slab' => $this->get_label( 'Kelly Slab' ),
			'Kenia' => $this->get_label( 'Kenia' ),
			'Khmer' => $this->get_label( 'Khmer' ),
			'Kite One' => $this->get_label( 'Kite One' ),
			'Knewave' => $this->get_label( 'Knewave' ),
			'Kotta One' => $this->get_label( 'Kotta One' ),
			'Koulen' => $this->get_label( 'Koulen' ),
			'Kranky' => $this->get_label( 'Kranky' ),
			'Kreon' => $this->get_label( 'Kreon' ),
			'Kristi' => $this->get_label( 'Kristi' ),
			'Krona One' => $this->get_label( 'Krona One' ),
			'La Belle Aurore' => $this->get_label( 'La Belle Aurore' ),
			'Lancelot' => $this->get_label( 'Lancelot' ),
			'Lato' => $this->get_label( 'Lato' ),
			'League Script' => $this->get_label( 'League Script' ),
			'Leckerli One' => $this->get_label( 'Leckerli One' ),
			'Ledger' => $this->get_label( 'Ledger' ),
			'Lekton' => $this->get_label( 'Lekton' ),
			'Lemon' => $this->get_label( 'Lemon' ),
			'Libre Baskerville' => $this->get_label( 'Libre Baskerville' ),
			'Life Savers' => $this->get_label( 'Life Savers' ),
			'Lilita One' => $this->get_label( 'Lilita One' ),
			'Lily Script One' => $this->get_label( 'Lily Script One' ),
			'Limelight' => $this->get_label( 'Limelight' ),
			'Linden Hill' => $this->get_label( 'Linden Hill' ),
			'Lobster' => $this->get_label( 'Lobster' ),
			'Lobster Two' => $this->get_label( 'Lobster Two' ),
			'Londrina Outline' => $this->get_label( 'Londrina Outline' ),
			'Londrina Shadow' => $this->get_label( 'Londrina Shadow' ),
			'Londrina Sketch' => $this->get_label( 'Londrina Sketch' ),
			'Londrina Solid' => $this->get_label( 'Londrina Solid' ),
			'Lora' => $this->get_label( 'Lora' ),
			'Love Ya Like A Sister' => $this->get_label( 'Love Ya Like A Sister' ),
			'Loved by the King' => $this->get_label( 'Loved by the King' ),
			'Lovers Quarrel' => $this->get_label( 'Lovers Quarrel' ),
			'Luckiest Guy' => $this->get_label( 'Luckiest Guy' ),
			'Lusitana' => $this->get_label( 'Lusitana' ),
			'Lustria' => $this->get_label( 'Lustria' ),
			'Macondo' => $this->get_label( 'Macondo' ),
			'Macondo Swash Caps' => $this->get_label( 'Macondo Swash Caps' ),
			'Magra' => $this->get_label( 'Magra' ),
			'Maiden Orange' => $this->get_label( 'Maiden Orange' ),
			'Mako' => $this->get_label( 'Mako' ),
			'Marcellus' => $this->get_label( 'Marcellus' ),
			'Marcellus SC' => $this->get_label( 'Marcellus SC' ),
			'Marck Script' => $this->get_label( 'Marck Script' ),
			'Margarine' => $this->get_label( 'Margarine' ),
			'Marko One' => $this->get_label( 'Marko One' ),
			'Marmelad' => $this->get_label( 'Marmelad' ),
			'Marvel' => $this->get_label( 'Marvel' ),
			'Mate' => $this->get_label( 'Mate' ),
			'Mate SC' => $this->get_label( 'Mate SC' ),
			'Maven Pro' => $this->get_label( 'Maven Pro' ),
			'McLaren' => $this->get_label( 'McLaren' ),
			'Meddon' => $this->get_label( 'Meddon' ),
			'MedievalSharp' => $this->get_label( 'MedievalSharp' ),
			'Medula One' => $this->get_label( 'Medula One' ),
			'Megrim' => $this->get_label( 'Megrim' ),
			'Meie Script' => $this->get_label( 'Meie Script' ),
			'Merienda' => $this->get_label( 'Merienda' ),
			'Merienda One' => $this->get_label( 'Merienda One' ),
			'Merriweather' => $this->get_label( 'Merriweather' ),
			'Merriweather Sans' => $this->get_label( 'Merriweather Sans' ),
			'Metal' => $this->get_label( 'Metal' ),
			'Metal Mania' => $this->get_label( 'Metal Mania' ),
			'Metamorphous' => $this->get_label( 'Metamorphous' ),
			'Metrophobic' => $this->get_label( 'Metrophobic' ),
			'Michroma' => $this->get_label( 'Michroma' ),
			'Milonga' => $this->get_label( 'Milonga' ),
			'Miltonian' => $this->get_label( 'Miltonian' ),
			'Miltonian Tattoo' => $this->get_label( 'Miltonian Tattoo' ),
			'Miniver' => $this->get_label( 'Miniver' ),
			'Miss Fajardose' => $this->get_label( 'Miss Fajardose' ),
			'Modern Antiqua' => $this->get_label( 'Modern Antiqua' ),
			'Molengo' => $this->get_label( 'Molengo' ),
			'Molle' => $this->get_label( 'Molle' ),
			'Monda' => $this->get_label( 'Monda' ),
			'Monofett' => $this->get_label( 'Monofett' ),
			'Monoton' => $this->get_label( 'Monoton' ),
			'Monsieur La Doulaise' => $this->get_label( 'Monsieur La Doulaise' ),
			'Montaga' => $this->get_label( 'Montaga' ),
			'Montez' => $this->get_label( 'Montez' ),
			'Montserrat' => $this->get_label( 'Montserrat' ),
			'Montserrat Alternates' => $this->get_label( 'Montserrat Alternates' ),
			'Montserrat Subrayada' => $this->get_label( 'Montserrat Subrayada' ),
			'Moul' => $this->get_label( 'Moul' ),
			'Moulpali' => $this->get_label( 'Moulpali' ),
			'Mountains of Christmas' => $this->get_label( 'Mountains of Christmas' ),
			'Mouse Memoirs' => $this->get_label( 'Mouse Memoirs' ),
			'Mr Bedfort' => $this->get_label( 'Mr Bedfort' ),
			'Mr Dafoe' => $this->get_label( 'Mr Dafoe' ),
			'Mr De Haviland' => $this->get_label( 'Mr De Haviland' ),
			'Mrs Saint Delafield' => $this->get_label( 'Mrs Saint Delafield' ),
			'Mrs Sheppards' => $this->get_label( 'Mrs Sheppards' ),
			'Muli' => $this->get_label( 'Muli' ),
			'Mystery Quest' => $this->get_label( 'Mystery Quest' ),
			'Neucha' => $this->get_label( 'Neucha' ),
			'Neuton' => $this->get_label( 'Neuton' ),
			'New Rocker' => $this->get_label( 'New Rocker' ),
			'News Cycle' => $this->get_label( 'News Cycle' ),
			'Niconne' => $this->get_label( 'Niconne' ),
			'Nixie One' => $this->get_label( 'Nixie One' ),
			'Nobile' => $this->get_label( 'Nobile' ),
			'Nokora' => $this->get_label( 'Nokora' ),
			'Norican' => $this->get_label( 'Norican' ),
			'Nosifer' => $this->get_label( 'Nosifer' ),
			'Nothing You Could Do' => $this->get_label( 'Nothing You Could Do' ),
			'Noticia Text' => $this->get_label( 'Noticia Text' ),
			'Noto Sans' => $this->get_label( 'Noto Sans' ),
			'Noto Serif' => $this->get_label( 'Noto Serif' ),
			'Nova Cut' => $this->get_label( 'Nova Cut' ),
			'Nova Flat' => $this->get_label( 'Nova Flat' ),
			'Nova Mono' => $this->get_label( 'Nova Mono' ),
			'Nova Oval' => $this->get_label( 'Nova Oval' ),
			'Nova Round' => $this->get_label( 'Nova Round' ),
			'Nova Script' => $this->get_label( 'Nova Script' ),
			'Nova Slim' => $this->get_label( 'Nova Slim' ),
			'Nova Square' => $this->get_label( 'Nova Square' ),
			'Numans' => $this->get_label( 'Numans' ),
			'Nunito' => $this->get_label( 'Nunito' ),
			'Odor Mean Chey' => $this->get_label( 'Odor Mean Chey' ),
			'Offside' => $this->get_label( 'Offside' ),
			'Old Standard TT' => $this->get_label( 'Old Standard TT' ),
			'Oldenburg' => $this->get_label( 'Oldenburg' ),
			'Oleo Script' => $this->get_label( 'Oleo Script' ),
			'Oleo Script Swash Caps' => $this->get_label( 'Oleo Script Swash Caps' ),
			'Open Sans' => $this->get_label( 'Open Sans' ),
			'Open Sans Condensed' => $this->get_label( 'Open Sans Condensed' ),
			'Oranienbaum' => $this->get_label( 'Oranienbaum' ),
			'Orbitron' => $this->get_label( 'Orbitron' ),
			'Oregano' => $this->get_label( 'Oregano' ),
			'Orienta' => $this->get_label( 'Orienta' ),
			'Original Surfer' => $this->get_label( 'Original Surfer' ),
			'Oswald' => $this->get_label( 'Oswald' ),
			'Over the Rainbow' => $this->get_label( 'Over the Rainbow' ),
			'Overlock' => $this->get_label( 'Overlock' ),
			'Overlock SC' => $this->get_label( 'Overlock SC' ),
			'Ovo' => $this->get_label( 'Ovo' ),
			'Oxygen' => $this->get_label( 'Oxygen' ),
			'Oxygen Mono' => $this->get_label( 'Oxygen Mono' ),
			'PT Mono' => $this->get_label( 'PT Mono' ),
			'PT Sans' => $this->get_label( 'PT Sans' ),
			'PT Sans Caption' => $this->get_label( 'PT Sans Caption' ),
			'PT Sans Narrow' => $this->get_label( 'PT Sans Narrow' ),
			'PT Serif' => $this->get_label( 'PT Serif' ),
			'PT Serif Caption' => $this->get_label( 'PT Serif Caption' ),
			'Pacifico' => $this->get_label( 'Pacifico' ),
			'Paprika' => $this->get_label( 'Paprika' ),
			'Parisienne' => $this->get_label( 'Parisienne' ),
			'Passero One' => $this->get_label( 'Passero One' ),
			'Passion One' => $this->get_label( 'Passion One' ),
			'Pathway Gothic One' => $this->get_label( 'Pathway Gothic One' ),
			'Patrick Hand' => $this->get_label( 'Patrick Hand' ),
			'Patrick Hand SC' => $this->get_label( 'Patrick Hand SC' ),
			'Patua One' => $this->get_label( 'Patua One' ),
			'Paytone One' => $this->get_label( 'Paytone One' ),
			'Peralta' => $this->get_label( 'Peralta' ),
			'Permanent Marker' => $this->get_label( 'Permanent Marker' ),
			'Petit Formal Script' => $this->get_label( 'Petit Formal Script' ),
			'Petrona' => $this->get_label( 'Petrona' ),
			'Philosopher' => $this->get_label( 'Philosopher' ),
			'Piedra' => $this->get_label( 'Piedra' ),
			'Pinyon Script' => $this->get_label( 'Pinyon Script' ),
			'Pirata One' => $this->get_label( 'Pirata One' ),
			'Plaster' => $this->get_label( 'Plaster' ),
			'Play' => $this->get_label( 'Play' ),
			'Playball' => $this->get_label( 'Playball' ),
			'Playfair Display' => $this->get_label( 'Playfair Display' ),
			'Playfair Display SC' => $this->get_label( 'Playfair Display SC' ),
			'Podkova' => $this->get_label( 'Podkova' ),
			'Poiret One' => $this->get_label( 'Poiret One' ),
			'Poller One' => $this->get_label( 'Poller One' ),
			'Poly' => $this->get_label( 'Poly' ),
			'Pompiere' => $this->get_label( 'Pompiere' ),
			'Pontano Sans' => $this->get_label( 'Pontano Sans' ),
			'Port Lligat Sans' => $this->get_label( 'Port Lligat Sans' ),
			'Port Lligat Slab' => $this->get_label( 'Port Lligat Slab' ),
			'Prata' => $this->get_label( 'Prata' ),
			'Preahvihear' => $this->get_label( 'Preahvihear' ),
			'Press Start 2P' => $this->get_label( 'Press Start 2P' ),
			'Princess Sofia' => $this->get_label( 'Princess Sofia' ),
			'Prociono' => $this->get_label( 'Prociono' ),
			'Prosto One' => $this->get_label( 'Prosto One' ),
			'Puritan' => $this->get_label( 'Puritan' ),
			'Purple Purse' => $this->get_label( 'Purple Purse' ),
			'Quando' => $this->get_label( 'Quando' ),
			'Quantico' => $this->get_label( 'Quantico' ),
			'Quattrocento' => $this->get_label( 'Quattrocento' ),
			'Quattrocento Sans' => $this->get_label( 'Quattrocento Sans' ),
			'Questrial' => $this->get_label( 'Questrial' ),
			'Quicksand' => $this->get_label( 'Quicksand' ),
			'Quintessential' => $this->get_label( 'Quintessential' ),
			'Qwigley' => $this->get_label( 'Qwigley' ),
			'Racing Sans One' => $this->get_label( 'Racing Sans One' ),
			'Radley' => $this->get_label( 'Radley' ),
			'Raleway' => $this->get_label( 'Raleway' ),
			'Raleway Dots' => $this->get_label( 'Raleway Dots' ),
			'Rambla' => $this->get_label( 'Rambla' ),
			'Rammetto One' => $this->get_label( 'Rammetto One' ),
			'Ranchers' => $this->get_label( 'Ranchers' ),
			'Rancho' => $this->get_label( 'Rancho' ),
			'Rationale' => $this->get_label( 'Rationale' ),
			'Redressed' => $this->get_label( 'Redressed' ),
			'Reenie Beanie' => $this->get_label( 'Reenie Beanie' ),
			'Revalia' => $this->get_label( 'Revalia' ),
			'Ribeye' => $this->get_label( 'Ribeye' ),
			'Ribeye Marrow' => $this->get_label( 'Ribeye Marrow' ),
			'Righteous' => $this->get_label( 'Righteous' ),
			'Risque' => $this->get_label( 'Risque' ),
			'Roboto' => $this->get_label( 'Roboto' ),
			'Roboto Condensed' => $this->get_label( 'Roboto Condensed' ),
			'Roboto Slab' => $this->get_label( 'Roboto Slab' ),
			'Rochester' => $this->get_label( 'Rochester' ),
			'Rock Salt' => $this->get_label( 'Rock Salt' ),
			'Rokkitt' => $this->get_label( 'Rokkitt' ),
			'Romanesco' => $this->get_label( 'Romanesco' ),
			'Ropa Sans' => $this->get_label( 'Ropa Sans' ),
			'Rosario' => $this->get_label( 'Rosario' ),
			'Rosarivo' => $this->get_label( 'Rosarivo' ),
			'Rouge Script' => $this->get_label( 'Rouge Script' ),
			'Ruda' => $this->get_label( 'Ruda' ),
			'Rufina' => $this->get_label( 'Rufina' ),
			'Ruge Boogie' => $this->get_label( 'Ruge Boogie' ),
			'Ruluko' => $this->get_label( 'Ruluko' ),
			'Rum Raisin' => $this->get_label( 'Rum Raisin' ),
			'Ruslan Display' => $this->get_label( 'Ruslan Display' ),
			'Russo One' => $this->get_label( 'Russo One' ),
			'Ruthie' => $this->get_label( 'Ruthie' ),
			'Rye' => $this->get_label( 'Rye' ),
			'Sacramento' => $this->get_label( 'Sacramento' ),
			'Sail' => $this->get_label( 'Sail' ),
			'Salsa' => $this->get_label( 'Salsa' ),
			'Sanchez' => $this->get_label( 'Sanchez' ),
			'Sancreek' => $this->get_label( 'Sancreek' ),
			'Sansita One' => $this->get_label( 'Sansita One' ),
			'Sarina' => $this->get_label( 'Sarina' ),
			'Satisfy' => $this->get_label( 'Satisfy' ),
			'Scada' => $this->get_label( 'Scada' ),
			'Schoolbell' => $this->get_label( 'Schoolbell' ),
			'Seaweed Script' => $this->get_label( 'Seaweed Script' ),
			'Sevillana' => $this->get_label( 'Sevillana' ),
			'Seymour One' => $this->get_label( 'Seymour One' ),
			'Shadows Into Light' => $this->get_label( 'Shadows Into Light' ),
			'Shadows Into Light Two' => $this->get_label( 'Shadows Into Light Two' ),
			'Shanti' => $this->get_label( 'Shanti' ),
			'Share' => $this->get_label( 'Share' ),
			'Share Tech' => $this->get_label( 'Share Tech' ),
			'Share Tech Mono' => $this->get_label( 'Share Tech Mono' ),
			'Shojumaru' => $this->get_label( 'Shojumaru' ),
			'Short Stack' => $this->get_label( 'Short Stack' ),
			'Siemreap' => $this->get_label( 'Siemreap' ),
			'Sigmar One' => $this->get_label( 'Sigmar One' ),
			'Signika' => $this->get_label( 'Signika' ),
			'Signika Negative' => $this->get_label( 'Signika Negative' ),
			'Simonetta' => $this->get_label( 'Simonetta' ),
			'Sintony' => $this->get_label( 'Sintony' ),
			'Sirin Stencil' => $this->get_label( 'Sirin Stencil' ),
			'Six Caps' => $this->get_label( 'Six Caps' ),
			'Skranji' => $this->get_label( 'Skranji' ),
			'Slackey' => $this->get_label( 'Slackey' ),
			'Smokum' => $this->get_label( 'Smokum' ),
			'Smythe' => $this->get_label( 'Smythe' ),
			'Sniglet' => $this->get_label( 'Sniglet' ),
			'Snippet' => $this->get_label( 'Snippet' ),
			'Snowburst One' => $this->get_label( 'Snowburst One' ),
			'Sofadi One' => $this->get_label( 'Sofadi One' ),
			'Sofia' => $this->get_label( 'Sofia' ),
			'Sonsie One' => $this->get_label( 'Sonsie One' ),
			'Sorts Mill Goudy' => $this->get_label( 'Sorts Mill Goudy' ),
			'Source Code Pro' => $this->get_label( 'Source Code Pro' ),
			'Source Sans Pro' => $this->get_label( 'Source Sans Pro' ),
			'Special Elite' => $this->get_label( 'Special Elite' ),
			'Spicy Rice' => $this->get_label( 'Spicy Rice' ),
			'Spinnaker' => $this->get_label( 'Spinnaker' ),
			'Spirax' => $this->get_label( 'Spirax' ),
			'Squada One' => $this->get_label( 'Squada One' ),
			'Stalemate' => $this->get_label( 'Stalemate' ),
			'Stalinist One' => $this->get_label( 'Stalinist One' ),
			'Stardos Stencil' => $this->get_label( 'Stardos Stencil' ),
			'Stint Ultra Condensed' => $this->get_label( 'Stint Ultra Condensed' ),
			'Stint Ultra Expanded' => $this->get_label( 'Stint Ultra Expanded' ),
			'Stoke' => $this->get_label( 'Stoke' ),
			'Strait' => $this->get_label( 'Strait' ),
			'Sue Ellen Francisco' => $this->get_label( 'Sue Ellen Francisco' ),
			'Sunshiney' => $this->get_label( 'Sunshiney' ),
			'Supermercado One' => $this->get_label( 'Supermercado One' ),
			'Suwannaphum' => $this->get_label( 'Suwannaphum' ),
			'Swanky and Moo Moo' => $this->get_label( 'Swanky and Moo Moo' ),
			'Syncopate' => $this->get_label( 'Syncopate' ),
			'Tangerine' => $this->get_label( 'Tangerine' ),
			'Taprom' => $this->get_label( 'Taprom' ),
			'Tauri' => $this->get_label( 'Tauri' ),
			'Telex' => $this->get_label( 'Telex' ),
			'Tenor Sans' => $this->get_label( 'Tenor Sans' ),
			'Text Me One' => $this->get_label( 'Text Me One' ),
			'The Girl Next Door' => $this->get_label( 'The Girl Next Door' ),
			'Tienne' => $this->get_label( 'Tienne' ),
			'Tinos' => $this->get_label( 'Tinos' ),
			'Titan One' => $this->get_label( 'Titan One' ),
			'Titillium Web' => $this->get_label( 'Titillium Web' ),
			'Trade Winds' => $this->get_label( 'Trade Winds' ),
			'Trocchi' => $this->get_label( 'Trocchi' ),
			'Trochut' => $this->get_label( 'Trochut' ),
			'Trykker' => $this->get_label( 'Trykker' ),
			'Tulpen One' => $this->get_label( 'Tulpen One' ),
			'Ubuntu' => $this->get_label( 'Ubuntu' ),
			'Ubuntu Condensed' => $this->get_label( 'Ubuntu Condensed' ),
			'Ubuntu Mono' => $this->get_label( 'Ubuntu Mono' ),
			'Ultra' => $this->get_label( 'Ultra' ),
			'Uncial Antiqua' => $this->get_label( 'Uncial Antiqua' ),
			'Underdog' => $this->get_label( 'Underdog' ),
			'Unica One' => $this->get_label( 'Unica One' ),
			'UnifrakturCook' => $this->get_label( 'UnifrakturCook' ),
			'UnifrakturMaguntia' => $this->get_label( 'UnifrakturMaguntia' ),
			'Unkempt' => $this->get_label( 'Unkempt' ),
			'Unlock' => $this->get_label( 'Unlock' ),
			'Unna' => $this->get_label( 'Unna' ),
			'VT323' => $this->get_label( 'VT323' ),
			'Vampiro One' => $this->get_label( 'Vampiro One' ),
			'Varela' => $this->get_label( 'Varela' ),
			'Varela Round' => $this->get_label( 'Varela Round' ),
			'Vast Shadow' => $this->get_label( 'Vast Shadow' ),
			'Vibur' => $this->get_label( 'Vibur' ),
			'Vidaloka' => $this->get_label( 'Vidaloka' ),
			'Viga' => $this->get_label( 'Viga' ),
			'Voces' => $this->get_label( 'Voces' ),
			'Volkhov' => $this->get_label( 'Volkhov' ),
			'Vollkorn' => $this->get_label( 'Vollkorn' ),
			'Voltaire' => $this->get_label( 'Voltaire' ),
			'Waiting for the Sunrise' => $this->get_label( 'Waiting for the Sunrise' ),
			'Wallpoet' => $this->get_label( 'Wallpoet' ),
			'Walter Turncoat' => $this->get_label( 'Walter Turncoat' ),
			'Warnes' => $this->get_label( 'Warnes' ),
			'Wellfleet' => $this->get_label( 'Wellfleet' ),
			'Wendy One' => $this->get_label( 'Wendy One' ),
			'Wire One' => $this->get_label( 'Wire One' ),
			'Yanone Kaffeesatz' => $this->get_label( 'Yanone Kaffeesatz' ),
			'Yellowtail' => $this->get_label( 'Yellowtail' ),
			'Yeseva One' => $this->get_label( 'Yeseva One' ),
			'Yesteryear' => $this->get_label( 'Yesteryear' ),
			'Zeyada' => $this->get_label( 'Zeyada' )
		);
		
		$this->settings['default_font_family'] = '';
		
		$this->settings['highlight_types'] = array(
			''            => $this->get_label( 'None(default)' ),
			'background'     => $this->get_label( 'Background' ),
			'border' => $this->get_label( 'Underline' )
		);
		$this->settings['highlight_default_type'] = '';
		
		$this->settings['button_sizes'] = array(
			'tiny'   => $this->get_label( 'Tiny' ),
			'small'  => $this->get_label( 'Small' ),
			'medium' => $this->get_label( 'Medium' ),
			'large'  => $this->get_label( 'Large' )
		);
		$this->settings['default_button_size'] = 'medium';
		
		$this->settings['button_icon_positions'] = array(
			'left' => $this->get_label( 'Left (default)'),
			'right' => $this->get_label( 'Right')
		);
		$this->settings['default_button_icon_position'] = 'left';
		
		$this->settings['button_shapes'] = array(
			'square'      =>     $this->get_label( 'Square (default)' ),
			'radius'      =>     $this->get_label( 'Radius' ),
			'round'       =>     $this->get_label( 'Round' )
		);
		$this->settings['default_button_shape'] = 'square';
	}
	
	/**
	 * Shortcode admin interface
	 */
	public function build_shortcode_editor_options() {
		
		$html = '';
		
		$source = array();
		
		if ( otw_post( 'shortcode_object', false, array(), 'json' ) ) {
			$source = otw_post( 'shortcode_object', array(), array(), 'json' );
		}
		
		$call_to_action = $this->settings['default_call_action'];
		
		if( isset( $source['otw-shortcode-element-call_to_action'] ) ){
			$call_to_action = trim( $source['otw-shortcode-element-call_to_action'] );
		}
		
		$html .= OTW_Form::text_input(array('id' => 'otw-shortcode-element-title', 'label' => $this->get_label('Title'), 'description' => $this->get_label('Enter title.'), 'parse' => $source ) );
		$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-title_tag', 'label' => $this->get_label( 'Title Tag' ), 'description' => $this->get_label('Select Title Tag.'), 'parse' => $source, 'options' => $this->settings['title_sizes'], 'value' => $this->settings['default_title_size'] ) ) );
		$html .= OTW_Form::text_input(array('id' => 'otw-shortcode-element-sub_title', 'label' => $this->get_label('Sub Title'), 'description' => $this->get_label('Enter sub title.'), 'parse' => $source ) );
		$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-sub_title_tag', 'label' => $this->get_label( 'Sub Title Tag' ), 'description' => $this->get_label('Select Sub Title.'), 'parse' => $source, 'options' => $this->settings['title_sizes'], 'value' => $this->settings['default_title_size'] ) ) );
		$html .= OTW_Form::text_area( array('id' => 'otw-shortcode-element-content', 'label' => $this->get_label('Content'), 'description' => $this->get_label('The content text. HTML is allowed.'), 'parse' => $source ) );
		$html .= OTW_Form::select( array('id' => 'otw-shortcode-element-call_to_action', 'label' => $this->get_label('Call to Action'), 'description' => $this->get_label('Choose the type of the call to action.'), 'parse' => $source, 'options' => $this->settings['call_action'], 'value' => $this->settings['default_call_action'], 'data-reload' => '1' ) );
		
		
		
		if( $call_to_action != 'none' ){
			
			$html .= OTW_Form::text_input( array('id' => 'otw-shortcode-element-action_text', 'label' => $this->get_label('Call to Action Text'), 'description' => $this->get_label('This is the text in the button or the text link.'), 'parse' => $source ) );
			$html .= OTW_Form::text_input( array('id' => 'otw-shortcode-element-action_href', 'label' => $this->get_label('Call to Action Link'), 'description' => $this->get_label('The link your call to action leads to.'), 'parse' => $source ) );
			$html .= OTW_Form::select( array('id' => 'otw-shortcode-element-action_text_color', 'label' => $this->get_label('Call to Action Text Color'), 'description' => $this->get_label('Choose text color.'), 'parse' => $source, 'options' => $this->settings['content_link_color'], 'value' => $this->settings['default_content_link_color'] ) );
			
			switch( $call_to_action == 'otw-button' ){
				
				case 'otw-button':
						$html .= OTW_Form::select( array('id' => 'otw-shortcode-element-action_button_color', 'label' => $this->get_label('Call to Action Button Background Color'), 'description' => $this->get_label('Choose button color.'), 'parse' => $source, 'options' => $this->settings['content_button_background'], 'value' => $this->settings['default_content_button_background'] ) );
						$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-action_button_target', 'label' => $this->get_label( 'Button Open in a new window' ), 'description' => $this->get_label( 'Optionally open this link in a new window.' ), 'parse' => $source, 'options' => array( '' => $this->get_label( 'no (default)' ), '_blank' => $this->get_label( 'yes' ) ), 'value' => '' )  );
						$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-action_button_size', 'label' => $this->get_label( 'Button Size' ), 'description' => $this->get_label( 'The size for the button.' ), 'parse' => $source, 'options' => $this->settings['button_sizes'], 'value' => $this->settings['default_button_size'] )  );
						$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-action_button_icon_type', 'label' => $this->get_label( 'Button Icon Type' ), 'description' => $this->get_label( 'The icons here are based on foundation icon fonts. The size and the color apply from the button title color and button size.' ), 'parse' => $source, 'options' => $this->settings['icon_types'], 'value' => $this->settings['default_icon_type'] )  );
						$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-action_button_icon_position', 'label' => $this->get_label( 'Button Icon Position' ), 'description' => $this->get_label( 'Icon can be position left or right of the button title.' ), 'parse' => $source, 'options' => $this->settings['button_icon_positions'], 'value' => $this->settings['default_button_icon_position'] )  );
						$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-action_button_shape', 'label' => $this->get_label( 'Button Shape' ), 'description' => $this->get_label( 'The shape of the button.' ), 'parse' => $source, 'options' => $this->settings['button_shapes'], 'value' => $this->settings['default_button_shape'] )  );
					break;
			}
		}
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-text_alignment', 'label' => $this->get_label( 'Welcome text alignment' ), 'description' => $this->get_label( 'Text position.' ), 'parse' => $source, 'options' => $this->settings['text_position'], 'value' => $this->settings['default_text_position'] ) );
		$html .= OTW_Form::text_input( array( 'id' => 'otw-shortcode-element-padding_lr', 'label' => $this->get_label( 'Welcome text padding left & right' ), 'description' => $this->get_label( 'Welcome text padding left & right.' ), 'parse' => $source ) );
		
		return $html;
	}

	/**
	* Shortcode admin interface custom options
	*/
	public function build_shortcode_editor_custom_options() {
	
		$html = '';
		$source = array();
		if ( otw_post( 'shortcode_object', false, array(), 'json' ) ) {
			$source = otw_post( 'shortcode_object', array(), array(), 'json' );
		}
		
		$call_to_action = $this->settings['default_call_action'];
		
		if( isset( $source['otw-shortcode-element-call_to_action'] ) ){
			$call_to_action = trim( $source['otw-shortcode-element-call_to_action'] );
		}
		
		$title_highlight_type = $this->settings['highlight_default_type'];
		
		if( isset( $source['otw-shortcode-element-title_highlight_type'] ) ){
			$title_highlight_type = trim( $source['otw-shortcode-element-title_highlight_type'] );
		}
		
		$sub_title_highlight_type = $this->settings['highlight_default_type'];
		
		if( isset( $source['otw-shortcode-element-sub_title_highlight_type'] ) ){
			$sub_title_highlight_type = trim( $source['otw-shortcode-element-sub_title_highlight_type'] );
		}
		
		$content_highlight_type = $this->settings['highlight_default_type'];
		
		if( isset( $source['otw-shortcode-element-content_highlight_type'] ) ){
			$content_highlight_type = trim( $source['otw-shortcode-element-content_highlight_type'] );
		}
		
		
		$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-title_font_size', 'label' => $this->get_label( 'Title Font Size' ), 'description' => $this->get_label( 'Title Font Size.' ), 'parse' => $source, 'options' => $this->settings['font_sizes'], 'value' => $this->settings['default_font_size'] ) ) );
		$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-title_font_weight', 'label' => $this->get_label( 'Title Font Weight' ), 'description' => $this->get_label( 'Title Font Weight.' ), 'parse' => $source, 'options' => $this->settings['font_weights'], 'value' => $this->settings['default_font_weight'] ) ) );
		$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-title_font_family', 'label' => $this->get_label( 'Title Font Family' ), 'description' => $this->get_label( 'Title Font Family.' ), 'parse' => $source, 'options' => $this->settings['font_families'], 'value' => $this->settings['default_font_family'] ) ) );
		$html .= OTW_Form::color_picker( ( array( 'id' => 'otw-shortcode-element-title_font_color', 'label' => $this->get_label( 'Title Font Color' ), 'description' => $this->get_label( 'Title Font Color.' ), 'parse' => $source ) ) );
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-title_highlight_type', 'label' => $this->get_label( 'Title Highlight Type' ), 'description' => $this->get_label( 'Colored is a highlight with a background. Underlined is a highlight with underlined text.' ), 'parse' => $source, 'options' => $this->settings['highlight_types'], 'value' => $this->settings['highlight_default_type'], 'data-reload' => '1' ) );
		
		if( $title_highlight_type ){
			
			switch( $title_highlight_type ){
				
				case 'background':
						$html .= OTW_Form::text_input( ( array( 'id' => 'otw-shortcode-element-title_highlight_opacity', 'label' => $this->get_label( 'Title Highlight Background Opacity' ), 'description' => $this->get_label( 'Title Highlight Background Opacity.' ), 'parse' => $source ) ) );
					break;
			}
			$html .= OTW_Form::color_picker( ( array( 'id' => 'otw-shortcode-element-title_highlight_color', 'label' => $this->get_label( 'Title Highlight Color' ), 'description' => $this->get_label( 'Title Highlight Color.' ), 'parse' => $source ) ) );
			$html .= OTW_Form::text_input( ( array( 'id' => 'otw-shortcode-element-title_highlight_padding', 'label' => $this->get_label( 'Title Highlight Padding' ), 'description' => $this->get_label( 'Title Highlight Padding.' ), 'parse' => $source ) ) );
		}
		$html .= OTW_Form::text_input( ( array( 'id' => 'otw-shortcode-element-title_padding_tb', 'label' => $this->get_label( 'Title Padding Top & Bottom' ), 'description' => $this->get_label( 'Title Padding Top & Bottom.' ), 'parse' => $source ) ) );
		
		$html .= '<div class="otw_separator"></div>';
		
		$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-sub_title_font_size', 'label' => $this->get_label( 'Sub title Font Size' ), 'description' => $this->get_label( 'Sub Title Font Size.' ), 'parse' => $source, 'options' => $this->settings['font_sizes'], 'value' => $this->settings['default_font_size'] ) ) );
		$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-sub_title_font_weight', 'label' => $this->get_label( 'Sub title Font Weight' ), 'description' => $this->get_label( 'Sub Title Font Weight.' ), 'parse' => $source, 'options' => $this->settings['font_weights'], 'value' => $this->settings['default_font_weight'] ) ) );
		$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-sub_title_font_family', 'label' => $this->get_label( 'Sub title Font Family' ), 'description' => $this->get_label( 'Title Font Family.' ), 'parse' => $source, 'options' => $this->settings['font_families'], 'value' => $this->settings['default_font_family'] ) ) );
		$html .= OTW_Form::color_picker( ( array( 'id' => 'otw-shortcode-element-sub_title_font_color', 'label' => $this->get_label( 'Sub title Font Color' ), 'description' => $this->get_label( 'Title Font Color.' ), 'parse' => $source ) ) );
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-sub_title_highlight_type', 'label' => $this->get_label( 'Sub Title Highlight Type' ), 'description' => $this->get_label( 'Colored is a highlight with a background. Underlined is a highlight with underlined text.' ), 'parse' => $source, 'options' => $this->settings['highlight_types'], 'value' => $this->settings['highlight_default_type'], 'data-reload' => '1' ) );
		
		if( $sub_title_highlight_type ){
			
			switch( $sub_title_highlight_type ){
				
				case 'background':
						$html .= OTW_Form::text_input( ( array( 'id' => 'otw-shortcode-element-sub_title_highlight_opacity', 'label' => $this->get_label( 'Sub title Highlight Background Opacity' ), 'description' => $this->get_label( 'Sub title Highlight Background Opacity.' ), 'parse' => $source ) ) );
					break;
			}
			$html .= OTW_Form::color_picker( ( array( 'id' => 'otw-shortcode-element-sub_title_highlight_color', 'label' => $this->get_label( 'Sub title Highlight Color' ), 'description' => $this->get_label( 'Sub title Highlight Color.' ), 'parse' => $source ) ) );
			$html .= OTW_Form::text_input( ( array( 'id' => 'otw-shortcode-element-sub_title_highlight_padding', 'label' => $this->get_label( 'Sub title Highlight Padding' ), 'description' => $this->get_label( 'Sub title Highlight Padding.' ), 'parse' => $source ) ) );
		}
		$html .= OTW_Form::text_input( ( array( 'id' => 'otw-shortcode-element-sub_title_padding_tb', 'label' => $this->get_label( 'Sub Title Padding Top & Bottom' ), 'description' => $this->get_label( 'Sub Title Padding Top & Bottom.' ), 'parse' => $source ) ) );
		$html .= '<div class="otw_separator"></div>';
		
		$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-content_font_size', 'label' => $this->get_label( 'Content Font Size' ), 'description' => $this->get_label( 'Content Font Size.' ), 'parse' => $source, 'options' => $this->settings['font_sizes'], 'value' => $this->settings['default_font_size'] ) ) );
		$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-content_font_weight', 'label' => $this->get_label( 'Content Font Weight' ), 'description' => $this->get_label( 'Content Font Weight.' ), 'parse' => $source, 'options' => $this->settings['font_weights'], 'value' => $this->settings['default_font_weight'] ) ) );
		$html .= OTW_Form::select( ( array( 'id' => 'otw-shortcode-element-content_font_family', 'label' => $this->get_label( 'Content Font Family' ), 'description' => $this->get_label( 'Content Font Family.' ), 'parse' => $source, 'options' => $this->settings['font_families'], 'value' => $this->settings['default_font_family'] ) ) );
		$html .= OTW_Form::color_picker( ( array( 'id' => 'otw-shortcode-element-content_font_color', 'label' => $this->get_label( 'Content Font Color' ), 'description' => $this->get_label( 'Content Font Color.' ), 'parse' => $source ) ) );
		$html .= OTW_Form::select( array( 'id' => 'otw-shortcode-element-content_highlight_type', 'label' => $this->get_label( 'Content Highlight Type' ), 'description' => $this->get_label( 'Colored is a highlight with a background. Underlined is a highlight with underlined text.' ), 'parse' => $source, 'options' => $this->settings['highlight_types'], 'value' => $this->settings['highlight_default_type'], 'data-reload' => '1' ) );
		
		if( $content_highlight_type ){
			
			switch( $content_highlight_type ){
				
				case 'background':
						$html .= OTW_Form::text_input( ( array( 'id' => 'otw-shortcode-element-content_highlight_opacity', 'label' => $this->get_label( 'Content Highlight Background Opacity' ), 'description' => $this->get_label( 'Content Highlight Background Opacity.' ), 'parse' => $source ) ) );
					break;
			}
			$html .= OTW_Form::color_picker( ( array( 'id' => 'otw-shortcode-element-content_highlight_color', 'label' => $this->get_label( 'Content Highlight Color' ), 'description' => $this->get_label( 'Title Highlight Color.' ), 'parse' => $source ) ) );
			$html .= OTW_Form::text_input( ( array( 'id' => 'otw-shortcode-element-content_highlight_padding', 'label' => $this->get_label( 'Content Highlight Padding' ), 'description' => $this->get_label( 'Content Highlight Padding.' ), 'parse' => $source ) ) );
		}
		
		$html .= OTW_Form::text_input( ( array( 'id' => 'otw-shortcode-element-content_padding_tb', 'label' => $this->get_label( 'Content Padding Top & Bottom' ), 'description' => $this->get_label( 'Content Paddding Top & Bottom.' ), 'parse' => $source ) ) );
		
		if( $call_to_action != 'none' ){
			
			$html .= '<div class="otw_separator"></div>';
			
			$html .= OTW_Form::color_picker( array('id' => 'otw-shortcode-element-action_text_custom_color', 'label' => $this->get_label('Call to Action Custom Text Color'), 'description' => $this->get_label( 'Call to Action Custom Text Color.' ), 'parse' => $source ) );
			switch( $call_to_action == 'otw-button' ){
				
				case 'otw-button':
						$html .= OTW_Form::color_picker( array('id' => 'otw-shortcode-element-action_button_custom_color', 'label' => $this->get_label('Call to Action Custom Button Background Color'), 'description' => $this->get_label( 'Call to Action Custom Button Background Color.' ), 'parse' => $source ) );
						$html .= OTW_Form::color_picker( array( 'id' => 'otw-shortcode-element-action_button_border_color', 'label' => $this->get_label( 'Button Border color' ), 'description' => $this->get_label( 'Custom color for the border.' ), 'parse' => $source )  );
					break;
			}
		}
		
		$html .= '<div class="otw_separator"></div>';
		
		$html .= OTW_Form::text_input( array('id' => 'otw-shortcode-element-css_class', 'label' => $this->get_label('CSS Class'), 'description' => $this->get_label('If you\'d like to style this element separately enter a name here. A CSS class with this name will be available for you to style this particular element..'), 'parse' => $source ) );
		
		return $html;
	}
	
	/**
	 *
	 *  @param array
	 *  @return string
	*/
	public function build_shortcode_code($attributes) {
		$code = '';
		
		if (!$this->has_error) {
			
			$code = '[otw_shortcode_welcome_text';
			
			$code .= $this->format_attribute('title', 'title', $attributes, false, '', true);
			$code .= $this->format_attribute('title_tag', 'title_tag', $attributes, false, '', true);
			$code .= $this->format_attribute('sub_title', 'sub_title', $attributes, false, '', true);
			$code .= $this->format_attribute('sub_title_tag', 'sub_title_tag', $attributes, false, '', true);
			$code .= $this->format_attribute('call_to_action', 'call_to_action', $attributes);
			$code .= $this->format_attribute('action_href', 'action_href', $attributes);
			$code .= $this->format_attribute('action_text', 'action_text', $attributes);
			$code .= $this->format_attribute('action_text_color', 'action_text_color', $attributes);
			$code .= $this->format_attribute('action_button_color', 'action_button_color', $attributes);
			$code .= $this->format_attribute('action_button_target', 'action_button_target', $attributes );
			$code .= $this->format_attribute('action_button_size', 'action_button_size', $attributes );
			$code .= $this->format_attribute('action_button_icon_type', 'action_button_icon_type', $attributes );
			$code .= $this->format_attribute('action_button_icon_position', 'action_button_icon_position', $attributes );
			$code .= $this->format_attribute('action_button_shape', 'action_button_shape', $attributes );
			
			$code .= $this->format_attribute('text_alignment', 'text_alignment', $attributes);
			$code .= $this->format_attribute('padding_lr', 'padding_lr', $attributes);
			
			$code .= $this->format_attribute('title_font_size', 'title_font_size', $attributes);
			$code .= $this->format_attribute('title_font_weight', 'title_font_weight', $attributes);
			$code .= $this->format_attribute('title_font_family', 'title_font_family', $attributes);
			$code .= $this->format_attribute('title_font_color', 'title_font_color', $attributes);
			$code .= $this->format_attribute('title_highlight_type', 'title_highlight_type', $attributes);
			$code .= $this->format_attribute('title_highlight_color', 'title_highlight_color', $attributes);
			$code .= $this->format_attribute('title_highlight_opacity', 'title_highlight_opacity', $attributes);
			$code .= $this->format_attribute('title_highlight_padding', 'title_highlight_padding', $attributes);
			$code .= $this->format_attribute('title_padding_tb', 'title_padding_tb', $attributes);
			
			$code .= $this->format_attribute('sub_title_font_size', 'sub_title_font_size', $attributes);
			$code .= $this->format_attribute('sub_title_font_weight', 'sub_title_font_weight', $attributes);
			$code .= $this->format_attribute('sub_title_font_family', 'sub_title_font_family', $attributes);
			$code .= $this->format_attribute('sub_title_font_color', 'sub_title_font_color', $attributes);
			$code .= $this->format_attribute('sub_title_highlight_type', 'sub_title_highlight_type', $attributes);
			$code .= $this->format_attribute('sub_title_highlight_color', 'sub_title_highlight_color', $attributes);
			$code .= $this->format_attribute('sub_title_highlight_opacity', 'sub_title_highlight_opacity', $attributes);
			$code .= $this->format_attribute('sub_title_highlight_padding', 'sub_title_highlight_padding', $attributes);
			$code .= $this->format_attribute('sub_title_padding_tb', 'sub_title_padding_tb', $attributes);
			
			$code .= $this->format_attribute('content_font_size', 'content_font_size', $attributes);
			$code .= $this->format_attribute('content_font_weight', 'content_font_weight', $attributes);
			$code .= $this->format_attribute('content_font_family', 'content_font_family', $attributes);
			$code .= $this->format_attribute('content_font_color', 'content_font_color', $attributes);
			$code .= $this->format_attribute('content_highlight_type', 'content_highlight_type', $attributes);
			$code .= $this->format_attribute('content_highlight_color', 'content_highlight_color', $attributes);
			$code .= $this->format_attribute('content_highlight_opacity', 'content_highlight_opacity', $attributes);
			$code .= $this->format_attribute('content_highlight_padding', 'content_highlight_padding', $attributes);
			$code .= $this->format_attribute('content_padding_tb', 'content_padding_tb', $attributes);
			
			$code .= $this->format_attribute('action_text_custom_color', 'action_text_custom_color', $attributes);
			$code .= $this->format_attribute('action_button_custom_color', 'action_button_custom_color', $attributes);
			$code .= $this->format_attribute('action_button_border_color', 'action_button_border_color', $attributes);
			$code .= $this->format_attribute('css_class', 'css_class', $attributes);
			
			$code .= ']';
			
			$code .= ( $attributes['content'] );
			
			$code .= '[/otw_shortcode_welcome_text]';
		}
		
		return $code;
	}
	
	/**
	 * Display shortcode
	 */
	public function display_shortcode($attributes, $content) {
		
		
		$html = '<div';
		
		/*class attributes*/
		$class = 'otw-wt';
		
		$class .= $this->format_attribute( '', 'css_class', $attributes, false, $class );
		$class .= $this->format_attribute( '', 'text_alignment', $attributes, false, $class );
		
		if( strlen( $class ) ){
			$html .= ' class="'.esc_attr( $class ).'"';
		}
		/*end class attributes*/
		
		$style = '';
		
		if( $value = $this->format_attribute('', 'padding_lr', $attributes, false, '') ){
			$style .= 'padding-left: '.$value.'px; padding-right: '.$value.'px;';
		}
		
		if( strlen( $style ) ){
			$html .= ' style="'.esc_attr( $style ).'"';
		}
		
		$html .= '>';
		
		if( $title = $this->format_attribute('', 'title', $attributes, false, '') ){
			
			$title_tag = $this->format_attribute('', 'title_tag', $attributes, false, '');
			
			if( !$title_tag ){
				$title_tag = $this->settings['default_title_size'];
			}
			
			$title_style = '';
			
			if( $value = $this->format_attribute('', 'title_font_size', $attributes, false, '') ){
				$title_style .= 'font-size: '.$value.';';
			}
			if( $value = $this->format_attribute('', 'title_font_weight', $attributes, false, '') ){
				
				switch( $value ){
					
					case 'regular':
							$title_style .= 'font-style: normal;';
							$title_style .= 'font-weight: normal;';
						break;
					case 'italic':
							$title_style .= 'font-style: italic;';
						break;
					case 'bold':
							$title_style .= 'font-weight: bold;';
						break;
					case 'bold_italic':
							$title_style .= 'font-style: italic;';
							$title_style .= 'font-weight: bold;';
						break;
				}
			}
			if( $value = $this->format_attribute('', 'title_font_family', $attributes, false, '') ){
				$title_style .= 'font-family: '.$value.';';
			}
			if( $value = $this->format_attribute('', 'title_font_color', $attributes, false, '') ){
				$title_style .= 'color: '.$value.';';
			}
			
			$title_highlight_class = '';
			$title_highlight_style = '';
			
			$title_highlight = $this->format_attribute( '', 'title_highlight_type', $attributes, false, $title_highlight_class );
			
			if( $title_highlight ){
				
				switch( $title_highlight ){
					case 'border':
							$title_highlight_class .= 'otw-sc-highlight with-border';
							
							if( $value = $this->format_attribute('', 'title_highlight_color', $attributes, false, '') ){
								$title_highlight_style .= 'border-color: '.$value.';';
							}
						break;
					case 'background':
							$title_highlight_class .= 'otw-sc-highlight';
							if( $opacity = $this->format_attribute('', 'title_highlight_opacity', $attributes, false, '') ){
								
								if( $color_value = $this->format_attribute('', 'title_highlight_color', $attributes, false, '') ){
									
									$bgcolors = $this->html2rgb( $color_value );
									
									if( count( $bgcolors ) == 3 ){
										$title_highlight_style .= 'background-color: rgba('.$bgcolors[0].','.$bgcolors[1].', '.$bgcolors[2].', '.$opacity.');';
									}
								}
							}elseif( $value = $this->format_attribute('', 'title_highlight_color', $attributes, false, '') ){
								$title_highlight_style .= 'background-color: '.$value.';';
							}
						break;
				}
				
				if( $value = $this->format_attribute('', 'title_highlight_padding', $attributes, false, '') ){
					$title_highlight_style .= 'padding: '.$value.'px;';
				}
			}
			if( $value = $this->format_attribute('', 'title_padding_tb', $attributes, false, '') ){
				$title_style .= 'padding-top: '.$value.'px; padding-bottom: '.$value.'px;';
			}
			
			if( strlen( trim( $title_style ) ) ){
				$title_style = ' style="'.esc_attr( $title_style ).'"';
			}
			
			if( strlen( trim( $title_highlight_class ) ) ){
				$title_highlight_class = ' class="'.esc_attr( $title_highlight_class ).'"';
			}
			
			if( strlen( trim( $title_highlight_style ) ) ){
				$title_highlight_style = ' style="'.esc_attr( $title_highlight_style ).'"';
			}
			
			$html .= '<'.$title_tag.''.$title_style.'>';
			
			if( $title_highlight ){
				$html .= '<span'.$title_highlight_class.''.$title_highlight_style.'>';
			}
			
			$html .= otw_htmlentities_decode( $title );
			
			if( $title_highlight ){
				$html .= '</span>';
			}
			
			$html .= '</'.$title_tag.'>';
		}
		
		//sub title
		if( $sub_title = $this->format_attribute('', 'sub_title', $attributes, false, '') ){
			
			$sub_title_tag = $this->format_attribute('', 'sub_title_tag', $attributes, false, '');
			
			if( !$sub_title_tag ){
				$sub_title_tag = $this->settings['default_title_size'];
			}
			
			$sub_title_style = '';
			
			if( $value = $this->format_attribute('', 'sub_title_font_size', $attributes, false, '') ){
				$sub_title_style .= 'font-size: '.$value.';';
			}
			if( $value = $this->format_attribute('', 'sub_title_font_weight', $attributes, false, '') ){
				
				switch( $value ){
					
					case 'regular':
							$sub_title_style .= 'font-style: normal;';
							$sub_title_style .= 'font-weight: normal;';
						break;
					case 'italic':
							$sub_title_style .= 'font-style: italic;';
						break;
					case 'bold':
							$sub_title_style .= 'font-weight: bold;';
						break;
					case 'bold_italic':
							$sub_title_style .= 'font-style: italic;';
							$sub_title_style .= 'font-weight: bold;';
						break;
				}
			}
			if( $value = $this->format_attribute('', 'sub_title_font_family', $attributes, false, '') ){
				$sub_title_style .= 'font-family: '.$value.';';
			}
			if( $value = $this->format_attribute('', 'sub_title_font_color', $attributes, false, '') ){
				$sub_title_style .= 'color: '.$value.';';
			}
			
			$sub_title_highlight_class = '';
			$sub_title_highlight_style = '';
			
			$sub_title_highlight = $this->format_attribute( '', 'sub_title_highlight_type', $attributes, false, $sub_title_highlight_class );
			
			if( $sub_title_highlight ){
				
				switch( $sub_title_highlight ){
					case 'border':
							$sub_title_highlight_class .= 'otw-sc-highlight with-border';
							
							if( $value = $this->format_attribute('', 'sub_title_highlight_color', $attributes, false, '') ){
								$sub_title_highlight_style .= 'border-color: '.$value.';';
							}
						break;
					case 'background':
							$sub_title_highlight_class .= 'otw-sc-highlight';
							if( $opacity = $this->format_attribute('', 'sub_title_highlight_opacity', $attributes, false, '') ){
								
								if( $color_value = $this->format_attribute('', 'sub_title_highlight_color', $attributes, false, '') ){
									
									$bgcolors = $this->html2rgb( $color_value );
									
									if( count( $bgcolors ) == 3 ){
										$sub_title_highlight_style .= 'background-color: rgba('.$bgcolors[0].','.$bgcolors[1].', '.$bgcolors[2].', '.$opacity.');';
									}
								}
							}elseif( $value = $this->format_attribute('', 'sub_title_highlight_color', $attributes, false, '') ){
								$sub_title_highlight_style .= 'background-color: '.$value.';';
							}
						break;
				}
				
				if( $value = $this->format_attribute('', 'sub_title_highlight_padding', $attributes, false, '') ){
					$sub_title_highlight_style .= 'padding: '.$value.'px;';
				}
			}
			
			if( $value = $this->format_attribute('', 'sub_title_padding_tb', $attributes, false, '') ){
				$sub_title_style .= 'padding-top: '.$value.'px; padding-bottom: '.$value.'px;';
			}
			
			if( strlen( trim( $sub_title_style ) ) ){
				$sub_title_style = ' style="'.esc_attr( $sub_title_style ).'"';
			}
			
			if( strlen( trim( $sub_title_highlight_class ) ) ){
				$sub_title_highlight_class = ' class="'.esc_attr( $sub_title_highlight_class ).'"';
			}
			
			if( strlen( trim( $sub_title_highlight_style ) ) ){
				$sub_title_highlight_style = ' style="'.esc_attr( $sub_title_highlight_style ).'"';
			}
			
			$html .= '<'.$sub_title_tag.''.$sub_title_style.'>';
			
			if( $sub_title_highlight ){
				$html .= '<span'.$sub_title_highlight_class.''.$sub_title_highlight_style.'>';
			}
			
			$html .= otw_htmlentities_decode( $sub_title );
			
			if( $sub_title_highlight ){
				$html .= '</span>';
			}
			
			$html .= '</'.$sub_title_tag.'>';
		}
		
		//content
		if( strlen( trim( $content ) ) ){
			$content_style = '';
			
			if( $value = $this->format_attribute('', 'content_font_size', $attributes, false, '') ){
				$content_style .= 'font-size: '.$value.';';
			}
			if( $value = $this->format_attribute('', 'content_font_weight', $attributes, false, '') ){
				
				switch( $value ){
					
					case 'regular':
							$content_style .= 'font-style: normal;';
							$content_style .= 'font-weight: normal;';
						break;
					case 'italic':
							$content_style .= 'font-style: italic;';
						break;
					case 'bold':
							$content_style .= 'font-weight: bold;';
						break;
					case 'bold_italic':
							$content_style .= 'font-style: italic;';
							$content_style .= 'font-weight: bold;';
						break;
				}
			}
			if( $value = $this->format_attribute('', 'content_font_family', $attributes, false, '') ){
				$content_style .= 'font-family: '.$value.';';
			}
			if( $value = $this->format_attribute('', 'content_font_color', $attributes, false, '') ){
				$content_style .= 'color: '.$value.';';
			}
			
			$content_highlight_class = '';
			$content_highlight_style = '';
			
			$content_highlight = $this->format_attribute( '', 'content_highlight_type', $attributes, false, $content_highlight_class );
			
			if( $content_highlight ){
				
				switch( $content_highlight ){
					case 'border':
							$content_highlight_class .= 'otw-sc-highlight with-border';
							
							if( $value = $this->format_attribute('', 'content_highlight_color', $attributes, false, '') ){
								$content_highlight_style .= 'border-color: '.$value.';';
							}
						break;
					case 'background':
							$content_highlight_class .= 'otw-sc-highlight';
							if( $opacity = $this->format_attribute('', 'content_highlight_opacity', $attributes, false, '') ){
								
								if( $color_value = $this->format_attribute('', 'content_highlight_color', $attributes, false, '') ){
									
									$bgcolors = $this->html2rgb( $color_value );
									
									if( count( $bgcolors ) == 3 ){
										$content_highlight_style .= 'background-color: rgba('.$bgcolors[0].','.$bgcolors[1].', '.$bgcolors[2].', '.$opacity.');';
									}
								}
							}elseif( $value = $this->format_attribute('', 'content_highlight_color', $attributes, false, '') ){
								$content_highlight_style .= 'background-color: '.$value.';';
							}
						break;
				}
				
				if( $value = $this->format_attribute('', 'content_highlight_padding', $attributes, false, '') ){
					$content_highlight_style .= 'padding: '.$value.'px;';
				}
			}
			if( $value = $this->format_attribute('', 'content_padding_tb', $attributes, false, '') ){
				$content_style .= 'padding-top: '.$value.'px; padding-bottom: '.$value.'px;';
			}
			
			if( strlen( trim( $content_highlight_class ) ) ){
				$content_highlight_class = ' class="'.esc_attr( $content_highlight_class ).'"';
			}
			
			if( strlen( trim( $content_highlight_style ) ) ){
				$content_highlight_style = ' style="'.esc_attr( $content_highlight_style ).'"';
			}
			
			if( strlen( trim( $content_style ) ) ){
				$content_style = ' style="'.esc_attr( $content_style ).'"';
			}
			$html .= '<p'.$content_style.'>';
			
			if( $content_highlight ){
				$html .= '<span'.$content_highlight_class.''.$content_highlight_style.'>';
			}
			
			$html .= nl2br($content);
			
			if( $content_highlight ){
				$html .= '</span>';
			}
			
			$html .= '</p>';
		}
		
		$call_to_action = $this->format_attribute('', 'call_to_action', $attributes);
		if( $call_to_action != 'none' ){
			
			$action_class = trim( $call_to_action );
			
			$action_class .= $this->format_attribute( '', 'action_text_color', $attributes, false, $action_class );
			
			if( trim( $call_to_action ) == 'otw-button' ){
				
				$action_class .= $this->format_attribute( '', 'action_button_color', $attributes, false, $action_class );
				$action_class .= $this->format_attribute( '', 'action_button_size', $attributes, false, $action_class );
				$action_class .= $this->format_attribute( '', 'action_button_shape', $attributes, false, $action_class );
				
				if( $icon_position = $this->format_attribute( '', 'action_button_icon_position', $attributes, false, '' ) ){
					if( $icon_position == 'right' ){
						$action_class = $this->append_attribute( $action_class, 'right-icon' );
					}
				}
			}
			
			$action_style = '';
			
			if( $value = $this->format_attribute('', 'action_text_custom_color', $attributes, false, '') ){
				$action_style .= 'color: '.$value.' !important;';
			}
			if( trim( $call_to_action ) == 'otw-button' ){
				
				if( $value = $this->format_attribute('', 'action_button_custom_color', $attributes, false, '') ){
					$action_style .= 'background-color: '.$value.' !important;';
				}
				
				if( $border_color = $this->format_attribute( '', 'action_button_border_color', $attributes, false, '' ) ){
					$action_style = $this->append_attribute( $action_style, 'border-color: '.$border_color.';' );
				}
				
			}
			
			$html .= '<a';
			
			if( trim( $call_to_action ) == 'otw-button' ){
				
				if( $value = $this->format_attribute('', 'action_button_target', $attributes, false, '') ){
					$html .= ' target="'.esc_attr( $value ).'"';
				}
			}
			
			if( strlen( trim( $action_class ) ) ){
				$html .= ' class="'.esc_attr( $action_class ).'"';
			}
			
			if( strlen( trim( $action_style ) ) ){
				$html .= ' style="'.esc_attr( $action_style ).'"';
			}
			
			if( $value = $this->format_attribute('', 'action_href', $attributes) ){
				$html .= ' href="'.esc_attr( $value ).'"';
			}
			
			$html .= '>';
			
			if( trim( $call_to_action ) == 'otw-button' ){
				if( $icon_type = $this->format_attribute( '', 'action_button_icon_type', $attributes, false, '' ) ){
					$html .= '<i class="'.esc_attr( $icon_type ).'"></i>';
				}
			}
			
			$html .= $this->format_attribute('', 'action_text', $attributes, false, '');
			$html .= '</a>';
		}
		
		$html .= '</div>';
		
		return $this->format_shortcode_output($html);
	}
	
	private function html2rgb( $color ){
		
		$color = preg_replace( "/^\#/", '', $color );
		
		if( strlen( $color ) == 6 ){
			list( $r, $g, $b ) = array( 
				$color[0].$color[1],
				$color[2].$color[3],
				$color[4].$color[5]
			);
		}else{
			return array( 0, 0, 0);
		}
		$r = hexdec( $r );
		$g = hexdec( $g );
		$b = hexdec( $b );
		
		return array( $r, $g, $b );
	}
}
