<?php get_header()?>
	<div class="otw-row">
		<section class="otw-twentyfour otw-columns">
			<!-- Single Project -->
			<div class="otw_portfolio_manager-portfolio-full otw_portfolio_manager-single-project">
				<?php if( $otw_pm_posts['otw_pm_item_title'] == 'yes' ){?>
				<?php echo $this->getTitle( $otw_pm_posts['post'] );?>
				<?php }?>

				<div class="pm_clear otw_portfolio_manager-mb15"></div>
					<?php if( !post_password_required() ){?>
					<?php echo $this->getItemMedia( $otw_pm_posts ) ?>
					<?php }?>
				<div class="pm_clear"></div>

				<div class="otw-row">
					<!-- Project Description -->
					<?php if( post_password_required() ){?>
					<div class="otw-eight otw-columns">
					</div>
					<div class="otw-sixteen otw-columns">
						<?php echo get_the_password_form();?>
					</div>
					<?php }else{?>
					<div class="otw-eight otw-columns">
						<h3 class="otw_portfolio_manager-mb25">
							<?php if( !empty( $otw_pm_posts['otw_pm_plugin_options']['otw_pm_description_title_text'] ) ){?>
								<?php echo $otw_pm_posts['otw_pm_plugin_options']['otw_pm_description_title_text']?>
							<?php }else{ ?>
								<?php esc_html_e( 'Project Description', 'otw-portfolio-manager' )?>
							<?php }?>
						</h3>
						<div class="otw_portfolio_manager-portfolio-content">
							<p><?php echo $this->getPostContent( $otw_pm_posts['post'] );?></p>
						</div>
						<div class="pm_clear otw_portfolio_manager-mb25"></div>
						<h3 class="otw_portfolio_manager-mb25">
						<?php if( !empty( $otw_pm_posts['otw_pm_plugin_options']['otw_pm_details_title_text'] ) ){?>
								<?php echo $otw_pm_posts['otw_pm_plugin_options']['otw_pm_details_title_text']?>
							<?php }else{ ?>
								<?php esc_html_e( 'Project Details', 'otw-portfolio-manager' )?>
							<?php }?>
						</h3>
						<div class="otw_portfolio_manager-project-info">
							<?php if( is_array( $otw_pm_posts['categories'] ) && count( $otw_pm_posts['categories'] ) ){?>
								<div class="otw_portfolio_manager-project-info-box">
									<h4><?php esc_html_e( 'Categories', 'otw-portfolio-manager' )?>:</h4>
									<div class="otw_portfolio_manager-project-info-box-content">
										<?php $total_items = count( $otw_pm_posts['categories'] ) - 1;?>
										<?php foreach( $otw_pm_posts['categories'] as $item_num => $cat ){?>
											<?php
												$category = get_term($cat, $this->portfolio_category);
												$catUrl = get_term_link( $category, $this->portfolio_category );
											?>
											<a href="<?= $catUrl?>" rel="tag"><?= $category->name?></a><?php if( $item_num < $total_items ){echo ', ';}?>
										<?php }?>
									</div>
								</div>
							<?php }?>
							<?php if( is_array( $otw_pm_posts['tags'] ) && count( $otw_pm_posts['tags'] ) ){?>
								<div class="otw_portfolio_manager-project-info-box">
									<h4><?php esc_html_e( 'Tags', 'otw-portfolio-manager' )?>:</h4>
									<div class="otw_portfolio_manager-project-info-box-content">
										<?php $total_items = count( $otw_pm_posts['tags'] ) - 1;?>
										<?php foreach( $otw_pm_posts['tags'] as $item_num => $tag ){?>
											<?php
												$tagUrl = get_term_link( $tag, $this->portfolio_tag );
											?>
											<a href="<?= $tagUrl?>" rel="tag"><?= $tag->name?></a><?php if( $item_num < $total_items ){echo ', ';}?>
										<?php }?>
									</div>
								</div>
							<?php }?>
							<?php foreach( $otw_pm_posts['otw_details'] as $detail_id => $detail ){?>
								<?php if( !empty( $otw_pm_posts['otw_details_value'][ 'otw_pm_portfolio_detail_'.$detail_id ] ) ){?>
									<div class="otw_portfolio_manager-project-info-box">
										<h4><?php echo esc_html( $detail['title'] );?></h4>
										<div class="otw_portfolio_manager-project-info-box-content">
											<?php echo $otw_pm_posts['otw_details_value'][ 'otw_pm_portfolio_detail_'.$detail_id ];?>
										</div>
									</div>
								<?php }?>
							<?php }?>
						</div>
					</div>

					<!-- More Project Info -->
					<div class="otw-sixteen otw-columns">
						<h3 class="otw_portfolio_manager-mb25">
							<?php if( !empty( $otw_pm_posts['otw_pm_plugin_options']['otw_pm_moreinfo_title_text'] ) ){?>
								<?php echo $otw_pm_posts['otw_pm_plugin_options']['otw_pm_moreinfo_title_text']?>
							<?php }else{ ?>
								<?php esc_html_e( 'More Project Info', 'otw-portfolio-manager' )?>
							<?php }?>
						</h3>
						<!-- Tabs -->
						<div class="otw_portfolio_manager-tabs">
						<?php if( isset( $otw_pm_posts['tabs'] ) && is_array( $otw_pm_posts['tabs'] ) && count( $otw_pm_posts['tabs'] ) ){?>
							<ul>
								<?php foreach( $otw_pm_posts['tabs'] as $tab_key => $tab_data ){?>
									<li><a href="#tabs-<?php echo $tab_key?>"><?php echo esc_html( $tab_data['title'] )?></a></li>
								<?php }?>
							</ul>
							<?php foreach( $otw_pm_posts['tabs'] as $tab_key => $tab_data ){?>
								<div id="tabs-<?php echo $tab_key?>">
									<p><?php echo nl2br( do_shortcode( $tab_data['content'] ) )?></p>
								</div>
							<?php }?>
						</div>
						<?php }?>
						<!-- End Tabs -->
					</div>
					<!-- End More Project Info -->
					<?php }?>
				</div>

				<div class="pm_clear"></div>
				<?php echo $this->getSocial( $otw_pm_posts['post'], 'single' ); ?>
				<?php echo $this->getPortfolioPagination( $otw_pm_posts ); ?>
				<?php echo $this->getPortfolioRelatedPosts( $otw_pm_posts ); ?>
			</div>
			<!-- End Single Project -->
		</section>
	</div>
<?php get_footer()?>