<?php
	global $otw_pm_validate_messages;
	
	$message = '';
	$massages = array();
	$messages[1] = esc_html__( 'Single Posts Template saved.', 'otw-portfolio-manager' );
	$messages[2] = esc_html__( 'Single Posts Template deleted.', 'otw-portfolio-manager' );
	$messages[5] = esc_html__( 'Single Posts Template copied.', 'otw-portfolio-manager' );
	
	if( otw_get('message',false) && isset( $messages[ otw_get('message','') ] ) ){
		$message .= $messages[ otw_get('message','') ];
	}
	
?>
<?php if ( $message ) : ?>
<div id="message" class="updated"><p><?php echo esc_html( $message ); ?></p></div>
<?php
 endif; ?>
<div class="wrap">
	<div id="icon-options-general" class="icon32"></div>
	<h2><?php echo esc_html( $page_title ) ?>
		<a class="button add-new-h2" href="admin.php?page=otw-pm-custom-templates"><?php esc_html_e('Back to custom templates list', 'otw-portfolio-manager') ?></a>
	</h2>
	<?php if( isset( $otw_pm_validate_messages ) && count( $otw_pm_validate_messages ) ){?>
		<div id="message" class="error">
			<?php foreach( $otw_pm_validate_messages as $v_message ){
				echo '<p>'.esc_html( $v_message ).'</p>';
			}?>
		</div>
	<?php }?>
	<div class="form-wrap" id="poststuff">
		<form method="post" action="" class="validate">
			<input type="hidden" name="otw_pm_action" value="manage_otw_pm_custom_templates" />
			<div id="post-body">
				<div class="form-field form-required">
					<label for="pm_custom_template_title"><?php esc_html_e( 'Single Posts Template title', 'otw-portfolio-manager' );?></label>
					<input type="text" id="pm_custom_template_title" value="<?php echo esc_attr( $otw_pm_custom_template_values['title'] )?>" tabindex="1" size="30" name="pm_custom_template_title"/>
					<p><?php esc_html_e( 'The name is how it appears on your site.', 'otw-portfolio-manager' );?></p>
				</div>
				<div class="form-field form-required">
					<label for="pm_custom_template_maxwidth"><?php esc_html_e( 'Set max-width', 'otw-portfolio-manager' );?></label>
					<input type="text" id="pm_custom_template_maxwidth" value="<?php echo esc_attr( $otw_pm_custom_template_values['maxwidth'] )?>" tabindex="1" size="4" maxlength="6" name="pm_custom_template_maxwidth" style="width: 100px;"/>
					<p><?php esc_html_e( 'Use this if your single post template is not taking the site width.', 'otw-portfolio-manager' );?></p>
				</div>
				<div id="<?php echo esc_attr( $otw_pm_grid_manager_object->meta_name );?>">
					<div class="meta-box-sortables">
						<div class="postbox">
							<h3 class="hndle sitem_header"><span><?php esc_html_e( 'OTW Grid Manager', 'otw-portfolio-manager' )?></span></h3>
							<div class="inside">
								<?php echo $otw_pm_grid_manager_object->build_custom_box( $otw_pm_custom_template_values['grid_content'] );?>
							</div>
						</div>
					</div>
				</div>
				<p class="submit">
					<input type="submit" value="<?php esc_html_e( 'Save Single Posts Template', 'otw-portfolio-manager') ?>" name="submit" class="button button-primary button-hero"/>
				</p>
			</div>
		</form>
	</div>
</div>