<?php
	$_wp_column_headers['toplevel_page_otw-pm'] = array(
	'title' => esc_html__( 'Title', 'otw-portfolio-manager' ),
	'order' => esc_html__( 'Order', 'otw-portfolio-manager' )
);
	
	$message = '';
	$massages = array();
	$messages[1] = esc_html__( 'Detail saved.', 'otw-portfolio-manager' );
	$messages[2] = esc_html__( 'Detail deleted.', 'otw-portfolio-manager' );
	
	if( otw_get('message',false) && isset( $messages[ otw_get('message','') ] ) ){
		$message .= $messages[ otw_get('message','') ];
	}
	
?>
<?php if ( $message ) : ?>
<div id="message" class="updated"><p><?php echo esc_html( $message ); ?></p></div>
<?php
 endif; ?>
<div class="wrap">
	<div id="icon-options-general" class="icon32"></div>
	<h2><?php esc_html_e('Portfolio Items Details', 'otw-portfolio-manager'); ?>
		<a class="button add-new-h2" href="admin.php?page=otw-pm-details-add"><?php esc_html_e('Add New', 'otw-portfolio-manager') ?></a>
	</h2>
	<div id="icon-options-general" class="icon32"></div>
	<p class="description"><?php esc_html_e('The following details will be available for each of your portfolio items.', 'otw-portfolio-manager'); ?></p>
	<?php if( is_array( $details ) && count( $details ) ){?>
		<table class="widefat fixed" cellspacing="0">
			<thead>
				<tr>
					<?php foreach( $_wp_column_headers['toplevel_page_otw-pm'] as $key => $name ){?>
						<th><?php echo esc_html( $name )?></th>
					<?php }?>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<?php foreach( $_wp_column_headers['toplevel_page_otw-pm'] as $key => $name ){?>
						<th><?php echo esc_html( $name )?></th>
					<?php }?>
				</tr>
			</tfoot>
			<tbody>
				<?php foreach( $details as $d_key => $d_item ){?>
					<tr>
						<?php foreach( $_wp_column_headers['toplevel_page_otw-pm'] as $column_name => $column_title ){
							
							$edit_link = admin_url( 'admin.php?page=otw-pm-details-edit&amp;detail='.$d_item['id'] );
							$delete_link = admin_url( 'admin.php?page=otw-pm-details-action&amp;detail='.$d_item['id'].'&amp;action=delete' );
							
							switch($column_name) {
								
								case 'title':
										echo '<td><strong><a href="'.esc_attr( $edit_link ).'" title="'.esc_attr(sprintf(__('Edit &#8220;%s&#8221;', 'otw-portfolio-manager'), $d_item['title'])).'">'.$d_item['title'].'</a></strong><br />';
										echo '<div class="row-actions">';
											echo '<a href="'.esc_attr( $edit_link ).'">' . esc_html__('Edit', 'otw-portfolio-manager') . '</a>';
											echo ' | <a href="'.esc_attr( $delete_link ).'">' . esc_html__('Delete', 'otw-portfolio-manager'). '</a>';
											echo '</div>';
										echo '</td>';
									break;
								case 'order':
										echo '<td>'.$d_item['order'].'</td>';
									break;
							}?>
						<?php }?>
					</tr>
				<?php }?>
			</tbody>
		</table>
	<?php }else{?>
		<p><?php esc_html_e('No details available.', 'otw-portfolio-manager')?></p>
	<?php }?>
</div>