<?php
	$_wp_column_headers['toplevel_page_otw-pm'] = array(
	'title' => esc_html__( 'Title', 'otw-portfolio-manager' ),
	'order' => esc_html__( 'Order', 'otw-portfolio-manager' )
);
	
	$otw_pm_plugin_options = get_option( 'otw_pm_plugin_options' );
	
	$otw_pm_plugin_options['otw_pm_promotions'] = get_option( $otw_pm_plugin_id.'_dnms' );
	
	if( empty( $otw_pm_plugin_options['otw_pm_promotions'] ) ){
		$otw_pm_plugin_options['otw_pm_promotions'] = 'on';
	}
	
	$otw_pm_plugin_options = $this->init_portfolio_item_values( $otw_pm_plugin_options );
	
	$otw_details = get_option( 'otw_pm_portfolio_details' );
	
	$message = '';
	$massages = array();
	$messages[1] = esc_html__( 'Detail saved.', 'otw-portfolio-manager' );
	$messages[2] = esc_html__( 'Detail deleted.', 'otw-portfolio-manager' );
	$messages[3] = esc_html__( 'OTW Portfolio Light plugin items imported successfully.', 'otw-portfolio-manager' );
	
	if( otw_get('message',false) && isset( $messages[ otw_get('message','') ] ) ){
		$message .= $messages[ otw_get('message','') ];
	}
	
	$otw_pm_templates = array( 'default' => esc_html__( 'Default Theme\'s Post Template', 'otw-portfolio-manager' ) ) + $this->otwDispatcher->portfolio_templates;
	
	$otw_pm_social_icons = array(
		'' => esc_html__( 'None (default)', 'otw-portfolio-manager' ),
		'share_icons' => esc_html__( 'Share Icons', 'otw-portfolio-manager' ),
		'share_btn_small' => esc_html__( 'Share Buttons Small', 'otw-portfolio-manager' ),
		'share_btn_large' => esc_html__( 'Share Buttons Large', 'otw-portfolio-manager' ),
		'like_buttons' => esc_html__( 'Like Buttons', 'otw-portfolio-manager' )
	);
	
	$otw_pm_prev_next_nav_options = array(
		'' => esc_html__( 'No (default)', 'otw-portfolio-manager' ),
		'yes' => esc_html__( 'Yes', 'otw-portfolio-manager' )
	);
	
	$otw_pm_item_title_options = array(
		'yes' => esc_html__( 'Yes (default)', 'otw-portfolio-manager' ),
		'no' => esc_html__( 'No', 'otw-portfolio-manager' )
	);
	
	$otw_pm_related_posts_options = array(
		'' => esc_html__( 'No (default)', 'otw-portfolio-manager' ),
		'yes' => esc_html__( 'Yes', 'otw-portfolio-manager' )
	);
	
	$otw_pm_related_posts_criteria_options = array(
		$this->portfolio_category => esc_html__( 'Category (default)', 'otw-portfolio-manager' ),
		$this->portfolio_tag => esc_html__( 'Tag', 'otw-portfolio-manager' )
	);
	
	$otw_pm_item_media_format_options = array(
		'' => esc_html__('Keep original file format (default)', 'otw-portfolio-manager' ),
		'jpg' => 'jpg',
		'png' => 'png',
		'gif' => 'gif'
	);
	
	if( is_array( $otw_details ) && count( $otw_details ) ){
		
		foreach( $otw_details as $otw_detail ){
			$otw_pm_related_posts_criteria_options[ 'otw_pm_portfolio_detail_'.$otw_detail['id'] ] = $otw_detail['title'];
		}
	}
	
	$otw_pm_media_lightbox_options = array(
		'yes' => esc_html__( 'Yes (default)', 'otw-portfolio-manager' ),
		'no' => esc_html__( 'No', 'otw-portfolio-manager' )
	);
	
	$otw_pm_grid_pages_options = array(
		'yes' => esc_html__( 'Yes (default)', 'otw-portfolio-manager' ),
		'no' => esc_html__( 'No', 'otw-portfolio-manager' )
	);
?>
<?php if ( $message ) : ?>
<div id="message" class="updated"><p><?php echo esc_html( $message ); ?></p></div>
<?php
 endif; ?>
<div class="wrap">
	<div id="icon-options-general" class="icon32"></div>
	<h2><?php esc_html_e('Portfolio Options', 'otw-portfolio-manager'); ?></h2>
  <?php
    if( $writableCssError ) {
      $message = esc_html__('The file \''.SKIN_PM_PATH.'custom.css\' is not writable. Please make sure you add read/write permissions to this file.', 'otw-portfolio-manager');
      echo '<div class="error"><p>'.$message.'</p></div>';
    }

  ?>
	<?php
		if( !empty( otw_get( 'success_css', '' ) ) && otw_get( 'success_css', '' ) == 'true' ) {
			$message = esc_html__('Options page has been saved.', 'otw-portfolio-manager');
			echo '<div class="updated"><p>'.$message.'</p></div>';
			flush_rewrite_rules();
		}
	?>
	<div id="icon-options-general" class="icon32"></div>
	
	<form name="otw-pm-list-style" method="post" action="" class="validate">
		<br />
		<h3><?php esc_html_e('OTW Promotions', OTW_PM_TRANSLATION); ?></h3>
		<div class="otw_pm_sp_settings">
			<table class="form-table">
				<tr>
					<th>
						<label for="otw_pm_promotions"><?php esc_html_e('Show OTW Promotion Messages in my WordPress admin', OTW_PM_TRANSLATION); ?></label>
						<select id="otw_pm_promotions" name="otw_pm_promotions">
							<option value="on" <?php echo ( isset( $otw_pm_plugin_options['otw_pm_promotions'] ) && ( $otw_pm_plugin_options['otw_pm_promotions'] == 'on' ) )? 'selected="selected"':''?>>on(default)</option>
							<option value="off"<?php echo ( isset( $otw_pm_plugin_options['otw_pm_promotions'] ) && ( $otw_pm_plugin_options['otw_pm_promotions'] == 'off' ) )? 'selected="selected"':''?>>off</option>
						</select>
					</th>
				</tr>
			</table>
		</div>
		<p class="submit">
			<input type="hidden" name="otw_pm_save_settings" value="1" />
			<input type="submit" value="<?php esc_html_e( 'Save', OTW_PM_TRANSLATION) ?>" name="submit" class="button button-primary button-hero"/>
		</p>
		<h3><?php esc_html_e('Portfolio items single page', 'otw-portfolio-manager'); ?></h3>
		<div class="otw_pm_sp_settings">
			<table class="form-table">
				<tr>
					<th scope="row"><label for="otw_pm_template"><?php esc_html_e('Template', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<select id="otw_pm_template" name="otw_pm_template">
						<?php foreach( $otw_pm_templates as $template_key => $template_name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pm_plugin_options['otw_pm_template'] ) && ( $otw_pm_plugin_options['otw_pm_template'] == $template_key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<?php if( $template_key == '-' ){ ?>
								<option disabled="disabled">------------------------------------------</option>
							<?php }else{ ?>
								<option value="<?php echo esc_attr( $template_key ) ?>"<?php echo $selected?>><?php echo esc_html( $template_name )?></option>
							<?php } ?>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'This is the template for your single portfolio page.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_item_title"><?php esc_html_e('Show Post Title', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<select id="otw_pm_item_title" name="otw_pm_item_title">
						<?php foreach( $otw_pm_item_title_options as $key => $name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pm_plugin_options['otw_pm_item_title'] ) && ( $otw_pm_plugin_options['otw_pm_item_title'] == $key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $key )?>"<?php echo $selected?>><?php echo esc_html( $name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'This will show the post title.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_social_icons"><?php esc_html_e('Social Icons', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<select id="otw_pm_social_icons" name="otw_pm_social_icons">
						<?php foreach( $otw_pm_social_icons as $icon_key => $icon_name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pm_plugin_options['otw_pm_social_icons'] ) && ( $otw_pm_plugin_options['otw_pm_social_icons'] == $icon_key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $icon_key )?>"<?php echo $selected?>><?php echo esc_html( $icon_name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'Show Social Icons for Portfolio items single page.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_prev_next_nav"><?php esc_html_e('Enable Previous / Next Post Navigation', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<select id="otw_pm_prev_next_nav" name="otw_pm_prev_next_nav">
						<?php foreach( $otw_pm_prev_next_nav_options as $key => $name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pm_plugin_options['otw_pm_prev_next_nav'] ) && ( $otw_pm_plugin_options['otw_pm_prev_next_nav'] == $key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $key )?>"<?php echo $selected?>><?php echo esc_html( $name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'Enable Previous / Next Post Navigation for Portfolio items single page.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_related_posts"><?php esc_html_e('Enable Related Posts', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<select id="otw_pm_related_posts" name="otw_pm_related_posts">
						<?php foreach( $otw_pm_related_posts_options as $key => $name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pm_plugin_options['otw_pm_related_posts'] ) && ( $otw_pm_plugin_options['otw_pm_related_posts'] == $key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $key )?>"<?php echo $selected?>><?php echo esc_html( $name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'Enable Related Posts for Portfolio items single page. Related Posts selection is based on Portfolio category.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_related_posts_criteria"><?php esc_html_e('Related Post Criteria', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<select id="otw_pm_related_posts_criteria" name="otw_pm_related_posts_criteria">
						<?php foreach( $otw_pm_related_posts_criteria_options as $key => $name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pm_plugin_options['otw_pm_related_posts_criteria'] ) && ( $otw_pm_plugin_options['otw_pm_related_posts_criteria'] == $key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $key )?>"<?php echo $selected?>><?php echo esc_html( $name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'Select the Related Post Criteria.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_related_posts_number"><?php esc_html_e('Related Posts Count per Slide', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<input type="text" name="otw_pm_related_posts_number" id="otw_pm_related_posts_number" value="<?php echo esc_attr( $otw_pm_plugin_options['otw_pm_related_posts_number'] )?>" />
						<p class="description"><?php esc_html_e( 'This is how many related posts will be visible per slide of the carousel. Default is 4.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_description_title_text"><?php esc_html_e('Project Description Title Text', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<input type="text" name="otw_pm_description_title_text" id="otw_pm_description_title_text" value="<?php echo otw_htmlentities( $otw_pm_plugin_options['otw_pm_description_title_text'] )?>" />
						<p class="description"><?php esc_html_e( 'Enter custom Project Description Title Text. If empty "Project Description" will be used.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_details_title_text"><?php esc_html_e('Project details Title Text', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<input type="text" name="otw_pm_details_title_text" id="otw_pm_details_title_text" value="<?php echo otw_htmlentities( $otw_pm_plugin_options['otw_pm_details_title_text'] )?>" />
						<p class="description"><?php esc_html_e( 'Enter custom Project Details Title Text. If empty "Project Details" will be used.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_social_title_text"><?php esc_html_e('Social Icons Title Text', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<input type="text" name="otw_pm_social_title_text" id="otw_pm_social_title_text" value="<?php echo otw_htmlentities( $otw_pm_plugin_options['otw_pm_social_title_text'] )?>" />
						<p class="description"><?php esc_html_e( 'Enter custom Project Social Icons Title Text. If empty "Hey, like this? Why not share it with a buddy?" will be used.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_moreinfo_title_text"><?php esc_html_e('More Project Info Title Text', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<input type="text" name="otw_pm_moreinfo_title_text" id="otw_pm_moreinfo_title_text" value="<?php echo otw_htmlentities( $otw_pm_plugin_options['otw_pm_moreinfo_title_text'] )?>" />
						<p class="description"><?php esc_html_e( 'Enter custom More Project Info Title Text. If empty "More Project Info" will be used.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_related_title_text"><?php esc_html_e('Project related Title Text', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<input type="text" name="otw_pm_related_title_text" id="otw_pm_related_title_text" value="<?php echo otw_htmlentities( $otw_pm_plugin_options['otw_pm_related_title_text'] )?>" />
						<p class="description"><?php esc_html_e( 'Enter custom Related Projects Title Text. If empty "Related Projects" will be used.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_item_media_width"><?php esc_html_e('Media Width', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<input type="text" name="otw_pm_item_media_width" id="otw_pm_item_media_width" value="<?php echo esc_attr( $otw_pm_plugin_options['otw_pm_item_media_width'] )?>" />
						<p class="description"><?php esc_html_e( 'Default 650px. Use -1 if you want to disable cropping and use the original image upload.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_item_media_height"><?php esc_html_e('Media Height', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<input type="text" name="otw_pm_item_media_height" id="otw_pm_item_media_height" value="<?php echo esc_attr( $otw_pm_plugin_options['otw_pm_item_media_height'] )?>" />
						<p class="description"><?php esc_html_e( 'Default 580px. Use -1 if you want to disable cropping and use the original image upload.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_item_media_format"><?php esc_html_e('Media Format', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<select id="otw_pm_item_media_format" name="otw_pm_item_media_format">
						<?php foreach( $otw_pm_item_media_format_options as $key => $name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pm_plugin_options['otw_pm_item_media_format'] ) && ( $otw_pm_plugin_options['otw_pm_item_media_format'] == $key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $key )?>"<?php echo $selected?>><?php echo esc_html( $name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'Cropping images formats.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr valign="top">
					<th scope="row"><label for="otw_pm_item_media_alt_attr"><?php esc_html_e('Add alt tag', 'otw-portfolio-manager');?></label></th>
					<td>
						<?php ( empty($otw_pm_plugin_options['otw_pm_item_media_alt_attr']) )? $otw_pm_item_media_alt_attr = 'no' : $otw_pm_item_media_alt_attr = $otw_pm_plugin_options['otw_pm_item_media_alt_attr']; ?>
						<select name="otw_pm_item_media_alt_attr" id="otw_pm_item_media_alt_attr">
							<option value="no" <?php echo ( $otw_pm_item_media_alt_attr == 'no' )?'selected="selected"':'';?> ><?php esc_html_e( 'No (default)', 'otw-portfolio-manager');?></option>
							<option value="media_settings" <?php echo ( $otw_pm_item_media_alt_attr == 'media_settings' )?'selected="selected"':'';?> ><?php esc_html_e( 'Use what is set in the Media Library', 'otw-portfolio-manager');?></option>
						</select>
						<p class="description"><?php esc_html_e('The alt tag helps position your images in search engines.', 'otw-portfolio-manager');?></p>
					</td>
				</tr>
				<tr valign="top">
					<th scope="row"><label for="otw_pm_item_media_title_attr"><?php esc_html_e('Add title tag', 'otw-portfolio-manager');?></label></th>
					<td>
						<?php ( empty($otw_pm_plugin_options['otw_pm_item_media_title_attr']) )? $otw_pm_item_media_title_attr = 'no' : $otw_pm_item_media_title_attr = $otw_pm_plugin_options['otw_pm_item_media_title_attr']; ?>
						<select name="otw_pm_item_media_title_attr" id="otw_pm_item_media_title_attr">
							<option value="no" <?php echo ( $otw_pm_item_media_title_attr == 'no' )?'selected="selected"':'';?> ><?php esc_html_e( 'No (default)', 'otw-portfolio-manager');?></option>
							<option value="media_settings" <?php echo ( $otw_pm_item_media_title_attr == 'media_settings' )?'selected="selected"':'';?> ><?php esc_html_e( 'Use what is set in the Media Library', 'otw-portfolio-manager');?></option>
						</select>
						<p class="description"><?php esc_html_e('The title tag helps position your images in search engines and is displayed on hover of the image.', 'otw-portfolio-manager');?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_related_media_width"><?php esc_html_e('Related Posts Media Width', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<input type="text" name="otw_pm_related_media_width" id="otw_pm_related_media_width" value="<?php echo esc_attr( $otw_pm_plugin_options['otw_pm_related_media_width'] )?>" />
						<p class="description"><?php esc_html_e( 'Default 220px. Use -1 if you want to disable cropping and use the original image upload.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_related_media_height"><?php esc_html_e('Related Posts Media Height', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<input type="text" name="otw_pm_related_media_height" id="otw_pm_related_media_height" value="<?php echo esc_attr( $otw_pm_plugin_options['otw_pm_related_media_height'] )?>" />
						<p class="description"><?php esc_html_e( 'Default 150px. Use -1 if you want to disable cropping and use the original image upload.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_related_media_format"><?php esc_html_e('Related Posts Media Format', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<select id="otw_pm_related_media_format" name="otw_pm_related_media_format">
						<?php foreach( $otw_pm_item_media_format_options as $key => $name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pm_plugin_options['otw_pm_related_media_format'] ) && ( $otw_pm_plugin_options['otw_pm_related_media_format'] == $key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $key )?>"<?php echo $selected?>><?php echo esc_html( $name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'Cropping images formats.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_media_lightbox"><?php esc_html_e('Enable Media Lightbox', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<select id="otw_pm_media_lightbox" name="otw_pm_media_lightbox">
						<?php foreach( $otw_pm_media_lightbox_options as $key => $name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pm_plugin_options['otw_pm_media_lightbox'] ) && ( $otw_pm_plugin_options['otw_pm_media_lightbox'] == $key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $key )?>"<?php echo $selected?>><?php echo esc_html( $name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'Enables a lightbox on click on the media.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_item_media_lightbox_width"><?php esc_html_e('Media Lightbox Width', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<input type="text" name="otw_pm_item_media_lightbox_width" id="otw_pm_item_media_lightbox_width" value="<?php echo esc_attr( $otw_pm_plugin_options['otw_pm_item_media_lightbox_width'] )?>" />
						<p class="description"><?php esc_html_e( 'Default 1024px. Use -1 if you want to disable cropping and use the original image upload.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_item_media_lightbox_height"><?php esc_html_e('Media Lightbox Height', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<input type="text" name="otw_pm_item_media_lightbox_height" id="otw_pm_item_media_lightbox_height" value="<?php echo esc_attr( $otw_pm_plugin_options['otw_pm_item_media_lightbox_height'] )?>" />
						<p class="description"><?php esc_html_e( 'Default 640px. Use -1 if you want to disable cropping and use the original image upload.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_item_media_lightbox_format"><?php esc_html_e('Media Lightbox Format', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<select id="otw_pm_item_media_lightbox_format" name="otw_pm_item_media_lightbox_format">
						<?php foreach( $otw_pm_item_media_format_options as $key => $name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pm_plugin_options['otw_pm_item_media_lightbox_format'] ) && ( $otw_pm_plugin_options['otw_pm_item_media_lightbox_format'] == $key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $key )?>"<?php echo $selected?>><?php echo esc_html( $name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'Cropping images formats.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_grid_pages"><?php esc_html_e('Enable OTW Grid Manager for pages', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<select id="otw_pm_grid_pages" name="otw_pm_grid_pages">
						<?php foreach( $otw_pm_grid_pages_options as $key => $name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pm_plugin_options['otw_pm_grid_pages'] ) && ( $otw_pm_plugin_options['otw_pm_grid_pages'] == $key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $key )?>"<?php echo $selected?>><?php echo esc_html( $name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'This will enable the OTW Grid Manager for pages. It will help you build complex layouts and put Portfolio Manager lists in them.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
			</table>
		</div>
		<p class="submit">
			<input type="hidden" name="otw_pm_save_settings" value="1" />
			<input type="submit" value="<?php esc_html_e( 'Save', 'otw-portfolio-manager') ?>" name="submit" class="button button-primary button-hero"/>
		</p>
		<h3><?php esc_html_e('Slugs', 'otw-portfolio-manager'); ?></h3>
		<div class="otw_pm_sp_settings">
			<table class="form-table">
				<tr>
					<th scope="row"><label for="otw_pm_portfolio_slug"><?php esc_html_e('Portfolio Single Page Slug', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<input type="text" name="otw_pm_portfolio_slug" id="otw_pm_portfolio_slug" value="<?php echo esc_attr( $otw_pm_plugin_options['otw_pm_portfolio_slug'] )?>" />
						<p class="description"><?php esc_html_e( 'Edit the Portfolio Single Page Slug. Default is: '.$this->portfolio_post_type, 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_portfolio_category_slug"><?php esc_html_e('Portfolio Category Slug', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<input type="text" name="otw_pm_portfolio_category_slug" id="otw_pm_portfolio_category_slug" value="<?php echo esc_attr( $otw_pm_plugin_options['otw_pm_portfolio_category_slug'] )?>" />
						<p class="description"><?php esc_html_e( 'Edit the Portfolio Category Slug. Default is: '.$this->portfolio_category, 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_portfolio_tag_slug"><?php esc_html_e('Portfolio Tag Slug', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<input type="text" name="otw_pm_portfolio_tag_slug" id="otw_pm_portfolio_tag_slug" value="<?php echo esc_attr( $otw_pm_plugin_options['otw_pm_portfolio_tag_slug'] )?>" />
						<p class="description"><?php esc_html_e( 'Edit the Portfolio Tag Slug. Default is: '.$this->portfolio_tag, 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
			</table>
		</div>
		<br />
		<h3><?php esc_html_e('Category & Tag Archive Pages', 'otw-portfolio-manager'); ?></h3>
		<div class="otw_pm_sp_settings">
			<table class="form-table">
				<tr>
					<th scope="row"><label for="otw_pm_archive_media_width"><?php esc_html_e('Media Width', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<input type="text" name="otw_pm_archive_media_width" id="otw_pm_archive_media_width" value="<?php echo esc_attr( $otw_pm_plugin_options['otw_pm_archive_media_width'] )?>" />
						<p class="description"><?php esc_html_e( 'Default 220px. Use -1 if you want to disable cropping and use the original image upload.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_archive_media_height"><?php esc_html_e('Media Height', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<input type="text" name="otw_pm_archive_media_height" id="otw_pm_archive_media_height" value="<?php echo esc_attr( $otw_pm_plugin_options['otw_pm_archive_media_height'] )?>" />
						<p class="description"><?php esc_html_e( 'Default 170px. Use -1 if you want to disable cropping and use the original image upload.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><label for="otw_pm_archive_media_format"><?php esc_html_e('Media Lightbox Format', 'otw-portfolio-manager'); ?></label></th>
					<td>
						<select id="otw_pm_archive_media_format" name="otw_pm_archive_media_format">
						<?php foreach( $otw_pm_item_media_format_options as $key => $name ){?>
							<?php
								$selected = '';
								if( isset( $otw_pm_plugin_options['otw_pm_archive_media_format'] ) && ( $otw_pm_plugin_options['otw_pm_archive_media_format'] == $key ) ){
									$selected = ' selected="selected"';
								}
							?>
							<option value="<?php echo esc_attr( $key )?>"<?php echo $selected?>><?php echo esc_html( $name )?></option>
						<?php }?>
						</select>
						<p class="description"><?php esc_html_e( 'Cropping images formats.', 'otw-portfolio-manager' )?></p>
					</td>
				</tr>
			</table>
		</div>
		<p class="submit">
			<input type="submit" value="<?php esc_html_e( 'Save', 'otw-portfolio-manager') ?>" name="submit" class="button button-primary button-hero"/>
		</p>
		<h3><?php esc_html_e('Custom CSS', 'otw-portfolio-manager'); ?></h3>
		<p class="description"><?php esc_html_e('Adjust your own CSS for all of your Portfolio Lists. Please use with caution.', 'otw-portfolio-manager'); ?></p>
		
		
		<textarea name="otw_css" cols="100" rows="35" class="otw-pm-custom-css" ><?php echo esc_textarea( $customCss );?></textarea>
		<p class="submit">
			<input type="submit" value="<?php esc_html_e( 'Save', 'otw-portfolio-manager') ?>" name="submit" class="button button-primary button-hero"/>
		</p>
		<?php if( isset( $import_from_light ) && $import_from_light ){?>
		<br />
		<h3><?php esc_html_e('Import from OTW Portfolio Light', 'otw-portfolio-manager'); ?></h3>
		<p class="description"><?php esc_html_e( 'This button will import portfolio items from your OTW Portfolio Light plugin into Portfolio Manager Pro.', 'otw-portfolio-manager') ?></p>
		<br />
		<a href="admin.php?page=otw-pm-import-from-light" class="add-new-h2"><?php esc_html_e('Import from OTW Portfolio Light', 'otw-portfolio-manager'); ?></a>
		<?php }?>
	</form>
</div>