<?php
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
?>
<div class="wrap">
	<h1><?php _e('Real3D Flipbook Help', 'r3dfb'); ?></h1>
	<p><?php _e('Learn how to get started with Real3D Flipbook and utilize all its features.', 'r3dfb'); ?></p>

	<?php
	?>
	<h2><?php _e('Getting Started', 'r3dfb'); ?></h2>
	<p><?php _e('To create a new flipbook:', 'r3dfb'); ?></p>
	<ol>
		<li><?php _e('Go to the Real3D Flipbook menu in your WordPress admin.', 'r3dfb'); ?></li>
		<li><?php _e('Click "Add New" to create a new flipbook.', 'r3dfb'); ?></li>
		<li><?php _e('Add pages to flipbook by clicking "Select PDF or images"', 'r3dfb'); ?></li>
		<li><?php _e('Customize your flipbook using the available settings.', 'r3dfb'); ?></li>
		<li><?php _e('Publish your flipbook and embed it in your posts or pages using the provided shortcode.', 'r3dfb'); ?></li>
	</ol>
	<?php
	?>
	<?php
	
	?>
	<p><?php _e('For more detailed instructions, visit the plugin\'s <a href="https://real3dflipbook.gitbook.io/wp/" target="_blank">documentation</a>.', 'r3dfb'); ?></p>
	<?php
	
	?>
	<a href="<?php echo admin_url('post-new.php?post_type=r3d'); ?>" class="button button-primary"><?php _e('Create New Flipbook', 'r3dfb'); ?></a>

</div>
<?php
